/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.SimpleDesktop;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.ReconnectDialog;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.types.Machine;
import javax.swing.RootPaneContainer;

public class ReconnectHandler
extends TechClientAdapter
implements ReconnectDialog.ReconnectDialogListener {
    private Object DIALOG_LOCK = new Object();
    private ReconnectDialog currentDialog = null;
    private GUI gui;
    private RootPaneContainer rp;
    private ReconnectThread reconnectThread = null;
    private SimpleDesktop.ReconnectListener reconnectListener;
    private boolean showDialog = true;
    private boolean expectReboot = false;
    private boolean expectSleep = false;
    private boolean expectLogoutOrShutdown = false;
    private boolean expectTerminate;

    private int getCurrentState() {
        if (this.expectTerminate) {
            return 4;
        }
        if (this.expectReboot) {
            return 1;
        }
        if (this.expectLogoutOrShutdown) {
            return 2;
        }
        if (this.expectSleep) {
            return 3;
        }
        return 0;
    }

    private void resetAllState() {
        this.expectReboot = false;
        this.expectSleep = false;
        this.expectLogoutOrShutdown = false;
        this.expectTerminate = false;
    }

    public ReconnectHandler(RootPaneContainer rp, GUI gui, SimpleDesktop.ReconnectListener reconnectListener) {
        this.gui = gui;
        this.reconnectListener = reconnectListener;
        this.rp = rp;
    }

    public void setExpectRemoteTerminate(boolean expectTerminate) {
        this.expectTerminate = expectTerminate;
    }

    public void setExpectReboot(boolean expectReboot) {
        this.expectReboot = expectReboot;
    }

    public void setExpectLogoutShutdown(boolean expectLogoutShutdown) {
        this.expectLogoutOrShutdown = expectLogoutShutdown;
    }

    public void setExpectSleep(boolean expectSleep) {
        this.expectSleep = this.expectReboot;
    }

    public void setShowReconnectDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLinkDown() {
        if (!this.showDialog) {
            return;
        }
        System.out.println("[ReconnectHandler] Link Down.");
        Object object = this.DIALOG_LOCK;
        synchronized (object) {
            if (this.currentDialog != null) {
                this.currentDialog.setIsDead(false);
            } else {
                try {
                    System.out.println("[ReconnectHandler] Creating a new dialog here");
                    this.currentDialog = new ReconnectDialog(this.rp, this, false, this.reconnectListener.canReconnect(), this.getCurrentState());
                    this.reconnectListener.addMachineOnlineListener(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLinkDead() {
        if (!this.showDialog) {
            return;
        }
        System.out.println("[ReconnectHandler] Link Dead.");
        Object object = this.DIALOG_LOCK;
        synchronized (object) {
            if (this.currentDialog != null) {
                this.currentDialog.setIsDead(true);
            } else {
                this.currentDialog = new ReconnectDialog(this.rp, this, true, this.reconnectListener.canReconnect(), this.getCurrentState());
                this.reconnectListener.addMachineOnlineListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLinkOK() {
        System.out.println("[ReconnectHandler] Link OK.");
        Object object = this.DIALOG_LOCK;
        synchronized (object) {
            if (this.currentDialog != null) {
                this.reconnectListener.removeMachineOnlineListener(this);
                this.currentDialog.setVisible(false);
                this.currentDialog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doReconnect() {
        Object object = this.DIALOG_LOCK;
        synchronized (object) {
            System.out.println("[ReconnectHandler] Reconnect thread is currently " + this.reconnectThread);
            if (this.reconnectThread == null) {
                this.reconnectThread = new ReconnectThread();
                this.reconnectThread.start();
            } else {
                System.out.println("[ReconnectHandler] Skipping reconnect request");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTerminate() {
        Object object = this.DIALOG_LOCK;
        synchronized (object) {
            if (this.reconnectThread != null) {
                this.reconnectThread.cancel();
                this.reconnectThread = null;
            }
        }
        this.gui.disableReconnect();
        if (this.gui.con != null) {
            this.gui.con.closeConnection();
        }
    }

    @Override
    public void machineOnline(Machine machine) {
        if (machine.getMachineID().equals(ConnectedTarget.getMachineID())) {
            System.out.println("[ReconnectHandler] Machine online! Instructing reconnect...");
            if (this.currentDialog != null) {
                this.currentDialog.setMachineOnline();
                this.currentDialog.doReconnect();
            } else {
                this.doReconnect();
            }
        }
    }

    @Override
    public void machineOffline(Machine machine) {
        if (machine.getMachineID().equals(ConnectedTarget.getMachineID())) {
            System.out.println("[ReconnectHandler] Machine offline!");
            if (this.currentDialog != null) {
                this.currentDialog.setMachineOffline();
            }
        }
    }

    class ReconnectThread
    extends Thread {
        private boolean die = false;

        ReconnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean success = false;
            System.out.println("[ReconnectHandler] Will try for two minutes to reconnect...");
            long endTime = System.currentTimeMillis() + 20000L;
            try {
                while (!success && !this.die && System.currentTimeMillis() < endTime) {
                    long reconnectStart = System.currentTimeMillis();
                    try {
                        ReconnectHandler.this.reconnectListener.reconnect();
                        success = true;
                    }
                    catch (Throwable t) {
                        System.out.println("[ReconnectHandler] Reconnect failed:");
                        t.printStackTrace();
                    }
                    if (success || System.currentTimeMillis() - reconnectStart >= 5000L) continue;
                    try {
                        Thread.sleep(5000L - (System.currentTimeMillis() - reconnectStart));
                    }
                    catch (Exception exception) {
                    }
                }
                if (!success && ReconnectHandler.this.currentDialog != null) {
                    ReconnectHandler.this.currentDialog.setReconnectFailed(true);
                }
            }
            finally {
                Object object = ReconnectHandler.this.DIALOG_LOCK;
                synchronized (object) {
                    ReconnectHandler.this.reconnectThread = null;
                }
            }
            ReconnectHandler.this.resetAllState();
            ReconnectHandler.this.setShowReconnectDialog(true);
        }

        public void cancel() {
            this.die = true;
        }
    }
}

