/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.CallingCardUI;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.RebootDialog;
import com.aem.sdesktop.client.gui.ResolutionControlPanel;
import com.aem.sdesktop.client.gui.RunCommandUI;
import com.aem.sdesktop.client.gui.ShortcutUI;
import com.aem.sdesktop.client.gui.TuneDialog;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.sdesktop.util.SendKeyPanel;
import com.aem.sdesktop.util.TranscriptSaver;
import com.aem.sgateway.ServiceConfigureGlassDialog;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.TechPermissionsHandler;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.tech.ElevationGlassDialog;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.OSNotificationUtil;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.Debugger;
import com.aem.utils.keyhandling.KeyRequest;
import com.aem.utils.os.SystemInfo;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.test.JWTesting;
import utils.message.Message;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.FadePanel;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class NorthPanel
extends JPanel
implements GuiConstants,
ActionListener,
MouseListener {
    private final ClientController controller;
    private final GUI uinterface;
    public static final int BUTTON_SIZE_X = SimpleHelpLookAndFeel.scale(34);
    public static final int BUTTON_SIZE_Y = SimpleHelpLookAndFeel.scale(32);
    private final String ECHO_DISABLE = Language.get("DISABLE_TEXT_ECHOING");
    private final String ECHO_ENABLE = Language.get("ENABLE_TEXT_ECHOING");
    private final JPopupMenu opt_menu = new JSmartPopupMenu(Language.get("TOOLS_MENU"));
    private boolean control_enabled = true;
    private boolean echoing_text = false;
    private final NorthPanelMenuItem opt_transcript = new NorthPanelMenuItem(Language.get("SAVE_CHAT_TRANSCRIPT"), ImageLoader.getImageIcon("images/svg/chat/chat.svg,16"));
    private final NorthPanelMenuItem opt_tuning = new NorthPanelMenuItem(Language.get("CONNECTION_TUNING"), ImageLoader.getImageIcon("images/svg/general/preferences.svg,16"));
    private final NorthPanelMenuItem opt_cad = new NorthPanelMenuItem(Language.get("SEND_CTRL_ALT_DEL"), ImageLoader.getImageIcon("images/svg/os/windows.svg,16"));
    private final NorthPanelMenuItem opt_elevate = new NorthPanelMenuItem(Language.get("TOOLS_ELEVATE"), ImageLoader.getImageIcon("images/svg/general/lock.svg,16"));
    private final NorthPanelMenuItem opt_reboot = new NorthPanelMenuItem(Language.get("REMOTE_REBOOT"), ImageLoader.getImageIcon("images/svg/arrows/reboot.svg,16"));
    private final NorthPanelMenuItem opt_shortcut = new NorthPanelMenuItem(Language.get("CREATE_MACHINE_SHORTCUT"), ImageLoader.getImageIcon("images/svg/general/star.svg,16"));
    private final NorthPanelMenuItem opt_callingcard = new NorthPanelMenuItem(Language.get("CALLING_CARD_TITLE"), ImageLoader.getImageIcon("images/svg/users/profile.svg,16"));
    private final NorthPanelMenuItem opt_popup = new NorthPanelMenuItem(Language.get("LEAVE_MESSAGE"), ImageLoader.getImageIcon("images/svg/chat/chat.svg,16"));
    private final NorthPanelMenuItem opt_getdebuginfo = new NorthPanelMenuItem(Language.get("GET_DEBUG_INFO"), ImageLoader.getImageIcon("images/svg/files-folders/file-info.svg,16"));
    private final NorthPanelMenuItem opt_dupconnect = new NorthPanelMenuItem(Language.get("START_DUPLICATE_SESSION"), ImageLoader.getImageIcon("images/svg/arrows/split.svg,16"));
    private final NorthPanelMenuItem opt_sginstall = new NorthPanelMenuItem(Language.get("INSTALL_RA_SESSION"), ImageLoader.getImageIcon("O[images/svg/technology/screen.svg,16 | images/svg/general/add.svg,12]"));
    private final NorthPanelMenuItem opt_sguninstall = new NorthPanelMenuItem(Language.get("UNINSTALL_RA_SESSION"), ImageLoader.getImageIcon("O[images/svg/technology/screen.svg,16 | images/svg/general/remove.svg,12]"));
    private final NorthPanelMenuItem opt_expscr = new NorthPanelMenuItem(Language.get("EXPORT_SCREEN_TO_IMAGE"), ImageLoader.getImageIcon("images/svg/general/camera.svg,16"));
    private final NorthPanelMenuItem opt_command = new NorthPanelMenuItem(Language.get("LAUNCH_REMOTE_COMMAND"), ImageLoader.getImageIcon("images/svg/users/runner.svg,16"));
    private final NorthPanelMenuItem opt_end = new NorthPanelMenuItem(Language.get("KILL_SESSION"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
    private final NorthPanelMenuItem opt_reconnect = new NorthPanelMenuItem(Language.get("DISCONNECTED_RECONNECT"), ImageLoader.getImageIcon("images/svg/arrows/refresh.svg,16"));
    private final NorthPanelMenuItem opt_disconnectvnc = new NorthPanelMenuItem(Language.get("VNC_DISCONNECT_TT"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
    private final NorthPanelMenuItem opt_vnc = new NorthPanelMenuItem(Language.get("VNC_MENU"), ImageLoader.getImageIcon("images/svg/technology/screen.svg,16"));
    private final NorthPanelMenuItem opt_track_change = new NorthPanelMenuItem(Language.get("TRACKING_MENU") + "...", ImageLoader.getImageIcon("images/svg/general/alarm.svg,16"));
    private final JPopupMenu clip_menu = new JSmartPopupMenu(Language.get("CLIPBOARD_MENU"));
    private final NorthPanelMenuItem clip_send = new NorthPanelMenuItem(Language.get("CLIPBOARD_SEND_BUTTON"), ImageLoader.getImageIcon("images/svg/arrows/export.svg,16"));
    private final NorthPanelMenuItem clip_get = new NorthPanelMenuItem(Language.get("CLIPBOARD_GET_BUTTON"), ImageLoader.getImageIcon("images/svg/arrows/import.svg,16"));
    private final NorthPanelMenuItem keyb_sendclipboardtyped = new NorthPanelMenuItem(Language.get("TYPING_PASTE_CLIPBOARD"), ImageLoader.getImageIcon("images/svg/computing/keyboard.svg,16"));
    private final JPopupMenu keyboard_menu = new JSmartPopupMenu(Language.get("KEYBOARD_MENU"));
    private final NorthPanelCheckMenuItem keyb_keys = new NorthPanelCheckMenuItem(Language.get("KEYBOARD_MAP_KEYS"), ImageLoader.getImageIcon("images/svg/computing/keyboard.svg,16"));
    private final NorthPanelCheckMenuItem keyb_chars = new NorthPanelCheckMenuItem(Language.get("KEYBOARD_MAP_CHARS"), ImageLoader.getImageIcon("images/svg/text/text-arrow.svg,16"));
    private final NorthPanelMenuItem keyb_sendkey = new NorthPanelMenuItem(Language.get("SEND_KEY"), ImageLoader.getImageIcon("images/svg/computing/keyboard.svg,16"));
    private boolean continuous_refresh = false;
    private final NorthPanelToggleButton mode_rdesktop = new NorthPanelToggleButton(ImageLoader.getImageIcon("images/svg/technology/screen.svg,20"));
    private final NorthPanelToggleButton mode_ftransfer = new NorthPanelToggleButton(ImageLoader.getImageIcon("images/svg/files-folders/copy-files.svg,20"));
    private final NorthPanelToggleButton mode_diagnostics = new NorthPanelToggleButton(ImageLoader.getImageIcon("images/svg/charts/meter.svg,20"));
    private final NorthPanelToggleButton mode_vnc = new NorthPanelToggleButton(ImageLoader.getImageIcon("images/svg/general/layers.svg,20"));
    private final NorthPanelButton auto_refresh = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/arrows/refresh.svg,20"));
    private final NorthPanelButton cont_show = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/pointer.svg,20"));
    private final NorthPanelButton echo_show = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/text/text-shadow.svg,20"));
    private final NorthPanelButton toolsMenuButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/general/gear.svg,20"));
    private final NorthPanelButton toolsMenuButton2 = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/general/gear.svg,20"));
    private final NorthPanelButton cadButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/os/windows.svg,20"));
    private final NorthPanelButton clipMenuButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/clipboard.svg,20"));
    private final NorthPanelButton keyboardMenuButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/keyboard.svg,20"));
    private final NorthPanelToggleButton chatButton = new NorthPanelToggleButton(ImageLoader.getImageIcon("images/svg/computing/east-panel.svg,20"));
    private final NorthPanelButton disconnectVNCSession = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/general/remove.svg,20"));
    private final NorthPanelButton allScreensButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/screen-pick.svg,20"));
    private final NorthPanelButton oneToOneButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/screen-one-to-one.svg,20"));
    private final NorthPanelButton fitHeightButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/screen-fit-height.svg,20"));
    private final NorthPanelButton fitAllButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/screen-fit-all.svg,20"));
    private final NorthPanelButton full_scr = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/arrows/fullscreen.svg,20"));
    private final NorthPanelButton resolutionOptionsButton = new NorthPanelButton(ImageLoader.getImageIcon("images/svg/computing/screen-pick.svg,20"));
    private final JToggleButton collectDiagnostics = new JToggleButton(Language.get("GATHER_STATS"), ImageLoader.getImageIcon("images/svg/av/play.svg,24"));
    private FadePanel screenOptionsPanel = new FadePanel(0);
    private final JPopupMenu resolutionOptionsMenu = new JSmartPopupMenu();
    private final AWTEventListener popupCloser = new PopupCloser();
    private final Object PERMISSIONS_LOCK = new Object();
    private final boolean canInstallSG = true;
    private boolean canUninstallSG = true;
    private int currentMode;
    private boolean runningVNCSession;
    private boolean disregardRememberedEchoState = false;
    private Spacer cadButtonSpacer;
    private int remoteOsBase = 0;
    private JLabel zoom_out;
    private JLabel zoom_in;
    private JSlider resolutionBar;
    private boolean ignoreResolutionChange = false;
    private ResolutionControlPanel resolutionControlPanel;
    private int remoteOSVariant;
    private GbPanel leftPanel;
    private GbPanel middlePanel;
    private CloseMenuThread closeThread = null;
    private final Object CONTROL_REQUEST_LOCK = new Object();
    private final Object SCREEN_REQUEST_LOCK = new Object();
    private TuneDialog tune_dialog;
    private static int AUTO_REFRESH_THREAD_COUNTER = 0;
    private int unseenChatCount = 0;
    private TransientTechUser techUser;
    private TechPermissionsHandler permissionsHandler;

    public void setCanUninstallSG(boolean can) {
        this.canUninstallSG = can;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.opt_sguninstall.setEnabled(NorthPanel.this.canUninstallSG);
            }
        });
    }

    public void disableSGManagement() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.opt_sginstall.setEnabled(false);
                NorthPanel.this.opt_sguninstall.setEnabled(false);
                try {
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_sginstall);
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_sguninstall);
                    for (int i = 0; i < NorthPanel.this.opt_menu.getComponentCount() - 1; ++i) {
                        Component current = NorthPanel.this.opt_menu.getComponent(i);
                        Component next = NorthPanel.this.opt_menu.getComponent(i + 1);
                        if (!(current instanceof JPopupMenu.Separator) || !(next instanceof JPopupMenu.Separator)) continue;
                        NorthPanel.this.opt_menu.remove(next);
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void setRemoteOS(final int remoteOsBase, int remoteOsVariant) {
        this.remoteOsBase = remoteOsBase;
        this.remoteOSVariant = remoteOsVariant;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (remoteOsBase != 0) {
                    NorthPanel.this.opt_cad.setEnabled(false);
                    NorthPanel.this.cadButton.setEnabled(false);
                    try {
                        NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_cad);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        NorthPanel.this.leftPanel.remove(NorthPanel.this.cadButtonSpacer);
                        NorthPanel.this.leftPanel.remove(NorthPanel.this.cadButton);
                        NorthPanel.this.leftPanel.revalidate();
                        NorthPanel.this.leftPanel.repaint();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_elevate);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    NorthPanel.this.opt_elevate.setEnabled(false);
                }
            }
        });
    }

    void disableChat() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_transcript);
            }
        });
    }

    public void setToolsMenuVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.toolsMenuButton.setVisible(b);
            }
        });
    }

    public void setControlsEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (enabled) {
                    System.out.println("[NorthPanel] Enable main controls");
                } else {
                    System.out.println("[NorthPanel] Disable main controls");
                }
                NorthPanel.this.toolsMenuButton.setEnabled(enabled);
                NorthPanel.this.toolsMenuButton2.setEnabled(enabled);
                NorthPanel.this.clipMenuButton.setEnabled(enabled);
                NorthPanel.this.keyboardMenuButton.setEnabled(enabled);
                NorthPanel.this.opt_menu.setEnabled(enabled);
                NorthPanel.this.auto_refresh.setEnabled(enabled);
                NorthPanel.this.cont_show.setEnabled(enabled);
                NorthPanel.this.echo_show.setEnabled(enabled);
                NorthPanel.this.full_scr.setEnabled(enabled);
                NorthPanel.this.disconnectVNCSession.setEnabled(enabled);
                NorthPanel.this.chatButton.setEnabled(enabled);
                NorthPanel.this.mode_rdesktop.setEnabled(enabled);
                NorthPanel.this.mode_ftransfer.setEnabled(enabled);
                NorthPanel.this.mode_diagnostics.setEnabled(enabled);
                NorthPanel.this.mode_vnc.setEnabled(enabled);
                NorthPanel.this.opt_vnc.setEnabled(enabled);
                NorthPanel.this.oneToOneButton.setEnabled(enabled);
                NorthPanel.this.fitHeightButton.setEnabled(enabled);
                NorthPanel.this.fitAllButton.setEnabled(enabled);
                NorthPanel.this.allScreensButton.setEnabled(enabled);
                NorthPanel.this.zoom_in.setEnabled(enabled);
                NorthPanel.this.resolutionBar.setEnabled(enabled);
                NorthPanel.this.zoom_out.setEnabled(enabled);
                NorthPanel.this.resolutionOptionsButton.setEnabled(enabled);
                NorthPanel.this.cadButton.setEnabled(enabled);
                NorthPanel.this.repaint();
            }
        });
    }

    public NorthPanel(ClientController c, GUI ui) {
        this.controller = c;
        this.uinterface = ui;
        this.initGraphics();
        this.initEventHandling();
        this.setControlsEnabled(false);
        if (GroupAccessKeyset.isEnabled()) {
            this.disableSGManagement();
        }
    }

    private void reinitMenu() {
        this.opt_menu.removeAll();
        switch (this.currentMode) {
            case 0: 
            case 1: 
            case 2: {
                if (!Switches.SH_updatedConnectionTuning) {
                    this.opt_menu.add(this.opt_tuning);
                    this.opt_menu.add(new NorthPanelMenuSeparator(true));
                }
                if (!GroupAccessKeyset.isEnabled()) {
                    this.opt_menu.add(this.opt_command);
                }
                this.opt_menu.add(this.opt_reboot);
                this.opt_menu.add(this.opt_elevate);
                this.opt_menu.add(this.opt_cad);
                this.opt_menu.add(this.opt_shortcut);
                this.opt_menu.add(this.opt_callingcard);
                if (Switches.SH_sessionLeavePopup) {
                    this.opt_menu.add(this.opt_popup);
                }
                this.opt_menu.add(this.opt_dupconnect);
                this.opt_menu.add(this.opt_getdebuginfo);
                if (Switches.SH_1543_autoTracking) {
                    this.opt_menu.add(this.opt_track_change);
                }
                this.opt_menu.add(new NorthPanelMenuSeparator(false));
                if (!GroupAccessKeyset.isEnabled()) {
                    this.opt_menu.add(this.opt_sginstall);
                    this.opt_menu.add(this.opt_sguninstall);
                }
                this.opt_menu.add(new NorthPanelMenuSeparator(false));
                this.opt_menu.add(this.opt_transcript);
                this.opt_menu.add(this.opt_expscr);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_vnc);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_reconnect);
                this.opt_menu.add(this.opt_end);
                break;
            }
            case 3: {
                this.opt_menu.add(this.opt_tuning);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_getdebuginfo);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_disconnectvnc);
                break;
            }
            case 6: 
            case 7: {
                this.opt_menu.add(this.opt_tuning);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_reboot);
                this.opt_menu.add(this.opt_getdebuginfo);
                this.opt_menu.add(new NorthPanelMenuSeparator(true));
                this.opt_menu.add(this.opt_reconnect);
                this.opt_menu.add(this.opt_end);
            }
        }
    }

    public void setIsRunningVNCSession(boolean sessionRunning) {
        this.runningVNCSession = sessionRunning;
        if (sessionRunning) {
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JToggleButton[]{this.mode_rdesktop, this.mode_ftransfer, this.mode_diagnostics, this.mode_vnc});
        } else {
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JToggleButton[]{this.mode_rdesktop, this.mode_ftransfer, this.mode_diagnostics});
        }
    }

    private void reinitLeftPanel() {
        this.leftPanel.removeAll();
        int X = 0;
        switch (this.currentMode) {
            case 0: {
                this.leftPanel.add(this.mode_rdesktop, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_ftransfer, X++, 0, 1, 1, 0, 1, 17, 3);
                if (!GroupAccessKeyset.isEnabled()) {
                    this.leftPanel.add(this.mode_diagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                }
                if (!GroupAccessKeyset.isEnabled() && this.runningVNCSession) {
                    this.leftPanel.add(this.mode_vnc, X++, 0, 1, 1, 0, 1, 17, 3);
                }
                this.leftPanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.auto_refresh, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.cont_show, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.echo_show, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.full_scr, X++, 0, 1, 1, 0, 1, 17, 3);
                this.cadButtonSpacer = new Spacer();
                this.leftPanel.add(this.cadButtonSpacer, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.cadButton, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.clipMenuButton, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.keyboardMenuButton, X++, 0, 1, 1, 0, 1, 17, 3);
                break;
            }
            case 1: {
                this.leftPanel.add(this.mode_rdesktop, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_ftransfer, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_diagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                if (!this.runningVNCSession) break;
                this.leftPanel.add(this.mode_vnc, X++, 0, 1, 1, 0, 1, 17, 3);
                break;
            }
            case 2: {
                this.leftPanel.add(this.mode_rdesktop, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_ftransfer, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_diagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                if (this.runningVNCSession) {
                    this.leftPanel.add(this.mode_vnc, X++, 0, 1, 1, 0, 1, 17, 3);
                }
                this.leftPanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.collectDiagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                break;
            }
            case 3: {
                this.leftPanel.add(this.mode_rdesktop, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_ftransfer, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_diagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                if (this.runningVNCSession) {
                    this.leftPanel.add(this.mode_vnc, X++, 0, 1, 1, 0, 1, 17, 3);
                }
                this.leftPanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.disconnectVNCSession, X++, 0, 1, 1, 0, 1, 17, 3);
                break;
            }
            case 6: 
            case 7: {
                this.leftPanel.add(this.mode_ftransfer, X++, 0, 1, 1, 0, 1, 17, 3);
                this.leftPanel.add(this.mode_diagnostics, X++, 0, 1, 1, 0, 1, 17, 3);
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JToggleButton[]{this.mode_ftransfer, this.mode_diagnostics});
            }
        }
        this.leftPanel.revalidate();
        this.leftPanel.repaint();
    }

    private void reinitMiddlePanel() {
        this.middlePanel.removeAll();
        int X = 0;
        this.middlePanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
        switch (this.currentMode) {
            case 0: {
                this.middlePanel.add(this.screenOptionsPanel, X++, 0, 1, 1, 1, 1, 17, 1);
                this.middlePanel.add(this.toolsMenuButton2, X++, 0, 1, 1, 0, 1, 10, 0);
                this.middlePanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.middlePanel.add(this.chatButton, X++, 0, 1, 1, 0, 1, 10, 0);
                break;
            }
            case 1: 
            case 2: {
                this.middlePanel.add(this.toolsMenuButton2, X++, 0, 1, 1, 1, 1, 13, 0);
                this.middlePanel.add(new Spacer(), X++, 0, 1, 1, 0, 1, 17, 3);
                this.middlePanel.add(this.chatButton, X++, 0, 1, 1, 0, 1, 13, 0);
                break;
            }
            case 3: {
                this.middlePanel.add(this.screenOptionsPanel, X++, 0, 1, 1, 1, 1, 17, 1);
                break;
            }
            case 6: 
            case 7: {
                this.middlePanel.add(this.toolsMenuButton2, X++, 0, 1, 1, 1, 1, 13, 0);
            }
        }
        this.middlePanel.revalidate();
        this.middlePanel.repaint();
    }

    private void initGraphics() {
        this.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, SHStyle.BORDER_COLOR), SHBorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.leftPanel = new GbPanel();
        this.middlePanel = new GbPanel();
        this.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.leftPanel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.middlePanel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.middlePanel, "Center");
        this.mode_rdesktop.setToolTipText(Language.get("REMOTE_SCREEN_MODE"));
        this.mode_ftransfer.setToolTipText(Language.get("FILE_TRANSFER_MODE"));
        this.mode_diagnostics.setToolTipText(Language.get("DIAGNOSTICS_MODE"));
        this.mode_vnc.setToolTipText(Language.get("VNC_MODE"));
        this.cadButton.setToolTipText(Language.get("SEND_CTRL_ALT_DEL"));
        this.mode_rdesktop.setSelected(true);
        this.chatButton.setSelected(true);
        this.reinitLeftPanel();
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JToggleButton[]{this.mode_rdesktop, this.mode_ftransfer, this.mode_diagnostics});
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JButton[]{this.clipMenuButton, this.keyboardMenuButton});
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JButton[]{this.auto_refresh, this.cont_show, this.echo_show, this.full_scr});
        this.resolutionBar = new JSlider(0, 200, 100);
        this.resolutionBar.setMinorTickSpacing(1);
        this.zoom_in = new JLabel(ImageLoader.getImageIcon("images/svg/computing/zoom-in.svg,12"));
        this.zoom_out = new JLabel(ImageLoader.getImageIcon("images/svg/computing/zoom-out.svg,12"));
        this.resolutionBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!NorthPanel.this.ignoreResolutionChange) {
                    double value = NorthPanel.this.resolutionBar.getValue();
                    NorthPanel.this.uinterface.setResolutionPercentage(value /= 100.0);
                }
            }
        });
        this.zoom_in.addMouseListener(this);
        this.zoom_out.addMouseListener(this);
        GbPanel allButtons = new GbPanel();
        int X = 0;
        this.allScreensButton.addActionListener(this);
        this.oneToOneButton.addActionListener(this);
        this.fitHeightButton.addActionListener(this);
        this.fitAllButton.addActionListener(this);
        this.resolutionOptionsButton.addActionListener(this);
        this.zoom_in.addMouseListener(this);
        this.zoom_out.addMouseListener(this);
        this.fitAllButton.setToolTipText(Language.get("TECH_UI_FIT_ALL"));
        this.fitHeightButton.setToolTipText(Language.get("TECH_UI_FIT_HEIGHT"));
        this.oneToOneButton.setToolTipText(Language.get("TECH_UI_FIT_ONE_TO_ONE"));
        this.allScreensButton.setToolTipText(Language.get("TECH_UI_SHOW_SCREENS"));
        this.resolutionOptionsButton.setToolTipText(Language.get("TECH_UI_RESOLUTION_CONTROL"));
        allButtons.add(this.allScreensButton, X++, 0, 1, 1, 0, 0, 17, 0);
        allButtons.add(this.oneToOneButton, X++, 0, 1, 1, 0, 0, 17, 0, new ScaledInsets(0, 10, 0, 0));
        allButtons.add(this.fitHeightButton, X++, 0, 1, 1, 0, 0, 17, 0);
        allButtons.add(this.fitAllButton, X++, 0, 1, 1, 0, 0, 17, 0);
        allButtons.add(this.zoom_out, X++, 0, 1, 1, 0, 0, 17, 0, new ScaledInsets(0, 10, 0, 0));
        allButtons.add(this.resolutionBar, X++, 0, 1, 1, 0, 1, 17, 1);
        allButtons.add(this.zoom_in, X++, 0, 1, 1, 1, 0, 17, 0, new ScaledInsets(0, 0, 0, 10));
        GbPanel condensed = new GbPanel();
        X = 0;
        condensed.add(this.resolutionOptionsButton, X++, 0, 1, 1, 1, 1, 17, 3);
        this.screenOptionsPanel.switchBetween(condensed, allButtons, false);
        this.screenOptionsPanel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup(new JButton[]{this.oneToOneButton, this.fitHeightButton, this.fitAllButton});
        this.reinitMiddlePanel();
        this.allScreensButton.setEnabled(false);
        this.oneToOneButton.setEnabled(false);
        this.fitHeightButton.setEnabled(false);
        this.fitAllButton.setEnabled(false);
        this.zoom_in.setEnabled(false);
        this.resolutionBar.setEnabled(false);
        this.zoom_out.setEnabled(false);
        this.cadButton.setEnabled(false);
        this.resolutionOptionsButton.setEnabled(false);
        SwingUtil.setWidth(this.resolutionBar, 80);
        SwingUtil.fixSizeToPreferredSize(this.resolutionBar);
        SwingUtil.fixSizeToPreferredSize(this.leftPanel);
        this.leftPanel.setSize(this.leftPanel.getPreferredSize());
        this.toolsMenuButton.setToolTipText(Language.get("TECH_UI_TOOLTIP_TOOLS"));
        this.toolsMenuButton2.setToolTipText(Language.get("TECH_UI_TOOLTIP_TOOLS"));
        this.clipMenuButton.setToolTipText(Language.get("TECH_UI_TOOLTIP_CLIP"));
        this.keyboardMenuButton.setToolTipText(Language.get("TECH_UI_TOOLTIP_KEYBOARD"));
        ActionListener toolsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton source = (JButton)e.getSource();
                int northPanelWidth = NorthPanel.super.getWidth();
                int buttonXInNorthPanel = SwingUtilities.convertPoint((Component)source.getParent(), (Point)source.getLocation(), (Component)NorthPanel.this).x;
                int buttonXOnScreen = source.getLocationOnScreen().x;
                int spaceToRight = northPanelWidth - buttonXInNorthPanel;
                int pullLeft = 0;
                NorthPanel.this.opt_menu.show(source, -(((NorthPanel)NorthPanel.this).opt_menu.getPreferredSize().width - spaceToRight + pullLeft), source.getHeight());
            }
        };
        this.toolsMenuButton.addActionListener(toolsListener);
        this.toolsMenuButton2.addActionListener(toolsListener);
        this.clipMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enableClipboardType = false;
                try {
                    String text = ClipboardUtil.getClipboardAsText();
                    enableClipboardType = text != null && text.length() > 0;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                NorthPanel.this.keyb_sendclipboardtyped.setEnabled(enableClipboardType);
                NorthPanel.this.clip_menu.show(NorthPanel.this.clipMenuButton, 0, NorthPanel.this.clipMenuButton.getHeight());
            }
        });
        this.keyboardMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NorthPanel.this.keyboard_menu.show(NorthPanel.this.keyboardMenuButton, 0, NorthPanel.this.keyboardMenuButton.getHeight());
            }
        });
        this.clip_menu.add(this.clip_send);
        this.clip_menu.add(this.clip_get);
        this.clip_menu.addSeparator();
        this.clip_menu.add(this.keyb_sendclipboardtyped);
        this.keyboard_menu.add(this.keyb_keys);
        this.keyboard_menu.add(this.keyb_chars);
        this.keyboard_menu.addSeparator();
        this.keyboard_menu.add(this.keyb_sendkey);
        this.auto_refresh.setToolTipText(Language.get("AUTO_SCREEN_REFRESH"));
        this.cont_show.setToolTipText(Language.get("REMOTE_CONTROL_ON"));
        this.echo_show.setToolTipText(Language.get("TEXT_ECHOING_ON"));
        this.full_scr.setToolTipText(Language.get("FULL_SCREEN_MODE"));
        this.disconnectVNCSession.setToolTipText(Language.get("VNC_DISCONNECT_TT"));
        SHButtonUI.makeButtonRed(this.disconnectVNCSession);
        this.resolutionControlPanel = new ResolutionControlPanel(this.uinterface);
        this.resolutionControlPanel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.resolutionOptionsMenu.add(this.resolutionControlPanel.getRootComponent());
        this.updateButtonsForNewMode();
    }

    private void updateButtonsForNewMode() {
        this.reinitMenu();
        this.reinitLeftPanel();
        this.reinitMiddlePanel();
    }

    public void loadStaticTechnicianPreferences() {
        String prop = TechProperties.INSTANCE.getProp("kbd", "c");
        if (prop.equals("c")) {
            this.actionPerformed(this.keyb_chars, false);
        } else {
            this.actionPerformed(this.keyb_keys, false);
        }
    }

    private void initEventHandling() {
        this.collectDiagnostics.addActionListener(this);
        this.opt_reconnect.addActionListener(this);
        this.opt_end.addActionListener(this);
        this.opt_disconnectvnc.addActionListener(this);
        this.cadButton.addActionListener(this);
        this.opt_shortcut.addActionListener(this);
        this.opt_callingcard.addActionListener(this);
        this.opt_popup.addActionListener(this);
        this.opt_getdebuginfo.addActionListener(this);
        this.opt_cad.addActionListener(this);
        this.opt_elevate.addActionListener(this);
        this.opt_reboot.addActionListener(this);
        this.opt_transcript.addActionListener(this);
        this.opt_tuning.addActionListener(this);
        this.opt_command.addActionListener(this);
        this.clip_get.addActionListener(this);
        this.clip_send.addActionListener(this);
        this.keyb_sendkey.addActionListener(this);
        this.keyb_sendclipboardtyped.addActionListener(this);
        this.keyb_keys.addActionListener(this);
        this.keyb_chars.addActionListener(this);
        this.opt_dupconnect.addActionListener(this);
        this.opt_sginstall.addActionListener(this);
        this.opt_sguninstall.addActionListener(this);
        this.opt_vnc.addActionListener(this);
        this.opt_expscr.addActionListener(this);
        this.auto_refresh.addActionListener(this);
        this.cont_show.addActionListener(this);
        this.echo_show.addActionListener(this);
        if (Switches.SH_1543_autoTracking) {
            this.opt_track_change.addActionListener(this);
        }
        this.full_scr.addActionListener(this);
        this.disconnectVNCSession.addActionListener(this);
        this.mode_rdesktop.addActionListener(this);
        this.mode_ftransfer.addActionListener(this);
        this.mode_diagnostics.addActionListener(this);
        this.mode_vnc.addActionListener(this);
        this.collectDiagnostics.addActionListener(this);
        this.chatButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o, true);
    }

    private void turnOnTextEcho() {
        if (this.echo_show.isVisible() && !this.echoing_text) {
            this.switchEcho(false);
        }
    }

    public void turnOffTextEchoInitial() {
        this.disregardRememberedEchoState = true;
        this.turnOffTextEcho();
    }

    public void turnOffTextEcho() {
        if (this.echo_show.isVisible() && this.echoing_text) {
            this.switchEcho(false);
        }
    }

    void releaseTrackingButton() {
        this.opt_track_change.setSelected(false);
        this.opt_track_change.setEnabled(true);
    }

    private void actionPerformed(Object o, boolean fromUser) {
        if (o == this.resolutionOptionsButton) {
            if (this.closeThread != null) {
                this.closeThread.cancel();
                this.closeThread = null;
            }
            this.resolutionOptionsMenu.show(this.resolutionOptionsButton, -this.resolutionControlPanel.getRootComponent().getPreferredSize().width / 2 + this.resolutionOptionsButton.getWidth() / 2, this.resolutionOptionsButton.getHeight());
            this.resolutionOptionsMenu.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(NorthPanel.this.popupCloser);
                }
            });
            Toolkit.getDefaultToolkit().addAWTEventListener(this.popupCloser, 16L);
        } else if (o == this.fitAllButton) {
            this.uinterface.setFitAll();
        } else if (o == this.fitHeightButton) {
            this.uinterface.setFitHeight();
        } else if (o == this.oneToOneButton) {
            this.uinterface.setFitOneToOne();
        } else if (o == this.allScreensButton) {
            this.uinterface.toggleShowAllScreens();
        } else if (o == this.collectDiagnostics) {
            this.uinterface.setCollectDiagnostics(this.collectDiagnostics.isSelected());
        } else if (o == this.mode_rdesktop) {
            this.uinterface.setRemoteScreenMode();
        } else if (o == this.mode_ftransfer) {
            this.uinterface.setFileTransferMode();
        } else if (o == this.mode_diagnostics) {
            this.uinterface.setDiagnosticsMode();
        } else if (o == this.mode_vnc) {
            this.uinterface.setVNCMode();
        } else if (o == this.opt_vnc) {
            this.uinterface.setVNCMode();
        } else if (o == this.disconnectVNCSession) {
            this.uinterface.disconnectVNCSession();
        } else if (o == this.chatButton) {
            this.uinterface.keyPressed(112);
            this.clearChatCount();
        } else if (o == this.cont_show) {
            this.switchControl();
        } else if (o == this.opt_track_change) {
            this.opt_track_change.setSelected(!this.opt_track_change.isSelected());
            if (this.opt_track_change.isSelected()) {
                Icon overlayedIcon = ImageLoader.getImageIcon(Icons.overlay("images/svg/technology/screen.svg,48", "images/svg/general/alarm.svg,16"));
                JPanel dialogPanel = new JPanel();
                dialogPanel.setBorder(SHBorderFactory.createEmptyBorder(15, 15, 15, 15));
                dialogPanel.setLayout(new BorderLayout(SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10)));
                JPanel contents = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(10)));
                JLabel label = new JLabel("<html>" + Language.get("DO_TRACKING_1"));
                JCheckBox box = new JCheckBox(Language.get("NOT_AGAIN"), false);
                contents.add((Component)label, "Center");
                contents.add((Component)box, "South");
                dialogPanel.add((Component)new JLabel(overlayedIcon), "West");
                dialogPanel.add((Component)contents, "Center");
                boolean doTracking = true;
                if (TechProperties.INSTANCE.getBooleanProp(TechProperties.PROP_SHOW_VISALARM, true)) {
                    doTracking = SHGlassOptionPane.showOkCancelPanelDialog(this.uinterface.getParentFrame(), dialogPanel, Language.get("AUTO_TRACKING"), Language.get("CREATE_VISUAL_ALARM"), Language.get("CANCEL"));
                }
                if (box.isSelected()) {
                    TechProperties.INSTANCE.setPropAndSave(TechProperties.PROP_SHOW_VISALARM, "false");
                }
                if (doTracking) {
                    this.uinterface.captureRectAndTrack();
                    this.opt_track_change.setEnabled(false);
                } else {
                    this.uinterface.releaseTrackingButton();
                }
            } else {
                this.uinterface.cancelTracking();
                this.opt_track_change.setEnabled(true);
            }
        } else if (o == this.echo_show) {
            this.switchEcho(fromUser);
        } else if (o instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)o;
            if (mi == this.opt_expscr) {
                this.uinterface.exportScreen();
            } else if (mi == this.opt_dupconnect) {
                this.uinterface.startDuplicateConnection();
            } else if (mi == this.opt_sginstall) {
                ServiceConfigureGlassDialog dialog;
                if (this.canUninstallSG && !SHGlassOptionPane.showConfirmDialog(this.uinterface.getParentFrame(), Language.get("INSTALL_REMOTE_ACCESS_EXISTS"), Language.get("INSTALL_REMOTE_ACCESS"), ImageLoader.getImageIcon("images/svg/dialogs/question.svg,48"), Language.get("INSTALL"))) {
                    return;
                }
                String template = null;
                if (this.techUser != null) {
                    template = this.techUser.setSubstitutedSGName();
                }
                if ((dialog = new ServiceConfigureGlassDialog(this.uinterface.getParentFrame(), this.controller, template, ConnectedTarget.TARGET)).didInstallation()) {
                    this.setCanUninstallSG(true);
                }
            } else if (mi == this.opt_sguninstall) {
                this.controller.requestSimpleGatewayUninstallation();
            } else if (mi == this.opt_tuning) {
                this.action_tune(false);
            } else if (mi == this.opt_command) {
                this.action_command();
            } else if (mi == this.keyb_sendkey) {
                this.action_sendkey();
            } else if (mi == this.keyb_sendclipboardtyped) {
                this.action_sendkeytyped();
            } else if (mi == this.opt_cad) {
                this.controller.sendControlAltDelete();
            } else if (mi == this.opt_elevate) {
                this.requestElevation();
            } else if (mi == this.opt_reboot) {
                this.requestReboot();
            } else if (mi == this.opt_getdebuginfo) {
                this.getDebugInfo();
            } else if (mi == this.opt_shortcut) {
                this.requestInstallShortcut();
            } else if (mi == this.opt_callingcard) {
                this.requestInstallCallingCard();
            } else if (mi == this.opt_popup) {
                this.requestLeavePopup();
            } else if (mi == this.opt_transcript) {
                TranscriptSaver.saveTranscript(this.uinterface.getParentFrame(), this.uinterface.getChatDocument());
            } else if (mi == this.opt_reconnect) {
                this.uinterface.disableReconnect();
                this.uinterface.forceReconnect();
            } else if (mi == this.opt_disconnectvnc) {
                this.uinterface.disconnectVNCSession();
            } else if (mi == this.opt_end) {
                this.uinterface.disableReconnect();
                this.uinterface.quit();
            } else if (o == this.clip_send) {
                this.controller.sendClipboard();
            } else if (o == this.clip_get) {
                this.controller.fetchClipboard(true);
            } else if (o == this.keyb_keys) {
                this.keyb_keys.setSelected(true);
                this.keyb_chars.setSelected(false);
                TechProperties.INSTANCE.setPropAndSaveIn("kbd", "k", 3000);
                this.uinterface.mapKeycodesToKeycodes();
            } else if (o == this.keyb_chars) {
                this.keyb_chars.setSelected(true);
                this.keyb_keys.setSelected(false);
                TechProperties.INSTANCE.setPropAndSaveIn("kbd", "c", 3000);
                this.uinterface.mapCharactersToCharacters();
            } else {
                Debugger.warning("Connection menu unknown JMenuItem " + mi.getText());
            }
        } else {
            this.uinterface.getKeyFocus();
            if (o == this.auto_refresh) {
                this.switchScreen();
            } else if (o == this.full_scr) {
                this.uinterface.keyPressed(123);
            } else if (o == this.cadButton) {
                this.controller.sendControlAltDelete();
            } else {
                Debugger.warning("action performed on unknown Component " + o);
            }
        }
    }

    private void switchControl() {
        if (!this.control_enabled && this.permissionsHandler.needToRequestControl()) {
            new RequestControlThread().start();
        } else {
            this.switchControlNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchScreen() {
        NorthPanel.logPreLock("switchScreen");
        Object object = this.PERMISSIONS_LOCK;
        synchronized (object) {
            NorthPanel.logPostLock("switchScreen");
            if (!this.continuous_refresh && this.permissionsHandler.needToRequestScreen()) {
                new RequestScreenThread().start();
            } else {
                this.action_autoRefresh();
            }
        }
    }

    private void switchEcho(boolean fromUser) {
        if (!this.echoing_text) {
            this.echoing_text = true;
            this.echo_show.setIcon(ImageLoader.getImageIcon("images/svg/text/text-shadow.svg,20"));
            this.echo_show.setToolTipText(Language.get("TEXT_ECHOING_ON"));
            this.uinterface.setTextEcho(true);
            if (fromUser) {
                SessionProperties.INSTANCE.setPropAndSave(SessionProperties.PROP_TEXTECHO, "true");
            }
        } else {
            this.echoing_text = false;
            this.echo_show.setIcon(ImageLoader.getImageIcon("O[images/svg/text/text-shadow.svg,20 | images/svg/dialogs/warning.svg,12]"));
            this.echo_show.setToolTipText(Language.get("TEXT_ECHOING_OFF"));
            this.uinterface.setTextEcho(false);
            if (fromUser) {
                SessionProperties.INSTANCE.setPropAndSave(SessionProperties.PROP_TEXTECHO, "false");
            }
        }
    }

    private void switchControlNow() {
        boolean bl = this.control_enabled = !this.control_enabled;
        if (this.control_enabled) {
            this.cont_show.setIcon(ImageLoader.getImageIcon("images/svg/computing/pointer.svg,20"));
            this.cont_show.setToolTipText(Language.get("REMOTE_CONTROL_ON"));
        } else if (!this.permissionsHandler.needToRequestControl()) {
            this.cont_show.setIcon(ImageLoader.getImageIcon("O[images/svg/computing/pointer.svg,20 | images/svg/dialogs/warning.svg,12]"));
            this.cont_show.setToolTipText(Language.get("REMOTE_CONTROL_OFF"));
        } else {
            this.cont_show.setIcon(ImageLoader.getImageIcon("O[images/svg/computing/pointer.svg,20 | images/svg/dialogs/question.svg,12]"));
            this.cont_show.setToolTipText(Language.get("REMOTE_CONTROL_OFF_REQUEST"));
        }
        this.cont_show.repaint();
        this.updateEnabled();
    }

    private void requestLeavePopup() {
    }

    private void requestInstallCallingCard() {
        CallingCardUI ui = CallingCardUI.showDialog((RootPaneContainer)((Object)this.getRootPane().getParent()));
        if (ui != null) {
            this.controller.installCallingCard(ui.getCardName(), ui.createDesktopShortcut(), ui.createMenuShortcut(), ui.automaticallyLogin());
        }
    }

    private void requestInstallShortcut() {
        ShortcutUI ui = new ShortcutUI();
        ui.showDialog((RootPaneContainer)((Object)this.getRootPane().getParent()));
        if (ui.isOK()) {
            if (ui.getCardName() == null) {
                return;
            }
            String shortcutName = ui.getCardName();
            String dir = ui.getSaveToDir();
            File targetDirectory = dir != null ? new File(dir) : new File(System.getProperty("user.home") + File.separator + "Desktop");
            try {
                Properties properties = new Properties();
                properties.setProperty("TechHelpUiPreConnectedID", "");
                JWSystem.saveLauncherShortcutForVirtualApp(targetDirectory, shortcutName, JWSystem.getMyAppName(), properties, false);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    private void getDebugInfo() {
        File file;
        ConnectionTestDialog dialog = new ConnectionTestDialog();
        dialog.showDialog(this.uinterface.getParentFrame());
        boolean doConnectionTest = dialog.isOK();
        boolean extendedConnectionTest = false;
        if (doConnectionTest) {
            extendedConnectionTest = dialog.doExtendedTest();
        }
        if ((file = SafeJFileChooser.saveFile(this.uinterface.getParentFrame(), "session.log")) == null) {
            return;
        }
        String path = file.getAbsolutePath();
        if (!path.toLowerCase().endsWith(".log")) {
            path = path + ".log";
        }
        if ((file = new File(path)).exists() && !SHGlassOptionPane.showConfirmDialog(this.uinterface.getParentFrame(), Language.get("OVERWRITE_MSG"), Language.get("OVERWRITE_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("OVERWRITE"))) {
            file = null;
        }
        if (file != null) {
            new GetDebugThread(file, doConnectionTest, extendedConnectionTest).start();
        }
    }

    private void requestReboot() {
        RebootDialog dialog = new RebootDialog(this.uinterface.getParentFrame(), this.remoteOsBase == 0, this.remoteOsBase == 2, ClientManagement.isSimpleHelp());
        if (dialog.doReboot() || dialog.doSafeModeReboot()) {
            if (dialog.doSafeModeReboot()) {
                System.out.println("[NorthPanel] Requesting safe mode reboot of remote machine");
            } else {
                System.out.println("[NorthPanel] Requesting normal reboot of remote machine");
            }
            this.controller.sendRemoteReboot(dialog.doSafeModeReboot(), dialog.force());
        }
    }

    private void requestElevation() {
        ElevationGlassDialog dialog = new ElevationGlassDialog((RootPaneContainer)((Object)this.getRootPane().getParent()), Language.get("ADMINISTRATOR"));
        String username = dialog.getUName();
        String password = dialog.getPass();
        if (dialog.mustPromptRemote()) {
            this.controller.sendElevateMouseMove();
        } else if (username != null && password != null) {
            this.controller.sendElevateMouseMove(username, password);
        }
    }

    public void keyLayoutAvailable() {
        this.keyb_sendkey.setEnabled(true);
    }

    private void action_sendkey() {
        new SendKeyPanel(this.uinterface.getParentFrame(), this.controller, this.uinterface, this.remoteOsBase);
    }

    private void action_sendkeytyped() {
        try {
            String text = ClipboardUtil.getClipboardAsText();
            if (text != null) {
                for (int n : text.toCharArray()) {
                    KeyRequest keyRequest = new KeyRequest();
                    keyRequest.preferMappedMode = true;
                    keyRequest.characterTyped = n;
                    keyRequest.keyPressed = true;
                    this.controller.sendKeyRequest(keyRequest);
                    Thread.sleep(10L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void action_command() {
        RunCommandUI ui = new RunCommandUI(this.remoteOsBase, this.remoteOSVariant);
        ui.showDialog(this.uinterface.getParentFrame());
        String command = ui.getCommandToRun();
        boolean elevate = ui.getElevate();
        if (command == null) {
            return;
        }
        this.controller.runProgram(command, ".", elevate);
    }

    public void testTakeTuningSnapshot(String name) {
        JWTesting.reportScreenshot(name, this.tune_dialog.getInternalFrame(), false);
    }

    public void showSessionInfoDialog() {
        this.action_tune(true);
    }

    private void action_tune(boolean showSessionFirst) {
        long fpsDelay = -1L;
        if (this.techUser != null && this.techUser.isFPSLimited()) {
            fpsDelay = this.techUser.getFPSDelay();
        }
        this.tune_dialog = new TuneDialog(this.uinterface, this.uinterface.getParentFrame(), this.controller, this.techUser != null && this.techUser.getPermissions().canUseUDP(), fpsDelay);
        this.tune_dialog.showSessionInfo();
        this.tune_dialog.setVisible(true);
        this.controller.requestScreenResend();
    }

    private void action_autoRefresh() {
        this.setAutoRefreshAndDontCheckPermissions(!this.continuous_refresh);
    }

    public void trySetAutoRefreshState(boolean newState) {
        if (!newState) {
            this.setAutoRefreshAndDontCheckPermissions(newState);
        } else {
            boolean refresh = this.permissionsHandler.canView();
            this.setAutoRefreshAndDontCheckPermissions(refresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAutoRefreshAndDontCheckPermissions(boolean newStatus) {
        NorthPanel.logPreLock("setAutoRefreshAndDontCheckPermissions");
        Object object = this.PERMISSIONS_LOCK;
        synchronized (object) {
            NorthPanel.logPostLock("setAutoRefreshAndDontCheckPermissions");
            new AutoRefresh(newStatus).start();
        }
    }

    public boolean getAutoRefresh() {
        return this.continuous_refresh;
    }

    public void upgradeComplete() {
        if (this.tune_dialog != null) {
            try {
                this.tune_dialog.upgradeComplete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void connected() {
        this.resolutionControlPanel.connected();
        System.out.println("[NorthPanel] (Connected) on");
        this.setControlsEnabled(true);
        System.out.println("[NorthPanel] (Connected) Setting static boolean property");
        if (!this.disregardRememberedEchoState) {
            if (SessionProperties.INSTANCE.getBooleanProp(SessionProperties.PROP_TEXTECHO, true)) {
                this.turnOnTextEcho();
            } else {
                this.turnOffTextEcho();
            }
        }
        System.out.println("[NorthPanel] (Connected) AutoRefresh run()");
        new AutoRefresh(true).run();
    }

    public void setMode(final int mode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.currentMode = mode;
                NorthPanel.this.updateButtonsForNewMode();
                NorthPanel.this.mode_rdesktop.setSelected(mode == 0);
                NorthPanel.this.mode_ftransfer.setSelected(mode == 1 || mode == 6);
                NorthPanel.this.mode_diagnostics.setSelected(mode == 2 || mode == 7);
                NorthPanel.this.mode_vnc.setSelected(mode == 3);
            }
        });
    }

    public void incrementChatCount() {
        if (!this.uinterface.isChatPanelVisible()) {
            ++this.unseenChatCount;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NorthPanel.this.chatButton.setIcon(ImageLoader.getIncrementalOverlayedIcon(ImageLoader.getImageIcon("images/svg/computing/east-panel.svg,20"), NorthPanel.this.unseenChatCount));
                    NorthPanel.this.chatButton.repaint();
                    if (OS.isMacOS()) {
                        OSXAdapter.setDockIconBadge("" + NorthPanel.this.unseenChatCount);
                    }
                }
            });
        }
        String frameTitle = this.uinterface.getParentFrame().getTitle();
        if (!this.uinterface.getParentFrame().isFocused()) {
            OSNotificationUtil.notifyUser(frameTitle, 3);
        }
    }

    public void clearChatCount() {
        this.unseenChatCount = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.chatButton.setIcon(ImageLoader.getImageIcon("images/svg/computing/east-panel.svg,20"));
                NorthPanel.this.chatButton.repaint();
                if (OS.isMacOS()) {
                    OSXAdapter.setDockIconBadge(null);
                }
            }
        });
    }

    public void setScreenSize(int w, int h, ScreenDimension[] screens) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermissions() {
        if (this.permissionsHandler == null) {
            return;
        }
        NorthPanel.logPreLock("updatePermissions");
        Object object = this.PERMISSIONS_LOCK;
        synchronized (object) {
            NorthPanel.logPostLock("updatePermissions");
            this.control_enabled = this.permissionsHandler.canControl();
            this.control_enabled = !this.control_enabled;
            this.switchControlNow();
            this.updateEnabled();
            boolean refresh = this.permissionsHandler.canView();
            this.setAutoRefreshAndDontCheckPermissions(refresh);
            boolean canEcho = this.permissionsHandler.getPermissions().canEchoText();
            if (!canEcho) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NorthPanel.this.turnOffTextEcho();
                        NorthPanel.this.echo_show.setVisible(false);
                    }
                });
            }
        }
    }

    private void updateEnabled() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NorthPanel.this.opt_command.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.opt_cad.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.opt_reboot.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.opt_vnc.setEnabled(NorthPanel.this.permissionsHandler.getPermissions().canUseVNC());
                NorthPanel.this.clipMenuButton.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.keyboardMenuButton.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.cadButton.setEnabled(NorthPanel.this.control_enabled);
                NorthPanel.this.mode_diagnostics.setEnabled(NorthPanel.this.permissionsHandler.getPermissions().canUseDiagnostics());
                NorthPanel.this.mode_ftransfer.setEnabled(NorthPanel.this.permissionsHandler.getPermissions().canUseFileTransfer());
                NorthPanel.this.opt_sginstall.setEnabled(true);
                NorthPanel.this.opt_sguninstall.setEnabled(NorthPanel.this.canUninstallSG);
                NorthPanel.this.cont_show.setEnabled(NorthPanel.this.permissionsHandler.canControlOrRequestControl());
                NorthPanel.this.uinterface.setCanControlAndView(NorthPanel.this.control_enabled && NorthPanel.this.permissionsHandler.canControl(), NorthPanel.this.permissionsHandler.canView());
                NorthPanel.this.opt_menu.repaint();
            }
        });
    }

    public void setTechnicianPermissions(TechGroupPermissions permissions, boolean techWishesRequestControl) {
        System.out.println("[NorthPanel] Setting technician permissions");
        this.permissionsHandler = new TechPermissionsHandler(permissions, techWishesRequestControl);
        this.updatePermissions();
    }

    private static void logPreLock(String methodName) {
        if (CentralDebugging.DEBUG_NORTHPANEL_LOCK) {
            System.out.println("[NorthPanel] (" + methodName + ", " + Thread.currentThread().getName() + ") - Requesting PERMISSIONS_LOCK");
        }
    }

    private static void logPostLock(String methodName) {
        if (CentralDebugging.DEBUG_NORTHPANEL_LOCK) {
            System.out.println("[NorthPanel] (" + methodName + ", " + Thread.currentThread().getName() + ") - Got PERMISSIONS_LOCK");
        }
    }

    public void setFileTransferProgress(int cur, int tot) {
        if (tot > 0 && cur != tot) {
            double percentage = (double)cur / (double)tot;
            this.mode_ftransfer.setProgress(percentage);
            this.mode_ftransfer.setShowProgressBar(true);
        } else {
            this.mode_ftransfer.setShowProgressBar(false);
        }
    }

    public void setVNCLocalStatus(boolean isLocal) {
    }

    public void setTechUser(TransientTechUser techUser) {
        this.techUser = techUser;
    }

    public void setResolutionPercentage(double scale) {
        System.out.println("[NorthPanel] Setting resolution scale to " + scale);
        this.ignoreResolutionChange = true;
        this.resolutionControlPanel.setResolutionPercentage(scale);
        this.resolutionBar.setValue((int)(scale * 100.0));
        this.ignoreResolutionChange = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int value = this.resolutionBar.getValue();
        int max = this.resolutionBar.getMaximum();
        int min = this.resolutionBar.getMinimum();
        if (e.getSource() == this.zoom_in && value < max) {
            this.resolutionBar.setValue(value + 1);
        } else if (e.getSource() == this.zoom_out && value > min) {
            this.resolutionBar.setValue(value - 1);
        }
        this.resolutionBar.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setupPostPreload() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ClientManagement.isSimpleHelp()) {
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_shortcut);
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_reconnect);
                } else {
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_elevate);
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_callingcard);
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_dupconnect);
                    NorthPanel.this.opt_menu.remove(NorthPanel.this.opt_sginstall);
                }
                NorthPanel.this.opt_menu.revalidate();
            }
        });
    }

    class NorthPanelMenuSeparator
    extends JSeparator {
        public NorthPanelMenuSeparator(boolean showIfHeadless) {
        }
    }

    class Spacer
    extends JPanel {
        public Spacer() {
            SwingUtil.setWidth(this, SimpleHelpLookAndFeel.scale(15));
            this.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        }
    }

    class NorthPanelToggleButton
    extends JToggleButton {
        private double percentage;
        private boolean showProgressBar;

        public NorthPanelToggleButton(Icon imageIcon) {
            super(imageIcon);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(BUTTON_SIZE_X, BUTTON_SIZE_Y);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void setProgress(double percentage) {
            if (percentage != this.percentage) {
                this.percentage = percentage;
                this.repaint();
            }
        }

        public void setShowProgressBar(boolean showProgressBar) {
            if (this.showProgressBar != showProgressBar) {
                this.showProgressBar = showProgressBar;
                if (!showProgressBar) {
                    this.percentage = -1.0;
                }
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.showProgressBar) {
                int leftBuffer = 4;
                int arc = 2;
                int bottomBuffer = 7;
                int height = 4;
                g.setColor(Color.WHITE);
                g.fillRoundRect(leftBuffer, this.getHeight() - bottomBuffer, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
                if (this.isEnabled()) {
                    g.setColor(SHStyle.MINI_PROGRESS_FILL);
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                }
                int width = (int)(this.percentage * (double)(this.getWidth() - 2 * leftBuffer - 1));
                g.fillRoundRect(leftBuffer, this.getHeight() - bottomBuffer, width, height, arc, arc);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRoundRect(leftBuffer, this.getHeight() - bottomBuffer, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
            }
        }
    }

    class NorthPanelButton
    extends JButton {
        public NorthPanelButton(Icon imageIcon) {
            super(imageIcon);
        }

        public NorthPanelButton(String text, Icon imageIcon) {
            super(text, imageIcon);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(BUTTON_SIZE_X, BUTTON_SIZE_Y);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    class NorthPanelCheckMenuItem
    extends JCheckBoxMenuItem {
        public NorthPanelCheckMenuItem(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    class NorthPanelMenuItem
    extends JMenuItem {
        public NorthPanelMenuItem(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    class AutoRefresh
    extends Thread {
        final boolean newStatus;

        public AutoRefresh(boolean newStatus) {
            super("AutoRefresh-" + AUTO_REFRESH_THREAD_COUNTER++);
            this.newStatus = newStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NorthPanel.logPreLock("[NorthPanel] AutoRefresh starting up");
            Object object = NorthPanel.this.PERMISSIONS_LOCK;
            synchronized (object) {
                NorthPanel.logPostLock("[NorthPanel] Got permissions lock");
                if (this.newStatus) {
                    System.out.println("[NorthPanel] Turning screen updates on");
                    NorthPanel.this.auto_refresh.setToolTipText(Language.get("AUTO_SCREEN_REFRESH_ON"));
                    NorthPanel.this.auto_refresh.setIcon(ImageLoader.getImageIcon("images/svg/arrows/refresh.svg,20"));
                    if (NorthPanel.this.controller != null) {
                        NorthPanel.this.controller.setContinuousRequestScreen(true);
                        NorthPanel.this.controller.requestScreen();
                    }
                } else {
                    System.out.println("[NorthPanel] Turning screen updates off");
                    if (NorthPanel.this.controller != null) {
                        NorthPanel.this.controller.setContinuousRequestScreen(false);
                    }
                    if (NorthPanel.this.permissionsHandler != null) {
                        if (NorthPanel.this.permissionsHandler.canView()) {
                            NorthPanel.this.auto_refresh.setToolTipText(Language.get("AUTO_SCREEN_REFRESH_OFF"));
                            NorthPanel.this.auto_refresh.setIcon(ImageLoader.getImageIcon("O[images/svg/arrows/refresh.svg,20 | images/svg/dialogs/warning.svg,12]"));
                        } else {
                            NorthPanel.this.auto_refresh.setToolTipText(Language.get("AUTO_SCREEN_REFRESH_OFF_REQUEST"));
                            NorthPanel.this.auto_refresh.setIcon(ImageLoader.getImageIcon("O[images/svg/arrows/refresh.svg,20 | images/svg/dialogs/question.svg,12]"));
                        }
                    }
                }
                NorthPanel.this.continuous_refresh = this.newStatus;
            }
        }
    }

    class GetDebugThread
    extends Thread {
        final File file;
        final boolean doConnectionTest;
        final boolean extendedConnectionTest;

        public GetDebugThread(File file, boolean doConnectionTest, boolean extendedConnectionTest) {
            this.file = file;
            this.doConnectionTest = doConnectionTest;
            this.extendedConnectionTest = extendedConnectionTest;
        }

        @Override
        public void run() {
            try {
                FileOutputStream fout = new FileOutputStream(this.file);
                PrintStream pout = new PrintStream(fout);
                NorthPanel.this.uinterface.setTopLeftGreyOverlay(Language.get("GETTING_DEBUG_INFO"), 300000L);
                try {
                    pout.println("**** Session Debug Information ****");
                    pout.println("");
                    pout.println("" + new Date());
                    pout.println("");
                    pout.println("**** Technician Side Information ****");
                    pout.println("");
                    pout.println(SystemInfo.getFullInfo());
                    FixedByteBuffer.INSTANCE.writeContentsTo(pout);
                    pout.println("");
                    pout.println("**** Customer Side Information ****");
                    pout.println("");
                    LogTextFetcher listener = new LogTextFetcher();
                    System.out.println("Sent request for logs...");
                    NorthPanel.this.controller.doAsyncRemoteCommand(listener, new Message(-1061158891));
                    for (int i = 0; i < 20; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (listener.logText == null) continue;
                        System.out.println("fetched logs OK");
                        pout.println(listener.logText);
                        break;
                    }
                    if (listener.logText == null) {
                        pout.println("(customer side info not available)");
                    }
                    if (this.doConnectionTest) {
                        NorthPanel.this.uinterface.setTopLeftGreyOverlay(Language.get("DOING_CONNECTION_TEST"), 1800000L);
                        listener = new LogTextFetcher();
                        System.out.println("Sent request for connection test...");
                        Message m = new Message(-1061158875);
                        m.append(this.extendedConnectionTest);
                        NorthPanel.this.controller.doAsyncRemoteCommand(listener, m);
                        pout.println("**** Technician Side Connection Test ****");
                        pout.println("");
                        pout.println(SHelpNodelinkConnector.diagnoseConnectionIssues(NorthPanel.this.controller.getConnectedServerIp(), NorthPanel.this.controller.getConnectedServerPort(), this.extendedConnectionTest, true));
                        pout.println("");
                        pout.println("**** Customer Side Connection Test ****");
                        pout.println("");
                        for (int i = 0; i < 180; ++i) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (listener.logText == null) continue;
                            System.out.println("fetched connection test OK");
                            pout.println(listener.logText);
                            break;
                        }
                        if (listener.logText == null) {
                            pout.println("(customer side connection test not available)");
                        }
                    }
                    pout.println("");
                }
                catch (Throwable listener) {
                    // empty catch block
                }
                NorthPanel.this.uinterface.setTopLeftGreyOverlay(Language.get("GOT_DEBUG_INFO"), 3000L);
                pout.close();
            }
            catch (Exception x) {
                String msg = Language.get("ERROR_GOT_DEBUG_INFO");
                if (x instanceof FileNotFoundException) {
                    String xMessage = x.getMessage();
                    int lastClose = xMessage.lastIndexOf(41);
                    int lastOpen = xMessage.lastIndexOf(40);
                    if (lastClose != -1 && lastOpen != -1 && lastOpen < lastClose) {
                        msg = msg + " - " + xMessage.substring(lastOpen + 1, lastClose);
                    }
                }
                NorthPanel.this.uinterface.setTopLeftGreyOverlay(msg, 5000L);
            }
        }
    }

    class ConnectionTestDialog
    extends OKCancelDialogPanel {
        CheckBoxField extendedField;

        public ConnectionTestDialog() {
            super(Language.get("START_TEST"), Language.get("CANCEL"));
            this.setIcon(ImageLoader.getImageIcon("images/svg/computing/network.svg,48"));
            this.setTitle(Language.get("DO_CONNECTION_TEST"), false);
        }

        public void showDialog(RootPaneContainer rpc) {
            this.extendedField = new CheckBoxField(Language.get("DO_CONNECTION_TEST_LONG"), null);
            FixedWidthCUIPanel cuiPanel = new FixedWidthCUIPanel();
            cuiPanel.setFields(new CUIField[]{this.extendedField});
            AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, 400, (AbstractDialogPanel)this);
            dialog.setTitle(Language.get("DO_CONNECTION_TEST_TITLE"));
            dialog.showDialog();
        }

        public boolean doExtendedTest() {
            return this.extendedField.isChecked();
        }
    }

    private class ScreenResponseListener
    implements CommandResponseListener {
        private ScreenResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            System.out.println("[NorthPanel] Got screen request response.");
            NorthPanel.this.auto_refresh.setEnabled(true);
            boolean result = m.getAsBoolean(0);
            if (result) {
                NorthPanel.this.permissionsHandler.requestScreenApproved();
                NorthPanel.this.action_autoRefresh();
            }
            NorthPanel.this.updateEnabled();
            Object object = NorthPanel.this.SCREEN_REQUEST_LOCK;
            synchronized (object) {
                NorthPanel.this.SCREEN_REQUEST_LOCK.notify();
            }
        }
    }

    private class RequestScreenThread
    extends Thread {
        private RequestScreenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("[NorthPanel] RequestScreenThread start");
            NorthPanel.this.auto_refresh.setEnabled(false);
            try {
                NorthPanel.this.controller.sendPermissionsRequest(Language.get("NORTH_PANEL_CONTROL_TITLE"), NorthPanel.this.uinterface.getTechUser().getDisplayName() + " " + Language.get("NORTH_PANEL_SCREEN_MESSAGE"), new ScreenResponseListener());
                Object object = NorthPanel.this.SCREEN_REQUEST_LOCK;
                synchronized (object) {
                    try {
                        NorthPanel.this.SCREEN_REQUEST_LOCK.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                NorthPanel.this.auto_refresh.setEnabled(true);
            }
        }
    }

    private class ControlResponseListener
    implements CommandResponseListener {
        private ControlResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            System.out.println("[NorthPanel] Got control response.");
            NorthPanel.this.cont_show.setEnabled(true);
            boolean result = m.getAsBoolean(0);
            if (result) {
                NorthPanel.this.permissionsHandler.requestControlApproved();
                NorthPanel.this.switchControlNow();
            }
            NorthPanel.this.updateEnabled();
            Object object = NorthPanel.this.CONTROL_REQUEST_LOCK;
            synchronized (object) {
                NorthPanel.this.CONTROL_REQUEST_LOCK.notify();
            }
        }
    }

    private class RequestControlThread
    extends Thread {
        private RequestControlThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("[NorthPanel] RequestControlThread start");
            NorthPanel.this.cont_show.setEnabled(false);
            try {
                NorthPanel.this.controller.sendPermissionsRequest(Language.get("NORTH_PANEL_CONTROL_TITLE"), NorthPanel.this.uinterface.getTechUser().getDisplayName() + " " + Language.get("NORTH_PANEL_CONTROL_MESSAGE"), new ControlResponseListener());
                Object object = NorthPanel.this.CONTROL_REQUEST_LOCK;
                synchronized (object) {
                    try {
                        NorthPanel.this.CONTROL_REQUEST_LOCK.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                NorthPanel.this.cont_show.setEnabled(true);
            }
        }
    }

    class LogTextFetcher
    implements CommandResponseListener {
        String logText;

        LogTextFetcher() {
        }

        @Override
        public void response(Message m) {
            this.logText = (String)m.get(0);
        }
    }

    private class PopupCloser
    implements AWTEventListener {
        private PopupCloser() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (SwingUtilities.isDescendingFrom((Component)event.getSource(), NorthPanel.this.resolutionControlPanel.getRootComponent()) || NorthPanel.this.resolutionControlPanel.getRootComponent() == event.getSource()) {
                MouseEvent me = (MouseEvent)event;
                if (me.getID() == 504) {
                    if (NorthPanel.this.closeThread != null) {
                        NorthPanel.this.closeThread.cancel();
                        NorthPanel.this.closeThread = null;
                    }
                } else if (me.getID() == 505) {
                    NorthPanel.this.closeThread = new CloseMenuThread();
                    NorthPanel.this.closeThread.start();
                }
            }
        }
    }

    class CloseMenuThread
    extends Thread {
        private boolean cancel = false;

        CloseMenuThread() {
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.cancel) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NorthPanel.this.resolutionOptionsMenu.setVisible(false);
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

