/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.SafeResourceBundle;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.vis.NLOptimisationFeed;
import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.ClientChatPanel;
import com.aem.sdesktop.client.gui.ConnectionSwitch;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.SimpleTunePanel;
import com.aem.sdesktop.client.gui.ToolsPanel;
import com.aem.sdesktop.client.gui.tools.RecordTool;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.mdupload.fs.WTokServerFS;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.common.ToolBoxConstants;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.tech.access.model.machine.filters.RunToolMachineFilter;
import com.aem.shelp.tech.properties.ToolBoxPropertiesPanel;
import com.aem.shelp.tech.toolbox.ToolBoxUI;
import com.aem.shelp.util.TimerPanel;
import com.aem.shelp.util.WebTransactor;
import com.aem.shelp.util.font.GlyphIconsLabel;
import com.aem.utils.sound.SoundUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.Mixer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import utils.message.Message;
import utils.osstats.types.SessionInfo;
import utils.progtools.WeakReferenceTimerThread;
import utils.swing.SwingUtil;
import utils.swing.components.CleanTabbedPanel;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.EnabledPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class EastPanel
extends JPanel
implements ActionListener,
NLOptimisationFeed,
NodeLinkStatusListener {
    private GlyphIconsLabel tuning;
    private GlyphIconsLabel moreInfo;
    private final ConnectionSwitch cs;
    private final TimerPanel timer = new TimerPanel(false);
    private ConnectionTuningSubPanel connectionTuningPanel;
    private GbPanel infoPanel;
    private BasicInfoSubPanel connectionTargetPanel;
    private JPanel connectionRatingPanel;
    private JPanel timePanel;
    ClientChatPanel chatPanel;
    private JPanel chatContainer;
    ToolBoxUI toolBoxUI;
    private ToolsPanel toolsPanel;
    private CleanTabbedPanel ctp;
    private final ClientController controller;
    private final ClientUserInterface gui;
    private RecordTool.RecordPanel recordPanel;
    private boolean canUseUDP = true;
    private int rowHeight;
    private StyledDocument chat_;
    private int connStarsMin = 0;
    private boolean connected = false;
    boolean optimised = false;
    private WebTransactor wtrans;

    public EastPanel(ClientController c, ClientUserInterface ui, boolean chatDisabled) {
        this.controller = c;
        this.gui = ui;
        this.cs = new ConnectionSwitch(this.canUseUDP, ui, c);
        this.initUI(chatDisabled, c);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.updateEnabled(b);
    }

    private void initInfoPanel() {
        this.timer.showZeroData(false);
        this.timer.showIcon(false);
        this.timer.summarise(true);
        this.tuning = new GlyphIconsLabel(SimpleHelpLookAndFeel.scale(14.0f));
        if (Switches.SH_updatedConnectionTuning) {
            this.tuning.setText("\ue602");
        } else {
            this.tuning.setText("\ue281");
        }
        this.tuning.setForeground(SHStyle.MINI_PROGRESS_FILL);
        this.moreInfo = new GlyphIconsLabel(SimpleHelpLookAndFeel.scale(14.0f));
        this.moreInfo.setText("\ue602");
        this.moreInfo.setForeground(SHStyle.MINI_PROGRESS_FILL);
        JLabel connectionLabel = new JLabel(Language.get("CONNECTION") + " ");
        JLabel durationLabel = new JLabel(Language.get("DURATION") + " ");
        SwingUtil.setSizesToWidest(connectionLabel, durationLabel);
        this.connectionTargetPanel = new BasicInfoSubPanel();
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)this.cs.getLabel(), "West");
        this.timePanel = new EnabledPropagatingPanel(new BorderLayout(5, 0));
        this.timePanel.add((Component)durationLabel, "West");
        this.timePanel.add((Component)this.timer, "Center");
        this.infoPanel.add(this.connectionTargetPanel, 0, 0, 1, 1, 1, 1, 17, 2, new ScaledInsets(2, 0, 2, 0));
        if (!Switches.SH_updatedConnectionTuning) {
            this.connectionRatingPanel = new EnabledPropagatingPanel(new BorderLayout(5, 0));
            this.connectionRatingPanel.add((Component)connectionLabel, "West");
            this.connectionRatingPanel.add((Component)subPanel, "Center");
            this.connectionRatingPanel.add((Component)this.tuning, "East");
            this.infoPanel.add(this.connectionRatingPanel, 0, 1, 1, 1, 1, 1, 17, 2, new ScaledInsets(2, 5, 2, 5));
        } else {
            this.connectionTuningPanel = new ConnectionTuningSubPanel(connectionLabel);
            this.infoPanel.add(this.connectionTuningPanel, 0, 1, 1, 1, 1, 1, 17, 2, new ScaledInsets(2, 0, 2, 0));
        }
        this.infoPanel.add(this.timePanel, 0, 2, 1, 1, 1, 1, 17, 2, new ScaledInsets(2, 5, 2, 5));
        this.tuning.addActionListener(this);
        this.tuning.setEnabled(false);
        this.moreInfo.addActionListener(this);
        this.moreInfo.setEnabled(false);
        this.rowHeight = !Switches.SH_updatedConnectionTuning ? this.connectionRatingPanel.getPreferredSize().height : this.connectionTuningPanel.getPreferredSize().height + SimpleHelpLookAndFeel.scale(5);
        SwingUtil.setHeight(this.timePanel, this.rowHeight);
    }

    public void loadStaticTechnicianPreferences() {
        String mixerName = TechProperties.INSTANCE.getProp("mxr");
        Mixer mixer = SoundUtils.getSourceDataLineMixerByName(mixerName);
        this.gui.setAudioMixer(mixer);
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.connectionTargetPanel.setSessionInfo(sessionInfo);
        if (Switches.SH_updatedConnectionTuning) {
            this.connectionTuningPanel.setSessionInfo(sessionInfo);
        }
    }

    public StyledDocument getChatDocument() {
        return this.chatPanel.getChatDocument();
    }

    private void setConnectionIcon(boolean optimising) {
        this.cs.setStars(this.connStarsMin);
    }

    public void disableChat() {
        if (this.ctp.getTabCount() == 2) {
            this.ctp.removeTab(0);
        }
    }

    private void initUI(boolean chatDisabled, ClientController c) {
        Tool[] tools = Tool.getToolsAndInitUI(c, this.gui);
        RecordTool recordTool = null;
        for (Tool tool : tools) {
            if (!(tool instanceof RecordTool)) continue;
            recordTool = (RecordTool)tool;
            break;
        }
        this.infoPanel = new GbPanel();
        this.initInfoPanel();
        this.chatPanel = new ClientChatPanel(c, this.gui);
        this.chatPanel.setTitle(null);
        this.recordPanel = recordTool.getRecordPanel();
        GbPanel northPanel = new GbPanel();
        northPanel.add(this.infoPanel, 0, 0, 1, 1, 1, 1, 10, 1);
        if (GroupAccessKeyset.isEnabled()) {
            this.infoPanel.setBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, SHStyle.PANEL_BACKGROUND_DARKER));
        } else {
            northPanel.add(this.recordPanel.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 1);
        }
        this.chatContainer = new JPanel();
        this.chatContainer.setLayout(new BorderLayout());
        this.chatContainer.add("North", northPanel);
        if (GroupAccessKeyset.isEnabled()) {
            JPanel white = new JPanel();
            white.setBackground(Color.white);
            this.chatContainer.add("Center", white);
        } else {
            this.chatContainer.add("Center", this.chatPanel.getRootComponent());
        }
        this.toolsPanel = new ToolsPanel(tools);
        this.toolBoxUI = new ToolBoxUI(false, null){

            @Override
            public void performSave() {
            }

            @Override
            public void synchroniseResources(ToolBoxUI ui, ToolBoxItem item, ToolBoxPropertiesPanel.SyncCancelledListener listener) {
            }

            @Override
            public void synchroniseResourcesAndBlock(ToolBox toolbox, ToolBoxItem item, ToolBoxPropertiesPanel.SyncCancelledListener listener) {
            }

            @Override
            public RunToolMachineFilter.ToolBoxResultWrapper runItem(ToolBoxItem item) {
                WTokServerFS serverFS = new WTokServerFS(EastPanel.this.wtrans);
                ToolBoxConstants.syncResourcesHeadless(serverFS, item);
                ToolBoxResult result = EastPanel.this.controller.runToolBoxItem(item);
                RunToolMachineFilter.ToolBoxResultWrapper wrapper = new RunToolMachineFilter.ToolBoxResultWrapper();
                wrapper.updateStatus(result);
                return wrapper;
            }

            @Override
            public ToolBoxGroup[] getSharedToolboxGroups() throws Exception {
                return null;
            }
        };
        this.setBackground(Color.WHITE);
        this.ctp = new CleanTabbedPanel(true);
        if (!chatDisabled) {
            this.ctp.addTab(ImageLoader.getImageIcon("images/svg/chat/chat.svg,24"), this.chatContainer);
        }
        if (!GroupAccessKeyset.isEnabled()) {
            this.ctp.addTab(ImageLoader.getImageIcon("images/svg/general/box.svg,24"), this.toolBoxUI.getRootComponent());
            this.ctp.addTab(ImageLoader.getImageIcon("images/svg/general/switch.svg,24"), this.toolsPanel.getRootComponent());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.ctp.getRootComponent(), "Center");
        this.ctp.getRootComponent().setPreferredSize(new Dimension(SimpleHelpLookAndFeel.scale(250), -1));
        this.updateEnabled(false);
        this.ctp.addTabChangeListener(new CleanTabbedPanel.TabChangeListener(){

            @Override
            public void notifyTabChange(JPanel newChosenPanel) {
                if (newChosenPanel == EastPanel.this.chatPanel.getRootComponent()) {
                    ((GUI)((EastPanel)EastPanel.this).gui).northp.clearChatCount();
                }
            }
        });
    }

    public String getChatText() {
        return this.chatPanel.getChatText();
    }

    public void addMessage(String user, String host, String message) {
        this.chatPanel.addMessage(user, host, message);
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        SafeResourceBundle.loadTestBundle();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        ((Window)frame).setSize(200, 300);
        EastPanel eastPanel = new EastPanel(null, null, false);
        frame.getContentPane().add(eastPanel);
        frame.setVisible(true);
        Thread.sleep(2000L);
        eastPanel.chatPanel.setEnabled(true);
        eastPanel.setEnabled(true);
        eastPanel.chatPanel.setEnabled(true);
        eastPanel.toolsPanel.setRemoteOS(0, 1);
        eastPanel.toolsPanel.setEnabled(true);
        eastPanel.ctp.setEnabled(true);
        eastPanel.tuning.setEnabled(true);
        eastPanel.toolBoxUI.setEnabled(true);
    }

    public void setTechUser(TransientTechUser user) {
        this.toolsPanel.setTechUser(user);
        this.chatPanel.setTechnicianDisplayName(user.displayName);
    }

    public void setToolState(String toolClassName, boolean enabled) {
        this.toolsPanel.setToolState(toolClassName, enabled);
    }

    private void updateEnabled(boolean enabled) {
        this.chatPanel.setEnabled(enabled);
        this.toolsPanel.setEnabled(enabled);
        this.ctp.setEnabled(enabled);
        this.tuning.setEnabled(enabled);
        this.cs.setEnabled(enabled);
        this.recordPanel.setEnabled(enabled);
        this.infoPanel.setEnabled(enabled);
        this.timePanel.setEnabled(enabled);
        if (!Switches.SH_updatedConnectionTuning) {
            this.connectionRatingPanel.setEnabled(enabled);
        }
        this.moreInfo.setEnabled(enabled);
        this.connectionTargetPanel.setEnabled(enabled);
        this.setConnectionIcon(false);
        this.repaint();
    }

    public void firstConnect() {
        if (Switches.SH_1562_resetSessionTimerOnFirstConnectOnly) {
            this.timer.reset();
            this.timer.start();
        }
    }

    public void connected() {
        this.connected = true;
        this.updateEnabled(true);
        if (this.controller == null) {
            return;
        }
        boolean safeToDoPortScanToTargetMachine = this.controller.getConnectedMachinePrefs().areUdpPortScansOK();
        if (CentralDebugging.NEVER_STORE_UDP_ALLOW_PS) {
            System.out.println("[NL UDP] Forcibly ignoring preferences for UDP PS");
            safeToDoPortScanToTargetMachine = false;
        }
        if (CentralDebugging.ALWAYS_ATTEMPT_FULL_UDP_DIRECT) {
            System.out.println("[NL UDP] Set to ALWAYS attempt FULL UDP PS");
            safeToDoPortScanToTargetMachine = true;
        }
        new ConnectionFetchThread(false, safeToDoPortScanToTargetMachine).start();
        if (Switches.SH_updatedConnectionTuning) {
            this.connectionTuningPanel.updateHeader();
        }
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.toolsPanel.setRemoteOS(remoteOsBase, remoteOsVariant);
        if (this.toolsPanel.isEmpty()) {
            this.ctp.removeTab(this.toolsPanel.getRootComponent());
            this.adjustEmpty();
        }
        this.toolBoxUI.setRemoteOperatingSystems(new int[]{remoteOsBase});
    }

    private void adjustEmpty() {
        if (this.ctp.getTabCount() == 0) {
            this.ctp.setVisible(false);
            this.setVisible(false);
        }
    }

    public void setCanControlAndView(boolean canControl, boolean canView) {
        this.toolsPanel.setEnabled(canControl);
    }

    public boolean isChatPanelVisible() {
        if (!this.ctp.isVisible()) {
            return false;
        }
        return this.ctp.getSelectedTab() == this.chatContainer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.tuning) {
            if (Switches.SH_updatedConnectionTuning) {
                this.connectionTuningPanel.toggleDetails();
            } else {
                this.gui.showSessionInfoDialog();
            }
        } else if (o == this.moreInfo) {
            this.connectionTargetPanel.toggleDetails();
        }
    }

    public void upgradeComplete() {
        SwingUtilities.invokeLater(new UpgradeDone(true));
    }

    @Override
    public void resetOptimisation() {
        this.setConnectionIcon(true);
        this.cs.repaint();
    }

    @Override
    public void receivingFreshData() {
        this.setConnectionIcon(false);
        this.cs.repaint();
    }

    @Override
    public void waitingForResend() {
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        this.updateEnabled(false);
        this.toolsPanel.linkDown(link, reason);
    }

    @Override
    public void linkOK(NodeLink link) {
        this.updateEnabled(true);
        this.toolsPanel.linkOK(link);
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        this.updateEnabled(false);
        this.toolsPanel.linkDead(link, reason);
    }

    public void setTechnicianPermissions(TechGroupPermissions permissions) {
        this.canUseUDP = permissions.canUseUDP();
        this.cs.setCanUseUDP(this.canUseUDP);
        this.toolsPanel.setTechnicianPermissions(permissions);
        if (!permissions.canRunToolsInSessions()) {
            this.ctp.removeTab(this.toolBoxUI.getRootComponent());
        }
    }

    public void hideRecordingButtons() {
        this.recordPanel.rootComponent.setVisible(false);
    }

    public void setWebTransactor(WebTransactor wtrans) {
        this.wtrans = wtrans;
    }

    public void startTimer() {
        this.timer.reset();
        this.timer.start();
    }

    public void updateSessionStats() {
        if (Switches.SH_updatedConnectionTuning) {
            this.connectionTuningPanel.updateHeader();
        }
    }

    public class ToggleIconJLabel
    extends JPanel
    implements MouseListener {
        private GlyphIconsLabel icon;
        private JLabel text;
        private String oldIcon;
        private boolean exited = false;

        public ToggleIconJLabel(String iconText) {
            this.setLayout(new BorderLayout());
            this.icon = new GlyphIconsLabel(SimpleHelpLookAndFeel.scale(14.0f));
            this.icon.setForeground(SHStyle.MINI_PROGRESS_FILL);
            this.icon.setText(iconText);
            SwingUtil.setWidth(this.icon, SimpleHelpLookAndFeel.scale(22));
            this.text = new JLabel();
            SwingUtil.setHeight(this, SimpleHelpLookAndFeel.scale(20));
            this.add((Component)this.icon, "West");
            this.add((Component)this.text, "Center");
            this.addMouseListener(this);
        }

        public void setText(String textString) {
            this.text.setText(textString);
        }

        public void copy() {
            ClipboardUtil.setClipboardAsText(this.text.getText());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            new Thread(){

                @Override
                public void run() {
                    ToggleIconJLabel.this.copy();
                    ToggleIconJLabel.this.icon.setText("\ue199");
                    ToggleIconJLabel.this.repaint();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!ToggleIconJLabel.this.exited) {
                        ToggleIconJLabel.this.icon.setText("\ue030");
                        ToggleIconJLabel.this.repaint();
                    }
                }
            }.start();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.exited = false;
            this.oldIcon = this.icon.getText();
            if (this.oldIcon != null) {
                this.icon.setText("\ue030");
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.exited = true;
            this.icon.setText(this.oldIcon);
        }
    }

    class BasicInfoSubPanel
    extends ColorPropagatingPanel
    implements MouseListener {
        private final JWrapLabel titleLabel = new JWrapLabel();
        private final ColorPropagatingGBPanel detailsPanel = new ColorPropagatingGBPanel();
        private ToggleIconJLabel[] lanIPLabels = null;
        private final JPanel lanIPPanel = new ColorPropagatingPanel(new GridLayout(0, 1));
        private final ToggleIconJLabel hostnameIcon = new ToggleIconJLabel("\ue066");
        private final ToggleIconJLabel osIcon = new ToggleIconJLabel("\ue341");
        private final ToggleIconJLabel usernameIcon = new ToggleIconJLabel("\ue004");
        private final ToggleIconJLabel wanIPIcon = new ToggleIconJLabel("\ue341");
        private final ToggleIconJLabel lanIcon = new ToggleIconJLabel("\ue051");

        public BasicInfoSubPanel() {
            this.initUI();
        }

        public void initUI() {
            ColorPropagatingPanel title = new ColorPropagatingPanel(new BorderLayout());
            title.setBorder(SHBorderFactory.createEmptyBorder(0, 5, 0, 5));
            title.add((Component)this.titleLabel, "Center");
            title.add((Component)EastPanel.this.moreInfo, "East");
            this.titleLabel.setText(" ");
            this.setLayout(new BorderLayout());
            this.add((Component)title, "North");
            this.add((Component)this.detailsPanel, "South");
            this.detailsPanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 1, 0, SHStyle.BORDER_COLOR_LIGHT), SHBorderFactory.createEmptyBorder(2, 5, 5, 5)));
            int Y = 0;
            this.detailsPanel.add(this.hostnameIcon, 0, Y++, 1, 1, 1, 1, 10, 2);
            this.hostnameIcon.setToolTipText(Language.get("HOSTNAME"));
            this.detailsPanel.add(this.osIcon, 0, Y++, 1, 1, 1, 1, 10, 2);
            this.osIcon.setToolTipText(Language.get("OPERATING_SYSTEM"));
            this.detailsPanel.add(this.usernameIcon, 0, Y++, 1, 1, 0, 1, 10, 2);
            this.usernameIcon.setToolTipText(Language.get("REMOTE_USER"));
            this.detailsPanel.add(this.wanIPIcon, 0, Y++, 1, 1, 1, 1, 10, 2);
            this.wanIPIcon.setToolTipText("WAN IP");
            this.detailsPanel.add(this.lanIPPanel, 0, Y++, 1, 1, 1, 1, 10, 2);
            this.lanIcon.setToolTipText("LAN IP");
            this.hostnameIcon.addMouseListener(this);
            this.osIcon.addMouseListener(this);
            this.usernameIcon.addMouseListener(this);
            this.wanIPIcon.addMouseListener(this);
            this.wanIPIcon.addMouseListener(this);
            this.detailsPanel.setBackground(Color.WHITE);
            this.lanIPPanel.setVisible(false);
            this.detailsPanel.setVisible(false);
            this.titleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    BasicInfoSubPanel.this.toggleDetails();
                }
            });
        }

        public void toggleDetails() {
            boolean showAllDetails;
            boolean bl = showAllDetails = !this.detailsPanel.isVisible();
            if (showAllDetails) {
                EastPanel.this.moreInfo.setText("\ue601");
            } else {
                EastPanel.this.moreInfo.setText("\ue602");
            }
            this.detailsPanel.setVisible(showAllDetails);
            this.repaint();
        }

        public void setSessionInfo(SessionInfo sessionInfo) {
            ArrayList<JComponent> allComponents = new ArrayList<JComponent>();
            this.setLabelContent(this.titleLabel, sessionInfo.machineTitle);
            this.setLabelContent(this.osIcon, sessionInfo.osNameWithBitness);
            this.setLabelContent(this.hostnameIcon, sessionInfo.hostname);
            this.setLabelContent(this.usernameIcon, sessionInfo.username);
            this.setLabelContent(this.wanIPIcon, sessionInfo.wanip);
            this.lanIPLabels = new ToggleIconJLabel[sessionInfo.localip.length];
            for (int i = 0; i < this.lanIPLabels.length; ++i) {
                this.lanIPLabels[i] = new ToggleIconJLabel("\ue051");
                this.lanIPLabels[i].setText(sessionInfo.localip[i]);
                this.lanIPLabels[i].setOpaque(false);
                this.lanIPPanel.add(this.lanIPLabels[i]);
                allComponents.add(this.lanIPLabels[i]);
            }
            this.lanIPPanel.setVisible(this.lanIPLabels.length > 0);
            allComponents.add(this.titleLabel);
            allComponents.add(this.hostnameIcon);
            allComponents.add(this.usernameIcon);
            allComponents.add(this.wanIPIcon);
            allComponents.add(this.osIcon);
            allComponents.add(this.lanIcon);
            for (JComponent c : allComponents) {
                c.setBorder(SHBorderFactory.createEmptyBorder(5, 0, 0, 5));
                if (c != this.titleLabel && !(c instanceof GlyphIconsLabel)) {
                    c.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
                }
                if (c == this.titleLabel) {
                    SwingUtil.setHeight(c, EastPanel.this.rowHeight);
                    continue;
                }
                SwingUtil.setHeight(c, EastPanel.this.rowHeight - SimpleHelpLookAndFeel.scale(4));
            }
            this.repaint();
        }

        private void setLabelContent(JComponent label, String text) {
            if (label instanceof JLabel) {
                ((JLabel)label).setText(text);
            } else {
                ((ToggleIconJLabel)label).setText(text);
            }
            label.setVisible(text != null && text.length() > 0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class ConnectionTuningSubPanel
    extends ColorPropagatingPanel
    implements MouseListener,
    Runnable {
        Color fgStd;
        Color fgBad = new Color(120, 0, 0);
        JLabel connectionPrefix;
        WeakReferenceTimerThread wrt;
        private final JWrapLabel titleLabel = new JWrapLabel();
        private final SimpleTunePanel detailsPanel = new SimpleTunePanel(EastPanel.access$000(EastPanel.this), (GUI)EastPanel.access$500(EastPanel.this), false);

        public ConnectionTuningSubPanel(JLabel connectionPrefix) {
            this.connectionPrefix = connectionPrefix;
            this.initUI();
            this.wrt = new WeakReferenceTimerThread(this, 3000);
            this.wrt.start();
        }

        @Override
        public void run() {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionTuningSubPanel.this.updateHeader();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void updateHeader() {
            if (EastPanel.this.controller != null) {
                NodeLinkStats stats = EastPanel.this.controller.getLocalSessionStats();
                if (stats == null) {
                    return;
                }
                String type = "TCP";
                if (stats.type == 0) {
                    type = "HTTP";
                } else if (stats.type == 1) {
                    type = "SSL";
                } else if (stats.type == 2) {
                    type = "TCP";
                } else if (stats.type == 3) {
                    type = "Server UDP";
                } else if (stats.type == 4) {
                    type = "Direct UDP";
                }
                if (stats.diedTimes <= 0L) {
                    this.titleLabel.setText(type);
                } else if (stats.diedTimes == 1L) {
                    this.titleLabel.setText(type + " (" + stats.diedTimes + " " + Language.get("CONNECTION_FAILURE") + ")");
                } else {
                    this.titleLabel.setText(type + " (" + stats.diedTimes + " " + Language.get("CONNECTION_FAILURES") + ")");
                }
                if (stats.diedTimes > 4L) {
                    this.titleLabel.setForeground(this.fgBad);
                } else {
                    this.titleLabel.setForeground(this.fgStd);
                }
                this.repaint();
            }
        }

        public void initUI() {
            ColorPropagatingPanel title = new ColorPropagatingPanel(new BorderLayout(5, 0));
            title.setBorder(SHBorderFactory.createEmptyBorder(0, 5, 0, 5));
            title.add((Component)this.connectionPrefix, "West");
            title.add((Component)this.titleLabel, "Center");
            title.add((Component)EastPanel.this.tuning, "East");
            this.titleLabel.setText("...");
            this.fgStd = this.titleLabel.getForeground();
            this.setLayout(new BorderLayout());
            this.add((Component)title, "North");
            this.add((Component)this.detailsPanel, "South");
            this.detailsPanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 1, 0, SHStyle.BORDER_COLOR_LIGHT), SHBorderFactory.createEmptyBorder(2, 5, 5, 5)));
            this.detailsPanel.setBackground(Color.WHITE);
            this.detailsPanel.setVisible(false);
            this.connectionPrefix.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ConnectionTuningSubPanel.this.toggleDetails();
                }
            });
            this.titleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ConnectionTuningSubPanel.this.toggleDetails();
                }
            });
        }

        public void toggleDetails() {
            boolean showAllDetails;
            this.detailsPanel.load();
            boolean bl = showAllDetails = !this.detailsPanel.isVisible();
            if (showAllDetails) {
                EastPanel.this.tuning.setText("\ue601");
            } else {
                EastPanel.this.tuning.setText("\ue602");
            }
            this.detailsPanel.setVisible(showAllDetails);
            this.repaint();
        }

        public void setSessionInfo(SessionInfo sessionInfo) {
            this.repaint();
        }

        private void setLabelContent(JComponent label, String text) {
            if (label instanceof JLabel) {
                ((JLabel)label).setText(text);
            } else {
                ((ToggleIconJLabel)label).setText(text);
            }
            label.setVisible(text != null && text.length() > 0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class UpgradeDone
    implements Runnable {
        final boolean nowDirect;

        public UpgradeDone(boolean nowDirect) {
            this.nowDirect = nowDirect;
        }

        @Override
        public void run() {
            new ConnectionFetchThread(false, false).start();
        }
    }

    class ConnectionFetchThread
    extends Thread
    implements CommandResponseListener {
        NodeLinkStats local;
        NodeLinkStats remote;
        final boolean autoUpgrade;
        final boolean allowPortScanOnAutoUpgrade;

        public ConnectionFetchThread(boolean autoUpgrade, boolean allowPortScanOnAutoUpgrade) {
            this.autoUpgrade = autoUpgrade;
            this.allowPortScanOnAutoUpgrade = allowPortScanOnAutoUpgrade;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.local = EastPanel.this.controller.getLocalSessionStats();
            if (Switches.SH_1566_showLocalStarsOnly) {
                EastPanel.this.connStarsMin = ConnectionSwitch.getStarsForNLStats(this.local);
                EastPanel.this.setConnectionIcon(EastPanel.this.connStarsMin >= 4);
                EastPanel.this.cs.repaint();
                EastPanel.this.repaint();
            } else {
                EastPanel.this.controller.getRemoteSessionStats(this);
            }
        }

        @Override
        public void response(Message m) {
            this.remote = NodeLinkStats.fromBytes((byte[])m.get(0));
            EastPanel.this.connStarsMin = Math.min(ConnectionSwitch.getStarsForNLStats(this.local), ConnectionSwitch.getStarsForNLStats(this.remote));
            EastPanel.this.setConnectionIcon(EastPanel.this.connStarsMin >= 4);
            EastPanel.this.cs.repaint();
            EastPanel.this.repaint();
        }
    }
}

