/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.GUI;
import com.aem.sdesktop.client.gui.diag.ConsolePanel;
import com.aem.sdesktop.client.gui.diag.CustomerInfoPanel;
import com.aem.sdesktop.client.gui.diag.PortProxyPanel;
import com.aem.sdesktop.client.gui.diag.ProcessTablePanel;
import com.aem.sdesktop.client.gui.diag.RegistryPanel;
import com.aem.sdesktop.client.gui.diag.ServicesPanel;
import com.aem.sdesktop.client.gui.diag.StatsPanel;
import com.aem.sdesktop.client.gui.diag.StatsPanel2;
import com.aem.sdesktop.client.gui.diag.SysInfoPanel;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.PortRedirector;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.message.Message;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.osstats.types.BasicInfo;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;

public class DiagnosticsPanel
extends JPanel {
    static final boolean PORT_REDIRECTION_ENABLED = true;
    ClientController con;
    GUI gui;
    JTabbedPane tabs = new JTabbedPane();
    RegistryPanel registryPanel;
    StatsInterface stats;
    SysInfoPanel infos;
    CustomerInfoPanel cust;
    ConsolePanel console;
    ProcessTablePanel processTable;
    ServicesPanel servicesPanel;
    JPanel portContainer;
    PortProxyPanel portPanel;
    private boolean controlEnabled;
    private boolean viewEnabled;

    public void setPortRedirector(PortRedirector redir) {
        this.portPanel = new PortProxyPanel(this.gui, this.con, redir);
        this.portContainer.removeAll();
        this.portContainer.add(this.portPanel);
        this.portContainer.revalidate();
        this.portContainer.repaint();
        this.updateEnabled();
    }

    public DiagnosticsPanel(ClientController con, GUI gui) {
        this.con = con;
        this.gui = gui;
        this.infos = new SysInfoPanel(con);
        this.cust = new CustomerInfoPanel();
        this.console = new ConsolePanel(con);
        this.processTable = new ProcessTablePanel(con, gui);
        this.stats = Switches.SH_diagnostics_improvements ? new StatsPanel2() : new StatsPanel();
        this.servicesPanel = new ServicesPanel(con, gui);
        this.registryPanel = new RegistryPanel(con);
        this.portContainer = new JPanel();
        this.portContainer.setLayout(new GridLayout(1, 1));
        this.portContainer.add(new JLabel(Language.get("PORT_PANEL_PLEASE_WAIT")));
        this.stats.setNoDataMessage(Language.get("NO_DATA_MESSAGE"));
        this.stats.setEnabled(false);
        this.processTable.setEnabled(false);
        this.servicesPanel.setEnabled(false);
        this.registryPanel.setEnabled(false);
        this.initGraphics();
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean enabled = this.isEnabled();
        this.tabs.setEnabled(enabled);
        this.stats.setEnabled(enabled && this.viewEnabled);
        this.infos.setEnabled(enabled && this.viewEnabled);
        this.cust.setEnabled(enabled && this.viewEnabled);
        if (this.portPanel != null) {
            this.portPanel.setEnabled(enabled && this.controlEnabled);
        }
        this.console.setEnabled(enabled && this.controlEnabled);
        this.processTable.setEnabled(enabled);
        this.servicesPanel.setEnabled(enabled);
        this.registryPanel.setEnabled(enabled);
    }

    public void setCollectDiagnostics(boolean collectDiagnostics) {
        if (collectDiagnostics) {
            if (this.con != null) {
                this.con.sendAsyncRemoteCommand(new Message(-1061158906), "stats");
            }
            this.stats.setEnabled(true);
            this.stats.setNoDataMessage(Language.get("NO_DATA_MESSAGE_WAITING"));
            this.stats.repaint();
            this.processTable.setEnabled(true);
            this.servicesPanel.requestTableUpdate();
        } else {
            if (this.con != null) {
                this.con.sendAsyncRemoteCommand(new Message(-1061158905), "stats");
            }
            this.stats.setEnabled(false);
            this.stats.setNoDataMessage(Language.get("NO_DATA_MESSAGE"));
            this.stats.repaint();
            this.processTable.setEnabled(false);
        }
        this.infos.diagnosticsOn(collectDiagnostics);
    }

    public void enableTargetWindows() {
        this.tabs.addTab(Language.get("WINDOWS_SERVICES"), ImageLoader.getImageIcon("images/svg/general/table.svg,24"), this.servicesPanel);
        this.tabs.addTab(Language.get("WINDOWS_REGISTRY"), ImageLoader.getImageIcon("images/svg/security/key.svg,24"), this.registryPanel);
        this.servicesPanel.connectedToWindows();
        this.registryPanel.connectedToWindows();
    }

    public void setStats(Stats s) {
        this.stats.diagnosticsDataUpdated(s);
        this.processTable.setProcessStatistics(s.getProcessStatistics());
    }

    public void connected() {
        this.console.connected();
        this.setEnabled(true);
        try {
            this.infos.connected();
            this.portPanel.connected();
            if (this.con != null) {
                this.con.registerOngoingListener(new StatsListener(), "stats");
                this.con.doAsyncRemoteCommand(new OsListener(), new Message(-1061158894));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initGraphics() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabs);
        this.tabs.addTab(Language.get("STATS"), ImageLoader.getImageIcon("images/svg/charts/bar.svg,24"), this.stats.getRootComponent());
        this.tabs.addTab(Language.get("PROCESSES"), ImageLoader.getImageIcon("images/svg/computing/window.svg,24"), this.processTable);
        this.tabs.addTab(Language.get("INFO"), ImageLoader.getImageIcon("images/svg/charts/bar.svg,24"), this.infos);
        if (ClientManagement.isSimpleHelp()) {
            this.tabs.addTab(Language.get("CUSTOMER"), ImageLoader.getImageIcon("images/svg/users/profile.svg,24"), this.cust);
        }
        this.tabs.addTab(Language.get("CONSOLE"), ImageLoader.getImageIcon("images/svg/computing/terminal.svg,24"), this.console.getRootComponent());
        this.tabs.addTab(Language.get("TCPPORTS"), ImageLoader.getImageIcon("images/svg/arrows/left-right.svg,24"), this.portContainer);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DiagnosticsPanel.this.hasReceivedFocus();
            }
        });
    }

    public void hasReceivedFocus() {
        if (this.tabs.getSelectedComponent() == this.console.getRootComponent()) {
            this.console.grabFocus();
        }
    }

    public void setTechnicianPermissions(TechGroupPermissions permissions) {
        if (!permissions.canUsePortForwarding()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagnosticsPanel.this.tabs.remove(DiagnosticsPanel.this.portContainer);
                    DiagnosticsPanel.this.tabs.revalidate();
                }
            });
        }
    }

    public void setCanControlAndView(boolean canControl, boolean canView) {
        this.controlEnabled = canControl;
        this.viewEnabled = canView;
        this.servicesPanel.setControlEnabled(canControl);
        this.processTable.setControlEnabled(canControl);
        this.registryPanel.setControlEnabled(canControl);
        this.updateEnabled();
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.console.setRemoteOS(remoteOsBase, remoteOsVariant);
    }

    public void setBasicInfo(BasicInfo basicInfo) {
        this.stats.setMachineBasicInfo(basicInfo);
    }

    class StatsListener
    implements CommandResponseListener {
        StatsListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == -1061158908) {
                try {
                    if (CentralDebugging.DIAGNOSTICS_ALL_MESSAGES) {
                        System.out.println(m.toPretty(null));
                    }
                    Message statsMessage = m.getNextMessage();
                    Stats s = OsStats.fromMessage(statsMessage);
                    DiagnosticsPanel.this.setStats(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (m.getType() == -1061158907) {
                System.out.println("Stats Command Response Failed.");
            }
        }
    }

    class OsListener
    implements CommandResponseListener {
        OsListener() {
        }

        @Override
        public void response(Message m) {
            String os;
            if (m.getType() == -1061158894 && (os = (String)m.get(0)).equalsIgnoreCase("win")) {
                DiagnosticsPanel.this.enableTargetWindows();
            }
        }
    }

    public static interface StatsInterface {
        public void setNoDataMessage(String var1);

        public void setEnabled(boolean var1);

        public void repaint();

        public void diagnosticsDataUpdated(Stats var1);

        public Component getRootComponent();

        public void setMachineBasicInfo(BasicInfo var1);
    }
}

