/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.util.ui.ChatPanel;
import com.aem.shelp.common.Language;

public class ClientChatPanel
extends ChatPanel {
    private ClientController controller;
    private ClientUserInterface uinterface;

    public ClientChatPanel(ClientController c, ClientUserInterface ui) {
        super(ui != null ? ui.getParentFrame() : null, "ignore", false);
        this.controller = c;
        this.uinterface = ui;
    }

    @Override
    protected void sendMessage(String message) {
        if (this.controller != null) {
            this.controller.sendMessage(message);
        }
    }

    @Override
    protected boolean isTechnicianMessage(String user_name, String host_name) {
        return !host_name.equals("server");
    }

    @Override
    protected boolean showNotifyButton() {
        return true;
    }

    @Override
    public void invokeNotifyMessage() {
        this.addNotificationMessageToChat(Language.get("CHAT_VISUAL_ALERT") + "...");
        this.controller.sendAlertRemoteUser();
    }

    @Override
    public void notifyKeyTyped() {
        if (this.controller != null) {
            this.controller.notifyTechnicianTyping(this.displayName);
        }
    }

    public void setTechnicianDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

