/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import java.awt.Insets;
import javax.swing.RootPaneContainer;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.contents.IsValidListener;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class CallingCardUI {
    private String cardName;
    private boolean createDesktopShortcut;
    private boolean createMenuShortcut;
    private boolean automaticallyLogin;

    public static CallingCardUI showDialog(RootPaneContainer rootPane) {
        TextField cardNameField = new TextField(Language.get("CALLING_CARD_NAME"), null);
        cardNameField.setRequired(true);
        final CheckBoxField desktopShortcut = new CheckBoxField(Language.get("CALLING_CARD_LEAVE_DESKTOP"), null);
        final CheckBoxField menuShortcut = new CheckBoxField(Language.get("CALLING_CARD_LEAVE_SHORTCUT"), null);
        CheckBoxField autoLogin = new CheckBoxField(Language.get("CALLING_CARD_AUTO_LOGIN"), null);
        autoLogin.setDefaultCheckedState(true);
        CUIField[] field = new CUIField[]{new LabelField(Language.get("CALLING_CARD_DESCRIPTION")), cardNameField, desktopShortcut, menuShortcut, autoLogin};
        FixedWidthCUIPanel cuiPanel = new FixedWidthCUIPanel();
        cuiPanel.setValidListener(new IsValidListener(){

            @Override
            public boolean isValid() {
                return desktopShortcut.isChecked() || menuShortcut.isChecked();
            }
        });
        Insets insets = (Insets)cuiPanel.getPanelInsets().clone();
        insets.top = 0;
        insets.bottom = 0;
        desktopShortcut.setLayoutInsets(insets);
        menuShortcut.setLayoutInsets(insets);
        autoLogin.setLayoutInsets(insets);
        cuiPanel.setFields(field);
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("CALLING_CARD_OK"), Language.get("CANCEL"));
        dialogPanel.setContent(cuiPanel);
        dialogPanel.setIcon(ImageLoader.getImageIcon("images/svg/users/profile.svg,48"));
        AbstractGlassDialog dialog = new AbstractGlassDialog(rootPane, 450, (AbstractDialogPanel)dialogPanel);
        dialog.setTitle(Language.get("CALLING_CARD_TITLE"));
        dialog.setShowDecoration(true);
        dialog.showDialog();
        if (dialogPanel.isOK()) {
            CallingCardUI result = new CallingCardUI();
            ResultPair[] filledOutResults = cuiPanel.getResults(Language.DEFLANG);
            result.cardName = filledOutResults[1].getValue();
            result.createDesktopShortcut = filledOutResults[2].getValue().equals(Language.get("YES"));
            result.createMenuShortcut = filledOutResults[3].getValue().equals(Language.get("YES"));
            result.automaticallyLogin = filledOutResults[4].getValue().equals(Language.get("YES"));
            return result;
        }
        return null;
    }

    public String getCardName() {
        return this.cardName;
    }

    public boolean createDesktopShortcut() {
        return this.createDesktopShortcut;
    }

    public boolean createMenuShortcut() {
        return this.createMenuShortcut;
    }

    public boolean automaticallyLogin() {
        return this.automaticallyLogin;
    }
}

