/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.utils.BandwidthBuckets;
import com.aem.nodelink.utils.RTTBuckets;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.vis.NLOptimisationFeed;
import com.aem.sdesktop.ArrayToMessage;
import com.aem.sdesktop.SessionPerformanceReporter;
import com.aem.sdesktop.Util;
import com.aem.sdesktop.client.controller.AsyncCommandsController;
import com.aem.sdesktop.client.controller.ChatController;
import com.aem.sdesktop.client.controller.ClipboardController;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.FTPController;
import com.aem.sdesktop.client.controller.InputController;
import com.aem.sdesktop.client.controller.LockedCommandResponseListener;
import com.aem.sdesktop.client.controller.MachinePrefs;
import com.aem.sdesktop.client.controller.PortRedirectController;
import com.aem.sdesktop.client.controller.ScreenController;
import com.aem.sdesktop.client.controller.SoundController;
import com.aem.sdesktop.client.controller.TerminalController;
import com.aem.sdesktop.client.controller.WhiteboardController;
import com.aem.sdesktop.client.gui.FPSSlider;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.server.controller.ImmediateFileTransferListener;
import com.aem.sdesktop.server.controller.LinuxKeyboardHandler;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.sdesktop.util.FTPUtil;
import com.aem.sdesktop.util.FileEntry;
import com.aem.sdesktop.util.TransportCommsLine;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.tech.ElevationGlassDialog;
import com.aem.shelp.tech.video.VideoRecorder;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.ObsoleteShServerNodeTransactor;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.PasswordSpecification;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.SHelpUdpNlNatHpMk2;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.WebTransactor;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.ProcessResultMessage;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.blowfish.BlowfishDecryptionStream;
import com.aem.utils.blowfish.BlowfishEncryptionStream;
import com.aem.utils.entropy.EntropyGatherer;
import com.aem.utils.keyhandling.KeyRequest;
import com.aem.utils.keyhandling.KeyboardLayout;
import com.aem.utils.multiplex.MultiplexerInputStream;
import com.aem.utils.multiplex.MultiplexerOutputStream;
import com.aem.utils.multiplex.MultiplexingInput;
import com.aem.utils.multiplex.MultiplexingOutput;
import com.aem.utils.random.GenericRandom;
import com.aem.utils.rsa.RSADecryptor;
import com.aem.utils.streamenc.ChunkFilter;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.Mixer;
import javax.swing.RootPaneContainer;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.logging.ProcessResult;
import utils.files.RemoteFile;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageUtils;
import utils.message.MessageWriter;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.mutable.MutableBoolean;
import utils.swing.components.path.elements.FTPVolume;
import utils.switches.Switches;

public class Controller
implements ClientController,
MSG {
    private ClientUserInterface gui;
    private ClipboardController clip_controller;
    private FTPController ftp_controller;
    private InputController input_controller;
    private ScreenController screen_controller;
    private AsyncCommandsController cmds_controller;
    private PortRedirectController port_controller;
    private SoundController sound_controller;
    private TransportCommsLine transport_line;
    private int sessionFwdID;
    private String remoteMachineID;
    private MessageWriter input_writer = null;
    private MessageReader input_reader = null;
    private MessageWriter screen_writer = null;
    private MessageReader screen_reader = null;
    private MessageWriter clipboard_writer = null;
    private MessageReader clipboard_reader = null;
    private MessageWriter chat_writer = null;
    private MessageReader chat_reader = null;
    private MessageWriter wboard_writer = null;
    private MessageReader wboard_reader = null;
    private MessageWriter ftp_writer = null;
    private MessageReader ftp_reader = null;
    private MessageWriter ftp_writer1 = null;
    private MessageReader ftp_reader1 = null;
    private MessageWriter ftp_writer2 = null;
    private MessageReader ftp_reader2 = null;
    private MessageWriter ftp_writer3 = null;
    private MessageReader ftp_reader3 = null;
    private MessageWriter ftp_writer4 = null;
    private MessageReader ftp_reader4 = null;
    private MessageWriter cmds_writer = null;
    private MessageReader cmds_reader = null;
    private MessageWriter port_writer = null;
    private MessageReader port_reader = null;
    private MessageWriter sound_writer = null;
    private MessageReader sound_reader = null;
    private MessageWriter terminal_writer = null;
    private MessageReader terminal_reader = null;
    private boolean block_control = false;
    private final Object DATA_LOCK = new Object();
    private Blowfish blowfish;
    private byte[] blowfish_key;
    private boolean encryption_on = true;
    byte[] seed = null;
    private WebTransactor wtrans;
    private PasswordSpecification pspec;
    private String keyboardLayoutDescription;
    private boolean amConnectedToMachine = false;
    private String customerOrMachineID;
    boolean continuous_request = false;
    private int enc = 3;
    private int fil = 51;
    private int scal = 150;
    private final int comp = 105;
    private int coldepth = 16;
    private boolean useHardwareAcceleration = true;
    private int updelay = 50;
    private int updelayLimit = 0;
    private NodeLink socket;
    private Node transportAssocNode;
    private NodeLink transportSocket;
    private NodeLink directSocket;
    Object msg_out_lock = new Object();
    private final Object input_out_lock = new Object();
    private final ArrayList input_out_buffer = new ArrayList();
    private RTTWriter rttwriter;
    private final BatchInputWriter batch_input_writer = new BatchInputWriter();
    private final boolean lightweightOnly;
    private int bandwidthLimitKBps = 0;
    String last_username = "ERROR";
    String last_thishost = "UNKNOWN";
    private String connectedServerHost;
    private int connectedServerPort;
    private String localServerHost;
    private int localServerPort;
    private TransientTechUser techUser;
    private TerminalController terminalController;
    private boolean firstConnect = true;
    private boolean terminated = false;
    private LLDelayThread initialNLL = null;
    private int FLUSH_COUNTER = 0;
    private final Object grScreenRequest_LOCK = new Object();
    private GrabRectangleChangeThread grThread = null;
    private Rectangle requestArea;
    private long lastScreenGrabRequest = 0L;
    private static final long DEFAULT_TOOL_TIMEOUT = 30000L;
    private boolean isScreenBlanked = false;
    private boolean isControlBlocked = false;
    private boolean isMonitorOff = false;
    private long doubleClickTime = -1L;
    private String localLayoutName;
    private long lastRttEchoRequest = SafeClock.currentTimeMillis();
    private final Object KEY_REQUEST_LOCK = new Object();
    private ArrayList<KeyRequest> keyRequests = new ArrayList();
    private final int LEGAL_BUTTON_MASK = 7196;
    private long currentLocLastSent = -1L;
    private long currentLocLastUpdated = 0L;
    private int currentLocX = -1;
    private int currentLocY = -1;
    private final Object lastMouseInput_LOCK = new Object();
    private long lastMouseInput = 0L;
    private int oldX = -1;
    private int oldY = -1;
    private int xExtent = 0;
    private int yExtent = 0;
    private final Object input_notifier = new Object();
    private long batchUntil = 0L;
    private long nextMouseMove = 0L;
    private long lastMouseDown = 0L;
    private boolean multiClick = false;
    private int waitForBatchUntil = 0;
    private int waitForBufferNonZero = 0;
    private long sendBatchLastCalled = 0L;
    private boolean mustFetchClipboardAfterInput = false;
    private boolean clearRemoteRtts = false;
    private RTTBuckets screenTimes;
    private BandwidthBuckets screenSizes;
    private final RTTBuckets apprtts = new RTTBuckets();
    private MachinePrefs prefs = null;
    private boolean switching = false;
    private final Object switch_LOCK = new Object();
    private SessionPerformanceReporter reporter;
    private long lastTechnicianTypingTime = 0L;

    public void ftpJobFinished(int job) {
        this.ftp_controller.ftpJobFinished(job);
    }

    public void setWebTransactor(WebTransactor wtrans) {
        this.wtrans = wtrans;
    }

    WebTransactor getWebTransactor() {
        return this.wtrans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadSecuritySettings() {
        Object object = this.DATA_LOCK;
        synchronized (object) {
        }
    }

    @Override
    public int getFiltering() {
        return this.fil;
    }

    @Override
    public int getColourDepth() {
        return this.coldepth;
    }

    @Override
    public boolean isColour() {
        return this.enc == 3;
    }

    @Override
    public void setColour(boolean col) {
        this.enc = this.lightweightOnly ? 3 : (col ? 3 : 5);
    }

    public boolean amConnectedToMachine() {
        return this.amConnectedToMachine;
    }

    public String getCustomerOrMachineID() {
        return this.customerOrMachineID;
    }

    public void setPreviouslyConnectedID(String id, boolean isMachine) {
        this.customerOrMachineID = id;
        this.amConnectedToMachine = isMachine;
    }

    private void setUpdateDelayLimitMS(long delayMS) {
        this.updelayLimit = (int)delayMS;
    }

    @Override
    public void setUpdateDelay(long delay) {
        this.updelay = Math.max(0, Math.min(5000, (int)delay));
    }

    @Override
    public int getUpdateDelay() {
        if (this.updelay < this.updelayLimit) {
            return this.updelayLimit;
        }
        return this.updelay;
    }

    public Controller(boolean lightweightOnly) {
        this.lightweightOnly = lightweightOnly;
        this.reloadSecuritySettings();
        this.batch_input_writer.setDaemon(true);
        this.batch_input_writer.start();
    }

    @Override
    public void setGUI(ClientUserInterface gui) {
        this.gui = gui;
    }

    @Override
    public boolean isDirectSocketUDP() {
        return this.directSocket.isUsingFlowControl();
    }

    private void restoreBandwidthLimit() {
        if (Switches.SH_nlFixedBandwidthLimiting) {
            this.setUpperBandwidthLimit(this.bandwidthLimitKBps);
        }
    }

    @Override
    public void setUpperBandwidthLimit(int KBps) {
        if (Switches.SH_nlFixedBandwidthLimiting) {
            System.out.println("[Controller] Told to set upper bandwidth limit to " + KBps + "KB/s");
            this.bandwidthLimitKBps = KBps;
            Message m = new Message(-1061158783);
            m.append(KBps);
            this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
            if (this.transportSocket != null) {
                this.transportSocket.setBandwidthLimit(KBps);
            }
            if (this.directSocket != null) {
                this.directSocket.setBandwidthLimit(KBps);
            }
        }
    }

    public void setFlexibleUdpBandwidth() {
        System.out.println("[Controller] Told to set screen pipe to flexible UDP bandwidth");
        if (this.isDirectSocketUDP()) {
            Message m = new Message(-1061158792);
            m.append(false);
            this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
        } else {
            System.out.println("[Controller] ERROR Direct socket is not UDP?");
        }
    }

    public void setFixedUdpBandwidth(double kbps) {
        System.out.println("[Controller] Told to set screen pipe to fixed UDP bandwidth at " + kbps + "KB/s");
        if (this.isDirectSocketUDP()) {
            Message m = new Message(-1061158792);
            m.append(true);
            m.append(kbps);
            this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
        } else {
            System.out.println("[Controller] ERROR Direct socket is not UDP?");
        }
    }

    @Override
    public void setMixerForAudioOutput(Mixer mixer) {
        this.sound_controller.setMixerForAudioOutput(mixer);
    }

    @Override
    public void sendMessage(String message) {
        Message m = new Message(327681);
        m.append(message);
        try {
            this.chat_writer.write(m);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doImmediateFileGet(String remotedir, String remotefile, ImmediateFileTransferListener listener) throws IOException {
        this.ftp_controller.doImmediateFileGet(remotedir, remotefile, listener);
    }

    public int addGetThenClipRequest(int ID, String localdir, String remotedir, String remotefile, String[] clipfiles) {
        return this.ftp_controller.addFileGetRequestThenClip(ID, localdir, remotedir, remotefile, clipfiles);
    }

    @Override
    public int addGetRequest(int ID, String localdir, String remotedir, String remotefile) {
        return this.ftp_controller.addFileGetRequest(ID, localdir, remotedir, remotefile);
    }

    @Override
    public int addPutRequest(int ID, String localdir, String remotedir, String localfile) {
        return this.ftp_controller.addFilePutRequest(ID, localdir, remotedir, localfile);
    }

    public int addPutThenPasteRequest(int ID, String localdir, String remotedir, String localfile, String[] clipboardfiles) {
        return this.ftp_controller.addFilePutRequestThenPaste(ID, localdir, remotedir, localfile, clipboardfiles);
    }

    public int addPutThenClipRequest(int ID, String localdir, String remotedir, String localfile, String[] clipboardfiles) {
        return this.ftp_controller.addFilePutRequestThenClip(ID, localdir, remotedir, localfile, clipboardfiles);
    }

    @Override
    public void cancelPut(int jobID) {
        this.ftp_controller.cancelPut(jobID);
    }

    @Override
    public void cancelGet(int jobID) {
        this.ftp_controller.cancelGet(jobID);
    }

    @Override
    public void newLocalFolder(String ldir, String folder) {
        this.ftp_controller.newLocalFolder(ldir, folder);
    }

    @Override
    public void newRemoteFolder(String rdir, String folder) {
        this.ftp_controller.newRemoteFolder(rdir, folder);
    }

    @Override
    public void renameLocalFile(String ldir, String oldname, String newname) {
        this.ftp_controller.renameLocalFile(ldir, oldname, newname);
    }

    @Override
    public void renameRemoteFile(String rdir, String oldname, String newname) {
        this.ftp_controller.renameRemoteFile(rdir, oldname, newname);
    }

    @Override
    public boolean deleteLocalFile(String dir, String file) {
        return this.ftp_controller.deleteLocalFile(dir, file);
    }

    @Override
    public boolean deleteRemoteFile(String dir, String file) {
        return this.ftp_controller.deleteRemoteFile(dir, file);
    }

    @Override
    public String getConnectedServerIp() {
        return this.connectedServerHost;
    }

    @Override
    public int getConnectedServerPort() {
        return this.connectedServerPort;
    }

    public InputStream nextInput(MultiplexingInput mxin, int N, String name) {
        return mxin.getInputStream((short)N, name);
    }

    private MessageReader nextReader(MultiplexingInput mxin, int N, String name, ChunkFilter priority) {
        InputStream in = mxin.getInputStream((short)N, name);
        return new MessageReader(in);
    }

    public OutputStream nextOutput(MultiplexingOutput mxout, int N) {
        return mxout.getOutputStream((short)N);
    }

    private MessageWriter nextWriter(MultiplexingOutput mxout, int N, ChunkFilter priority) {
        OutputStream out = mxout.getOutputStream((short)N);
        return new MessageWriter(out);
    }

    public PasswordSpecification getPasswordSpecification() {
        return this.pspec;
    }

    public void setLocalServerAddress(String host, int port) {
        this.localServerHost = host;
        this.localServerPort = port;
    }

    @Override
    public void connectToProxy(ProxyConnectSettings settings, SHelpNodelinkPatcher patcherDirect, SHelpNodelinkPatcher patcherReplace, NodeLink sock, InputStream in, OutputStream out, NLOptimisationFeed feed, BCUtil bcu, TransientTechUser techUser) throws Exception {
        try {
            Object[] streams;
            sock.setFriendlyName("ServerTransportLine");
            this.connectedServerHost = settings.host;
            this.connectedServerPort = settings.port;
            this.techUser = techUser;
            System.out.println("[Controller] Establishing session encryption");
            byte[][] secKeys = null;
            if (CentralDebugging.USE_BCU_FOR_SESSION) {
                in = new BCUtilInputStream(in, bcu);
                out = new BCUtilOutputStream(out, bcu);
                System.out.println("[SDServer] Streams created");
                out.write(8);
                out.flush();
                System.out.println("[SDServer] Read Check: " + in.read());
            } else {
                this.setupStaticEncryption(in, out);
                secKeys = this.createMoreSecureKeys(in, out, 4);
                streams = this.secureStreams(in, out, secKeys[0], secKeys[1]);
                in = (InputStream)streams[0];
                out = (OutputStream)streams[1];
            }
            Message uniqueIDMessage = MessageUtils.readMessage(in);
            this.remoteMachineID = uniqueIDMessage.getAsString(0);
            int remoteBaseType = uniqueIDMessage.getAsInt(1);
            int remoteVariant = uniqueIDMessage.getAsInt(2);
            System.out.println("[Controller] Got remote machine ID: " + this.remoteMachineID);
            StreamUtils.writeInt(out, 1195447384);
            out.flush();
            Message bits = new Message(1195447384);
            bits.append(settings.initialMode);
            bits.append(techUser.maxFileTransferSize);
            bits.append(OpusConfig.bitRate);
            Message toolsMessage = new Message(1195447385);
            this.loadAndAppendToolsDesiredState(toolsMessage, remoteBaseType, remoteVariant);
            bits.append(toolsMessage);
            bits.append(CentralDebugging.DEBUG_NL_PACKET_LOSS_LONG);
            bits.append(CentralDebugging.DEBUG_NL_PACKET_LOSS_VERY_LONG);
            if (CentralDebugging.DEBUG_NL_PACKET_LOSS_VERY_LONG) {
                NodeLink.setDebugPacketLoss(300);
            } else if (CentralDebugging.DEBUG_NL_PACKET_LOSS_LONG) {
                NodeLink.setDebugPacketLoss(60);
            }
            MessageUtils.writeMessage(out, bits);
            out.flush();
            boolean tryAndWaitForProxiedUDP = false;
            if (patcherDirect != null) {
                this.transportAssocNode = sock.getMyNode();
                this.transport_line = new TransportCommsLine();
                this.transport_line.in = in;
                this.transport_line.out = out;
                int patchID = BCUtil.getSecureRandom().nextInt();
                StreamUtils.writeInt(out, 1195447392);
                StreamUtils.writeInt(out, patchID);
                out.flush();
                StreamUtils.readInt(in);
                System.out.println("[Controller] Trying to establish basic patched connection under fwdID " + patchID);
                this.directSocket = patcherDirect.finishPatch(false, patchID, null, in, out, this.transportAssocNode, false);
                this.directSocket.setFriendlyName("PatchedDirectDataLine");
                in = this.directSocket.getInputStream();
                out = this.directSocket.getOutputStream();
                if (CentralDebugging.USE_BCU_FOR_SESSION) {
                    in = new BCUtilInputStream(in, bcu);
                    out = new BCUtilOutputStream(out, bcu);
                } else {
                    streams = this.secureStreams(in, out, secKeys[2], secKeys[3]);
                    in = (InputStream)streams[0];
                    out = (OutputStream)streams[1];
                }
                this.directSocket.addAllLinkStatusListenersFrom(sock);
                patchID = BCUtil.getSecureRandom().nextInt();
                StreamUtils.writeInt(out, patchID);
                out.flush();
                StreamUtils.readInt(in);
                System.out.println("[Controller] Trying to establish replacement patched connection under fwdID " + patchID);
                NodeLink sockReplace = patcherReplace.finishPatch(false, patchID, null, in, out, this.transportAssocNode, true);
                this.sessionFwdID = sockReplace.getMyNode().getForwardingID();
                System.out.println("[Controller] Associated session with patch " + patchID + ", fwdID " + this.sessionFwdID);
                this.transportSocket = sockReplace;
                this.transport_line.in = new BCUtilInputStream(sockReplace.getInputStream(), bcu);
                this.transport_line.out = new BCUtilOutputStream(sockReplace.getOutputStream(), bcu);
                this.transportSocket.setFriendlyName("PatchedNonUdpTransportLine");
                StreamUtils.writeStringUTF8(this.transport_line.out, "Hello DesktopServer");
                this.transport_line.out.flush();
                System.out.println(StreamUtils.readStringUTF8(this.transport_line.in));
                sock.setFriendlyName("InitialSetupNonPatchedTransportLine");
                sock.removeAllLinkStatusListeners();
                sock.stopImmediate("closing shell transport nl during patch");
                sock = sockReplace;
                this.directSocket.terminateInTandem(this.transportSocket);
                System.out.println("[Controller] Got basic connections");
            }
            if (settings.port == -1) {
                System.out.println("[Controller] Internal server connection");
                if (CentralDebugging.ATTEMPT_UDP_DIRECT) {
                    if (tryAndWaitForProxiedUDP && this.localServerHost != null && CentralDebugging.UDP_DURING_SDEMO) {
                        StreamUtils.writeInt(out, 1195447382);
                        out.flush();
                        NodeLink direct = Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor ? SHelpUdpNlNatHpMk2.establishProxiedUDP(this.wtrans.getNLForwardingAPI(this.transportAssocNode), this.localServerHost, this.localServerPort, in, out) : SHelpUdpNlNatHpMk2.establishProxiedUDP(new ObsoleteShServerNodeTransactor(this.transportAssocNode, sock), this.localServerHost, this.localServerPort, in, out);
                        if (direct != null) {
                            System.out.println("++++++++++++++++++++++++++++++++++++++++++++");
                            System.out.println("+++++++    Switching to PX-UDP NL    +++++++");
                            System.out.println("++++++++++++++++++++++++++++++++++++++++++++");
                            this.directSocket = direct;
                            in = direct.getInputStream();
                            out = direct.getOutputStream();
                            if (CentralDebugging.USE_BCU_FOR_SESSION) {
                                in = new BCUtilInputStream(in, bcu);
                                out = new BCUtilOutputStream(out, bcu);
                            } else {
                                streams = this.secureStreams(in, out, secKeys[2], secKeys[3]);
                                in = (InputStream)streams[0];
                                out = (OutputStream)streams[1];
                            }
                            direct.terminateInTandem(this.transportSocket);
                            direct.addAllLinkStatusListenersFrom(sock);
                            if (feed != null) {
                                direct.setOptimisationFeed(feed);
                            }
                        }
                    } else {
                        StreamUtils.writeInt(out, 1195447383);
                        out.flush();
                        System.out.println("--------------------------------------------");
                        System.out.println("-------   Not attempting PX-UDP NL   -------");
                        System.out.println("--------------------------------------------");
                    }
                }
            } else if (CentralDebugging.ATTEMPT_UDP_DIRECT) {
                if (tryAndWaitForProxiedUDP) {
                    StreamUtils.writeInt(out, 1195447382);
                    out.flush();
                    NodeLink direct = Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor ? SHelpUdpNlNatHpMk2.establishProxiedUDP(this.wtrans.getNLForwardingAPI(this.transportAssocNode), settings.host, settings.port, in, out) : SHelpUdpNlNatHpMk2.establishProxiedUDP(new ObsoleteShServerNodeTransactor(this.transportAssocNode, sock), settings.host, settings.port, in, out);
                    if (direct != null) {
                        System.out.println("********************************************");
                        System.out.println("*******    Switching to PX-UDP NL    *******");
                        System.out.println("********************************************");
                        this.directSocket = direct;
                        in = direct.getInputStream();
                        out = direct.getOutputStream();
                        if (CentralDebugging.USE_BCU_FOR_SESSION) {
                            in = new BCUtilInputStream(in, bcu);
                            out = new BCUtilOutputStream(out, bcu);
                        } else {
                            streams = this.secureStreams(in, out, secKeys[2], secKeys[3]);
                            in = (InputStream)streams[0];
                            out = (OutputStream)streams[1];
                        }
                        direct.terminateInTandem(this.transportSocket);
                        direct.addAllLinkStatusListenersFrom(sock);
                        if (feed != null) {
                            direct.setOptimisationFeed(feed);
                        }
                    }
                } else {
                    StreamUtils.writeInt(out, 1195447383);
                    out.flush();
                    System.out.println("--------------------------------------------");
                    System.out.println("-------   Not attempting PX-UDP NL   -------");
                    System.out.println("--------------------------------------------");
                }
            }
            MultiplexerInputStream mxin = new MultiplexerInputStream(in, "Controller-SessionDemultiplexer");
            MultiplexerOutputStream mxout = new MultiplexerOutputStream(out);
            System.out.println("[Controller] Wrote native protocol");
            if (techUser.isSessionSpeedLimited()) {
                int KBpsLimit = techUser.getSessionSpeedLimitKBps();
                System.out.println("[Controller] Bandwidth restrictions are in force, limit is " + KBpsLimit + "KB/s");
            } else {
                System.out.println("[Controller] No bandwidth restrictions");
            }
            if (techUser.isFPSLimited()) {
                double fpsLimit = FPSSlider.getFPSFromDelay(techUser.getFPSDelay());
                System.out.println("[Controller] FPS restrictions are in force, limit is " + fpsLimit + " f/s");
            } else {
                System.out.println("[Controller] No FPS restrictions");
            }
            if (settings.techname.trim().length() == 0) {
                this.newConnection(sock, mxin, mxout, Language.get("REMOTE_TECH_NAME"), "xxxxyyyy", "127.0.0.1", settings.pspec, settings.isMobile);
            } else {
                this.newConnection(sock, mxin, mxout, settings.techname, "xxxxyyyy", "127.0.0.1", settings.pspec, settings.isMobile);
            }
            System.out.println("[Controller] PatcherDirect " + patcherDirect + ", updatedTuning " + Switches.SH_updatedConnectionTuning);
            if (patcherDirect != null) {
                if (Switches.SH_updatedConnectionTuning) {
                    int transport = SessionProperties.INSTANCE.getIntProp(SessionProperties.PROP_PINNED_CONN, -1, -99, 99);
                    if (transport == -1) {
                        System.out.println("[Controller] No tech preference for transport type");
                    } else if (!(transport != 0 && transport != 1 || techUser.getPermissions().canUseUDP())) {
                        System.out.println("[Controller] Tech is not allowed to use UDP so will not switch based on tech preference (" + transport + ")");
                    } else {
                        System.out.println("[Controller] Will attempt to switch transport based on tech preference (" + transport + ")");
                        try {
                            this.switchTransports(transport, transport);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                } else {
                    int[] desired = this.getConnectedMachinePrefs().getDesiredLocalAndRemoteTransport();
                    if (!Switches.SH_updatedConnectionTuning && desired != null && desired.length == 2) {
                        System.out.println("[Controller] Will attempt a desired-upgrade to " + Arrays.toString(desired));
                        int local = desired[0];
                        int remote = desired[1];
                        if (local == 1) {
                            AutoUpgrade au = new AutoUpgrade(1, 1);
                            au.start();
                        } else if (local == 0) {
                            AutoUpgrade au = new AutoUpgrade(1, 1, 0, 0);
                            au.start();
                        } else {
                            AutoUpgrade au = new AutoUpgrade(local, remote);
                            au.start();
                        }
                    } else {
                        System.out.println("[Controller] Tech can use UDP");
                        if (techUser.getPermissions().canUseUDP()) {
                            boolean defaultUdp;
                            boolean bl = defaultUdp = !Switches.SH_updatedConnectionTuning;
                            if (TechProperties.INSTANCE.getBooleanProp(TechProperties.PROP_UDP, defaultUdp) && TechProperties.INSTANCE.getBooleanProp(TechProperties.PROP_DIRECT, defaultUdp)) {
                                System.out.println("[Controller] Will attempt to auto-upgrade to UDP Direct (no PS)");
                                AutoUpgrade au = new AutoUpgrade(1, 1, 0, 0);
                                au.start();
                            } else if (TechProperties.INSTANCE.getBooleanProp(TechProperties.PROP_UDP, defaultUdp)) {
                                System.out.println("[Controller] Will attempt to auto-upgrade to Proxied-UDP");
                                AutoUpgrade au = new AutoUpgrade(1, 1);
                                au.start();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.gui.setCentreGreyOverlay(Language.get("CONNECTION_FAILED") + ". " + e.getMessage(), 60000L);
            e.printStackTrace();
            this.clearConnection("connect to proxyserver failed " + e);
            throw e;
        }
        catch (Throwable e) {
            this.gui.setCentreGreyOverlay(Language.get("CONNECTION_FAILED") + ". " + e.getMessage(), 60000L);
            e.printStackTrace();
            this.clearConnection("connect to proxyserver failed " + e);
            Exception x = new Exception(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    private void loadAndAppendToolsDesiredState(Message toolsMessage, int remoteBaseType, int remoteVariant) {
        Tool[] allTools;
        for (Tool allTool : allTools = Tool.getAllToolsNoUI()) {
            boolean needToLoadTechnicainSide = allTool.isTechnicianSideOnly();
            allTool.loadFrom(TechProperties.INSTANCE.getMyProperties(), needToLoadTechnicainSide);
            if (!allTool.showForThisRemoteOS(remoteBaseType, remoteVariant)) continue;
            toolsMessage.append(allTool.getDesiredStateAsMessage());
        }
    }

    private void newConnection(NodeLink s, MultiplexingInput mxin, MultiplexingOutput mxout, String username, String password, String ip, PasswordSpecification reconnectPassword, boolean isMobile) throws Exception {
        this.socket = s;
        int REAL_SOCKET_COUNT = 12;
        try {
            this.setColourDepth(SessionProperties.INSTANCE.getIntProp(SessionProperties.PROP_COLDEPTH, 10, 4, 255));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setUpdateDelay(SessionProperties.INSTANCE.getIntProp(SessionProperties.PROP_UPDATEDELAY, 62, 0, 5000));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setColour(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!CentralDebugging.ALLOW_CHANGE_FILTERING_SIZE) {
                this.setFiltering(51);
            } else if (SessionProperties.INSTANCE.getProp(SessionProperties.PROP_FILTERING).equalsIgnoreCase("large")) {
                this.setFiltering(51);
            } else {
                this.setFiltering(52);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        InputStream fin = mxin.getInputStream((short)0, "Socket Setup");
        OutputStream fout = mxout.getOutputStream((short)0);
        System.out.println("[Controller] Waiting for acceptance on mxin:0 (" + fin + ")");
        int ret = StreamUtils.readInt(fin);
        System.out.println("[Controller] Checking remote response + requirements (" + Integer.toHexString(ret) + ")");
        this.pspec = new PasswordSpecification();
        this.pspec.setPasswordRequired(false);
        if (ret == 1430580991) {
            try {
                s.stop("host disallowed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("This host has been banned");
        }
        if (ret == -1091846421) {
            try {
                s.stop("rate limiting");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("To prevent malicious attacks this host must wait before the server will allow it to try to connect again");
        }
        if (ret == -572662307) {
            this.pspec.setPasswordRequired(true);
        } else if (ret != -4517462) {
            try {
                s.stop("ordering issue");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("out of sync, please try again");
        }
        System.out.println("[Controller] Machine password required");
        if (this.pspec.REQUIRED) {
            if (reconnectPassword != null) {
                this.pspec.setPassword(reconnectPassword.PASSWORD);
            } else {
                String newPassword = this.gui.requestMachinePassword();
                if (newPassword == null || newPassword.length() == 0) {
                    throw new IOException("Invalid Password");
                }
                this.pspec.setPassword(newPassword);
            }
        }
        System.out.println("[Controller] Requesting channels");
        StreamUtils.writeInt(fout, REAL_SOCKET_COUNT);
        fout.flush();
        ret = StreamUtils.readInt(fin);
        if (ret != -286348613) {
            try {
                s.stop("mx socket count incorrect");
            }
            catch (Exception newPassword) {
                // empty catch block
            }
            throw new Exception("requested too many sockets (" + ret + ")");
        }
        ret = StreamUtils.readInt(fin);
        if (ret == -17895697) {
            System.out.println("[Controller] Setting up encryption");
            this.encryption_on = true;
        } else {
            this.encryption_on = false;
        }
        this.verifyUser(fout, fin, username);
        this.verifyPassword(fout, fin, password);
        System.out.println("[Controller] Encryption OK");
        int license = StreamUtils.readInt(fin);
        if (license == -295244186) {
            throw new Exception("Server has corrupt license");
        }
        int eval_uses = StreamUtils.readInt(fin);
        int eval_wait = StreamUtils.readInt(fin);
        if (license != 0x1ECE1ECE) {
            this.gui.doLicenseWait(eval_uses, eval_wait);
        }
        license = StreamUtils.readInt(fin);
        System.out.println("[Controller] Starting all controllers");
        ChunkFilter low_priority = Util.low_priority;
        ChunkFilter med_priority = Util.med_priority;
        ChunkFilter high_priority = Util.high_priority;
        int SERVER_N = 0;
        this.input_writer = this.nextWriter(mxout, SERVER_N, high_priority);
        this.input_reader = this.nextReader(mxin, SERVER_N, "Session Input", high_priority);
        this.input_controller = new InputController(this, this.gui, this.input_reader);
        this.input_controller.start();
        this.screen_writer = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.screen_reader = this.nextReader(mxin, SERVER_N, "Session Screen Updates", high_priority);
        this.screen_controller = new ScreenController(this, this.gui, this.screen_reader, this.lightweightOnly);
        this.screen_controller.start();
        this.clipboard_writer = this.nextWriter(mxout, ++SERVER_N, low_priority);
        this.clipboard_reader = this.nextReader(mxin, SERVER_N, "Session Clipboard", low_priority);
        this.clip_controller = new ClipboardController(this, this.gui, this.clipboard_reader, this.clipboard_writer);
        this.clip_controller.start();
        this.chat_writer = this.nextWriter(mxout, ++SERVER_N, med_priority);
        this.chat_reader = this.nextReader(mxin, SERVER_N, "Session Chat", med_priority);
        ChatController chat_controller = new ChatController(this, this.gui, this.chat_reader, this.chat_writer);
        chat_controller.start();
        this.wboard_writer = this.nextWriter(mxout, ++SERVER_N, low_priority);
        this.wboard_reader = this.nextReader(mxin, SERVER_N, "Session Whiteboard", low_priority);
        WhiteboardController wboard_controller = new WhiteboardController(this, this.gui, this.wboard_reader, this.wboard_writer);
        wboard_controller.start();
        this.ftp_writer = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.ftp_reader = this.nextReader(mxin, SERVER_N, "Session FTP Main (1/5)", high_priority);
        this.ftp_writer1 = this.nextWriter(mxout, ++SERVER_N, low_priority);
        this.ftp_reader1 = this.nextReader(mxin, SERVER_N, "Session FTP 2", low_priority);
        this.ftp_writer2 = this.nextWriter(mxout, ++SERVER_N, low_priority);
        this.ftp_reader2 = this.nextReader(mxin, SERVER_N, "Session FTP 3", low_priority);
        this.ftp_writer3 = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.ftp_reader3 = this.nextReader(mxin, SERVER_N, "Session FTP 4", high_priority);
        this.ftp_writer4 = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.ftp_reader4 = this.nextReader(mxin, SERVER_N, "Session FTP 5", high_priority);
        this.ftp_controller = new FTPController(this, this.gui, this.ftp_reader, this.ftp_writer, this.ftp_reader1, this.ftp_writer1, this.ftp_reader2, this.ftp_writer2, this.ftp_reader3, this.ftp_writer3, this.ftp_reader4, this.ftp_writer4, this.techUser.maxFileTransferSize);
        this.ftp_controller.start();
        this.cmds_writer = this.nextWriter(mxout, ++SERVER_N, med_priority);
        this.cmds_reader = this.nextReader(mxin, SERVER_N, "Session Async Commands", med_priority);
        this.cmds_controller = new AsyncCommandsController(this, this.gui, this.cmds_reader, this.cmds_writer);
        this.cmds_controller.start();
        this.port_writer = this.nextWriter(mxout, ++SERVER_N, med_priority);
        this.port_reader = this.nextReader(mxin, SERVER_N, "Session Port Redirection", med_priority);
        this.port_controller = new PortRedirectController(this, this.gui, this.port_reader, this.port_writer);
        this.gui.setPortRedirector(this.port_controller.getRedirector());
        this.sound_writer = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.sound_reader = this.nextReader(mxin, SERVER_N, "Session Sound", high_priority);
        this.sound_controller = new SoundController(this, this.gui, this.sound_reader, this.sound_writer, isMobile);
        this.sound_controller.start();
        this.terminal_writer = this.nextWriter(mxout, ++SERVER_N, high_priority);
        this.terminal_reader = this.nextReader(mxin, SERVER_N, "Terminal", high_priority);
        ++SERVER_N;
        this.terminalController = new TerminalController(this, this.gui, this.terminal_reader, this.terminal_writer);
        try {
            if (this.lightweightOnly) {
                this.setProcessHighPriority(false);
            } else {
                this.setProcessHighPriority(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.firstConnect) {
            this.firstConnect = false;
            this.gui.firstConnect();
        }
        this.gui.connected();
        if (this.rttwriter == null) {
            this.rttwriter = new RTTWriter();
            this.rttwriter.setDaemon(true);
            this.rttwriter.start();
        }
        if (this.techUser.isSessionSpeedLimited()) {
            System.out.println("[Controller] Applying upper bandwidth limit of " + this.techUser.getSessionSpeedLimitKBps() + "KB/s");
            this.setUpperBandwidthLimit(this.techUser.getSessionSpeedLimitKBps());
        }
        if (this.techUser.isFPSLimited()) {
            double fps = FPSSlider.getFPSFromDelay(this.techUser.getFPSDelay());
            System.out.println("[Controller] Applying upper FPS limit of " + fps + "f/s");
            this.setUpdateDelayLimitMS(this.techUser.getFPSDelay());
        }
        this.gui.setConnected(true, ip);
        if (Switches.SH_reportStatsAtSessionStart && this.reporter != null) {
            try {
                this.reporter.reportInterimStats();
            }
            catch (Exception x) {
                System.out.println("[Controller] Unable to report stats: " + x);
                x.printStackTrace();
            }
        }
    }

    private void verifyUser(OutputStream fout, InputStream fin, String username) throws IOException {
        byte[] utf8 = username.getBytes("UTF8");
        if (CentralDebugging.USE_BCU_FOR_SESSION) {
            StreamUtils.writeBytes(fout, utf8);
            fout.flush();
        } else {
            byte[] encb = this.blowfish.encryptSecure(utf8, 0, utf8.length, true);
            StreamUtils.writeBytes(fout, encb);
            fout.flush();
        }
        int response = StreamUtils.readInt(fin);
        if (response != 287484603) {
            if (response == -1146478063) {
                throw new IOException("Invalid Username");
            }
            if (response == -859037167) {
                throw new IOException("User not allowed");
            }
            throw new IOException("Bad User");
        }
    }

    private void setupStaticEncryption(InputStream fin, OutputStream fout) throws IOException {
        System.out.println("[Controller] Setting up static encryption");
        String[] pub_key = SecurityUtil.getMyPublicKey();
        StreamUtils.writeStringUTF8(fout, pub_key[0]);
        StreamUtils.writeStringUTF8(fout, pub_key[1]);
        fout.flush();
        RSADecryptor rsa_dec = SecurityUtil.getMyRSADecryptor();
        byte[] enc_blowfish = StreamUtils.readNBytes(fin, 5000000);
        this.blowfish_key = rsa_dec.decrypt(enc_blowfish);
        this.blowfish = new Blowfish();
        this.blowfish.init(this.blowfish_key);
    }

    private byte[][] createMoreSecureKeys(InputStream in, OutputStream out, int count) throws IOException {
        byte[][] keys = new byte[count][];
        for (int i = 0; i < count; ++i) {
            byte[] key = this.blowfish.decryptSecure(StreamUtils.readNBytes(in, 5000000), 0, true);
            keys[i] = key;
        }
        out.flush();
        return keys;
    }

    private Object[] secureStreams(InputStream in, OutputStream out, byte[] inkey, byte[] outkey) throws IOException {
        Object[] tmp = new Object[]{new BufferedInputStream(new BlowfishDecryptionStream((InputStream)new BufferedInputStream(in), inkey)), new BufferedOutputStream(new BlowfishEncryptionStream((OutputStream)new BufferedOutputStream(out), outkey))};
        System.out.println("[Controller] Streams secured");
        return tmp;
    }

    private void verifyPassword(OutputStream fout, InputStream fin, String password) throws IOException {
        boolean passwordOK = false;
        int attempts = 10;
        int response = 1126292666;
        while (!passwordOK && attempts >= 0) {
            --attempts;
            if (this.pspec.REQUIRED) {
                byte[] hashb = this.pspec.PASSWORD.getBytes("UTF8");
                if (CentralDebugging.USE_BCU_FOR_SESSION) {
                    StreamUtils.writeBytes(fout, hashb);
                    fout.flush();
                } else {
                    byte[] encb = this.blowfish.encryptSecure(hashb, 0, hashb.length, true);
                    StreamUtils.writeBytes(fout, encb);
                    fout.flush();
                }
            } else {
                StreamUtils.writeBytes(fout, new byte[1]);
                fout.flush();
            }
            response = StreamUtils.readInt(fin);
            if (response == 1126292666) {
                String newPassword = this.gui.requestMachinePassword();
                if (newPassword == null || newPassword.length() == 0) break;
                this.pspec.setPassword(newPassword);
                continue;
            }
            passwordOK = true;
        }
        if (response != -1412623820) {
            throw new IOException("Invalid Password");
        }
    }

    @Override
    public void closeConnection() {
        new Exception("***Explicit Connection Close Requested***").printStackTrace();
        try {
            this.directSocket.stop("session closed");
        }
        catch (Exception e) {
            System.out.println("[Controller] Ignored problem (" + e + ") closing connection:");
        }
        try {
            this.socket.stop("session closed");
        }
        catch (Exception e) {
            System.out.println("[Controller] Ignored problem (" + e + ") closing connection:");
        }
        this.socket = null;
        this.directSocket = null;
        this.cancelSessionOrTimeout();
        this.gui.setCentreGreyOverlay(Language.get("CONNECTION_CLOSED"), 60000L);
    }

    private long getUdpRtt() {
        if (this.directSocket != null) {
            return this.directSocket.getSmoothedRTT();
        }
        return -1L;
    }

    private long getNonUdpRtt() {
        if (this.socket != null) {
            return this.socket.getSmoothedRTT();
        }
        return -1L;
    }

    private int getSafeRttEstimateForServerTransactions() {
        long max = Math.max(this.getUdpRtt(), this.getNonUdpRtt());
        if (max == -1L) {
            return 5000;
        }
        max = Math.max(350L, max);
        return (int)(max *= 2L);
    }

    private void cancelSessionOrTimeout() {
        this.cancelSessionOrBlock(this.getSafeRttEstimateForServerTransactions());
    }

    private void cancelSessionOrBlock(int timeout) {
        System.out.println("[Controller] Trying to cancel session FWD on server");
        CancelUdpForwarding udp = new CancelUdpForwarding();
        udp.start();
        CancelNonUdpForwarding nonudp = new CancelNonUdpForwarding();
        nonudp.start();
        long max = Math.max(5, timeout);
        max = Math.min(10000L, max);
        long T = SafeClock.currentTimeMillis();
        try {
            udp.join(max);
        }
        catch (Exception exception) {
            // empty catch block
        }
        max -= SafeClock.currentTimeMillis() - T;
        max = Math.max(5L, max);
        T = SafeClock.currentTimeMillis();
        try {
            nonudp.join(max);
        }
        catch (Exception exception) {
            // empty catch block
        }
        max -= SafeClock.currentTimeMillis() - T;
        max = Math.max(5L, max);
        try {
            Thread.sleep(max);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public ScreenDimension[] getScreenDimensions() {
        if (this.screen_controller != null) {
            return this.screen_controller.getScreenDimensions();
        }
        return null;
    }

    @Override
    public void terminate() {
        this.cancelSessionOrTimeout();
        this.terminated = true;
        try {
            this.batch_input_writer.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.ftp_controller.terminate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearConnection(String reason) {
        System.out.println("[Controller] Stopping the direct socket");
        this.gui.setConnected(false, "");
        try {
            if (this.directSocket != null) {
                this.directSocket.stop(reason);
            }
        }
        catch (Exception e) {
            System.out.println("[Controller] Ignored problem (" + e + ") closing connection:");
        }
        this.directSocket = null;
        System.out.println("[Controller] Stopping the socket");
        try {
            if (this.socket != null) {
                this.socket.stop(reason);
            }
        }
        catch (Exception e) {
            System.out.println("[Controller] Ignored problem (" + e + ") closing connection:");
        }
        this.socket = null;
        System.out.println("[Controller] Cancelling the forwarding rules");
        this.cancelSessionOrBlock(this.getSafeRttEstimateForServerTransactions());
    }

    @Override
    public void setControlEnabled(boolean b) {
        this.block_control = !b;
    }

    @Override
    public void setEncoding(int enc) {
        this.enc = enc;
    }

    @Override
    public void setFiltering(int fil) {
        this.fil = this.lightweightOnly ? 53 : (!CentralDebugging.ALLOW_CHANGE_FILTERING_SIZE ? 51 : fil);
    }

    @Override
    public void setCompression(int comp) {
    }

    @Override
    public void setColourDepth(int depth) {
        this.coldepth = depth;
    }

    @Override
    public void setScaling(int scal) {
        if (this.scal != scal) {
            this.scal = scal;
            this.requestScreenResend();
        } else {
            this.scal = scal;
        }
    }

    private void disableInitialLL(boolean force) {
        if (force) {
            this.initialNLL = null;
        }
        if (this.initialNLL == null) {
            this.initialNLL = new LLDelayThread();
            this.initialNLL.start();
        }
    }

    @Override
    public void setContinuousRequestScreen(boolean b) {
        this.continuous_request = b;
        if (this.continuous_request) {
            FTPUtil.SLOW_DOWN_FOREVER();
            try {
                this.socket.setLowLatencyRequired(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.directSocket != null) {
                    this.directSocket.setLowLatencyRequired(true);
                }
            }
            catch (Exception exception) {}
        } else {
            FTPUtil.SPEED_UP_FOREVER();
            try {
                this.socket.setLowLatencyRequired(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.directSocket != null) {
                    this.directSocket.setLowLatencyRequired(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disableInitialLL(false);
        new ContinuousScreenRequest(b).start();
    }

    public void respondScreenEcho(Message m) {
        try {
            this.screen_writer.write(m);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void optimizeConnection() {
    }

    private void waitForFlush(int n) throws Exception {
        Message flushret;
        Integer flushPacket = n;
        while ((flushret = this.screen_controller.waitForScreenFlush(10000L)) != null && !flushret.get(0).equals(flushPacket)) {
        }
        if (flushret == null) {
            throw new Exception("timed out");
        }
    }

    private void doScreenFlush() throws Exception {
        int n = this.FLUSH_COUNTER++;
        Message flush = new Message(196615);
        flush.append(n);
        this.screen_writer.write(flush);
        this.waitForFlush(n);
    }

    @Override
    public void requestScreenResendAsPngs(Rectangle areaRequest) {
        if (this.screen_writer == null) {
            return;
        }
        try {
            Message cls = new Message(196627);
            this.screen_writer.write(cls);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.requestScreenAsPngs(areaRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void requestScreenResend() {
        try {
            this.requestScreen();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.screen_writer == null) {
            return;
        }
        try {
            Message cls = new Message(196627);
            this.screen_writer.write(cls);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void notifyGrabRectangleHasChanged() {
        boolean startNewThread = false;
        if (this.grThread == null) {
            startNewThread = true;
        } else {
            boolean bl = startNewThread = !this.grThread.isAlive();
        }
        if (this.gui != null && startNewThread) {
            this.grThread = new GrabRectangleChangeThread();
            this.grThread.start();
        }
    }

    @Override
    public void requestScreenAsPngs(Rectangle requestArea) {
        System.out.println("[Controller] Requesting screen as images");
        this.requestArea = requestArea;
        int N = 0;
        while (this.screen_writer == null) {
            System.out.println("[Controller] Waiting for screen writer (" + N + ")...");
            try {
                if (N == 30) {
                    return;
                }
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++N;
        }
        if (this.screen_writer == null) {
            return;
        }
        System.out.println("[Controller] Screen writer OK");
        try {
            Message m = new Message(196630);
            if (requestArea != null) {
                m.append(requestArea.x);
                m.append(requestArea.y);
                m.append(requestArea.width);
                m.append(requestArea.height);
            }
            this.screen_writer.write(m);
        }
        catch (NullPointerException t) {
            t.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.requestScreen();
    }

    @Override
    public void requestScreen() {
        Rectangle rect = this.gui.getGrabRectangle();
        if (this.requestArea != null) {
            rect = this.requestArea;
        }
        this.requestScreen(rect.x, rect.y, rect.width, rect.height);
    }

    private void requestScreen(int x, int y, int w, int h) {
        this.requestScreen(x, y, w, h, false);
    }

    private void requestScreen(int x, int y, int w, int h, boolean force) {
        if (this.screen_writer == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastScreenGrabRequest < 200L && !force) {
            return;
        }
        this.lastScreenGrabRequest = System.currentTimeMillis();
        try {
            Message m = new Message(196609);
            if (this.scal == 151) {
                x *= 2;
                y *= 2;
                w *= 2;
                h *= 2;
            } else if (this.scal == 152) {
                x *= 4;
                y *= 4;
                w *= 4;
                h *= 4;
            }
            if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                int tmp = x << 16 | y;
                m.append(tmp);
                tmp = w << 16 | h;
                m.append(tmp);
                tmp = this.enc << 2 | this.fil - 50;
                tmp = tmp << 3 | 5;
                tmp = tmp << 2 | this.scal - 150;
                tmp = tmp << 8 | this.coldepth;
                tmp = tmp << 14 | this.getUpdateDelay();
                m.append(tmp);
            } else {
                m.append(x);
                m.append(y);
                m.append(w);
                m.append(h);
                m.append(this.enc);
                m.append(this.fil);
                m.append(105);
                m.append(this.scal);
                m.append(this.coldepth);
                m.append(this.getUpdateDelay());
            }
            this.sendMouseMoveIfNecessary(false);
            this.screen_writer.write(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sendLockingKey(int code, boolean on) {
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(65539);
            m.append(code);
            m.append(on);
            this.bufferInput(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void ignoreCurrentClipboard() {
        if (this.clip_controller != null) {
            this.clip_controller.ignoreCurrentClipboard();
        }
    }

    @Override
    public boolean sendClipboardAndPaste() {
        if (this.clip_controller != null) {
            return this.clip_controller.sendClipboardAndPaste();
        }
        return false;
    }

    @Override
    public void sendFilesAndPaste(List files) {
        new FileSendPaste(files).start();
    }

    @Override
    public boolean sendClipboard() {
        if (this.clip_controller != null) {
            return this.clip_controller.sendClipboard();
        }
        return false;
    }

    @Override
    public void fetchClipboard(boolean textOnly) {
        new ClipFetch(textOnly).start();
    }

    @Override
    public void installCallingCard(String cardName, boolean createDesktopShortcut, boolean createMenuShortcut, boolean automaticallyLogin) {
        if (cardName != null) {
            Message callingCardMessage = new Message(-1061158815);
            callingCardMessage.append(cardName);
            callingCardMessage.append(createDesktopShortcut);
            callingCardMessage.append(createMenuShortcut);
            callingCardMessage.append(automaticallyLogin);
            this.doAsyncRemoteCommand(new CallingCardResponseResponseListener(), callingCardMessage);
        }
    }

    @Override
    public void requestSimpleGatewayUninstallation() {
        try {
            Message elevationWrapper = new Message(65558);
            Message m = new Message(65553);
            elevationWrapper.append(m);
            String message = Language.get("REQ_UNINSTALL_RA_SESSION") + "...";
            try {
                this.gui.setTopLeftGreyOverlay(message, 3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doAsyncRemoteCommand(new ElevationAndRunListener(new SimpleGatewayUninstallationListener(), message), elevationWrapper);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void sendElevateMouseMove() {
        this.sendElevateMouseMove(null, null);
    }

    @Override
    public void sendElevateMouseMove(String username, String password) {
        try {
            Message m = new Message(65557);
            m.append(username);
            m.append(password);
            try {
                this.gui.setTopLeftGreyOverlay(Language.get("REQ_ELEVATION") + "...", 3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doAsyncRemoteCommand(new ElevationListener(), m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void requestSimpleGatewayInstallation(SimpleGatewayConfig config, boolean installShortcuts) {
        try {
            Message elevationWrapper = new Message(65558);
            Message m = new Message(65552);
            byte[] cbytes = config.save(true);
            m.append(cbytes);
            m.append(installShortcuts);
            elevationWrapper.append(m);
            String message = Language.get("REQ_INSTALL_RA_SESSION") + "...";
            try {
                this.gui.setTopLeftGreyOverlay(message, 3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doAsyncRemoteCommand(new ElevationAndRunListener(new SimpleGatewayInstallationListener(), message), elevationWrapper);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void showErrorDialogFor(String title, String message, String moreInfo) {
        ErrorDialogs.ErrorGlassDialog egd = new ErrorDialogs.ErrorGlassDialog(this.gui.getParentFrame(), title);
        egd.setText(title, message, moreInfo);
        egd.showDialog();
    }

    private void showErrorDialogFor(ProcessResult result, String title) {
        String message = null;
        if (result.logErrors != null && result.logErrors.length() > 0) {
            message = result.logErrors.toString();
        }
        String moreInfo = result.stacktrace;
        this.showErrorDialogFor(title, message, moreInfo);
    }

    @Override
    public void requestDuplicateBackConnection() {
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(65545);
            this.bufferInput(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void launchRemoteDebugger() {
        Message m = new Message(-1061158862);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMonitorOffState(boolean enabled) {
        System.out.println("[Controller] Setting monitor off to " + enabled);
        Message m = new Message(-1061158800);
        m.append(enabled);
        this.isMonitorOff = enabled;
        this.gui.showBlankScreenOrBlockedInputWarning(this.isMonitorOff || this.isScreenBlanked || this.isControlBlocked);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            this.doAsyncRemoteCommand(new LockedCommandResponseListener(LOCK, timeout), m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setCaptureAudio(boolean capture) {
        System.out.println("[Controller] Capturing audio set to " + capture + " with rate " + OpusConfig.bitRate);
        Message m = new Message(-1061158843);
        m.append(capture);
        m.append(OpusConfig.bitRate);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlankScreenState(boolean enabled, String title, String message) {
        System.out.println("[Controller] Setting blank screen to " + enabled);
        Message m = new Message(-1061158873);
        m.append(enabled);
        m.append(title);
        m.append(message);
        this.isScreenBlanked = enabled;
        this.gui.showBlankScreenOrBlockedInputWarning(this.isMonitorOff || this.isScreenBlanked || this.isControlBlocked);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            this.doAsyncRemoteCommand(new LockedCommandResponseListener(LOCK, timeout), m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockControlState(boolean enabled) {
        System.out.println("[Controller] Setting block control to " + enabled);
        Message m = new Message(-1061158872);
        m.append(enabled);
        this.isControlBlocked = enabled;
        this.gui.showBlankScreenOrBlockedInputWarning(this.isMonitorOff || this.isScreenBlanked || this.isControlBlocked);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            this.doAsyncRemoteCommand(new LockedCommandResponseListener(LOCK, timeout), m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockDesktop(boolean enabled) {
        System.out.println("[Controller] Setting lock desktop to " + enabled);
        Message m = new Message(-1061158784);
        m.append(enabled);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            this.doAsyncRemoteCommand(new LockedCommandResponseListener(LOCK, timeout), m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackgroundImageState(boolean enabled) {
        System.out.println("[Controller] Setting background image to " + enabled);
        Message m = new Message(-1061158889);
        m.append(enabled);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            this.doAsyncRemoteCommand(new LockedCommandResponseListener(LOCK, timeout), m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAeroEffectsState(boolean enabled, boolean block) {
        this.setAeroEffectsState(enabled);
    }

    @Override
    public void setAeroEffectsState(boolean enabled) {
        System.out.println("[Controller] Setting aero effects to " + enabled);
        Message m = new Message(-1061158888);
        m.append(enabled);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void setGraphicsDriverDisabled(boolean disabled) {
        System.out.println("[Controller] Setting graphics driver state to " + !disabled);
        Message m = new Message(-1061158887);
        m.append(disabled);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void setUseHardwareAcceleration(boolean useIt) {
        System.out.println("[Controller] Setting use hw accel to " + useIt);
        this.useHardwareAcceleration = useIt;
        Message m = new Message(-1061158880);
        m.append(useIt);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    public boolean getUseHardwareAcceleration() {
        return this.useHardwareAcceleration;
    }

    @Override
    public void setProcessHighPriority(boolean high) {
        System.out.println("[Controller] Setting use high priority to " + high);
        Message m = new Message(-1061158861);
        m.append(high);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void sendRemoteReboot(boolean safeModeIfPossible, boolean forceIfPossible) {
        System.out.println("[Controller] Sending remote reboot request (safe mode=" + safeModeIfPossible + ",force=" + forceIfPossible + ")");
        Message m = new Message(-1061158879);
        m.append(safeModeIfPossible);
        m.append(forceIfPossible);
        this.doAsyncRemoteCommand(new RebootCommandResponseListener(), m);
        this.gui.expectReboot();
    }

    @Override
    public void sendControlAltDelete() {
        if (this.input_writer == null) {
            return;
        }
        try {
            System.out.println("[Controller] Requesting CAD");
            this.doElevatedAsyncRemoteCommand(null, new Message(-1061158876), Language.get("SEND_CTRL_ALT_DEL"));
        }
        catch (Throwable t) {
            System.out.println("[Controller] Error requesting CAD!");
            t.printStackTrace();
        }
    }

    @Override
    public void setAlterNumLock(boolean allowed) {
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(65570);
            m.append(allowed);
            this.input_writer.write(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sendAllowWiggle(boolean allowed) {
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(65544);
            m.append(allowed);
            this.bufferInput(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setDoubleClickTime(long t) {
        this.doubleClickTime = t;
    }

    public void setKeyLayoutDescription(String desc) {
        this.keyboardLayoutDescription = desc;
    }

    @Override
    public String getRemoteKeyMappingName() {
        return this.keyboardLayoutDescription;
    }

    @Override
    public String getLocalKeyMappingName() {
        if (this.localLayoutName != null) {
            return this.localLayoutName;
        }
        try {
            if (OS.isLinux()) {
                this.localLayoutName = LinuxKeyboardHandler.getCurrentLayoutName();
            }
            if (OS.isWindows()) {
                long id = JWNativeAPI.getInstance().getCurrentKeyboardLayout();
                this.localLayoutName = KeyboardLayout.getWindowsKeyboardLayoutDescription(id);
            }
            if (OS.isMacOS()) {
                String layoutName = RunCommandGetOutput.runCommandGetOutput(new String[]{"/bin/sh", "-c", "defaults read ~/Library/Preferences/com.apple.HIToolbox.plist AppleCurrentKeyboardLayoutInputSourceID"})[0];
                String keyboardLayoutID = layoutName.trim();
                this.localLayoutName = keyboardLayoutID.replace("com.apple.keylayout.", "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.localLayoutName == null) {
            this.localLayoutName = "Unknown";
        }
        return this.localLayoutName;
    }

    private boolean mayRequestRttEcho() {
        long T = SafeClock.currentTimeMillis();
        if (T > this.lastRttEchoRequest + 1000L) {
            this.lastRttEchoRequest = T;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendKeyRequest(KeyRequest key) {
        if (CentralDebugging.SHOW_KEY_INPUT_CODES) {
            System.out.println("[Controller] Requesting key: " + key);
        }
        if (!key.isKeyDown()) {
            this.flushAllBufferedKeys();
        }
        Object object = this.KEY_REQUEST_LOCK;
        synchronized (object) {
            this.keyRequests.add(key);
        }
        if (!key.isKeyDown() || key.preferMappedMode && key.charIsValid()) {
            this.flushAllBufferedKeys();
        }
    }

    private void reallySendKeyRequest(KeyRequest request) {
        if (CentralDebugging.SHOW_KEY_INPUT_CODES) {
            System.out.println("[Controller] Sending key request: " + request);
        }
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = request.toMessage();
            m.setType(65536);
            this.bufferInput(m);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushAllBufferedKeys() {
        ArrayList<KeyRequest> tmp;
        Iterator<KeyRequest> iterator = this.KEY_REQUEST_LOCK;
        synchronized (iterator) {
            tmp = this.keyRequests;
            this.keyRequests = new ArrayList();
        }
        for (KeyRequest key : tmp) {
            this.reallySendKeyRequest(key);
        }
    }

    @Override
    public void sendMouseWheel(int clicksRotation) {
        this.flushAllBufferedKeys();
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(131076);
            m.append(clicksRotation);
            m.append(0);
            m.append(0);
            this.sendMouseMoveIfNecessary(true);
            this.bufferInput(m);
        }
        catch (NullPointerException t) {
            t.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void sendMouseDown(int x, int y, int buttons, int modifiers, int nativebutton) {
        this.flushAllBufferedKeys();
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(131074);
            m.append(0x1C1C & buttons);
            m.append(modifiers);
            m.append(nativebutton);
            m.append(x);
            m.append(y);
            this.sendMouseMoveIfNecessary(true);
            this.bufferInput(m);
        }
        catch (NullPointerException t) {
            t.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void sendMouseUp(int x, int y, int buttons, int modifiers, int nativebutton) {
        this.flushAllBufferedKeys();
        if (this.input_writer == null) {
            return;
        }
        try {
            Message m = new Message(131075);
            m.append(0x1C1C & buttons);
            m.append(modifiers);
            m.append(nativebutton);
            m.append(x);
            m.append(y);
            this.sendMouseMoveIfNecessary(true);
            this.bufferInput(m);
        }
        catch (NullPointerException t) {
            t.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setCurrentMouseLocation(int x, int y) {
        this.currentLocX = x;
        this.currentLocY = y;
        this.currentLocLastUpdated = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMouseMoveIfNecessary(boolean realInput) {
        Object object = this.lastMouseInput_LOCK;
        synchronized (object) {
            if (realInput) {
                this.lastMouseInput = System.currentTimeMillis();
            } else if (System.currentTimeMillis() < this.lastMouseInput + 250L) {
                return;
            }
        }
        if (this.currentLocLastUpdated != this.currentLocLastSent) {
            this.sendMouseMove(this.currentLocX, this.currentLocY);
            this.currentLocLastSent = this.currentLocLastUpdated;
        }
    }

    private void resetMouseMoveExtent() {
        this.oldX = -1;
        this.oldY = -1;
        this.xExtent = 0;
        this.yExtent = 0;
    }

    private int getMouseMoveExtent() {
        return Math.max(this.xExtent, this.yExtent);
    }

    @Override
    public void sendMouseMove(int x, int y) {
        if (x == -1 || y == -1) {
            return;
        }
        if (this.input_writer == null) {
            return;
        }
        try {
            if (this.scal == 151) {
                x *= 2;
                y *= 2;
            } else if (this.scal == 152) {
                x *= 4;
                y *= 4;
            }
            Message m = new Message(131073);
            m.append(x);
            m.append(y);
            this.bufferInput(m);
            if (this.oldX == -1) {
                this.oldX = x;
                this.oldY = y;
            } else {
                this.xExtent = Math.max(this.xExtent, Math.abs(x - this.oldX));
                this.yExtent = Math.max(this.yExtent, Math.abs(y - this.oldY));
            }
            if (VideoRecorder.getInstance() != null) {
                VideoRecorder.getInstance().setCursorPosition(x, y);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String[] getRemoteClipboardFiles() {
        try {
            return this.ftp_controller.getRemoteClipboardFiles();
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    @Override
    public String getRemoteTempDir() {
        try {
            return this.ftp_controller.getRemoteTempDir();
        }
        catch (Throwable t) {
            return "./";
        }
    }

    @Override
    public String getRemoteEnv(String name) {
        try {
            return this.ftp_controller.getRemoteEnv(name);
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public String getRemoteHomeDir() {
        try {
            return this.ftp_controller.getRemoteHomeDir();
        }
        catch (Throwable t) {
            return "./";
        }
    }

    @Override
    public FTPVolume[] getRemoteVolumes() {
        try {
            return this.ftp_controller.getRemoteVolumes();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new FTPVolume[]{new FTPVolume("/")};
        }
    }

    @Override
    public String getRemoteSeparator() {
        try {
            return this.ftp_controller.getRemoteSeparator();
        }
        catch (Throwable t) {
            return "/";
        }
    }

    public long getFileSize(String path) {
        try {
            return this.ftp_controller.getFileSize(path);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    @Override
    public FileEntry[] getRemoteDir(RemoteFile file) {
        try {
            return this.ftp_controller.getRemoteDir(file);
        }
        catch (Throwable t) {
            return new FileEntry[0];
        }
    }

    @Override
    public void saveRemoteClipboard(File directory) {
        if (this.clipboard_writer == null) {
            return;
        }
        try {
            Message m = new Message(262145);
            m.append(directory.getAbsolutePath());
            this.clipboard_writer.write(m);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void runProgram(String program, String working_dir, boolean elevate) {
        Message m = new Message(65543);
        m.append(program);
        m.append(working_dir);
        m.append(elevate);
        if (elevate) {
            this.doElevatedAsyncRemoteCommand(null, m, Language.get("RUN_COMMAND_TITLE"));
        } else {
            this.doAsyncRemoteCommand(null, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferInput(Message m) {
        Object object = this.input_out_lock;
        synchronized (object) {
            Message previous;
            int type = m.getType();
            boolean appendMessage = true;
            long tnow = System.currentTimeMillis();
            if (type == 65536) {
                this.batchUntil = tnow;
            } else if (type == 65559) {
                this.batchUntil = tnow;
            } else if (type == 131074) {
                this.nextMouseMove = 0L;
                if (CentralDebugging.SIMULATE_DOUBLE_CLICKS_IF_REQUIRED && this.doubleClickTime != -1L) {
                    if (this.multiClick) {
                        this.multiClick = false;
                    }
                    this.batchUntil = tnow;
                    if (tnow - this.lastMouseDown < 800L && (long)this.getMouseMoveExtent() < 3L) {
                        m.setType(131077);
                        if (CentralDebugging.VERBOSE_DOUBLE_CLICK_SIMULATION) {
                            System.out.println("[Controller] Sending MOUSE_DOWN as double click");
                        }
                        this.multiClick = true;
                        this.lastMouseDown = 0L;
                    } else {
                        if (CentralDebugging.VERBOSE_DOUBLE_CLICK_SIMULATION) {
                            System.out.println("[Controller] Sending MOUSE_DOWN immediately");
                        }
                        this.multiClick = false;
                        this.lastMouseDown = tnow;
                    }
                    this.resetMouseMoveExtent();
                } else {
                    this.batchUntil = CentralDebugging.NO_MOUSE_DELAYS_FOR_DOUBLECLICK ? tnow : tnow + 200L;
                }
            } else if (type == 131075) {
                this.nextMouseMove = 0L;
                if (CentralDebugging.SIMULATE_DOUBLE_CLICKS_IF_REQUIRED && this.doubleClickTime != -1L) {
                    this.batchUntil = tnow;
                    if (this.multiClick) {
                        if (CentralDebugging.VERBOSE_DOUBLE_CLICK_SIMULATION) {
                            System.out.println("[Controller] Ignoring MOUSE_UP part of double click");
                        }
                        this.multiClick = false;
                        return;
                    }
                    if (CentralDebugging.VERBOSE_DOUBLE_CLICK_SIMULATION) {
                        System.out.println("[Controller] Sending MOUSE_UP immediately");
                    }
                } else {
                    this.batchUntil = CentralDebugging.NO_MOUSE_DELAYS_FOR_DOUBLECLICK ? tnow : tnow + 150L;
                }
            } else if (type == 131073) {
                if (CentralDebugging.SCR_SEND_NOTHING_ON_NO_CHANGE) {
                    // empty if block
                }
            } else {
                this.batchUntil = tnow;
            }
            if (type == 131073 && this.input_out_buffer.size() > 0 && (previous = (Message)this.input_out_buffer.get(this.input_out_buffer.size() - 1)).getType() == type) {
                this.input_out_buffer.set(this.input_out_buffer.size() - 1, m);
                appendMessage = false;
            }
            if (appendMessage) {
                this.input_out_buffer.add(m);
            }
            if (this.batchUntil >= tnow) {
                Object object2 = this.input_notifier;
                synchronized (object2) {
                    this.input_notifier.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatchedInputNow() {
        long T = System.currentTimeMillis();
        Object object = this.input_out_lock;
        synchronized (object) {
            T = System.currentTimeMillis() - T;
            if (T > 20L && CentralDebugging.DEBUG_INPUT_BUFFERING_LAG) {
                System.out.println("[Controller] Had to wait " + T + " for input lock");
            }
            if (System.currentTimeMillis() > this.batchUntil) {
                if (this.input_out_buffer.size() > 0) {
                    Message batch = new Message(65554);
                    T = System.currentTimeMillis() - this.sendBatchLastCalled;
                    if (CentralDebugging.DEBUG_INPUT_BUFFERING_LAG) {
                        System.out.println("Sending INPUT BATCH of " + this.input_out_buffer.size() + " (+" + T + "ms since last call, " + this.waitForBatchUntil + " batch timer waits, " + this.waitForBufferNonZero + " empty buffer waits)");
                    }
                    for (int i = 0; i < this.input_out_buffer.size(); ++i) {
                        Message m = (Message)this.input_out_buffer.get(i);
                        batch.append(m);
                        if (!CentralDebugging.DEBUG_INPUT_BUFFERING_LAG) continue;
                        System.out.println(i + ": " + m);
                    }
                    if (!this.block_control) {
                        if (CentralDebugging.DEBUG_INPUT_BUFFERING_LAG) {
                            System.out.println("Writing input batch");
                        }
                        try {
                            if (Switches.SH_1555_performanceMeasurementsOnInput && this.mayRequestRttEcho()) {
                                batch.append(this.getRttEchoRequest(!Switches.SH_1555_performanceMeasurementsPeriodically));
                            }
                            this.input_writer.write(batch);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (CentralDebugging.DEBUG_INPUT_BUFFERING_LAG) {
                            System.out.println("Wrote input batch");
                        }
                    }
                    this.input_out_buffer.clear();
                    this.waitForBatchUntil = 0;
                    this.waitForBufferNonZero = 0;
                } else {
                    ++this.waitForBufferNonZero;
                }
            } else {
                ++this.waitForBatchUntil;
            }
        }
        this.sendBatchLastCalled = System.currentTimeMillis();
    }

    @Override
    public void fetchClipboardAfterInputSent() {
        ClipboardUtil.setClipboardAsText("");
        this.mustFetchClipboardAfterInput = true;
    }

    public RTTBuckets getScreenTimes() {
        return this.screenTimes;
    }

    public BandwidthBuckets getScreenSizes() {
        return this.screenSizes;
    }

    public RTTBuckets getAppRTTs() {
        return this.apprtts;
    }

    private Message getRttEchoRequest(boolean sendBackBuckets) {
        Message m = new Message(-1061158791);
        m.append(SafeClock.currentTimeMillis());
        m.append(sendBackBuckets);
        m.append(this.clearRemoteRtts);
        m.append(OneClock.getCentralTimeNow());
        this.clearRemoteRtts = false;
        return m;
    }

    @Override
    public void addPortRedirection(long UID, int localport, String remotehost, int remoteport) {
        this.port_controller.getRedirector().addRedirection(localport, remotehost, remoteport, UID);
    }

    @Override
    public void addRemotePortRedirection(long UID, int localport, String remotehost, int remoteport) {
        this.port_controller.getRedirector().addRemoteRedirection(localport, remotehost, remoteport, UID);
    }

    @Override
    public void removePortRedirection(long UID) {
        this.port_controller.getRedirector().removeRedirection(UID);
    }

    @Override
    public void doElevatedAsyncRemoteCommand(CommandResponseListener listener, Message m, String performingElevatedActionMessage) {
        Message elevationWrapper = new Message(65558);
        elevationWrapper.append(m);
        this.doAsyncRemoteCommand(new ElevationAndRunListener(listener, performingElevatedActionMessage), elevationWrapper);
    }

    @Override
    public void doAsyncRemoteCommand(CommandResponseListener listener, Message m) {
        if (this.cmds_controller != null) {
            this.cmds_controller.doAsyncRemoteCommand(listener, m);
        }
    }

    @Override
    public void sendAsyncRemoteCommand(Message m, String conversation) {
        if (this.cmds_controller != null) {
            this.cmds_controller.sendAsyncRemoteCommand(m, conversation);
        }
    }

    @Override
    public void registerOngoingListener(CommandResponseListener listener, String conversation) {
        if (this.cmds_controller != null) {
            this.cmds_controller.registerOngoingListener(listener, conversation);
        }
    }

    @Override
    public void deregisterListener(String conversation) {
        if (this.cmds_controller != null) {
            this.cmds_controller.deregisterListener(conversation);
        }
    }

    public void reconnectConnection() {
    }

    @Override
    public NodeLinkStats getLocalSessionStats() {
        NodeLink direct = this.directSocket;
        if (direct != null) {
            return direct.getStats();
        }
        if (this.socket != null) {
            return this.socket.getStats();
        }
        return null;
    }

    @Override
    public void getRemoteSessionStats(CommandResponseListener listener) {
        Message m = new Message(-1061158874);
        this.doAsyncRemoteCommand(listener, m);
    }

    @Override
    public void setSelectedScreen(int selectedScreen) {
        Message m = new Message(-791674880);
        m.append(selectedScreen);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void sendPermissionsRequest(String title, String message, CommandResponseListener responseListener) {
        System.out.println("[Controller] Sending permission request.");
        Message m = new Message(-1061158864);
        m.append(title);
        m.append(message);
        this.doAsyncRemoteCommand(responseListener, m);
    }

    void writeMachineSpecificPreferences(Properties properties) throws IOException {
        File cacheDir = JWSystem.getAllAppVersionsSharedFolder();
        File preferencesFolder = new File(cacheDir, "preferences");
        preferencesFolder.mkdirs();
        File machineProperties = new File(preferencesFolder, this.remoteMachineID + ".xml");
        FileOutputStream fout = new FileOutputStream(machineProperties);
        properties.storeToXML(fout, "SimpleHelp Machine Properties");
        fout.close();
    }

    @Override
    public MachinePrefs getConnectedMachinePrefs() {
        if (this.prefs == null) {
            this.prefs = new MachinePrefs(this);
        }
        return this.prefs;
    }

    Properties readMachineSpecificPreferences() {
        File machineProperties;
        File cacheDir = JWSystem.getAllAppVersionsSharedFolder();
        Properties properties = new Properties();
        File preferencesFolder = new File(cacheDir, "preferences");
        if (preferencesFolder.exists() && (machineProperties = new File(preferencesFolder, this.remoteMachineID + ".xml")).exists()) {
            try {
                FileInputStream fin = new FileInputStream(machineProperties);
                properties.loadFromXML(fin);
            }
            catch (Throwable t) {
                System.out.println("[Controller] WARNING: unable to load properties file (" + machineProperties.getAbsolutePath() + ").");
                t.printStackTrace();
            }
        }
        return properties;
    }

    @Override
    public boolean switchTransports(int ourTransport, int remoteTransport) {
        return this.switchTransports(ourTransport, remoteTransport, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean switchTransports(int ourTransport, int remoteTransport, boolean allowPortScan) {
        Object object = this.switch_LOCK;
        synchronized (object) {
            this.switching = true;
            try {
                if (ourTransport == 0) {
                    boolean bl = this.reestablishUdpTransport(true, allowPortScan);
                    return bl;
                }
                if (ourTransport == 1) {
                    boolean bl = this.reestablishUdpTransport(false, allowPortScan);
                    return bl;
                }
                boolean bl = this.reestablishNonUdpTransport(ourTransport, remoteTransport);
                return bl;
            }
            finally {
                this.switching = false;
            }
        }
    }

    @Override
    public boolean isSwitchingTransport() {
        return this.switching;
    }

    public String getSessionNLID() {
        if (this.directSocket != null) {
            return this.directSocket.getSimpleID();
        }
        return "none";
    }

    public void clearSessionStats() {
        if (this.directSocket != null) {
            this.directSocket.clearReadRate();
        }
        if (this.getAppRTTs() != null) {
            this.getAppRTTs().clear();
        }
        this.clearRemoteRtts = true;
        if (this.directSocket != null) {
            this.directSocket.getStats().buckets.clear();
            this.directSocket.getStats().sessionStarted = System.currentTimeMillis();
            this.directSocket.getStats().diedTimes = 0L;
        }
    }

    @Override
    public void sendSessionPerformanceSlice() {
        this.reporter.reportInterimStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reestablishNonUdpTransport(int localType, int remoteType) {
        System.out.println("[Controller] Reestablishing with non-UDP transport");
        if (this.rttwriter != null) {
            this.rttwriter.skipWrites = true;
        }
        try {
            boolean ok;
            OutputStream out;
            NodeLink nonudp;
            String time;
            if (CentralDebugging.REPORT_SESSION_RTTS_ON_SWITCH) {
                try {
                    if (this.reporter != null) {
                        this.reporter.reportInterimStats();
                    }
                }
                catch (Exception x) {
                    System.out.println("[Controller] Unable to report: " + x);
                    x.printStackTrace();
                }
            }
            long id = BCUtil.getSecureRandom().nextLong();
            int fwdID = BCUtil.getSecureRandom().nextInt();
            Message m = new Message(-1061158798);
            m.append(id);
            m.append(remoteType);
            this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("HHmmSS");
                time = sdf.format(new Date());
                nonudp = null;
                try {
                    nonudp = SHelpNodelinkConnector.getSpecificConnection(localType, this.connectedServerHost, this.connectedServerPort, null);
                    nonudp.setFriendlyName("TemporaryPatchShellNonUDP-" + time);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                boolean iAmOk = nonudp != null;
                StreamUtils.writeBoolean(this.transport_line.out, iAmOk);
                this.transport_line.out.flush();
                boolean theyAreOk = StreamUtils.readBoolean(this.transport_line.in);
                if (!iAmOk || !theyAreOk) {
                    if (!iAmOk) {
                        System.out.println("[Controller] Unable to establish requested transport on the local side");
                    }
                    if (!theyAreOk) {
                        System.out.println("[Controller] Unable to establish requested transport on the remote side");
                    }
                    boolean bl = false;
                    return bl;
                }
                out = nonudp.getOutputStream();
            }
            catch (Exception x) {
                x.printStackTrace();
                boolean bl = false;
                return bl;
            }
            StreamUtils.writeLong(out, BuildDateUtil.getPatchMagicBuildDate());
            out.flush();
            InputStream in = nonudp.getInputStream();
            try {
                if (BuildDateUtil.getPatchMagicBuildDate() != StreamUtils.readLong(in)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
            }
            SHelpNodelinkPatcher.issuePatchRequestAndWait(nonudp, id, fwdID, this.directSocket, this.transportAssocNode, false);
            this.directSocket.setFriendlyName("ReestablishedPatchedRemoteNonUDP-" + time);
            try {
                ok = this.directSocket.replaceTransportWithTransportFrom(nonudp, this.transport_line.in, this.transport_line.out, fwdID, false);
            }
            catch (Exception x) {
                System.out.println("Transport switch failed with exception: " + x);
                x.printStackTrace();
                ok = false;
            }
            if (!ok && Switches.SH_1468_nlCloseShellNlOnSwitchFail) {
                System.out.println("Closing shell NL used for transport switch");
                nonudp.stop("closing shell NL used in transport switch");
                boolean x = false;
                return x;
            }
            try {
                this.directSocket.setOptimisationFeed(this.gui.getNLOptimisationFeed());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (CentralDebugging.REPORT_SESSION_RTTS_ON_SWITCH) {
                this.clearSessionStats();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            this.rttwriter.skipWrites = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reestablishUdpTransport(boolean direct, boolean allowPortScan) {
        if (direct ? this.directSocket.getStats().type == 4 : this.directSocket.getStats().type == 3) {
            return true;
        }
        this.rttwriter.skipWrites = true;
        try {
            int port;
            if (CentralDebugging.REPORT_SESSION_RTTS_ON_SWITCH) {
                try {
                    if (this.reporter != null) {
                        this.reporter.reportInterimStats();
                    }
                }
                catch (Exception x) {
                    System.out.println("[Controller] Unable to report: " + x);
                    x.printStackTrace();
                }
            }
            ReadRateResponseListener readRate = new ReadRateResponseListener();
            System.out.println("[Controller] Sending UDP transport reestablish request (" + (direct ? "direct" : "proxied") + ")");
            Message m = new Message(-1061158860);
            m.append(direct);
            m.append(allowPortScan);
            if (direct) {
                m.append(readRate.getMyMaxRateDirect());
            } else {
                m.append(readRate.getMyMaxRateProxied());
            }
            this.doAsyncRemoteCommand(readRate, m);
            String host = this.localServerHost != null ? this.localServerHost : this.connectedServerHost;
            int n = port = this.localServerHost != null ? this.localServerPort : this.connectedServerPort;
            NodeLink nl = direct ? (Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor ? SHelpUdpNlNatHpMk2.establishDirectUDP(this.wtrans.getNLForwardingAPI(this.transportAssocNode), host, port, this.transport_line.in, this.transport_line.out, allowPortScan) : SHelpUdpNlNatHpMk2.establishDirectUDP(new ObsoleteShServerNodeTransactor(this.transportAssocNode, this.socket), host, port, this.transport_line.in, this.transport_line.out, allowPortScan)) : (Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor ? SHelpUdpNlNatHpMk2.establishProxiedUDP(this.wtrans.getNLForwardingAPI(this.transportAssocNode), host, port, this.transport_line.in, this.transport_line.out) : SHelpUdpNlNatHpMk2.establishProxiedUDP(new ObsoleteShServerNodeTransactor(this.transportAssocNode, this.socket), host, port, this.transport_line.in, this.transport_line.out));
            if (nl != null) {
                boolean success;
                try {
                    success = this.directSocket.replaceTransportWithTransportFrom(nl, this.transport_line.in, this.transport_line.out, 0, true);
                }
                catch (Exception x) {
                    System.out.println("Transport switch failed with exception: " + x);
                    x.printStackTrace();
                    success = false;
                }
                if (success) {
                    this.directSocket.setInitialRateKbPerSec(readRate.getMaxSendRate(0));
                }
                if (!success && Switches.SH_1468_nlCloseShellNlOnSwitchFail) {
                    System.out.println("Closing shell NL used for transport switch");
                    nl.stop("closing shell NL used in transport switch");
                    boolean x = false;
                    return x;
                }
                this.disableInitialLL(true);
                try {
                    this.directSocket.setOptimisationFeed(this.gui.getNLOptimisationFeed());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (CentralDebugging.REPORT_SESSION_RTTS_ON_SWITCH) {
                    this.clearSessionStats();
                }
                boolean bl = success;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rttwriter.skipWrites = false;
        }
    }

    public void setSessionPerformanceReporter(SessionPerformanceReporter reporter) {
        this.reporter = reporter;
        if (Switches.SH_reportStatsAtSessionStart && reporter != null) {
            try {
                reporter.reportInterimStats();
            }
            catch (Exception x) {
                System.out.println("[Controller] Unable to report stats: " + x);
                x.printStackTrace();
            }
        }
    }

    @Override
    public void sendAlertRemoteUser() {
        Message m = new Message(-1061158816);
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public boolean isTechnicianSide() {
        return true;
    }

    @Override
    public void notifyTechnicianTyping(String name) {
        if (System.currentTimeMillis() - this.lastTechnicianTypingTime > 1000L) {
            this.lastTechnicianTypingTime = System.currentTimeMillis();
            Message m = new Message(-1061158799);
            m.append(name);
            this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolBoxResult runToolBoxItem(ToolBoxItem item) {
        Message m = item.toMessage();
        m.setType(-1061158811);
        Object LOCK = new Object();
        MutableBoolean timeout = new MutableBoolean();
        Object object = LOCK;
        synchronized (object) {
            LockedCommandResponseListener listener = new LockedCommandResponseListener(LOCK, timeout);
            this.doAsyncRemoteCommand(listener, m);
            try {
                LOCK.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (timeout.value) {
                return null;
            }
            return ToolBoxResult.fromMessage(listener.getResponse());
        }
    }

    @Override
    public void sendFailoverRequest(String url) {
        Message m = new Message(-1061158793);
        m.append(url);
        m.append(this.getCustomerOrMachineID());
        this.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void sendTerminalControl(char toWrite) {
        this.terminalController.sendTerminalControl(toWrite);
    }

    @Override
    public void sendTerminalControl(byte[] data, int offset, int len) {
        this.terminalController.sendTerminalControl(data, offset, len);
    }

    @Override
    public void setWinSize(int columns, int rows) {
        if (this.terminalController != null) {
            this.terminalController.setWinSize(columns, rows);
        } else {
            System.out.println("[Controller] Unable to set window size as controller is null");
        }
    }

    private class ReadRateResponseListener
    implements CommandResponseListener {
        private Object LOCK = new Object();
        private int maxRateKBps = -1;

        private ReadRateResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            this.maxRateKBps = m.getNextInt();
            if (this.maxRateKBps == -1) {
                this.maxRateKBps = 0;
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notifyAll();
            }
        }

        public int getMyMaxRateProxied() {
            int maxReadRate = 0;
            if (Controller.this.socket != null) {
                maxReadRate = Controller.this.socket.getMaxReadRateProxiedKBps();
            }
            if (Controller.this.directSocket != null) {
                maxReadRate = Math.max(maxReadRate, Controller.this.directSocket.getMaxReadRateProxiedKBps());
            }
            return maxReadRate;
        }

        public int getMyMaxRateDirect() {
            int maxReadRate = 0;
            if (Controller.this.socket != null) {
                maxReadRate = Controller.this.socket.getMaxReadRateDirectKBps();
            }
            if (Controller.this.directSocket != null) {
                maxReadRate = Math.max(maxReadRate, Controller.this.directSocket.getMaxReadRateDirectKBps());
            }
            return maxReadRate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxSendRate(int delay) {
            long quitAt = SafeClock.currentTimeMillis() + (long)delay;
            if (this.maxRateKBps == -1 && delay > 0) {
                try {
                    Object object = this.LOCK;
                    synchronized (object) {
                        this.LOCK.wait(delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return Math.max(1, this.maxRateKBps);
        }
    }

    class AutoUpgrade
    extends Thread {
        final int local;
        final int remote;
        int local2;
        int remote2;
        int stages = 1;

        public AutoUpgrade(int local, int remote) {
            this.local = local;
            this.remote = remote;
            this.stages = 1;
        }

        public AutoUpgrade(int local, int remote, int local2, int remote2) {
            this.local = local;
            this.remote = remote;
            this.local2 = local2;
            this.remote2 = remote2;
            this.stages = 2;
        }

        @Override
        public void run() {
            Controller.this.gui.upgradeStarted(this.local, this.remote);
            try {
                System.out.println("[Auto Upgrade] Trying to switch transports to " + this.local + "/" + this.remote);
                if (Controller.this.switchTransports(this.local, this.remote, false)) {
                    System.out.println("[Auto Upgrade] Switched transports to " + this.local + "/" + this.remote + " OK");
                    Controller.this.gui.upgradeComplete();
                    Thread.sleep(1000L);
                    if (this.stages == 2) {
                        System.out.println("[Auto Upgrade] Initial upgrade OK, trying to switch transports further to " + this.local2 + "/" + this.remote2);
                        Controller.this.gui.upgradeStarted(this.local2, this.remote2);
                        if (Controller.this.switchTransports(this.local2, this.remote2, false)) {
                            System.out.println("[Auto Upgrade] Switched transports to " + this.local2 + "/" + this.remote2 + " OK");
                            Controller.this.gui.upgradeComplete();
                        } else {
                            System.out.println("[Auto Upgrade] Failed to switch transports");
                            Controller.this.gui.upgradeFailed(true);
                        }
                    }
                } else {
                    System.out.println("[Auto Upgrade] Failed to switch transports");
                    Controller.this.gui.upgradeFailed(false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println("[Auto Upgrade] Unexpected failure " + t);
                Controller.this.gui.upgradeFailed(false);
            }
        }
    }

    private static class SecurityConfig {
        boolean encrypted_sockets;
        int pubpriv_keysize;
        int sym_keysize;
        GenericRandom cprng;
        EntropyGatherer ent;
        boolean gather_at_start;

        private SecurityConfig() {
        }
    }

    class BatchInputWriter
    extends Thread {
        public BatchInputWriter() {
            super("BatchInputWriter");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Controller.this.terminated) {
                Controller.this.sendBatchedInputNow();
                long T = System.currentTimeMillis();
                if (Controller.this.mustFetchClipboardAfterInput) {
                    Controller.this.mustFetchClipboardAfterInput = false;
                    System.out.println("[BatchInputWriter] Must fetch clipboard after input now!");
                    try {
                        Controller.this.fetchClipboard(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ((T = System.currentTimeMillis() - T) > 20L) {
                    System.out.println("[BatchInputWriter] fetching clipboard took " + T + "ms");
                }
                try {
                    T = System.currentTimeMillis();
                    Object object = Controller.this.input_notifier;
                    synchronized (object) {
                        T = System.currentTimeMillis() - T;
                        if (T > 20L) {
                            System.out.println("[BatchInputWriter] unable to secure lock for " + T + "ms");
                        }
                        T = System.currentTimeMillis();
                        Controller.this.input_notifier.wait(50L);
                        T = System.currentTimeMillis() - T;
                        if (T > 70L) {
                            System.out.println("[BatchInputWriter] forced to wait for " + T + "ms");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    class RTTWriter
    extends Thread
    implements CommandResponseListener {
        boolean skipWrites;

        public RTTWriter() {
            super("RTTWriter");
            this.skipWrites = false;
        }

        @Override
        public void run() {
            boolean registered = false;
            while (!Controller.this.terminated) {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.skipWrites || Controller.this.cmds_controller == null) continue;
                if (!registered) {
                    Controller.this.cmds_controller.registerOngoingListener(this, "rttecho");
                    registered = true;
                    if (!Switches.SH_1555_performanceMeasurementsPeriodically) break;
                }
                if (!Switches.SH_1555_performanceMeasurementsPeriodically || Controller.this.directSocket == null) continue;
                Message m = Controller.this.getRttEchoRequest(true);
                Controller.this.cmds_controller.sendAsyncRemoteCommand(m, "rttecho");
            }
        }

        @Override
        public void response(Message m) {
            long rtt = SafeClock.currentTimeMillis() - m.getNextLong();
            Controller.this.apprtts.rttMeasured(rtt);
            try {
                if (m.hasNext()) {
                    RTTBuckets screenWorks = new RTTBuckets();
                    screenWorks.rtts = ArrayToMessage.fromCompressed(m.getNextByteArray());
                    BandwidthBuckets screenBytes = new BandwidthBuckets();
                    screenBytes.bytes = ArrayToMessage.fromCompressed(m.getNextByteArray());
                    Controller.this.screenTimes = screenWorks;
                    Controller.this.screenSizes = screenBytes;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private class CadResponseListener
    implements CommandResponseListener {
        private CadResponseListener() {
        }

        @Override
        public void response(Message m) {
            Language.get("DONE");
        }
    }

    private class RebootCommandResponseListener
    implements CommandResponseListener {
        private RebootCommandResponseListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == -286392320) {
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(Language.get("REBOOT_FAILED"), 10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class IgnoredCommandResponseListener
    implements CommandResponseListener {
        private IgnoredCommandResponseListener() {
        }

        @Override
        public void response(Message m) {
        }
    }

    private class SimpleGatewayUninstallationListener
    implements CommandResponseListener {
        private SimpleGatewayUninstallationListener() {
        }

        @Override
        public void response(Message m) {
            System.out.println("[Controller] SimpleGatewayUninstallationListener received a response.");
            if (m.getType() == 65553) {
                ProcessResult result = ProcessResultMessage.fromMessage((Message)m.get(0));
                System.out.println(result);
                if (result.isOK()) {
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_UNINSTALL_RA_OK"), 3000L);
                    }
                    catch (Exception exception) {}
                } else if (result.isError()) {
                    Controller.this.showErrorDialogFor(result, Language.get("REQ_UNINSTALL_RA_ERROR"));
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_UNINSTALL_RA_ERROR"), 10000L);
                    }
                    catch (Exception exception) {}
                }
            } else if (m.getType() == -286392320) {
                String message = m.get(0).toString();
                String stacktrace = m.get(1).toString();
                System.out.println("[Controller] Error uninstalling SG - " + message);
                System.out.println(stacktrace);
                Controller.this.showErrorDialogFor(Language.get("REQ_UNINSTALL_RA_ERROR"), message, stacktrace);
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_UNINSTALL_RA_ERROR"), 10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class SimpleGatewayInstallationListener
    implements CommandResponseListener {
        private SimpleGatewayInstallationListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == 65552) {
                ProcessResult result = ProcessResultMessage.fromMessage((Message)m.get(0));
                System.out.println(result);
                if (result.isOK()) {
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_INSTALL_RA_OK"), 3000L);
                    }
                    catch (Exception exception) {}
                } else if (result.isError()) {
                    Controller.this.showErrorDialogFor(result, Language.get("REQ_INSTALL_RA_ERROR"));
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_INSTALL_RA_ERROR"), 10000L);
                    }
                    catch (Exception exception) {}
                }
            } else if (m.getType() != -421134336 && m.getType() == -286392320) {
                String message = m.get(0).toString();
                String stacktrace = m.get(1).toString();
                System.out.println("[Controller] Error installing SG - " + message);
                System.out.println(stacktrace);
                Controller.this.showErrorDialogFor(Language.get("REQ_INSTALL_RA_ERROR"), message, stacktrace);
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_INSTALL_RA_ERROR"), 10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class ElevationAndRunListener
    implements CommandResponseListener {
        private final CommandResponseListener secondaryListener;
        private final String contentGUIMessage;

        public ElevationAndRunListener(CommandResponseListener secondaryListener, String contentGUIMessage) {
            this.secondaryListener = secondaryListener;
            this.contentGUIMessage = contentGUIMessage;
        }

        @Override
        public void response(Message m) {
            if (m.getType() == 65558) {
                System.out.println("[Controller] Elevation OK - sending secondary message");
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(this.contentGUIMessage, 3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message contentMessage = (Message)m.get(0);
                Controller.this.doAsyncRemoteCommand(this.secondaryListener, contentMessage);
            } else if (m.getType() == -421134336) {
                ElevationGlassDialog dialog = new ElevationGlassDialog((RootPaneContainer)((Object)Controller.this.gui.getParentFrame().getRootPane().getParent()), Language.get("ADMINISTRATOR"));
                String username = dialog.getUName();
                String password = dialog.getPass();
                if (!dialog.mustPromptRemote() && username == null) {
                    return;
                }
                try {
                    Message contentMessage = (Message)m.get(0);
                    m = new Message(65558);
                    m.append(contentMessage);
                    m.append(dialog.mustPromptRemote());
                    m.append(username);
                    m.append(password);
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_ELEVATION") + "...", 3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Controller.this.doAsyncRemoteCommand(this, m);
                }
                catch (Throwable throwable) {}
            } else if (m.getType() == -286392320) {
                if (m.get(0) instanceof String) {
                    String message = "" + m.get(0);
                    String stacktrace = "" + m.get(1);
                    System.out.println("[Controller] Error requesting elevation - " + message);
                    System.out.println(stacktrace);
                    Controller.this.showErrorDialogFor(Language.get("REQ_ELEVATION_ERROR"), message, stacktrace);
                } else {
                    ProcessResult result = ProcessResultMessage.fromMessage((Message)m.get(0));
                    if (!result.isCancelled()) {
                        Controller.this.showErrorDialogFor(result, Language.get("REQ_ELEVATION_ERROR"));
                    }
                }
            }
        }
    }

    private class ElevationListener
    implements CommandResponseListener {
        private ElevationListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == 65557) {
                ProcessResult result = ProcessResultMessage.fromMessage((Message)m.get(0));
                System.out.println(result);
                if (result.isOK()) {
                    try {
                        Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_ELEVATION_OK"), 3000L);
                    }
                    catch (Exception exception) {}
                } else if (result.isError()) {
                    Controller.this.showErrorDialogFor(result, Language.get("REQ_ELEVATION_ERROR"));
                }
            } else if (m.getType() == -286392320) {
                String message = "" + m.get(0);
                String stacktrace = "" + m.get(1);
                System.out.println("[Controller] Error requesting elevation - " + message);
                System.out.println(stacktrace);
                Controller.this.showErrorDialogFor(Language.get("REQ_ELEVATION_ERROR"), message, stacktrace);
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(Language.get("REQ_ELEVATION_ERROR"), 10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class CallingCardResponseResponseListener
    implements CommandResponseListener {
        private CallingCardResponseResponseListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == -286392320) {
                try {
                    Controller.this.gui.setTopLeftGreyOverlay(Language.get("INSTALL_CALLING_CARD_FAILED"), 10000L);
                    System.out.println("[Controller] " + m);
                }
                catch (Exception exception) {}
            } else {
                Controller.this.gui.setTopLeftGreyOverlay(Language.get("INSTALL_CALLING_CARD_WORKED"), 10000L);
            }
        }
    }

    class ClipFetch
    extends Thread {
        final boolean textOnly;

        public ClipFetch(boolean textOnly) {
            this.textOnly = textOnly;
        }

        @Override
        public void run() {
            if (Controller.this.clip_controller != null) {
                Controller.this.clip_controller.fetchClipboard(this.textOnly);
            } else {
                System.out.println("[Controller] Unable to fetch clipboard as the clip_controller is null.");
            }
        }
    }

    class FileSendPaste
    extends Thread {
        final List files;

        public FileSendPaste(List files) {
            this.files = files;
        }

        @Override
        public void run() {
            if (Controller.this.clip_controller != null) {
                Controller.this.clip_controller.sendFilesAndPaste(this.files);
            }
        }
    }

    class GrabRectangleChangeThread
    extends Thread {
        GrabRectangleChangeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Rectangle rect;
            Object object = Controller.this.grScreenRequest_LOCK;
            synchronized (object) {
                rect = Controller.this.gui.getGrabRectangle();
                Controller.this.requestScreen(rect.x, rect.y, rect.width, rect.height, true);
                if (VideoRecorder.getInstance() != null) {
                    VideoRecorder.getInstance().setRequestRectangle(rect);
                }
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = Controller.this.grScreenRequest_LOCK;
            synchronized (object) {
                rect = Controller.this.gui.getGrabRectangle();
                Controller.this.requestScreen(rect.x, rect.y, rect.width, rect.height, true);
                if (VideoRecorder.getInstance() != null) {
                    VideoRecorder.getInstance().setRequestRectangle(rect);
                }
            }
        }
    }

    class ContinuousScreenRequest
    extends Thread {
        final Message m = new Message(196624);

        public ContinuousScreenRequest(boolean b) {
            this.m.append(b);
        }

        @Override
        public void run() {
            long timeout = System.currentTimeMillis() + 30000L;
            while (Controller.this.screen_writer == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= timeout) continue;
            }
            try {
                Controller.this.screen_writer.write(this.m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class LLDelayThread
    extends Thread {
        LLDelayThread() {
        }

        @Override
        public void run() {
            System.out.println("[Controller] Disabling LL for a short while");
            try {
                Controller.this.socket.setLowLatencyRequired(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (Controller.this.directSocket != null) {
                    Controller.this.directSocket.setLowLatencyRequired(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("[Controller] Re-enabling LL");
            if (Controller.this.continuous_request) {
                try {
                    Controller.this.socket.setLowLatencyRequired(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (Controller.this.directSocket != null) {
                        Controller.this.directSocket.setLowLatencyRequired(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class CancelNonUdpForwarding
    extends Thread {
        private CancelNonUdpForwarding() {
        }

        @Override
        public void run() {
            this.setName("CancelNonUdpForwarding");
            try {
                if (Controller.this.transportSocket != null) {
                    if (Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor) {
                        Controller.this.wtrans.getNLForwardingAPI(Controller.this.transportAssocNode).cancelForwardingRule(Controller.this.sessionFwdID);
                    } else {
                        new ObsoleteShServerNodeTransactor(Controller.this.transportAssocNode, Controller.this.transportSocket).cancelForwardingRule(Controller.this.sessionFwdID);
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private class CancelUdpForwarding
    extends Thread {
        private CancelUdpForwarding() {
        }

        @Override
        public void run() {
            this.setName("CancelUdpForwarding");
            try {
                if (Controller.this.directSocket != null) {
                    if (Switches.SH_1582_useWebTransactorInsteadOfNodeTransactor) {
                        Controller.this.wtrans.getNLForwardingAPI(Controller.this.transportAssocNode).cancelForwardingRule(Controller.this.sessionFwdID);
                    } else {
                        new ObsoleteShServerNodeTransactor(Controller.this.transportAssocNode, Controller.this.directSocket).cancelForwardingRule(Controller.this.sessionFwdID);
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

