/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.server.SessionInfoUpdater;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.video.VideoRecorder;
import com.aem.shelp.util.WebTransactor;
import com.aem.utils.CursorInfo;
import java.io.IOException;
import java.util.HashMap;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.osstats.types.SessionInfo;
import utils.switches.Switches;

public class AsyncCommandsController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    MessageWriter mout;
    Object uid_LOCK = new Object();
    int uid = 0;
    Object LOCK = new Object();
    HashMap onetime = new HashMap();
    HashMap ongoing = new HashMap();
    boolean amWindowsWithSessions = false;
    int mySessionID = 0;
    int consoleSessionID = 0;
    private CursorInfo.CursorInfoCache cursorCache = new CursorInfo.CursorInfoCache();
    Object check_LOCK = new Object();
    ConsoleCheckThread check;

    public void log(String msg, String details) {
    }

    public AsyncCommandsController(Controller controller, ClientUserInterface gui, MessageReader min, MessageWriter mout) {
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            this.log(Language.get("CONNECTION_TERMINATED"), Language.get("CONNECTION_TERMINATED_DETAILS"));
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Async Commands Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[AsyncCommandsController] " + e);
            }
        }
        catch (Throwable e) {
            System.out.println("(Async Commands Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextUniqueConversation() {
        Object object = this.uid_LOCK;
        synchronized (object) {
            int tmp = this.uid++;
            return "AsyncUniqueConv#" + tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAsyncRemoteCommand(CommandResponseListener listener, Message m) {
        String conv = this.getNextUniqueConversation();
        Object object = this.LOCK;
        synchronized (object) {
            this.onetime.put(conv, listener);
        }
        this.sendAsyncRemoteCommand(m, conv);
    }

    public void sendAsyncRemoteCommand(Message m, String conversation) {
        Message cmd = new Message(524288);
        cmd.append(conversation);
        cmd.append(m);
        AsyncCommandSendThread sendy = new AsyncCommandSendThread();
        sendy.cmd = cmd;
        sendy.conversation = conversation;
        sendy.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOngoingListener(CommandResponseListener listener, String conversation) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ongoing.put(conversation, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterListener(String conversation) {
        Object object = this.LOCK;
        synchronized (object) {
            this.ongoing.remove(conversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message m) throws IOException {
        if (CentralDebugging.ASYNC_VERBOSE_RESPONSE) {
            System.out.println("Async asked to handle message " + m);
        }
        if (m.getType() == 524289) {
            CommandResponseListener listener;
            String conversation = (String)m.get(0);
            Message resp = (Message)m.get(1);
            if (CentralDebugging.ASYNC_VERBOSE) {
                System.out.println("Got asynchronous response on " + conversation);
            }
            Object object = this.LOCK;
            synchronized (object) {
                listener = (CommandResponseListener)this.onetime.get(conversation);
                if (listener == null) {
                    listener = (CommandResponseListener)this.ongoing.get(conversation);
                } else {
                    this.onetime.remove(conversation);
                }
            }
            if (listener != null) {
                listener.response(resp);
            }
        } else if (m.getType() == 65568) {
            long dctime = ((Number)m.get(0)).longValue();
            System.out.println("[DoubleClick] Double click time detected as " + dctime);
            this.controller.setDoubleClickTime(dctime);
        } else if (m.getType() == 65571) {
            String desc = m.getAsString(0);
            this.controller.setKeyLayoutDescription(desc);
        } else if (m.getType() == -1061158832) {
            System.out.println("[AsyncCommandController] COMMAND_STATUS_WILLLOGOUT " + m.getAsString(0));
            if (Switches.SH_silentReconnect) {
                System.out.println("[RaConsoleCheck] Received session logout, will issue console check now");
                this.doWindowsConsoleReconnectCheck();
            } else {
                this.gui.expectPowerOrLogoff();
            }
        } else if (m.getType() == -1061158831) {
            System.out.println("[AsyncCommandController] COMMAND_STATUS_WILLSLEEP " + m.getAsString(0));
            this.gui.expectSleep();
        } else if (m.getType() == -1061158830) {
            System.out.println("[AsyncCommandController] COMMAND_STATUS_DIDACTIVATE " + m.getAsString(0));
            this.gui.expectSessionActivated();
        } else if (m.getType() == -1061158829) {
            System.out.println("[AsyncCommandController] COMMAND_STATUS_WILLDEACTIVATE " + m.getAsString(0));
            if (Switches.SH_silentReconnect) {
                System.out.println("[RaConsoleCheck] Received session deactivate, will issue console check now");
                this.doWindowsConsoleReconnectCheck();
            } else {
                this.gui.expectSessionDeactivated();
            }
        } else if (m.getType() == -1061158828) {
            System.out.println("[AsyncCommandController] COMMAND_STATUS_DIDWAKE " + m.getAsString(0));
            this.gui.expectWake();
        } else if (m.getType() == -1061158827) {
            this.gui.expectCustomerTerminate();
        } else if (m.getType() == -791674879) {
            SessionInfo info = SessionInfo.fromMessage(m);
            SessionInfoUpdater.updateSessionInfo(info, ConnectedTarget.TARGET.getRemoteMachine());
            this.gui.setSessionInfo(info);
        } else if (m.getType() == -1061158799) {
            this.gui.updateCustomerIsTyping(m.getAsString(0));
        } else if (m.getType() == -1061158795) {
            this.gui.recommendTcp();
        } else if (m.getType() == -1061158855) {
            int tmp = (Integer)m.get(0);
            int pointerx = (0xFFFF & tmp >>> 16) - 1;
            int pointery = (0xFFFF & tmp) - 1;
            this.gui.setPointerLocation(pointerx, pointery);
        } else if (m.getType() == -1061158856) {
            CursorInfo cInfo = CursorInfo.fromMessage(m);
            if (cInfo.dataLength == 0L && cInfo.data == null) {
                cInfo = this.cursorCache.getFromCache(cInfo.signature);
                if (CentralDebugging.VERBOSE_CURSOR_CACHE) {
                    System.out.println("[AsyncCommandsController] Got " + cInfo + " from cursor cache.");
                }
            } else {
                this.cursorCache.addToCache(cInfo);
            }
            try {
                this.gui.setRemoteCursor(cInfo);
                if (VideoRecorder.getInstance() != null) {
                    VideoRecorder.getInstance().setCursorImage(cInfo);
                }
            }
            catch (Exception x) {
                System.out.println("Unable to set GUI cursor: " + x);
                x.printStackTrace();
            }
        } else if (m.getType() == -1061158877) {
            this.gui.stopReconnectsForRemoteClose();
        } else if (m.getType() == 196643) {
            this.amWindowsWithSessions = m.getNextBoolean();
            this.mySessionID = m.getNextInt();
            this.consoleSessionID = m.getNextInt();
            if (this.amWindowsWithSessions) {
                System.out.println("[RaConsoleCheck] Am connected to windows console session, myID " + this.mySessionID + ", consoleID " + this.consoleSessionID);
            } else {
                System.out.println("[RaConsoleCheck] Am not connected to windows console session");
            }
        } else if (m.getType() == 196629) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("SCREEN_WINDOWS_NOT_CONSOLE_SESSION " + m);
            }
            new Thread(){

                @Override
                public void run() {
                    AsyncCommandsController.this.gui.promptForRdpConsoleSwitch();
                }
            }.start();
        } else if (m.getType() == 65556) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("MMOVE_ATTEMPED_BUT_FAILED " + m);
            }
            new Thread(){

                @Override
                public void run() {
                    AsyncCommandsController.this.gui.promptMmoveFailure();
                }
            }.start();
        } else if (m.getType() == 100488) {
            System.out.println("Asynchronous commands not allowed (control permissions denied)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWindowsConsoleReconnectCheck() {
        if (this.controller.amConnectedToMachine()) {
            Object object = this.check_LOCK;
            synchronized (object) {
                if (this.check != null) {
                    return;
                }
                this.check = new ConsoleCheckThread();
                this.check.start();
            }
        } else {
            System.out.println("[RaConsoleCheck] Skipping check, support session, unable to do reconnects");
        }
    }

    class ConsoleCheckThread
    extends Thread {
        public ConsoleCheckThread() {
            this.setName("RaConsoleCheckThread");
        }

        @Override
        public void run() {
            WebTransactor wtrans = AsyncCommandsController.this.controller.getWebTransactor();
            System.out.println("[RaConsoleCheck] Requesting " + AsyncCommandsController.this.controller.getCustomerOrMachineID() + " check recent or future change from windows console session " + AsyncCommandsController.this.consoleSessionID);
            try {
                if (wtrans.checkRaConsoleIdChanged(AsyncCommandsController.this.controller.getCustomerOrMachineID(), AsyncCommandsController.this.consoleSessionID)) {
                    AsyncCommandsController.this.gui.silentReconnect("Remote RA service reported windows console changed, reconnecting");
                } else {
                    System.out.println("[RaConsoleCheck] No console change, will not issue silent reconnect");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                AsyncCommandsController.this.check = null;
            }
        }
    }

    class AsyncCommandSendThread
    extends Thread {
        Message cmd;
        String conversation;

        AsyncCommandSendThread() {
        }

        @Override
        public void run() {
            try {
                if (CentralDebugging.ASYNC_VERBOSE) {
                    System.out.println("Sending async command on " + this.conversation);
                }
                AsyncCommandsController.this.mout.write(this.cmd);
            }
            catch (IOException e) {
                System.out.println("Failed to send async command: " + e);
            }
        }
    }
}

