/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import com.aem.shelp.util.ByteModder;
import com.aem.utils.streamenc.ChunkFilter;
import com.aem.utils.streamenc.PriorityFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Util {
    public static ChunkFilter low_priority = new PriorityFilter(1L, 1, 1L, 1);
    public static ChunkFilter med_priority = new PriorityFilter(1L, 8, 1L, 8);
    public static ChunkFilter high_priority = new PriorityFilter(1L, 10, 1L, 10);

    public void writeEmpty(OutputStream out, boolean colour) throws IOException {
        if (colour) {
            out.write(0);
            out.write(0);
            out.write(0);
        } else {
            out.write(0);
        }
    }

    public void writeBlack001(OutputStream out, boolean colour) throws IOException {
        if (colour) {
            out.write(0);
            out.write(0);
            out.write(1);
        } else {
            out.write(1);
        }
    }

    public void writeModdedColour(OutputStream out, int n, boolean colour, ByteModder modder) throws IOException {
        if (colour) {
            this.writeModdedRGB(out, n, modder);
        } else {
            this.writeModdedBlackAndWhite(out, n, modder);
        }
    }

    private void writeModdedRGB(OutputStream out, int n, ByteModder modder) throws IOException {
        out.write(modder.modFast((byte)(n >>> 16)));
        out.write(modder.modFast((byte)(n >>> 8)));
        out.write(modder.modFast((byte)n));
    }

    private void writeModdedBlackAndWhite(OutputStream out, int n, ByteModder modder) throws IOException {
        int r = 0xFF & n >>> 16;
        int g = 0xFF & n >>> 8;
        int b = 0xFF & n >>> 0;
        int total = r + g + b;
        out.write(modder.modFast((byte)(0xFF & (total /= 3))));
    }

    public void writeColour(OutputStream out, int n, boolean colour) throws IOException {
        if (colour) {
            this.writeRGB(out, n);
        } else {
            this.writeBlackAndWhite(out, n);
        }
    }

    private void writeRGB(OutputStream out, int n) throws IOException {
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    private void writeBlackAndWhite(OutputStream out, int n) throws IOException {
        int r = 0xFF & n >>> 16;
        int g = 0xFF & n >>> 8;
        int b = 0xFF & n >>> 0;
        int total = r + g + b;
        out.write(0xFFFFFFFF & (total /= 3));
    }

    public int readColour(InputStream in, boolean colour) throws IOException {
        if (colour) {
            return this.readRGB(in);
        }
        return this.readBlackAndWhite(in);
    }

    private int readRGB(InputStream in) throws IOException {
        int n = -1;
        int r = 0;
        for (int i = 0; i < 3; ++i) {
            r = in.read();
            if (r == -1) {
                throw new IOException("End of stream");
            }
            n = n << 8 | r;
        }
        return n;
    }

    private int readBlackAndWhite(InputStream in) throws IOException {
        int n = -1;
        int r = in.read();
        for (int i = 0; i < 3; ++i) {
            if (r == -1) {
                throw new IOException("End of stream");
            }
            n = n << 8 | r;
        }
        return n;
    }
}

