/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo.util;

import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.types.Machine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MachinesTree {
    static final TreeComparator TREE_COMPARATOR = new TreeComparator();
    private TreeNode rootNode = new TreeNode(null, null, null);

    public TreeNode getRoot() {
        return this.rootNode;
    }

    public MachinesTree(Machine[] machineDetails, TechUser user, MergedTechGroup loggedInGroup) {
        for (int i = 0; i < machineDetails.length; ++i) {
            if (!user.canLoggedInTechUserSeeMachine(machineDetails[i], loggedInGroup)) continue;
            String name = machineDetails[i].getMachineName().getName();
            String[] group = machineDetails[i].getMachineName().getGroup();
            TreeNode parent = this.rootNode;
            if (group != null) {
                for (int depthIndex = 0; depthIndex < group.length; ++depthIndex) {
                    TreeNode child = parent.getChildByName(group[depthIndex]);
                    if (child == null) {
                        child = new TreeNode(parent, null, group[depthIndex]);
                        parent.children.add(child);
                    }
                    parent = child;
                }
            }
            TreeNode leafNode = new TreeNode(parent, machineDetails[i], name);
            parent.children.add(leafNode);
        }
        this.sortTree(this.rootNode);
    }

    private void sortTree(TreeNode root) {
        Collections.sort(root.children, TREE_COMPARATOR);
        for (int i = 0; i < root.children.size(); ++i) {
            this.sortTree((TreeNode)root.children.get(i));
        }
    }

    static class TreeComparator
    implements Comparator {
        TreeComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }

    public class TreeNode {
        public ArrayList children = new ArrayList();
        TreeNode parent = null;
        public Machine info;
        public String shortName;

        public TreeNode(TreeNode parent, Machine machineDetails, String shortName) {
            this.parent = parent;
            this.info = machineDetails;
            this.shortName = shortName;
        }

        public TreeNode getChildByName(String name) {
            for (int i = 0; i < this.children.size(); ++i) {
                TreeNode child = (TreeNode)this.children.get(i);
                if (!child.shortName.equals(name)) continue;
                return child;
            }
            return null;
        }

        public String toString() {
            return this.shortName;
        }
    }
}

