/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo.ui;

import com.aem.sdemo.ui.DemoConfigPanel;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import utils.swing.JFixedWidthTextField;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class DemoURLPanel
implements ActionListener {
    private JPanel urlPanel;
    private JTextField urlLabel;
    private JButton copyToClipboard;
    private boolean ssl;
    private String demoName;
    private TechClient client;

    public DemoURLPanel(boolean ssl) {
        this.initUI();
        this.ssl = ssl;
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
        this.updateDemoURL(this.demoName);
    }

    public void updateDemoURL(String demoName) {
        this.demoName = demoName;
        String name = DemoConfigPanel.fixDemoName(demoName);
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String newHostname = this.ssl ? "https://" + this.client.getVirtualServerHostname() : "http://" + this.client.getVirtualServerHostname();
        if (name.length() > 0) {
            this.setURL(newHostname + "/demo?name=" + name);
            this.setEnabled(true);
        } else {
            this.setURL("");
            this.setEnabled(false);
        }
    }

    private void initUI() {
        JLabel desc = new JLabel(Language.get("DEMO_URL_LABEL") + ": ");
        this.urlLabel = new JFixedWidthTextField();
        this.urlLabel.setEditable(false);
        this.copyToClipboard = new JButton(Language.get("COPY"));
        this.copyToClipboard.addActionListener(this);
        this.urlPanel = new RoundBorderPanel();
        this.urlPanel.setLayout(new GridLayout(1, 1));
        GbPanel contentPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        contentPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        contentPanel.add(desc, 0, 0, 1, 1, 1, 1, 13, 0);
        contentPanel.add(this.urlLabel, 1, 0, 1, 1, 100, 1, 17, 2);
        contentPanel.add(this.copyToClipboard, 2, 0, 1, 1, 1, 1, 10, 0);
        this.urlPanel.add(contentPanel);
    }

    public JPanel getRootComponent() {
        return this.urlPanel;
    }

    public void setURL(String url) {
        this.urlLabel.setText(url);
        this.urlLabel.setToolTipText(url);
    }

    public void setEnabled(boolean enabled) {
        this.urlPanel.setEnabled(enabled);
        this.urlLabel.setEnabled(enabled);
        this.copyToClipboard.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.copyToClipboard)) {
            String url = this.urlLabel.getText();
            ClipboardUtil.setClipboardAsText(url);
        }
    }
}

