/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo.ui;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdemo.ui.DemoRunningPanel;
import com.aem.sdemo.ui.DemoURLPanel;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.DemoInfo;
import com.aem.shelp.proxy.techclient.TechClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;
import utils.swing.simplelist.wrapper.SortWrapper;

public class DemoConfigPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener,
NodeLinkStatusListener,
ListListener {
    RootPaneContainer rpc;
    TechClient client;
    JLabel demoNameL;
    JTextField demoName;
    JTextArea demoDesc;
    JLabel demoPassL;
    JTextField demoPass;
    JCheckBox forceSecure;
    JCheckBox privateListed;
    JCheckBox requestDetails;
    JButton startPresentation;
    JButton registerPresentation;
    JButton deletePresentation;
    GbPanel config;
    DemoRunningPanel dp;
    boolean expectToEnd = false;
    private SimpleList demoInfoList;
    private SortWrapper sortedDemoInfoList;
    private JTable registeredTable;
    private DemoURLPanel demoUrlPanel;

    public DemoConfigPanel(RootPaneContainer rpc) {
        this.rpc = rpc;
        this.setLayout(new BorderLayout());
        this.init();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
        this.demoUrlPanel.setTechClient(client);
        this.demoUrlPanel.updateDemoURL(this.demoName.getText());
        this.initToNoPresentation();
    }

    private void init() {
        this.config = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        GbPanel demoInformation = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        this.demoUrlPanel = new DemoURLPanel(false);
        this.demoNameL = new JLabel(Language.get("PRESENTATION_NAME"));
        this.demoPassL = new JLabel(Language.get("PRESENTATION_PASSWORD_LABEL"));
        this.demoName = new JTextField(25);
        this.demoDesc = new JTextArea(10, 25);
        this.demoDesc.setBackground(this.demoName.getBackground());
        this.demoPass = new JTextField(25);
        this.forceSecure = new JCheckBox(Language.get("FORCE_PRESENTATION_SECURE"), false);
        this.privateListed = new JCheckBox(Language.get("PRIVATE_PRESENTATION"), false);
        this.requestDetails = new JCheckBox(Language.get("FORCE_ATTENDEES_DETAILS"), false);
        SwingUtil.setWidth(this.demoName, 300);
        SwingUtil.setWidth(this.demoPass, 300);
        int Y = 0;
        demoInformation.add(this.demoNameL, 0, Y, 1, 1, 30, 10, 13, 0);
        demoInformation.add(this.demoName, 1, Y++, 1, 1, 30, 10, 17, 0);
        demoInformation.add(this.demoPassL, 0, Y, 1, 1, 30, 10, 13, 0);
        demoInformation.add(this.demoPass, 1, Y++, 1, 1, 30, 10, 17, 0);
        GbPanel attendeeNotes = new GbPanel();
        attendeeNotes.setBorder(SHBorderFactory.createEmptyBorder(5, 100, 0, 100));
        JScrollPane demoPane = new JScrollPane(this.demoDesc);
        demoPane.setVerticalScrollBarPolicy(22);
        JLabel label = new JLabel(Language.get("PRESENTATION_DESC"));
        int YY = 0;
        attendeeNotes.add(label, 0, YY++, 2, 1, 100, 1, 17, 2);
        attendeeNotes.add(demoPane, 0, YY++, 2, 1, 100, 100, 10, 1);
        attendeeNotes.add(this.requestDetails, 0, YY, 1, 1, 30, 10, 17, 0);
        attendeeNotes.add(this.privateListed, 1, YY++, 1, 1, 30, 10, 17, 0);
        attendeeNotes.add(this.forceSecure, 0, YY++, 1, 1, 30, 10, 17, 0);
        attendeeNotes.add(this.demoUrlPanel.getRootComponent(), 0, YY++, 2, 1, 30, 10, 10, 2);
        demoInformation.add(attendeeNotes, 0, Y++, 2, 1, 10, 1000, 10, 1);
        this.registerPresentation = new JButton(Language.get("REGISTER_PRESENTATION"), ImageLoader.getImageIcon("images/svg/general/clock-simple.svg,24"));
        this.registerPresentation.setEnabled(false);
        this.startPresentation = new JButton(Language.get("START_PRESENTATION"), ImageLoader.getImageIcon("images/svg/general/bullhorn.svg,24"));
        this.startPresentation.setEnabled(false);
        this.startPresentation.setHorizontalAlignment(2);
        this.registerPresentation.setHorizontalAlignment(2);
        JPanel demoControl = new JPanel();
        demoControl.setLayout(new GridLayout(1, 2, 10, 0));
        demoControl.add(this.registerPresentation);
        demoControl.add(this.startPresentation);
        demoInformation.add(demoControl, 0, Y++, 2, 1, 0, 0, 10, 0);
        this.config.add(demoInformation, 0, 0, 1, 1, 1000, 100, 10, 1);
        GbPanel listPanel = new GbPanel();
        this.deletePresentation = new JButton(ImageLoader.getImageIcon("images/svg/general/remove.svg,16"));
        this.deletePresentation.setEnabled(false);
        TableStructure ts = TableStructure.createTableStructure(DemoInfo.class, new String[]{"name", "attendeeCount", "secure", "started"}, new String[]{Language.get("DEMO_TABLE_NAME"), Language.get("DEMO_TABLE_ATTENDEES"), Language.get("DEMO_TABLE_SECURE"), Language.get("DEMO_TABLE_STARTED")});
        ts.setWidths(new int[]{200, 10, 10, 10});
        this.demoInfoList = new SimpleList();
        this.demoInfoList.addListListener(this);
        this.sortedDemoInfoList = new SortWrapper(this.demoInfoList, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
        SimpleTableModel slm = new SimpleTableModel(this.sortedDemoInfoList, ts);
        this.registeredTable = new SHJTable(0, ts.getColumnCount());
        if (this.registeredTable.getRowHeight() < SimpleHelpLookAndFeel.scale(18)) {
            this.registeredTable.setRowHeight(SimpleHelpLookAndFeel.scale(22));
        }
        this.registeredTable.setModel(slm);
        this.registeredTable.setSelectionMode(0);
        ts.initTableDimensions(this.registeredTable);
        JScrollPane regpane = new JScrollPane(this.registeredTable);
        regpane.getViewport().setBackground(Color.white);
        ts.initTableDimensions(this.registeredTable);
        listPanel.add(regpane, 0, 0, 1, 1, 1000, 1000, 10, 1);
        listPanel.add(this.deletePresentation, 1, 0, 1, 1, 1, 1, 11, 0);
        this.config.add(listPanel, 0, 1, 1, 1, 1000, 100, 10, 1);
        this.registerPresentation.addActionListener(this);
        this.startPresentation.addActionListener(this);
        this.privateListed.addActionListener(this);
        this.deletePresentation.addActionListener(this);
        this.demoName.addKeyListener(this);
        this.registeredTable.getSelectionModel().addListSelectionListener(this);
        this.forceSecure.addActionListener(this);
    }

    private void initToNoPresentation() {
        this.removeAll();
        this.add("Center", this.config);
        this.checkEnabled(true);
        this.updateList();
        this.revalidate();
        this.repaint();
    }

    public void demoListChanged() {
        this.updateList();
    }

    public void startPresentation() {
        try {
            if (this.client.presentationHasStarted(this.demoName.getText())) {
                SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("LIVE_PRESENTATION_EXISTS"), Language.get("LIVE_PRESENTATION_EXISTS_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            } else {
                this.expectToEnd = false;
                this.removeAll();
                this.dp = new DemoRunningPanel(this, this.rpc, this.client, this.demoName.getText().trim(), this.demoDesc.getText().trim(), this.demoPass.getText(), this.forceSecure.isSelected(), this.requestDetails.isSelected(), this.privateListed.isSelected(), this);
                this.add("Center", this.dp);
                this.invalidate();
                this.revalidate();
                this.repaint();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow;
        Object o = e.getSource();
        if (o == this.startPresentation) {
            this.demoName.setText(DemoConfigPanel.fixDemoName(this.demoName.getText()));
            boolean createdOk = false;
            try {
                createdOk = this.client.registerPresentation(this.demoName.getText(), this.demoDesc.getText(), this.demoPass.getText(), this.forceSecure.isSelected(), this.requestDetails.isSelected(), this.privateListed.isSelected());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!createdOk) {
                SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("LIVE_PRESENTATION_EXISTS"), Language.get("LIVE_PRESENTATION_EXISTS_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            } else {
                this.startPresentation();
            }
            this.checkEnabled(true);
        } else if (o == this.forceSecure) {
            this.demoUrlPanel.setSSL(this.forceSecure.isSelected());
        } else if (o == this.registerPresentation) {
            this.demoName.setText(DemoConfigPanel.fixDemoName(this.demoName.getText()));
            try {
                boolean createdOk = this.client.registerPresentation(this.demoName.getText(), this.demoDesc.getText(), this.demoPass.getText(), this.forceSecure.isSelected(), this.requestDetails.isSelected(), this.privateListed.isSelected());
                if (!createdOk) {
                    SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("LIVE_PRESENTATION_EXISTS"), Language.get("LIVE_PRESENTATION_EXISTS_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                }
                this.checkEnabled(true);
            }
            catch (Exception createdOk) {
                // empty catch block
            }
            this.updateList();
        } else if (o == this.privateListed) {
            this.checkEnabled(true);
        } else if (o == this.deletePresentation && (selectedRow = this.registeredTable.getSelectedRow()) >= 0) {
            DemoInfo info = (DemoInfo)this.sortedDemoInfoList.get(selectedRow);
            if (info != null) {
                try {
                    if (!info.started) {
                        this.client.deletePresentation(info.name);
                        this.registeredTable.getSelectionModel().clearSelection();
                    } else if (SHGlassOptionPane.showConfirmDialog(this.rpc, Language.get("TERMINATE_PRESENTATION"), Language.get("TERMINATE_PRESENTATION_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,48"), Language.get("FINISH"))) {
                        this.client.deletePresentation(info.name);
                        this.registeredTable.getSelectionModel().clearSelection();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            this.updateList();
            this.checkEnabled(true);
        }
    }

    public void endPresentation(String demoName) {
        this.expectToEnd = true;
        if (this.dp != null) {
            this.dp.stopPresentation();
        }
        this.initToNoPresentation();
        this.checkEnabled(true);
        try {
            this.client.deletePresentation(demoName);
            this.registeredTable.getSelectionModel().clearSelection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.checkEnabled(true);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public static String fixDemoName(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c != ' ' && c != '-' && c != '_' && c != '/' && c != '\\' && c != ',' && c != '.' && c != ':' && c != ';' && c != '!' && c != '@' && c != '$' && c != '=' && c != '*' && c != '[' && c != ']' && c != '(' && c != ')') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private DemoInfo getDemoByName(String name) {
        for (int i = 0; i < this.demoInfoList.size(); ++i) {
            DemoInfo info = (DemoInfo)this.demoInfoList.get(i);
            if (info == null || info.name == null || !info.name.trim().equals(name)) continue;
            return info;
        }
        return null;
    }

    public void checkEnabled(boolean setSelection) {
        this.demoUrlPanel.updateDemoURL(this.demoName.getText());
        this.deletePresentation.setEnabled(false);
        String name = this.demoName.getText().trim();
        DemoInfo existingDemo = this.getDemoByName(name);
        if (existingDemo == null) {
            this.startPresentation.setEnabled(name.length() > 0);
            this.registerPresentation.setEnabled(name.length() > 0 && !this.privateListed.isSelected());
            if (setSelection) {
                this.registeredTable.clearSelection();
            }
        } else {
            int index = this.demoInfoList.indexOf(existingDemo);
            if (setSelection) {
                this.registeredTable.getSelectionModel().setSelectionInterval(index, index);
            }
            if (existingDemo.started) {
                this.startPresentation.setEnabled(false);
                this.registerPresentation.setEnabled(false);
                this.deletePresentation.setEnabled(true);
            } else {
                this.startPresentation.setEnabled(true);
                this.registerPresentation.setEnabled(false);
                this.deletePresentation.setEnabled(true);
            }
        }
    }

    public void updateList() {
        try {
            if (this.client == null) {
                return;
            }
            DemoInfo[] infos = this.client.getPresentationList();
            this.demoInfoList.makeEqualTo(infos);
            this.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSettingsFrom(DemoInfo info) {
        this.demoName.setText(info.name);
        this.demoDesc.setText(info.desc);
        this.demoPass.setText(info.pass);
        this.forceSecure.setSelected(info.secure);
        this.requestDetails.setSelected(info.details);
        this.demoUrlPanel.setSSL(info.secure);
        this.checkEnabled(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DemoInfo info;
        int selectedRow = this.registeredTable.getSelectedRow();
        if (selectedRow >= 0 && (info = (DemoInfo)this.sortedDemoInfoList.get(selectedRow)) != null) {
            this.loadSettingsFrom(info);
        }
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        if (!this.expectToEnd) {
            SHGlassOptionPane.showErrorDialog(this.rpc, Language.get("PRESENTATION_KILLED"), Language.get("PRESENTATION_KILLED_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
            this.initToNoPresentation();
        }
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    public void listAltered(ListEvent event) {
        this.checkEnabled(false);
    }
}

