/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo;

import com.aem.shelp.proxy.HttpResponse;
import com.aem.shelp.proxy.ServerBranding;
import com.aem.shelp.proxy.ServerLanguageCollection;
import java.util.HashMap;
import utils.switches.Switches;

public class SDemoHtml {
    public static String NOT_FOUND_MARKER = " not found";
    private static String STANDARD_IOS = null;
    private static String STANDARD_CSS = null;

    public static void appendHttpsRedirectJavascript(StringBuffer sb, int[] portList) {
        boolean mustNotAllowImplicitPort = true;
        for (int i = 0; i < portList.length; ++i) {
            if (portList[i] != 443) continue;
            mustNotAllowImplicitPort = false;
        }
        sb.append("<script>");
        sb.append("var hpsRedirLoc = document.location.href;");
        if (mustNotAllowImplicitPort) {
            sb.append("if (hpsRedirLoc.indexOf(':',8) == -1) {");
            sb.append("  var hpsIndex = hpsRedirLoc.indexOf('/',8);");
            sb.append("  var hpsFirst = hpsRedirLoc.substring(0,hpsIndex);");
            sb.append("  var hpsRest = hpsRedirLoc.substring(hpsIndex);");
            sb.append("  hpsRedirLoc = hpsFirst + ':80' + hpsRest;");
            sb.append("}");
        }
        sb.append("document.write('<meta http-equiv=\"refresh\" content=\"2;url=https' + hpsRedirLoc.substring(4) + '\"/>');</script>");
    }

    public static String getStandardCSSPageHeaders() {
        if (STANDARD_CSS == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LINK href=\"/lightweightfiles/css/simplehelp_web.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
            sb.append("<script src=\"/lightweightfiles/js/filtertable.js\" type=\"text/javascript\"></script>\n");
            STANDARD_CSS = sb.toString();
        }
        return STANDARD_CSS;
    }

    public static String getStandardIosMobilePageHeaders() {
        if (STANDARD_IOS == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(SDemoHtml.getStandardCSSPageHeaders());
            sb.append("<meta name='viewport' content='user-scalable=yes, initial-scale=1.0, width=device-width'/>\n");
            if (!Switches.SH_disableIOSWebApp) {
                sb.append("<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n");
                sb.append("<meta names=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\" />\n");
            }
            sb.append("<link rel=\"apple-touch-icon\" sizes=\"57x57\" href=\"/iosicon57.png\">");
            sb.append("<link rel=\"apple-touch-icon\" sizes=\"72x72\" href=\"/iosicon72.png\">");
            sb.append("<link rel=\"apple-touch-icon\" sizes=\"114x114\" href=\"/iosicon114.png\">");
            sb.append("<link rel=\"apple-touch-icon\" sizes=\"144x144\" href=\"/iosicon144.png\">");
            sb.append("<script>");
            sb.append("if ((' '+navigator.userAgent).toLowerCase().indexOf('ipad') != -1) {");
            sb.append(" document.write('<link rel=\"apple-touch-startup-image\" href=\"/lightweightfiles/ipadsplash.png\"/>');");
            sb.append("} else {");
            sb.append(" document.write('<link rel=\"apple-touch-startup-image\" href=\"/lightweightfiles/iphonesplash.png\"/>');");
            sb.append("}");
            sb.append("</script>\n");
            STANDARD_IOS = sb.toString();
        }
        return STANDARD_IOS;
    }

    public static void imageHeader(StringBuffer sb, String htag, String imgsrc, String text, boolean newline) {
        sb.append("<").append(htag);
        if (!newline) {
            sb.append(" style='display:inline'>");
        } else {
            sb.append(">");
        }
        sb.append("<img style='display:inline; vertical-align:middle' border='0' src='").append(imgsrc).append("'> &nbsp;").append(text).append("</").append(htag).append(">");
    }

    public static HttpResponse generateRedirectPage(String image, String title, String message, String metaUrl, HashMap paramsMap) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta name='viewport' content='user-scalable=yes, initial-scale=1.0, width=device-width'/>");
        sb.append(SDemoHtml.getStandardCSSPageHeaders());
        sb.append("<script>document.write('<meta http-equiv=\"refresh\" content=\"5;url=").append(metaUrl).append("\"/>');</script>");
        sb.append("</head>");
        sb.append("<body style='font-family: sans-serif'>");
        SDemoHtml.imageHeader(sb, "h3", "/lightweightfiles/" + image, title, true);
        sb.append(message);
        sb.append("</body>");
        sb.append("</html>");
        return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
    }

    public static String getApplicationNameTitleTag(String simpleHelpTranslation, boolean isCustomerFacing) {
        String appName = ServerBranding.get().getApplicationNameWithVersion(isCustomerFacing);
        return "<title>" + appName + "</title>";
    }

    public static String getLanguageEncodingMetaTag(String language) {
        return "<meta http-equiv=\"Content-type\" content=\"text/html;charset=UTF-8\">\n";
    }

    public static String getLanguageEncodingMetaTag(HashMap paramsMap) {
        return SDemoHtml.getLanguageEncodingMetaTag(ServerLanguageCollection.getLanguageCode(paramsMap));
    }

    public static void addSHTitleBranding(StringBuffer sb, boolean isCustomerFacing) {
        sb.append("<div class=\"sh_logodiv\">");
        sb.append("<img src=\"/branding/applet_splash.png\" class=\"sh_logo\" />");
        sb.append("<br>");
        sb.append(ServerBranding.get().getApplicationNameWithVersion(isCustomerFacing));
        sb.append("</div>");
    }
}

