/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdemo.LightweightClientUserInterface;
import com.aem.sdemo.ProxiedClientController;
import com.aem.sdemo.SDemoHtml;
import com.aem.sdemo.util.MachinesTree;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.proxy.HttpResponse;
import com.aem.shelp.proxy.LoginType;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ServerBranding;
import com.aem.shelp.proxy.ServerLanguageCollection;
import com.aem.shelp.proxy.SessionLimitExceededException;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.TwoTierAuthentication;
import com.aem.shelp.proxy.authentication.TOTPAuthenticator;
import com.aem.shelp.proxy.authentication.TOTPConfig;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.config.LazyPassword;
import com.aem.shelp.proxy.config.MergedTechGroup;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.Debugger;
import com.sun.deploy.net.URLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import utils.message.Message;
import utils.radius.ChallengeHandler;

public class MobileQueryHandler {
    private static final long MOBILE_TIMEOUT = 600000L;
    private final CredentialsCache credentialsCache = new CredentialsCache();
    private final Object mobileTechs_LOCK = new Object();
    private HashMap<String, MobileTech> mobileTechs = new HashMap();
    private long LAST_MOBILE_CLEAROUT = System.currentTimeMillis();
    private ClearoutThread clearout = new ClearoutThread();

    public MobileQueryHandler() {
        this.clearout.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMobileClearout() {
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[MobileQueryHandler] clearing out expired MobileTechs");
        }
        if (System.currentTimeMillis() - this.LAST_MOBILE_CLEAROUT > 240000L) {
            Object object = this.mobileTechs_LOCK;
            synchronized (object) {
                String[] keys = this.mobileTechs.keySet().toArray(new String[0]);
                if (CentralDebugging.MOBILE_REQUEST_HANDLING) {
                    System.out.println("[Mobile] " + keys.length + " mobile tech sessions");
                }
                for (int i = 0; i < keys.length; ++i) {
                    MobileTech tech = this.mobileTechs.get(keys[i]);
                    if (CentralDebugging.MOBILE_REQUEST_HANDLING) {
                        System.out.println("[Mobile] Mobile tech session " + i + " = " + tech);
                    }
                    if (System.currentTimeMillis() - tech.lastAccess > 600000L) {
                        this.mobileTechs.remove(keys[i]);
                        ProxyServer.INSTANCE.deregisterSessionID(tech.user, tech.credentials.getSessionToken());
                        if (CentralDebugging.MOBILE_REQUEST_HANDLING || CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            System.out.println("[Mobile] Removing aged MobileTech session" + tech);
                        }
                        try {
                            tech.closeAllSessions();
                        }
                        catch (Exception x) {
                            if (!CentralDebugging.MOBILE_REQUEST_HANDLING && !CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) continue;
                            System.out.println("[Mobile] Unable to remove MobileTech session " + x);
                        }
                        continue;
                    }
                    if (!CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) continue;
                    Debugger.info("[MobileQueryHandler] Keeping MobileTech session " + tech);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handleMobileQuery(String sourceIP, String fullResource, String cookie, HashMap paramsMap, boolean isSsl) throws Exception {
        StringBuffer sb;
        byte[] newToken;
        String submittedCode;
        HttpResponse resp;
        String RADIUSSESSION;
        String SHSESSION;
        block79: {
            if (!isSsl) {
                StringBuffer sb2 = this.getRedirectToHTTPSResponse(paramsMap);
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] non-SSL request, responding with redirect");
                }
                return new HttpResponse(sb2.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            SHSESSION = null;
            RADIUSSESSION = null;
            try {
                if (cookie != null) {
                    int index2;
                    int index1 = cookie.indexOf("shelp_mobile_access");
                    if (index1 != -1) {
                        index2 = cookie.indexOf(59, index1 = cookie.indexOf(61, index1 + "shelp_mobile_access".length()) + 1);
                        if (index2 == -1) {
                            index2 = cookie.length();
                        }
                        if (index1 != -1) {
                            SHSESSION = cookie.substring(index1, index2);
                        }
                    }
                    if ((index1 = cookie.indexOf("shelp_radius")) != -1) {
                        index2 = cookie.indexOf(59, index1 = cookie.indexOf(61, index1 + "shelp_radius".length()) + 1);
                        if (index2 == -1) {
                            index2 = cookie.length();
                        }
                        if (index1 != -1) {
                            RADIUSSESSION = cookie.substring(index1, index2);
                        }
                    }
                }
            }
            catch (Exception x) {
                if (!CentralDebugging.MOBILE_REQUEST_HANDLING && !CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) break block79;
                System.out.println("[Mobile] Problem handling cookies " + cookie);
                x.printStackTrace();
            }
        }
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[MobileQueryHandler] Mobile session " + SHSESSION);
        }
        if (fullResource.contains("logout=1")) {
            StringBuffer sb3 = this.getLogoutResponse(paramsMap, "/mobile");
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] logout requested, responding with logout HTML");
            }
            if (SHSESSION != null) {
                Object index2 = this.mobileTechs_LOCK;
                synchronized (index2) {
                    this.mobileTechs.remove(SHSESSION);
                }
            }
            HttpResponse httpResponse = new HttpResponse(sb3.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            httpResponse.cookie = "shelp_mobile_access=-1";
            return httpResponse;
        }
        MobileTech mtech = null;
        if (SHSESSION != null) {
            Object httpResponse = this.mobileTechs_LOCK;
            synchronized (httpResponse) {
                mtech = this.mobileTechs.get(SHSESSION);
            }
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] fetched MobileTech for session " + mtech);
            }
            long tnow = System.currentTimeMillis();
            if (mtech == null) {
                if (CentralDebugging.MOBILE_REQUEST_HANDLING || CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    System.out.println("[Mobile] Session " + SHSESSION + " not found, wiping and asking for authorization");
                }
                SHSESSION = null;
            } else if (tnow - mtech.lastAccess > 600000L) {
                if (CentralDebugging.MOBILE_REQUEST_HANDLING || CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    System.out.println("[Mobile] Session " + SHSESSION + " too old (" + (tnow - mtech.lastAccess) + " / " + new Date(mtech.lastAccess) + ", wiping and asking for authorization");
                }
                Object object = this.mobileTechs_LOCK;
                synchronized (object) {
                    this.mobileTechs.remove(SHSESSION);
                }
                SHSESSION = null;
            } else {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] refreshing mtech timer");
                }
                mtech.lastAccess = System.currentTimeMillis();
            }
        }
        if (paramsMap.get("ping") != null) {
            return new HttpResponse("OK", "text/html");
        }
        String badPasswordButUsername = null;
        String setCookie = null;
        if (SHSESSION == null) {
            CachedCredentials radiusCredentials;
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] no valid session");
            }
            TechCredentials credentials = new TechCredentials((String)paramsMap.get("techuser"), (String)paramsMap.get("techpass"), TechClient.NULL_SESSION_ID);
            String challengeCode = (String)paramsMap.get("techchallenge");
            if (challengeCode != null && (radiusCredentials = this.credentialsCache.getCachedCredentialsFor(RADIUSSESSION)) != null) {
                if (radiusCredentials.credentials.hasUsername()) {
                    credentials.setUsername(radiusCredentials.credentials.getUsername());
                }
                if (radiusCredentials.credentials.hasPassword()) {
                    credentials.setPassword(radiusCredentials.credentials.getPassword());
                }
            }
            if (credentials.hasUsername()) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] login attempt");
                }
                if (credentials.hasPassword()) {
                    System.out.println("[MobileQueryHandler] Mobile login attempt from " + credentials);
                    RadiusChallengeHandler handler = new RadiusChallengeHandler(challengeCode);
                    TechUser loggedInUser = null;
                    LoginType type = new LoginType();
                    loggedInUser = ProxyServer.INSTANCE.getAuthenticationHelper().doTechnicianLogin(sourceIP, credentials, type, handler);
                    if (loggedInUser != null) {
                        MergedTechGroup loggedInGroup = loggedInUser.getMergedTechGroupInstance();
                        boolean requiresAppAuthentication = loggedInGroup.requiresAppAuthentication();
                        boolean requiresEmailAuthentication = loggedInGroup.requiresEmailAuthentication();
                        System.out.println("[MobileQueryHandler] Mobile login from " + credentials + " accepted");
                        SHSESSION = Long.toString(SecurityUtil.nextSecureID());
                        if (CentralDebugging.MOBILE_REQUEST_HANDLING || CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            System.out.println("[Mobile] Creating new session " + SHSESSION + " for tech " + credentials.getUsername());
                        }
                        mtech = new MobileTech();
                        mtech.lastAccess = System.currentTimeMillis();
                        mtech.user = loggedInUser;
                        mtech.group = loggedInGroup;
                        mtech.ttRequired = requiresEmailAuthentication;
                        mtech.appRequired = requiresAppAuthentication;
                        if (mtech.appRequired) {
                            TOTPConfig config = ServerConfig.get().getTOTPConfig();
                            mtech.authenticator = new TOTPAuthenticator(config);
                        }
                        if (mtech.ttRequired) {
                            mtech.groupToUseForAuthentication = loggedInGroup.getGroupForEmailAuthentication();
                        }
                        mtech.permissions = loggedInGroup.getPermissions();
                        mtech.credentials = credentials;
                        Object object = this.mobileTechs_LOCK;
                        synchronized (object) {
                            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                Debugger.info("[MobileQueryHandler] storing MobileTech " + mtech + " for session " + SHSESSION);
                            }
                            this.mobileTechs.put(SHSESSION, mtech);
                        }
                        setCookie = "shelp_mobile_access=" + SHSESSION;
                    } else {
                        SHSESSION = null;
                        if (handler.challengeRequired) {
                            RADIUSSESSION = Long.toString(SecurityUtil.nextSecureID());
                            CachedCredentials radiusCredentials2 = new CachedCredentials();
                            radiusCredentials2.credentials = credentials;
                            this.credentialsCache.putCachedCredentials(RADIUSSESSION, radiusCredentials2);
                            StringBuffer sb4 = new StringBuffer();
                            sb4.append("<html>");
                            sb4.append("<head>");
                            sb4.append(SDemoHtml.getStandardIosMobilePageHeaders());
                            sb4.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                            sb4.append("</head>");
                            sb4.append("<body>");
                            SDemoHtml.addSHTitleBranding(sb4, false);
                            sb4.append("<form id='sh_loginform' method='post' action='/mobile'>\n");
                            sb4.append("<div align=\"center\">");
                            sb4.append("<table class='sh_fixedWidthTable'\">");
                            sb4.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
                            SDemoHtml.imageHeader(sb4, "h3", "lightweightfiles/padlock.png", ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_TITLE"), true);
                            sb4.append(handler.message);
                            sb4.append("<br>");
                            sb4.append("<br>");
                            sb4.append("<table class='sh_login_table'>");
                            sb4.append("<tr>");
                            sb4.append("<td  class='sh_labelcell'>");
                            sb4.append(ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_SHORT")).append(":");
                            sb4.append("</td>");
                            sb4.append("<td class='sh_fieldcell'>");
                            sb4.append("<input class='sh_login' type='password' size='20' name='techchallenge'/>");
                            sb4.append("</td>");
                            sb4.append("</tr>");
                            sb4.append("</table>");
                            sb4.append("</td></tr></table>");
                            sb4.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
                            sb4.append("<br>");
                            sb4.append("<br>");
                            sb4.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.forms['sh_loginform'].submit();\" >\n");
                            sb4.append(ServerLanguageCollection.getString(paramsMap, "LOG_INTO")).append(" ").append(ServerBranding.get().getApplicationName(false));
                            sb4.append("</span>");
                            sb4.append("<br>");
                            sb4.append("<br>");
                            sb4.append("</td></tr>");
                            sb4.append("</table>");
                            sb4.append("</div>");
                            sb4.append("</form>");
                            sb4.append("</body>");
                            sb4.append("</html>");
                            HttpResponse resp2 = new HttpResponse(sb4.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                            resp2.cookie = "shelp_radius=" + RADIUSSESSION;
                            return resp2;
                        }
                        badPasswordButUsername = credentials.getUsername();
                        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            Debugger.info("[MobileQueryHandler] login failed");
                        }
                    }
                } else {
                    SHSESSION = null;
                    badPasswordButUsername = null;
                }
            }
        }
        if (SHSESSION == null) {
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] mobile user is not logged in, will respond with login page");
            }
            StringBuffer sb5 = new StringBuffer();
            sb5.append("<html>");
            sb5.append("<head>");
            sb5.append(SDemoHtml.getStandardIosMobilePageHeaders());
            sb5.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb5.append("</head>");
            sb5.append("<body>");
            SDemoHtml.addSHTitleBranding(sb5, false);
            String passthroughMachine = (String)paramsMap.get("mach");
            String passthroughFtp = (String)paramsMap.get("ftp");
            if (passthroughMachine != null) {
                sb5.append("<form id='sh_loginform' method='post' action='/mobile?mach=").append(URLEncoder.encode((String)passthroughMachine, (String)"UTF-8")).append("'>\n");
            } else if (passthroughFtp != null) {
                sb5.append("<form id='sh_loginform' method='post' action='/mobile?mach=").append(URLEncoder.encode((String)passthroughMachine, (String)"UTF-8")).append("&ftp=").append(URLEncoder.encode((String)passthroughFtp, (String)"UTF-8")).append("'>\n");
            } else {
                sb5.append("<form id='sh_loginform' method='post' action='/mobile'>\n");
            }
            sb5.append("<div align=\"center\">");
            sb5.append("<table class='sh_fixedWidthTable'\">");
            sb5.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
            sb5.append("<br>");
            if (badPasswordButUsername != null) {
                sb5.append("<span class='sh_invalidPassword'>");
                sb5.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_TECH_BAD_PASSWORD"));
                sb5.append("</span>");
                sb5.append("<br>");
                sb5.append("<br>");
                sb5.append("<br>");
            }
            sb5.append("<table class='sh_login_table'>");
            sb5.append("<tr>");
            sb5.append("<td class='sh_labelcell'>");
            sb5.append(ServerLanguageCollection.getString(paramsMap, "USERNAME"));
            sb5.append("</td>");
            sb5.append("<td class='sh_fieldcell'>");
            if (badPasswordButUsername == null) {
                sb5.append("<input id='sh_loginfield' class='sh_login' type='text' size='20' name='techuser'/>");
            } else {
                sb5.append("<input id='sh_loginfield' class='sh_login' type='text' size='20' name='techuser' value='").append(badPasswordButUsername).append("'/>");
            }
            sb5.append("</td>");
            sb5.append("</tr>");
            sb5.append("<tr>");
            sb5.append("<td  class='sh_labelcell'>");
            sb5.append(ServerLanguageCollection.getString(paramsMap, "PASSWORD"));
            sb5.append("</td>");
            sb5.append("<td class='sh_fieldcell'>");
            sb5.append("<input class='sh_login' type='password' size='20' name='techpass'/>");
            sb5.append("</td>");
            sb5.append("</tr>");
            sb5.append("</table>");
            String lang = (String)paramsMap.get("language");
            if (lang != null) {
                sb5.append("<input type='hidden' name='language' value='").append(lang).append("'/>");
            }
            sb5.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
            sb5.append("<br>");
            sb5.append("<br>");
            sb5.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.forms['sh_loginform'].submit();\" >\n");
            sb5.append(ServerLanguageCollection.getString(paramsMap, "LOG_INTO")).append(" ").append(ServerBranding.get().getApplicationName(false));
            sb5.append("</span>");
            sb5.append("<br>");
            sb5.append("<br>");
            sb5.append("</td></tr>");
            sb5.append("</table>");
            sb5.append("</div>");
            sb5.append("<script> document.getElementById('sh_loginfield').focus(); </script>");
            sb5.append("</form>");
            sb5.append("</body>");
            sb5.append("</html>");
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] responding with HTML login page");
            }
            resp = new HttpResponse(sb5.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            resp.cookie = setCookie;
            return resp;
        }
        if (mtech.ttRequired && !mtech.ttAuthenticationDone) {
            submittedCode = (String)paramsMap.get("ttcode");
            boolean incorrectCode = false;
            if (submittedCode != null) {
                if (mtech.isValidTTCode(submittedCode)) {
                    mtech.ttAuthenticationDone = true;
                    newToken = new byte[16];
                    BCUtil.getSecureRandom().nextBytes(newToken);
                    mtech.credentials.setSessionToken(newToken);
                    ProxyServer.INSTANCE.registerSessionID(mtech.user, mtech.credentials.getSessionToken());
                } else {
                    incorrectCode = true;
                }
            } else {
                mtech.generateNewTTCode();
            }
            if (!mtech.ttAuthenticationDone) {
                sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.addSHTitleBranding(sb, false);
                sb.append("<form id='sh_loginform' method='post' action='/mobile'>\n");
                sb.append("<div align=\"center\">");
                sb.append("<table class='sh_fixedWidthTable'\">");
                sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
                SDemoHtml.imageHeader(sb, "h3", "lightweightfiles/padlock.png", ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_TITLE"), true);
                String email = mtech.user.emailAddress;
                String message = ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_TITLE_MSG1") + ":    <BR><BR><span class='sh_two_tier_email'>" + email + "</span> <BR><BR>" + ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_TITLE_MSG2");
                sb.append(message);
                sb.append("<br>");
                sb.append("<br>");
                if (incorrectCode) {
                    sb.append("<br>");
                    sb.append("<span class='sh_invalidPassword'>");
                    sb.append(ServerLanguageCollection.getString(paramsMap, "TWO_TIER_INVALID_CODE"));
                    sb.append("</span>");
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("<br>");
                }
                sb.append("<table class='sh_login_table'>");
                sb.append("<tr>");
                sb.append("<td  class='sh_labelcell'>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_SHORT")).append(":");
                sb.append("</td>");
                sb.append("<td class='sh_fieldcell'>");
                sb.append("<input class='sh_login' type='password' size='20' name='ttcode'/>");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("</table>");
                sb.append("</td></tr></table>");
                sb.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.forms['sh_loginform'].submit();\" >\n");
                sb.append(ServerLanguageCollection.getString(paramsMap, "LOG_INTO")).append(" ").append(ServerBranding.get().getApplicationName(false));
                sb.append("</span>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("</td></tr>");
                sb.append("</table>");
                sb.append("</div>");
                sb.append("</form>");
                sb.append("</body>");
                sb.append("</html>");
                HttpResponse resp3 = new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                resp3.cookie = setCookie;
                return resp3;
            }
        }
        if (mtech.appRequired && !mtech.appAuthenticationDone) {
            submittedCode = (String)paramsMap.get("appcode");
            boolean incorrectCode = false;
            if (submittedCode != null) {
                if (mtech.isValidAppCode(submittedCode)) {
                    mtech.appAuthenticationDone = true;
                    newToken = new byte[16];
                    BCUtil.getSecureRandom().nextBytes(newToken);
                    mtech.credentials.setSessionToken(newToken);
                    ProxyServer.INSTANCE.registerSessionID(mtech.user, mtech.credentials.getSessionToken());
                } else {
                    incorrectCode = true;
                }
            }
            if (!mtech.appAuthenticationDone) {
                sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.addSHTitleBranding(sb, false);
                sb.append("<form id='sh_loginform' method='post' action='/mobile'>\n");
                sb.append("<div align=\"center\">");
                sb.append("<table class='sh_fixedWidthTable'\">");
                sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
                SDemoHtml.imageHeader(sb, "h3", "lightweightfiles/padlock.png", ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_TITLE"), true);
                String message = ServerLanguageCollection.getString(paramsMap, "TOTP_CODE_ENTRY_DESC");
                sb.append(message);
                sb.append("<br>");
                sb.append("<br>");
                if (incorrectCode) {
                    sb.append("<br>");
                    sb.append("<span class='sh_invalidPassword'>");
                    sb.append(ServerLanguageCollection.getString(paramsMap, "TWO_TIER_INVALID_CODE"));
                    sb.append("</span>");
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("<br>");
                }
                sb.append("<table class='sh_login_table'>");
                sb.append("<tr>");
                sb.append("<td  class='sh_labelcell'>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "TWO_TIER_CODE_SHORT")).append(":");
                sb.append("</td>");
                sb.append("<td class='sh_fieldcell'>");
                sb.append("<input class='sh_login' type='password' size='20' name='appcode'/>");
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("</table>");
                sb.append("</td></tr></table>");
                sb.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.forms['sh_loginform'].submit();\" >\n");
                sb.append(ServerLanguageCollection.getString(paramsMap, "LOG_INTO")).append(" ").append(ServerBranding.get().getApplicationName(false));
                sb.append("</span>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("</td></tr>");
                sb.append("</table>");
                sb.append("</div>");
                sb.append("</form>");
                sb.append("</body>");
                sb.append("</html>");
                resp = new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                resp.cookie = setCookie;
                return resp;
            }
        }
        HttpResponse resp4 = this.handleMobileQueryAuthenticated(fullResource, paramsMap, isSsl, mtech);
        if (setCookie != null) {
            resp4.cookie = setCookie;
        }
        return resp4;
    }

    private StringBuffer getRedirectToHTTPSResponse(HashMap paramsMap) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
        sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
        SDemoHtml.appendHttpsRedirectJavascript(sb, ServerConfig.get().portList);
        sb.append("</head>");
        sb.append("<body>");
        SDemoHtml.addSHTitleBranding(sb, false);
        sb.append("<div class=\"sh_logout\">\n");
        sb.append("<br>");
        sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_NEEDS_SECURE"));
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.location='https' + document.location.href.substring(4);\" >\n");
        sb.append(ServerLanguageCollection.getString(paramsMap, "REDIRECT_NOW")).append("...");
        sb.append("</span>\n");
        sb.append("</div>\n");
        sb.append("</body>");
        sb.append("</html>");
        return sb;
    }

    private StringBuffer getNotEnoughSessionsResponse(HashMap paramsMap) {
        return this.getCouldNotConnectDueToErrorResponse(paramsMap, ServerLanguageCollection.getString(paramsMap, "SESSION_LIMIT_EXCEEDED"));
    }

    private StringBuffer getCouldNotConnectDueToErrorResponse(HashMap paramsMap, String errorMessage) {
        String redirectURL = "/mobile";
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
        sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
        sb.append("</head>");
        sb.append("<body>");
        SDemoHtml.addSHTitleBranding(sb, false);
        sb.append("<div class=\"sh_logout\">\n");
        sb.append("<br>");
        sb.append("<b>");
        sb.append(ServerLanguageCollection.getString(paramsMap, "CONNECTION_FAILED"));
        sb.append("</b>");
        sb.append("<br>");
        if (errorMessage != null && errorMessage.length() > 0) {
            char firstChar = errorMessage.charAt(0);
            sb.append(Character.toUpperCase(firstChar)).append(errorMessage.substring(1));
        }
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.location='").append(redirectURL).append("';\" >\n");
        sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_BACK_TO_MACHINES_LIST"));
        sb.append("</span>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("</div>\n");
        sb.append("</body>");
        sb.append("</html>");
        return sb;
    }

    private StringBuffer getLogoutResponse(HashMap paramsMap, String loginURL) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
        sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
        sb.append("</head>");
        sb.append("<body>");
        SDemoHtml.addSHTitleBranding(sb, false);
        sb.append("<div class=\"sh_logout\">\n");
        sb.append("<br>");
        sb.append(ServerLanguageCollection.getString(paramsMap, "LOGGED_OUT"));
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.location='").append(loginURL).append("';\" >\n");
        sb.append(ServerLanguageCollection.getString(paramsMap, "LOG_INTO")).append(" ").append(ServerBranding.get().getApplicationName(false));
        sb.append("</span>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("</div>\n");
        sb.append("</body>");
        sb.append("</html>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handleMobileQueryAuthenticated(String fullResource, HashMap paramsMap, boolean isSsl, MobileTech mtech) {
        MobileHandler handler;
        String session = (String)paramsMap.get("name");
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[MobileQueryHandler] authenticated mobile request, session=" + session);
        }
        if (session == null) {
            String mach;
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] no mobile session specified as parameter, will respond with non-(machine or customer)-specific page");
            }
            if ((mach = (String)paramsMap.get("mach")) != null) {
                String NEW_SESSION = Long.toString(SecurityUtil.nextSecureID());
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] SG direct connection attempt, assigning new random session " + NEW_SESSION);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append("<meta http-equiv='refresh' content='0;url=").append(fullResource).append("&name=").append(NEW_SESSION).append("'>");
                sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), false));
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.imageHeader(sb, "h3", "lightweightfiles/internet.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_CONNECTING"), true);
                sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_META_NO_REDIRECT"));
                sb.append(" <a href='").append(fullResource).append("&name=").append(NEW_SESSION).append("'>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_META_PLEASE_CLICK"));
                sb.append("</a>");
                sb.append("</body>");
                sb.append("</html>");
                HttpResponse resp = new HttpResponse(sb.toString(), "text/html");
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] responding with redirect to set new session");
                }
                resp.redirect = fullResource + "&name=" + NEW_SESSION;
                return resp;
            }
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] will respond with standard Mobile homepage");
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), false));
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            this.addAjaxPinger(sb);
            sb.append("</head>");
            sb.append("<body>");
            String NEW_SESSION = Long.toString(SecurityUtil.nextSecureID());
            Machine[] machineDetails = ProxyServer.INSTANCE.getMachineDetails();
            Customer[] customerDetails = ProxyServer.INSTANCE.getCustomerDetails(mtech.user);
            SDemoHtml.addSHTitleBranding(sb, false);
            sb.append("<div align=\"right\" class=\"help_div\">");
            sb.append("<a href=\"#help\" onclick=\"var divElement = document.getElementById('hiddenhelpdiv'); divElement.style.display='block';\"> <img src=\"lightweightfiles/24/help.png\" class=\"help_logo\" /> </a>");
            sb.append("</div>");
            if (mtech.permissions.canRemoteSupport()) {
                sb.append("<div class=\"sh_blockBorder\">\n");
                sb.append("<table class=\"sh_filtertable\">\n");
                sb.append("\t<tr class=\"sh_filtertable\">\n");
                sb.append("\t\t<td class=\"sh_filtertable sh_cellleft\"><H3>").append(ServerLanguageCollection.getString(paramsMap, "WAITING_CUSTOMERS")).append("</H3></td>");
                sb.append("<td class=\"sh_filtertable sh_cellright\">\n");
                this.addFilterForm("customers", sb, paramsMap, null);
                sb.append("</td>\n");
                sb.append("\t</tr>\n");
                sb.append("</table>");
                sb.append("<table class=\"sh_customers\">\n");
                sb.append("<tr class=\"sh_header\">\n");
                sb.append("<th class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "CUSTOMER_QUEUE")).append("</th>\n");
                sb.append("</tr>\n");
                this.createTable(mtech, customerDetails, sb, 0, NEW_SESSION, "c");
                sb.append("</table>\n");
                sb.append("</div>\n");
            }
            sb.append("<BR><BR>");
            if (mtech.permissions.canRemoteAccess()) {
                sb.append("<div class=\"sh_blockBorder\">\n");
                sb.append("<table class=\"sh_filtertable\">\n");
                sb.append("\t<tr class=\"sh_filtertable\">\n");
                sb.append("\t\t<td class=\"sh_filtertable sh_cellleft\"><H3>").append(ServerLanguageCollection.getString(paramsMap, "AVAILABLE_MACHINES")).append("</H3></td>");
                sb.append("<td class=\"sh_filtertable sh_cellright\">\n");
                this.addFilterForm("machines", sb, paramsMap, Language.get("ONLINE"));
                sb.append("</td>\n");
                sb.append("\t</tr>\n");
                sb.append("</table>");
                MachinesTree tree = new MachinesTree(machineDetails, mtech.user, mtech.group);
                MachinesTree.TreeNode rootNode = tree.getRoot();
                sb.append("<table class=\"sh_availablemachines\">\n");
                sb.append("<tr class=\"sh_header\">\n");
                sb.append("<th class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "REMOTE_ACCESS_MACHINES")).append("</th>\n");
                sb.append("</tr>\n");
                MobileQueryHandler.createTreeStructureInTable(rootNode, tree, sb, 0, 0, NEW_SESSION, "");
                sb.append("</table>\n");
                sb.append("</div>\n");
            }
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<div id=\"hiddenhelpdiv\" class=\"hiddenhelpdiv sh_blockBorder\">\n");
            sb.append("<a name=\"help\"><H3>Mobile Client Help</H3></a>");
            sb.append("<table class=\"sh_helptable\">\n");
            sb.append("<tr class=\"sh_header\">\n");
            sb.append("<th colspan=\"2\" class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "HELP_CONTROL_BUTTON")).append("</th>\n");
            sb.append("</tr>\n");
            this.addHelpRow(sb, true, "lightweightfiles/pulloutbig.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_CONTROLS"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_CONTROLS"));
            sb.append("</table>\n");
            sb.append("<br>");
            sb.append("<table class=\"sh_helptable\">\n");
            sb.append("<tr class=\"sh_header\">\n");
            sb.append("<th colspan=\"2\" class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "HELP_CONTROL")).append("</th>\n");
            sb.append("</tr>\n");
            this.addHelpRow(sb, true, "lightweightfiles/48/pointer.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_PRIMARY_CLICK"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_PRIMARY_CLICK"));
            this.addHelpRow(sb, false, "lightweightfiles/mousebig_double.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_DOUBLE_CLICK"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_DOUBLE_CLICK"));
            this.addHelpRow(sb, true, "lightweightfiles/mousebig_right.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_RIGHT_CLICK"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_RIGHT_CLICK"));
            this.addHelpRow(sb, false, "lightweightfiles/mousebig_drag.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_DRAGGING"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_DRAGGING"));
            sb.append("</table>\n");
            sb.append("<BR>");
            sb.append("<table class=\"sh_helptable\">\n");
            sb.append("<tr class=\"sh_header\">\n");
            sb.append("<th colspan=\"2\" class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "HELP_INPUT")).append("</th>\n");
            sb.append("</tr>\n");
            this.addHelpRow(sb, true, "lightweightfiles/48/typing_large.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_TYPING_TEXT"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_TYPING_TEXT"));
            this.addHelpRow(sb, false, "lightweightfiles/keyboard.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_SENDING_KEYS"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_SENDING_KEYS"));
            sb.append("</table>\n");
            sb.append("<BR>");
            sb.append("<table class=\"sh_helptable\">\n");
            sb.append("<tr class=\"sh_header\">\n");
            sb.append("<th colspan=\"2\" class=\"sh_headerrow\">").append(ServerLanguageCollection.getString(paramsMap, "HELP_ADVANCED_CONTROLS")).append("</th>\n");
            sb.append("</tr>\n");
            this.addHelpRow(sb, true, "lightweightfiles/filetransfer.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_FILE_TRANSFER"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_FILE_TRANSFER"));
            this.addHelpRow(sb, false, "lightweightfiles/fittoscreen.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_SCALE_TO_FIT"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_SCALE_TO_FIT"));
            this.addHelpRow(sb, true, "lightweightfiles/cad.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_SEND_CAD"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_SEND_CAD"));
            this.addHelpRow(sb, false, "lightweightfiles/tune.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_OPTION_CONFIGURE_SESSION"), ServerLanguageCollection.getString(paramsMap, "MOBILE_DESCRIPTION_CONFIGURE_SESSION"));
            sb.append("</table>\n");
            sb.append("</div>");
            sb.append("<div class=\"sh_logout\">\n");
            sb.append("<br>");
            sb.append("<a href=\"/mobile?logout=1\">");
            sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" >\n");
            sb.append(ServerLanguageCollection.getString(paramsMap, "LOG_OUT"));
            sb.append("</span>");
            sb.append("</a>");
            sb.append("<span style=\"padding: 0px 20px 0px 20px\">&nbsp;</span>");
            sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"var divElement = document.getElementById('hiddenhelpdiv'); divElement.style.display='block'; window.scroll(0,findPos(divElement));\" >\n");
            sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_HELP"));
            sb.append("</span>");
            sb.append("</div>\n");
            sb.append("<br><br>");
            sb.append("</body>");
            sb.append("</html>");
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] responding with standard mobile HTML homepage");
            }
            HttpResponse resp = new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            return resp;
        }
        Object sb = mtech.sessions_LOCK;
        synchronized (sb) {
            handler = (MobileHandler)mtech.sessions.get(session);
        }
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[MobileQueryHandler] got mobile handler " + handler + " for session " + session);
        }
        if (handler == null) {
            String cust = (String)paramsMap.get("cust");
            String mach = (String)paramsMap.get("mach");
            String fin = (String)paramsMap.get("finished");
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] handler does not exist, must create this session, cust=" + cust + ", mach=" + mach + ", finished=" + fin);
            }
            if (cust != null) {
                handler = new MobileHandler(mtech, session, mtech.user.displayName, cust, false);
            } else if (mach != null) {
                handler = new MobileHandler(mtech, session, mtech.user.displayName, mach, true);
            } else {
                if (fin != null) {
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append("<html>");
                    sb2.append("<head>");
                    sb2.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), false));
                    sb2.append(SDemoHtml.getStandardIosMobilePageHeaders());
                    sb2.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                    sb2.append("</head>");
                    sb2.append("<body>");
                    SDemoHtml.addSHTitleBranding(sb2, false);
                    sb2.append("<div align=\"center\">");
                    sb2.append("<table class='sh_fixedWidthTable'\">");
                    sb2.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
                    sb2.append("<br>");
                    SDemoHtml.imageHeader(sb2, "h3", "lightweightfiles/finished.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_FINISHED_TITLE"), true);
                    sb2.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_FINISHED_MESSAGE"));
                    sb2.append("<br>");
                    sb2.append("<br>");
                    sb2.append("<br>");
                    sb2.append("<br>");
                    sb2.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.location='/mobile';\" >\n");
                    sb2.append(ServerLanguageCollection.getString(paramsMap, "GO_TO_MOBILE"));
                    sb2.append("</span>\n");
                    sb2.append("<br>");
                    sb2.append("<br>");
                    sb2.append("</td></tr></table>");
                    sb2.append("</body>");
                    sb2.append("</html>");
                    return new HttpResponse(sb2.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                }
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] mobile session was not found and no target cust or mach specified so responding with session not found HTML page");
                }
                return new HttpResponse("Mobile session" + SDemoHtml.NOT_FOUND_MARKER, "text/plain");
            }
            if (CentralDebugging.MOBILE_REQUEST_HANDLING || CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                System.out.println("[Mobile] Starting handler for " + session);
            }
            handler.start();
            Object object = mtech.sessions_LOCK;
            synchronized (object) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] assigning handler " + handler + " to session " + session);
                }
                mtech.sessions.put(session, handler);
            }
        }
        HttpResponse resp = handler.handleQueryAuthenticated(fullResource, paramsMap, isSsl);
        return resp;
    }

    private void addAjaxPinger(StringBuffer sb) {
        sb.append("\n<script>");
        sb.append("\nvar checkTimeout = 60*1000;");
        sb.append("\nvar xmlhttp;");
        sb.append("\nif (window.XMLHttpRequest) {");
        sb.append("\n xmlhttp = new XMLHttpRequest();");
        sb.append("\n} else {");
        sb.append("\n if (window.ActiveXObject) {");
        sb.append("\n  xmlhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
        sb.append("\n }");
        sb.append("\n}");
        sb.append("\nfunction pingServerToKeepSessionAlive() {");
        sb.append("\nxmlhttp.onreadystatechange = dealWithResponse;");
        sb.append("\nvar url = '/mobile?ping=yes';");
        sb.append("\nxmlhttp.open('GET',url,true);");
        sb.append("\nxmlhttp.send(null);");
        sb.append("\n}");
        sb.append("\nfunction dealWithResponse() {");
        sb.append("\nif (xmlhttp.readyState != 4) return;");
        sb.append("\nif (xmlhttp.status == 200) {");
        sb.append("\nsetTimeout('pingServerToKeepSessionAlive();',checkTimeout);");
        sb.append("\n}");
        sb.append("\n}");
        sb.append("\npingServerToKeepSessionAlive();");
        sb.append("\n</script>");
    }

    private void addHelpRow(StringBuffer sb, boolean even, String image, String title, String description) {
        if (even) {
            sb.append("<tr class=\"sh_evenrow\">\n");
        } else {
            sb.append("<tr class=\"sh_oddrow\">\n");
        }
        sb.append("<td width=\"1%\">");
        sb.append("<img alt=\"").append(title).append("\" class=\"help_sub_image\" src=\"").append(image).append("\">");
        sb.append("</td>");
        sb.append("<td style=\"vertical-align:top\">");
        sb.append("<ul style=\"padding-left:15px\">");
        sb.append("<li><b>").append(title).append("</b> - ").append(description).append("</li>");
        sb.append("</ul>");
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void createTable(MobileTech mtech, Customer[] customerDetails, StringBuffer sb, int rowCount, String NEW_SESSION, String postFix) {
        for (int i = 0; i < customerDetails.length; ++i) {
            if (!mtech.user.canLoggedInTechUserSeeCustomer(customerDetails[i], mtech.group)) continue;
            if (rowCount % 2 == 0) {
                sb.append("<tr class=\"sh_customerrow sh_evenrow\">\n");
            } else {
                sb.append("<tr class=\"sh_customerrow sh_oddrow\">\n");
            }
            sb.append("<td class=\"sh_customercell\">\n");
            String id = customerDetails[i].getCustomerID();
            sb.append("<a href='/mobile?name=").append(NEW_SESSION).append('_').append(postFix).append("_").append(i);
            sb.append("&cust=").append(id).append("'>\n");
            sb.append("<img src=\"lightweightfiles/16/user.png\" class=\"sh_customerfolder\"/>\n");
            String visibleName = customerDetails[i].toString(false);
            sb.append("<span name=\"sh_customers\">").append(visibleName).append("</span></td>\n");
            sb.append("</a>\n");
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++rowCount;
        }
    }

    private void addFilterForm(String filterElementNames, StringBuffer sb, HashMap paramsMap, String checkname) {
        String filterID = "" + Math.abs(SecurityUtil.nextSecureID());
        String checkbox = checkname == null ? "" : "filter_" + checkname;
        String filterText = ServerLanguageCollection.getString(paramsMap, "FILTER") + "...";
        sb.append("<form  onSubmit=\"return false;\" >\n");
        if (checkbox.length() > 0) {
            sb.append("<label><input style='display:inline' type='checkbox' id='").append(checkbox).append("' onchange='doFilter").append(filterID).append("();' checked/> ").append(checkname).append("</label>&nbsp; &nbsp;\n");
        }
        sb.append("<input class=\"sh_filterField\" id='").append(filterID).append("' type=\"text\" value=\"").append(filterText).append("\" name=\"").append(filterElementNames).append("_filterform\" onFocus=\"if (this.value == '").append(filterText).append("') { this.value = ''; this.style.color='#000000';} \" onKeyUp=\"doFilter").append(filterID).append("();\"/>\n");
        sb.append("</form>\n");
        sb.append("<script>\n");
        sb.append(" function doFilter").append(filterID).append("() {\n");
        sb.append("  filter(document.getElementById(\"").append(filterID).append("\").value==\"").append(filterText).append("\"?\"\":document.getElementById(\"").append(filterID).append("\").value, \"").append(filterElementNames).append("\", \"").append(checkbox).append("\");\n");
        sb.append(" }\n");
        sb.append("</script>\n");
    }

    private static int createTreeStructureInTable(MachinesTree.TreeNode treeRoot, MachinesTree tree, StringBuffer sb, int depth, int rowCount, String NEW_SESSION, String postFix) {
        return MobileQueryHandler.createTreeStructureInTable(treeRoot, tree, sb, depth, rowCount, NEW_SESSION, postFix, new boolean[1]);
    }

    private static int createTreeStructureInTable(MachinesTree.TreeNode treeRoot, MachinesTree tree, StringBuffer sb, int depth, int rowCount, String NEW_SESSION, String postFix, boolean[] haveOnline) {
        for (int i = 0; i < treeRoot.children.size(); ++i) {
            boolean isOnline;
            boolean isMachine;
            boolean showLink;
            MachinesTree.TreeNode child = (MachinesTree.TreeNode)treeRoot.children.get(i);
            boolean bl = showLink = child.children.size() == 0 && child.info.isAvailable();
            if (child.children.size() == 0 && showLink) {
                isMachine = true;
                isOnline = true;
                haveOnline[0] = true;
            } else if (child.children.size() == 0) {
                isMachine = true;
                isOnline = false;
            } else {
                isMachine = false;
                isOnline = true;
            }
            int skipmePoint = sb.length();
            String tdID = "td_" + Math.abs(SecurityUtil.nextSecureID());
            String folderID = "group_" + Math.abs(SecurityUtil.nextSecureID());
            if (rowCount % 2 == 0) {
                sb.append("<tr class=\"sh_machinerow sh_evenrow\">\n");
            } else {
                sb.append("<tr class=\"sh_machinerow sh_oddrow\">\n");
            }
            sb.append("<td id='").append(tdID).append("' class=\"sh_machinecell\" style=\"padding-left:").append(20 * depth).append("px; ").append(isMachine && !isOnline ? "display:none" : "").append("\">");
            if (showLink) {
                String machineID = child.info.getMachineID();
                sb.append("<a href='/mobile?name=").append(NEW_SESSION).append('_').append(postFix).append("_").append(i);
                sb.append("&mach=").append(machineID).append("'>\n");
            }
            if (isMachine && isOnline) {
                sb.append("<img src=\"lightweightfiles/16/screen.png\" class=\"sh_machine\"/>\n");
                sb.append("<span name=\"machines\" status='online'>").append(child.shortName).append("</span></td>\n");
            } else if (isMachine) {
                sb.append("<img src=\"lightweightfiles/16/screen_offline.png\" class=\"sh_machine\"/>\n");
                sb.append("<span class=\"sh_machine_offline\" name=\"machines\" status='offline'>").append(child.shortName).append("</span></td>\n");
            } else {
                sb.append("<img src=\"lightweightfiles/16/group.png\" class=\"sh_machinefolder\"/>\n");
                sb.append("<span id='").append(folderID).append("' name=\"machines\" status='online'>").append(child.shortName).append("</span></td>\n");
            }
            if (showLink) {
                sb.append("</a>\n");
            }
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++rowCount;
            boolean[] folderHasOnline = new boolean[]{false};
            rowCount = MobileQueryHandler.createTreeStructureInTable(child, tree, sb, depth + 1, rowCount, NEW_SESSION, postFix + i, folderHasOnline);
            if (isMachine || folderHasOnline[0]) continue;
            sb.append("<script>\n");
            sb.append("  document.getElementById('").append(folderID).append("').setAttribute('status','offline');\n");
            sb.append("  document.getElementById('").append(tdID).append("').style.display='none';\n");
            sb.append("</script>\n");
        }
        return rowCount;
    }

    class CredentialsCache {
        private HashMap<String, CachedCredentials> map = new HashMap();

        CredentialsCache() {
        }

        public void putCachedCredentials(String radiussession, CachedCredentials credentials) {
            credentials.creationTime = System.currentTimeMillis();
            this.map.put(radiussession, credentials);
        }

        public CachedCredentials getCachedCredentialsFor(String radiussession) {
            CachedCredentials creds = this.map.get(radiussession);
            if (creds == null) {
                return null;
            }
            if (System.currentTimeMillis() - creds.creationTime > 300000L) {
                this.map.remove(radiussession);
                return null;
            }
            return creds;
        }
    }

    public class RadiusChallengeHandler
    implements ChallengeHandler {
        public boolean challengeRequired = false;
        public String message;
        public String challengeCode;

        public RadiusChallengeHandler(String passedInCode) {
            this.challengeCode = passedInCode;
        }

        @Override
        public String getChallengeResponse(String message) throws IOException {
            this.challengeRequired = true;
            this.message = message;
            if (this.challengeCode != null) {
                String code = this.challengeCode;
                this.challengeCode = null;
                return code;
            }
            return "";
        }
    }

    class MobileHandler
    extends Thread
    implements TechClientListener,
    NodeLinkStatusListener {
        MobileTech parent;
        String techName;
        String targetComputer;
        boolean isMachine;
        String mobileSession;
        NodeLink sock;
        LightweightClientUserInterface sdui;
        Controller con;
        ProxiedClientController pcon;
        boolean amConnected;
        boolean amAccessed;
        boolean amBadPassword;
        boolean amNotEnoughSessions;
        boolean amBrokenWithErrorMsg;
        private String brokenErrorMsg = null;

        public MobileHandler(MobileTech parent, String mobileSession, String techName, String targetComputer, boolean isMachine) {
            this.parent = parent;
            this.mobileSession = mobileSession;
            this.techName = techName;
            this.targetComputer = targetComputer;
            this.isMachine = isMachine;
            this.amBadPassword = false;
            this.amConnected = false;
            this.amAccessed = false;
            this.amBrokenWithErrorMsg = false;
            this.amNotEnoughSessions = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            try {
                this.con.closeConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.con.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sock.stop("mobile handler shutting down");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = this.parent.sessions_LOCK;
            synchronized (object) {
                this.parent.sessions.remove(this.mobileSession);
            }
        }

        public HttpResponse handleQueryAuthenticated(String fullResource, HashMap paramsMap, boolean isSsl) {
            StringBuffer sb;
            boolean connectingCheck;
            boolean bl = connectingCheck = paramsMap.get("stillconnecting") != null;
            if (connectingCheck && CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[MobileQueryHandler] request is just to check if still connecting");
            }
            if (this.sdui != null && this.sdui.machinePasswordRequired()) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] SM Lightweight Client UI requires a (SG) password");
                }
                if (connectingCheck) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] responding with plain text to say finished connecting (must display login page)");
                    }
                    return new HttpResponse("<connecting>false</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
                }
                String pass = (String)paramsMap.get("pw");
                if (pass != null) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] password provided, setting in SM Lightweight Client UI");
                    }
                    this.sdui.setMachinePassword(pass);
                    String tmp = fullResource.substring(0, fullResource.indexOf(63));
                    tmp = tmp + "?name=" + this.mobileSession;
                    String lang = (String)paramsMap.get("language");
                    if (lang != null) {
                        tmp = tmp + "&language=" + lang;
                    }
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] Responding with redirect to go back to connecting");
                    }
                    HttpResponse redirectNoPwd = new HttpResponse("", "text/plain");
                    redirectNoPwd.redirect = tmp;
                    return redirectNoPwd;
                }
                if (pass == null) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] No password specified, responding");
                    }
                    StringBuffer sb2 = this.getMachinePasswordRequest(paramsMap, false);
                    return new HttpResponse(sb2.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                }
            }
            if (this.amBadPassword) {
                if (connectingCheck) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] Bad password entered, responding with plain text to say finished connecting");
                    }
                    return new HttpResponse("<connecting>false</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
                }
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Bad password entered, responding with HTML page to request new password?");
                }
                sb = this.getMachinePasswordRequest(paramsMap, true);
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (this.amBrokenWithErrorMsg) {
                if (connectingCheck) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] Error encountered, responding with plain text to say finished connecting");
                    }
                    return new HttpResponse("<connecting>false</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
                }
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Could not connect because of error '" + this.brokenErrorMsg + "'");
                }
                sb = MobileQueryHandler.this.getCouldNotConnectDueToErrorResponse(paramsMap, this.brokenErrorMsg);
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (this.amNotEnoughSessions) {
                if (connectingCheck) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] Not enough sessions available, responding with plain text to say finished connecting");
                    }
                    return new HttpResponse("<connecting>false</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
                }
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Not enough sessions available, respond with HTML page to notify end user.");
                }
                sb = MobileQueryHandler.this.getNotEnoughSessionsResponse(paramsMap);
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (!this.amConnected) {
                if (connectingCheck) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[MobileQueryHandler] not connected yet, responding with plain text to say keep checking");
                    }
                    return new HttpResponse("<connecting>true</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
                }
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Not connected yet, will respond with standard 'connecting' page");
                }
                sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), false));
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.addSHTitleBranding(sb, false);
                sb.append("<div align=\"center\">");
                sb.append("<table class='sh_fixedWidthTable'\">");
                sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
                sb.append("<br>");
                SDemoHtml.imageHeader(sb, "h3", "lightweightfiles/internet.png", ServerLanguageCollection.getString(paramsMap, "MOBILE_CONNECTING"), true);
                sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_CONNECTING_WAIT"));
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("</td></tr></table>");
                sb.append("\n<script>");
                sb.append("\nvar xmlhttp;");
                sb.append("\nif (window.XMLHttpRequest) {");
                sb.append("\n xmlhttp = new XMLHttpRequest();");
                sb.append("\n} else {");
                sb.append("\n if (window.ActiveXObject) {");
                sb.append("\n  xmlhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
                sb.append("\n }");
                sb.append("\n}");
                sb.append("\nfunction checkForUpdates() {");
                sb.append("\n xmlhttp.onreadystatechange = checkRefresh;");
                sb.append("\n var url = '/mobile?name=").append(this.mobileSession).append("&stillConnecting=q&random='+(new Date()).getTime();");
                sb.append("\n xmlhttp.open('GET',url,true);");
                sb.append("\n xmlhttp.send(null);");
                sb.append("\n}");
                sb.append("\nfunction checkRefresh() {");
                sb.append("\n if (xmlhttp.readyState != 4) return;");
                sb.append("\n if (xmlhttp.status == 200) {");
                sb.append("\n   if (xmlhttp.responseText.search('false') != -1) window.location.reload();");
                sb.append("\n }");
                sb.append("\n setTimeout('checkForUpdates();',2000);");
                sb.append("\n}");
                sb.append("\n setTimeout('checkForUpdates();',2000);");
                sb.append("\n</script>");
                sb.append("</body>");
                sb.append("</html>");
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Responding with standard HTML 'connecting' page");
                }
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (connectingCheck) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Connected (amConnected=" + this.amConnected + "), responding with plain text to say finished connecting");
                }
                return new HttpResponse("<connecting>false</connecting>", "text/plain", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (!this.amAccessed) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[MobileQueryHandler] Marking session as having been accessed");
                }
                this.amAccessed = true;
            }
            return this.sdui.handleQuery(paramsMap);
        }

        private StringBuffer getMachinePasswordRequest(HashMap paramsMap, boolean isIncorrectPassword) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb.append("</head>");
            sb.append("<body>");
            SDemoHtml.addSHTitleBranding(sb, false);
            sb.append("<div align=\"center\">");
            sb.append("<table class='sh_fixedWidthTable'\">");
            sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
            sb.append("<br>");
            if (isIncorrectPassword) {
                sb.append("<span class='sh_invalidPassword'>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_BAD_PASSWORD"));
                sb.append("</span>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<br>");
            } else {
                sb.append(ServerLanguageCollection.getString(paramsMap, "MOBILE_MACHINE_PASS_REQUIRED"));
                sb.append("<BR><BR>");
            }
            sb.append("<form id ='sh_mobilePasswordForm' method=\"post\" action=\"/mobile\">");
            sb.append("<table border='0' cellspacing='5' cellpadding='0'>");
            sb.append("<tr>");
            sb.append("<td class='sh_fieldcell'>");
            sb.append("<input size='20' id='sh_passwordfield' class='sh_login' type='password' name='pw'/>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
            String lang = (String)paramsMap.get("language");
            if (lang != null) {
                sb.append("<input type='hidden' name='language' value='").append(lang).append("'/>");
            }
            sb.append("<input type='hidden' name='name' value='").append(this.mobileSession).append("'/>");
            sb.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.forms['sh_mobilePasswordForm'].submit();\" >\n");
            sb.append(ServerLanguageCollection.getString(paramsMap, "CONTINUE"));
            sb.append("</span>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<script> document.getElementById('sh_passwordfield').focus(); </script>");
            sb.append("</form>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</div>");
            sb.append("</body>");
            sb.append("</html>");
            return sb;
        }

        public Message handleProxiedControllerMessage(Message m) {
            return this.pcon.handleProxiedControllerMessage(m);
        }

        @Override
        public void run() {
            long initTime = System.currentTimeMillis();
            try {
                BCUtil sessionBCU;
                Debugger.info("[Mobile] Initing handler for mobile (" + this.targetComputer + ")");
                this.con = new Controller(true);
                this.pcon = new ProxiedClientController(this.con);
                ProxyConnectSettings settings = new ProxyConnectSettings();
                settings.retry = false;
                settings.isMachine = this.isMachine;
                String[] ips = ServerConfig.get().ipPortPairsList;
                if (ips != null && ips.length > 0) {
                    settings.host = ServerConfig.getHostFromIpAndPort(ips[0]);
                    settings.port = ServerConfig.getPortFromIpAndPort(ips[0]);
                } else {
                    settings.host = "localhost";
                    int[] ports = ServerConfig.get().portList;
                    settings.port = ports[0];
                }
                settings.credentials = (TechCredentials)this.parent.credentials.clone();
                settings.requestAccess = this.parent.permissions.mustRequestConnection();
                settings.requestAccessTimeout = settings.requestAccess ? this.parent.getRequestTimeout() : 0L;
                settings.customerOrMachineID = this.targetComputer;
                settings.techname = this.techName;
                settings.isMobile = true;
                Debugger.info("[Mobile] Creating TechClient");
                TechClient tc = new TechClient("NO LANGFILE NEEDED", Language.DEFLANG, settings.credentials, true, this, this);
                settings.credentials.setSessionToken(tc.getSessionID());
                Debugger.info("[Mobile] Connecting TechClient");
                try {
                    sessionBCU = tc.connect(initTime, settings);
                }
                catch (Exception ex) {
                    if (settings.isMachine) {
                        this.askServerToFetchLogs(tc, initTime, settings);
                    }
                    ex.printStackTrace();
                    if (ex instanceof SessionLimitExceededException) {
                        this.amNotEnoughSessions = true;
                    } else {
                        this.amBrokenWithErrorMsg = true;
                        this.brokenErrorMsg = ex.getMessage();
                    }
                    Thread.sleep(20000L);
                    this.terminate();
                    return;
                }
                Debugger.info("[Mobile] Getting session streams");
                this.sock = tc.getConnectedSocketAndInvalidateTC();
                OutputStream out = tc.getConnectedOutputStream();
                InputStream in = tc.getConnectedInputStream();
                this.sdui = new LightweightClientUserInterface(this.con, this.mobileSession, this.isMachine ? this.targetComputer : null, false);
                this.sdui.setTechPermissions(tc.getTechUser().getPermissions());
                this.sdui.setTechUser(tc.getTechUser());
                this.con.setGUI(this.sdui);
                Debugger.info("[Mobile] Launching session controller");
                try {
                    ProxyConnectSettings connectSettings = new ProxyConnectSettings();
                    connectSettings.techname = settings.techname;
                    connectSettings.host = "localhost";
                    connectSettings.port = -1;
                    connectSettings.initialMode = 0;
                    connectSettings.isMobile = settings.isMobile;
                    this.con.connectToProxy(connectSettings, null, null, this.sock, in, out, null, sessionBCU, tc.getTechUser());
                }
                catch (Exception x) {
                    x.printStackTrace();
                    if (x.toString().contains("Invalid Password")) {
                        this.amBadPassword = true;
                    } else {
                        this.amBrokenWithErrorMsg = true;
                        this.brokenErrorMsg = x.getMessage();
                    }
                    Thread.sleep(60000L);
                    this.terminate();
                    return;
                }
                this.sock.addLinkStatusListener(this);
                this.amConnected = true;
                int counts = 30;
                for (int i = 0; i < counts; ++i) {
                    Thread.sleep(10000L);
                    if (this.amAccessed) break;
                }
                if (!this.amAccessed) {
                    this.terminate();
                }
            }
            catch (Throwable t) {
                Debugger.info("[Mobile] Failed to handle session (" + this.targetComputer + "):");
                t.printStackTrace();
            }
        }

        private void askServerToFetchLogs(TechClient tc, long initTime, ProxyConnectSettings settings) {
        }

        @Override
        public void customerListChanged() {
        }

        @Override
        public void setWarningMessage(String text) {
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            Debugger.info("[Mobile] Mobile session ended (" + this.targetComputer + ") - " + link);
            try {
                this.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            Debugger.info("[Mobile] Link broken for mobile session (" + this.targetComputer + ") - " + link);
        }

        @Override
        public void linkOK(NodeLink link) {
            Debugger.info("[Mobile] Link ok for mobile session (" + this.targetComputer + ") - " + link);
        }

        @Override
        public void demoListChanged() {
        }

        @Override
        public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, boolean isPlan2, int totalSessions, int maxSHSessions, int maxSGSessions, int alertedMachines, int alertLimit, int regMachines, int machineLimit) {
        }

        @Override
        public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String emailAddress, boolean allowRemember) {
            return new TechClientListener.TwoTierResponse();
        }

        @Override
        public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
            return new TechClientListener.TwoTierResponse();
        }

        @Override
        public void machineAdded(Machine machine) {
        }

        @Override
        public void machineRemoved(Machine machine) {
        }

        @Override
        public void machinesAdded(Machine[] machine) {
        }

        @Override
        public void machinesRemoved(Machine[] machine) {
        }

        @Override
        public void machineOnline(Machine machine) {
        }

        @Override
        public void machineOffline(Machine machine) {
        }

        @Override
        public void machineDataChanged(Machine machine) {
        }

        @Override
        public void machineFilterableInfoChanged(Machine machine) {
        }

        @Override
        public void sessionAdded(AccessSession session) {
        }

        @Override
        public void sessionRemoved(AccessSession session) {
        }

        @Override
        public void customerLiveListChanged() {
        }

        @Override
        public void peersChanged() {
        }

        @Override
        public void licenseChanged() {
        }

        @Override
        public void alertAdded(ResourceContainer alert) {
        }

        @Override
        public void alertRemoved(ResourceContainer alert) {
        }

        @Override
        public void alertChanged(ResourceContainer alert) {
        }

        @Override
        public void newNotificationReceived(Notification newNotification) {
        }

        @Override
        public long requestAppAuthenticationSetup(String totpKey, String totpUsername, String hostname, int length) {
            return 0L;
        }

        @Override
        public void closeAppAuthenticationSetup() {
        }

        @Override
        public void configChanged() {
        }

        @Override
        public void waitingForRemoteUserToAccept() {
        }

        @Override
        public void sgUpdatingDuringConnect() {
        }
    }

    private class CachedCredentials {
        public long creationTime;
        public TechCredentials credentials;

        private CachedCredentials() {
        }
    }

    private class MobileTech {
        long lastAccess = System.currentTimeMillis();
        TechUser user;
        MergedTechGroup group;
        TechGroup groupToUseForAuthentication;
        TechCredentials credentials;
        final Object sessions_LOCK = new Object();
        HashMap sessions = new HashMap();
        boolean ttRequired;
        boolean appRequired;
        boolean ttAuthenticationDone = false;
        boolean appAuthenticationDone = false;
        TOTPAuthenticator authenticator;
        ArrayList<String> validCodeList = new ArrayList();
        public TechGroupPermissions permissions;

        private MobileTech() {
        }

        public boolean isValidTTCode(String code) {
            if (code == null) {
                return false;
            }
            for (String aValidCodeList : this.validCodeList) {
                if (!code.equals(aValidCodeList)) continue;
                return true;
            }
            return false;
        }

        public long getRequestTimeout() {
            if (this.group == null) {
                return 0L;
            }
            return this.group.getRequestAccessTimeout();
        }

        public boolean isValidAppCode(String submittedCode) {
            Long code = Long.parseLong(submittedCode);
            LazyPassword totpKey = this.user.getTOTPKey();
            if (totpKey != null && !totpKey.isNull()) {
                return this.authenticator.checkCode(totpKey.getDecryptedPassword(), code, System.currentTimeMillis());
            }
            return false;
        }

        public void generateNewTTCode() throws Exception {
            String newCode = TwoTierAuthentication.sendAuthenticationCode(this.user, this.groupToUseForAuthentication);
            this.validCodeList.add(newCode);
            if (this.validCodeList.size() > 5) {
                this.validCodeList.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeAllSessions() {
            Object object = this.sessions_LOCK;
            synchronized (object) {
                Object[] keys;
                for (Object key : keys = this.sessions.keySet().toArray()) {
                    if (CentralDebugging.MOBILE_REQUEST_HANDLING) {
                        System.out.println("[Mobile] Removing aged mobile session " + key);
                    }
                    try {
                        MobileHandler handler = (MobileHandler)this.sessions.get(key);
                        handler.terminate();
                    }
                    catch (Exception x) {
                        if (!CentralDebugging.MOBILE_REQUEST_HANDLING) continue;
                        System.out.println("[Mobile] Unable to remove mobile session " + x);
                    }
                }
            }
        }

        public String toString() {
            long msOld = System.currentTimeMillis() - this.lastAccess;
            try {
                return this.user.displayName + " (" + msOld + ")";
            }
            catch (Exception x) {
                return this.user + " (" + msOld + ")";
            }
        }
    }

    private class ClearoutThread
    extends Thread {
        public ClearoutThread() {
            super("MobileQueryHandler-ClearoutThread");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    MobileQueryHandler.this.doMobileClearout();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                return;
            }
        }
    }
}

