/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo;

import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.vis.NLOptimisationFeed;
import com.aem.sdemo.SDemoHtml;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.client.controller.IgnoredCommandResponseListener;
import com.aem.sdesktop.common.FileTransferStats;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.server.controller.ImmediateFileTransferListener;
import com.aem.sdesktop.util.FileEntry;
import com.aem.sdesktop.util.PortRedirector;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.proxy.HttpResponse;
import com.aem.shelp.proxy.HttpResponsePrinter;
import com.aem.shelp.proxy.MimeTypes;
import com.aem.shelp.proxy.ServerLanguageCollection;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.TechPermissionsHandler;
import com.aem.shelp.proxy.WebDownloadServer;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.WebTransactor;
import com.aem.utils.CursorInfo;
import com.aem.utils.keyhandling.KeyRequest;
import com.aem.utils.keyhandling.KeysList;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.sound.sampled.Mixer;
import javax.swing.JFrame;
import javax.swing.text.StyledDocument;
import utils.files.RemoteFile;
import utils.message.Message;
import utils.osstats.types.SessionInfo;
import utils.site.StringEscaper;
import utils.stream.StreamUtils;
import utils.string.StringToAscii;
import utils.string.StringUtil;
import utils.swing.components.path.elements.FTPVolume;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.png.PngEncoder;

public class LightweightClientUserInterface
implements ClientUserInterface {
    private FileTransferStats fileTransferStats = new FileTransferStats();
    private int PAD = 70;
    private static final String[] MODIFIERS = new String[]{"VK_SHIFT", "VK_CONTROL", "VK_ALT", "VK_ALT_GRAPH", "VK_META"};
    private static final boolean TEST_LIMIT_TO_TOPLEFT = false;
    private static final boolean TEST_BROWSER_SPEED = false;
    private static final boolean COUNT_ONLOADS = true;
    private static final int CHUNK = 128;
    private final String page;
    private long logicalTimestamp = 0L;
    private int screenRefresh = 0;
    private final Object LOCK = new Object();
    private final long[] indices = new long[1536];
    private final Object[] pngs = new Object[1536];
    private int pointerX;
    private int pointerY;
    private long[] test_indices;
    private boolean test_on;
    private int numberOfChunksWide;
    private int numberOfChunksHigh;
    private int widthLastChunk;
    private int heightLastChunk;
    private int widthFirstChunk;
    private int heightFirstChunk;
    private final int queryEveryMs = 200;
    private Rectangle screenSize = new Rectangle(0, 0, 10, 10);
    private final Controller con;
    private final String machineOrEmpty;
    private final String sessionName;
    private final String escapedSessionName;
    private final byte[] blackPng;
    private final boolean isDemo;
    private static final Object controls_LOCK = new Object();
    private static long controls_checked = 0L;
    private static long controls_modified = 0L;
    private static String controls_begin;
    private static String controls_mid;
    private static String controls_end;
    private static String controls_header;
    private static String controls_css;
    private static File controls_file;
    private final Object keyBytes_LOCK = new Object();
    private final HashMap<Integer, byte[]> keyBytes = new HashMap();
    private final Object CONTROL_REQUEST_LOCK = new Object();
    private final Object SCREEN_REQUEST_LOCK = new Object();
    private final int CAD_SPECIAL = -999999;
    private boolean rightClick = false;
    private boolean doubleClick = false;
    private boolean leftDragBegin = false;
    private boolean leftDragEnd = false;
    private static final boolean CONTROLS_ROUND_BORDER = true;
    private final StringBuffer changed = new StringBuffer();
    private static final boolean VARIABLE_SIZE_FIRST_CHUNK = false;
    private boolean machinePasswordRequired = false;
    private String machinePassword = null;
    private TechPermissionsHandler techPermissionsHandler;
    private TransientTechUser techUser;

    private static String escapeFtp(String ftppath) {
        char[] chars;
        boolean backslash = false;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = ftppath.toCharArray()) {
            if (c == '\\') {
                if (!backslash) {
                    sb.append('\\');
                    sb.append('\\');
                }
                backslash = true;
                continue;
            }
            backslash = false;
            sb.append(c);
        }
        return sb.toString();
    }

    private static void reloadStaticHtml() {
        if (System.currentTimeMillis() - controls_checked > 15000L) {
            controls_checked = System.currentTimeMillis();
            LightweightClientUserInterface.initStatic();
        }
    }

    private static String readFileAsString(String path) throws IOException {
        File targetFile = WebDownloadServer.findLocalFile(path);
        return new String(StreamUtils.readAll(new FileInputStream(targetFile)), "UTF8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initStatic() {
        if (controls_begin != null && controls_file.lastModified() == controls_modified) {
            return;
        }
        Object object = controls_LOCK;
        synchronized (object) {
            try {
                controls_file = WebDownloadServer.findLocalFile("lightweightfiles/html/deployLightweightBody.html");
                controls_modified = controls_file.lastModified();
                String whole = LightweightClientUserInterface.readFileAsString("lightweightfiles/html/deployLightweightBody.html");
                int index1st = whole.indexOf("REPLACEME_TEXTINPUT");
                int index2nd = whole.indexOf("REPLACEME_CONTROLS");
                int len1 = "REPLACEME_TEXTINPUT".length();
                int len2 = "REPLACEME_CONTROLS".length();
                controls_begin = whole.substring(0, index1st);
                controls_mid = whole.substring(index1st + len1, index2nd);
                controls_end = whole.substring(index2nd + len2);
                controls_header = LightweightClientUserInterface.readFileAsString("lightweightfiles/html/deployLightweightHeader.html");
                controls_css = LightweightClientUserInterface.readFileAsString("lightweightfiles/css/simplehelp_session.css");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LightweightClientUserInterface(Controller con, String name, String machine, boolean isDemo) {
        this.con = con;
        this.sessionName = name;
        this.isDemo = isDemo;
        this.page = isDemo ? "demo" : "mobile";
        this.machineOrEmpty = machine != null ? "&mach=" + machine : "";
        if (isDemo) {
            this.PAD = 0;
        }
        LightweightClientUserInterface.initStatic();
        this.escapedSessionName = StringEscaper.escapeToJavascriptString(this.sessionName);
        PngEncoder png = new PngEncoder();
        this.blackPng = png.encode(1, 1, new byte[]{70, 70, 70});
    }

    private int getMapIndex(int x, int y) {
        return x + y * this.numberOfChunksWide;
    }

    private int getKey(int x, int y) {
        return x * 100 + y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getKeyBytes(int x, int y) {
        byte[] tmp;
        Integer key = new Integer(this.getKey(x, y));
        Object object = this.keyBytes_LOCK;
        synchronized (object) {
            tmp = this.keyBytes.get(key);
            if (tmp == null) {
                tmp = StringToAscii.stringToAsciiBytes(key.toString());
                this.keyBytes.put(key, tmp);
            }
        }
        return tmp;
    }

    private void ftpAppendLink(StringBuffer sb, String link, String name, String image, boolean white) {
        if (white) {
            sb.append("\n<tr style='background-color: #FFFFFF'>");
        } else {
            sb.append("\n<tr style='background-color: #DDDDDD'>");
        }
        sb.append("\n<td valign='middle'>");
        sb.append("\n<img border='0' src='");
        sb.append(image);
        sb.append("'>");
        sb.append("\n</td>");
        sb.append("\n<td width='99%' valign='middle' colspan='2'");
        sb.append(" onclick='location.href=\"").append(link).append("\";' ");
        sb.append(">");
        sb.append("\n<h3 style='display:inline'><a href='");
        sb.append(link);
        sb.append("'>").append(name).append("</a></h3>");
        sb.append("\n</td>");
        sb.append("\n</tr>");
    }

    private void ftpAppendElement(String language, StringBuffer sb, String prefix, String name, boolean isDir, long size, boolean white) {
        if (name.startsWith("|D:|")) {
            isDir = true;
            name = name.substring("|D:|".length());
        }
        if (white) {
            sb.append("\n<tr style='background-color: #FFFFFF'>");
        } else {
            sb.append("\n<tr style='background-color: #DDDDDD'>");
        }
        sb.append("\n<td valign='middle'>");
        sb.append("\n<img border='0' src='");
        if (prefix == null) {
            sb.append("lightweightfiles/filetransfer.png");
        } else if (isDir) {
            sb.append("lightweightfiles/folder.png");
        } else {
            sb.append("lightweightfiles/file.png");
        }
        sb.append("'>");
        sb.append("\n</td>");
        if (size >= 0L) {
            sb.append("\n<td valign='middle'>");
            sb.append(DataSizeFormatter.INSTANCE.getFormattedSize(size));
            sb.append("&nbsp;&nbsp;");
            sb.append("\n</td>");
        }
        String link = this.page + "?language=" + language + "&name=" + this.escapedSessionName + this.machineOrEmpty + "&" + (isDir ? "ftp=" : "download=") + LightweightClientUserInterface.escapeFtp(prefix + name);
        if (size < 0L) {
            sb.append("\n<td width='99%' valign='middle' colspan='2' ");
        } else {
            sb.append("\n<td width='99%' valign='middle' ");
        }
        sb.append(" onclick='location.href=\"").append(link).append("\";' ");
        sb.append(">");
        if (prefix == null) {
            sb.append("\n<h2 style='display:inline'>").append(name).append("</h2>");
        } else if (isDir) {
            sb.append("\n<h3 style='display:inline'><a href='");
            sb.append(link);
            sb.append("'>").append(name).append("</a></h3>");
        } else {
            sb.append("\n<h3 style='display:inline'><a href='");
            sb.append(link);
            sb.append("'>").append(name).append("</a></h3>");
        }
        sb.append("\n</td>");
        sb.append("\n</tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestControl() {
        try {
            this.con.sendPermissionsRequest(Language.get("NORTH_PANEL_CONTROL_TITLE"), this.techUser.getDisplayName() + " " + Language.get("NORTH_PANEL_CONTROL_MESSAGE"), new ControlResponseListener());
            Object object = this.CONTROL_REQUEST_LOCK;
            synchronized (object) {
                try {
                    this.CONTROL_REQUEST_LOCK.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestScreen() {
        try {
            this.con.sendPermissionsRequest(Language.get("NORTH_PANEL_CONTROL_TITLE"), this.techUser.getDisplayName() + " " + Language.get("NORTH_PANEL_SCREEN_MESSAGE"), new ScreenResponseListener());
            Object object = this.SCREEN_REQUEST_LOCK;
            synchronized (object) {
                try {
                    this.SCREEN_REQUEST_LOCK.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int getKeyCodeForName(String name) {
        name = name.toUpperCase();
        if ((name = name.trim()).equals("CTRL")) {
            return 17;
        }
        if (name.equals("RETURN")) {
            return 10;
        }
        if (name.equals("ESC")) {
            return 27;
        }
        if (name.equals("SHFT")) {
            return 16;
        }
        if (name.equals("BACK")) {
            return 8;
        }
        if (name.equals("PRSCR")) {
            return 154;
        }
        if (name.equals("PRTSCR")) {
            return 154;
        }
        if (name.equals("WIN")) {
            return 157;
        }
        if (name.equals("WINDOWS")) {
            return 157;
        }
        if (name.equals("APPLE")) {
            return 157;
        }
        if (name.equals("LINUX")) {
            return 157;
        }
        if (name.equals("DEL")) {
            return 127;
        }
        if (name.equals("PGUP") || name.equals("PAGEUP")) {
            return 33;
        }
        if (name.equals("PGDOWN") || name.equals("PGDN") || name.equals("PAGEDOWN")) {
            return 34;
        }
        if (name.equals("DEL")) {
            return 127;
        }
        if (name.equals("CAD")) {
            return -999999;
        }
        try {
            System.out.println("[MobileUI] No key found for combo entry '" + name + "'");
            return ((Number)KeyEvent.class.getDeclaredField("VK_" + name).get(null)).intValue();
        }
        catch (Exception x) {
            return 0;
        }
    }

    public HttpResponse handleQuery(HashMap paramsMap) {
        String image = (String)paramsMap.get("z");
        if (image != null) {
            int y;
            int key = Integer.parseInt(image);
            int x = key / 100;
            int index = this.getMapIndex(x, y = key % 100);
            byte[] dat = (byte[])this.pngs[index];
            if (dat == null || !this.techPermissionsHandler.canView()) {
                return new HttpResponse(this.blackPng, "image/png");
            }
            return new HttpResponse(dat, "image/png");
        }
        String download = (String)paramsMap.get("download");
        String ftp = (String)paramsMap.get("ftp");
        if (download != null) {
            String filename = download.substring(download.lastIndexOf(this.con.getRemoteSeparator().charAt(0)) + 1);
            String mime = MimeTypes.getMimeTypeFor(filename);
            HttpResponse resp = new HttpResponse("", mime, ServerLanguageCollection.isUTF8(paramsMap));
            resp.contentDisposition = "attachment; filename=" + filename + ";";
            int index = download.lastIndexOf(this.con.getRemoteSeparator().charAt(0));
            String remotedir = download.substring(0, index + 1);
            String remotefile = download.substring(index + 1);
            if (CentralDebugging.LIGHTWEIGHT_FILE_TRANSFER) {
                System.out.println("[LightweightFileTransfer] Asked to transfer file " + remotedir + " -- " + remotefile);
            }
            resp.printer = new FileDownloader(this.con.getFileSize(remotedir + remotefile), remotedir, remotefile);
            return resp;
        }
        if (ftp != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("\n<html>");
            sb.append("\n<head>");
            sb.append("\n<title>SimpleHelp</title>");
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb.append("\n</head>");
            sb.append("\n<body style='font-family: sans-serif'>");
            String language = (String)paramsMap.get("language");
            sb.append("\n<table border='0' cellspacing='0' cellpadding='3' width='100%'>");
            String prefix = "";
            boolean white = true;
            boolean displayFolderContents = true;
            ftp = ftp.trim();
            if (ftp.length() == 0) {
                displayFolderContents = false;
                Object[] volumes = this.con.getRemoteVolumes();
                Arrays.sort(volumes);
                if (volumes.length == 1 && ((FTPVolume)volumes[0]).path.equals("/")) {
                    ftp = "/";
                    displayFolderContents = true;
                }
                if (!displayFolderContents) {
                    this.ftpAppendElement(language, sb, null, ServerLanguageCollection.getString(language, "ALL_VOLUMES"), true, -1L, white);
                    white = !white;
                    this.ftpAppendLink(sb, this.page + "?language=" + language + "&name=" + this.escapedSessionName + this.machineOrEmpty, "(" + ServerLanguageCollection.getString(language, "BACK_TO_SCREEN") + ")", "lightweightfiles/backtoscreen.png", white);
                    white = !white;
                    for (Object volume : volumes) {
                        this.ftpAppendElement(language, sb, prefix, ((FTPVolume)volume).path, true, -1L, white);
                        white = !white;
                    }
                }
            }
            if (displayFolderContents) {
                prefix = ftp;
                if (ftp.length() != 1) {
                    prefix = prefix + this.con.getRemoteSeparator();
                }
                String parent = ftp;
                try {
                    parent = parent.substring(0, parent.lastIndexOf(this.con.getRemoteSeparator().charAt(0)));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                this.ftpAppendElement(language, sb, null, ftp, true, -1L, white);
                white = !white;
                this.ftpAppendLink(sb, this.page + "?language=" + language + "&name=" + this.escapedSessionName + this.machineOrEmpty, "(" + ServerLanguageCollection.getString(language, "BACK_TO_SCREEN") + ")", "lightweightfiles/backtoscreen.png", white);
                boolean bl = white = !white;
                if (!ftp.equals("/")) {
                    parent = StringUtil.stripTrailing(parent, "\\");
                    this.ftpAppendLink(sb, this.page + "?language=" + language + "&name=" + this.escapedSessionName + this.machineOrEmpty + "&ftp=" + LightweightClientUserInterface.escapeFtp(parent), "(" + ServerLanguageCollection.getString(language, "PARENT_FOLDER_CAPS") + ")", "lightweightfiles/parent.png", white);
                    white = !white;
                }
                Object[] fents = this.con.getRemoteDir(new RemoteFile(new File(ftp), this.con.getRemoteSeparator().equals("\\")));
                Arrays.sort(fents);
                for (Object fent : fents) {
                    if (!((FileEntry)fent).folder) continue;
                    this.ftpAppendElement(language, sb, prefix, ((FileEntry)fent).name, ((FileEntry)fent).folder, ((FileEntry)fent).size, white);
                    white = !white;
                }
                for (Object fent : fents) {
                    if (((FileEntry)fent).folder) continue;
                    this.ftpAppendElement(language, sb, prefix, ((FileEntry)fent).name, ((FileEntry)fent).folder, ((FileEntry)fent).size, white);
                    white = !white;
                }
            }
            sb.append("\n</table>");
            sb.append("\n</body>");
            sb.append("\n</html>");
            return new HttpResponse(sb.toString(), "text/html");
        }
        String timestamp = (String)paramsMap.get("t");
        if (timestamp != null) {
            return this.produceChangedUpdates(Long.parseLong(timestamp));
        }
        String control = (String)paramsMap.get("control");
        if (CentralDebugging.MOBILE_PRINT_CONTROLS) {
            System.out.println("CONTROL: " + control);
        }
        if (control != null) {
            if (!this.isDemo) {
                if (control.equals("terminate")) {
                    try {
                        this.con.closeConnection();
                    }
                    catch (Throwable prefix) {
                        // empty catch block
                    }
                    try {
                        this.con.terminate();
                    }
                    catch (Throwable prefix) {}
                } else if (control.equals("requestcontrol")) {
                    this.requestControl();
                } else if (control.equals("requestscreen")) {
                    this.requestScreen();
                } else if (control.equals("fullcolor")) {
                    this.con.setColour(true);
                    this.con.setColourDepth(255);
                    this.con.requestScreenResend();
                } else if (control.equals("mediumcolor")) {
                    this.con.setColour(true);
                    this.con.setColourDepth(8);
                    this.con.requestScreenResend();
                } else if (control.equals("blackandwhite")) {
                    this.con.setColour(false);
                    this.con.setColourDepth(8);
                } else if (this.techPermissionsHandler.canControl()) {
                    if (control.equals("cad")) {
                        this.con.sendControlAltDelete();
                    } else if (control.equals("hw_on")) {
                        this.con.setUseHardwareAcceleration(true);
                    } else if (control.equals("hw_off")) {
                        this.con.setUseHardwareAcceleration(false);
                    } else if (control.equals("clearclicks")) {
                        this.rightClick = false;
                        this.doubleClick = false;
                        this.leftDragBegin = false;
                    } else if (control.equals("rightclick")) {
                        this.rightClick = true;
                        this.doubleClick = false;
                        this.leftDragBegin = false;
                    } else if (control.equals("doubleclick")) {
                        this.doubleClick = true;
                        this.rightClick = false;
                        this.leftDragBegin = false;
                    } else if (control.equals("leftdrag")) {
                        this.leftDragBegin = true;
                        this.doubleClick = false;
                        this.rightClick = false;
                    } else if (control.equals("combos")) {
                        String[] combos;
                        String inputText = (String)paramsMap.get("inputtext");
                        if (CentralDebugging.MOBILE_PRINT_INPUT) {
                            System.out.println("Combos: " + inputText);
                        }
                        inputText = inputText.trim().toUpperCase();
                        for (String combo : combos = inputText.split(",")) {
                            ArrayList<Integer> codes = new ArrayList<Integer>();
                            boolean ctrl = false;
                            boolean alt = false;
                            boolean del = false;
                            String[] keys = combo.split(" ");
                            for (String key : keys) {
                                int code = this.getKeyCodeForName(key);
                                if (code == -999999) {
                                    ctrl = true;
                                    alt = true;
                                    del = true;
                                }
                                if (code == 17) {
                                    ctrl = true;
                                }
                                if (code == 18) {
                                    alt = true;
                                }
                                if (code == 127) {
                                    del = true;
                                }
                                codes.add(code);
                            }
                            if (ctrl && alt && del) {
                                this.con.sendControlAltDelete();
                                continue;
                            }
                            for (Integer code : codes) {
                                this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, true));
                            }
                            for (Integer code : codes) {
                                this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, false));
                            }
                        }
                        this.con.flushAllBufferedKeys();
                    } else if (control.equals("typing")) {
                        String inputText = (String)paramsMap.get("inputtext");
                        if (CentralDebugging.MOBILE_PRINT_INPUT) {
                            System.out.println("Typing: " + inputText);
                        }
                        for (char c : inputText.toCharArray()) {
                            this.con.sendKeyRequest(KeyRequest.getKeyRequestForChar(c));
                            this.con.flushAllBufferedKeys();
                        }
                    } else if (control.equals("keydown")) {
                        int key = Integer.parseInt((String)paramsMap.get("key"));
                        String which = (String)paramsMap.get("which");
                        if (CentralDebugging.MOBILE_PRINT_INPUT) {
                            System.out.println("KeyDown: " + key + " / " + which);
                        }
                        this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(key, true));
                        this.con.flushAllBufferedKeys();
                    } else if (control.equals("keyup")) {
                        int key = Integer.parseInt((String)paramsMap.get("key"));
                        String which = (String)paramsMap.get("which");
                        if (CentralDebugging.MOBILE_PRINT_INPUT) {
                            System.out.println("KeyUp: " + key + " / " + which);
                        }
                        this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(key, false));
                        this.con.flushAllBufferedKeys();
                    } else if (control.equals("click")) {
                        int x = (int)Double.parseDouble((String)paramsMap.get("x"));
                        int y = (int)Double.parseDouble((String)paramsMap.get("y"));
                        if (this.rightClick) {
                            this.con.sendMouseDown(x, y, 4, 0, 2);
                            this.con.sendMouseUp(x, y, 4, 0, 2);
                        } else if (this.doubleClick) {
                            this.con.sendMouseDown(x, y, 16, 0, 0);
                            this.con.sendMouseUp(x, y, 16, 0, 0);
                            this.con.sendMouseDown(x, y, 16, 0, 0);
                            this.con.sendMouseUp(x, y, 16, 0, 0);
                        } else if (this.leftDragBegin) {
                            this.leftDragBegin = false;
                            this.leftDragEnd = true;
                            this.con.sendMouseDown(x, y, 16, 0, 0);
                        } else if (this.leftDragEnd) {
                            this.leftDragEnd = false;
                            this.con.sendMouseUp(x, y, 16, 0, 0);
                        } else {
                            this.con.sendMouseDown(x, y, 16, 0, 0);
                            this.con.sendMouseUp(x, y, 16, 0, 0);
                        }
                        this.rightClick = false;
                        this.doubleClick = false;
                    } else if (control.equals("releasemods")) {
                        String[] keys = ((String)paramsMap.get("mods")).split(",");
                        for (int i = 0; i < keys.length; ++i) {
                            keys[i] = keys[i].trim();
                            if (keys[i].length() <= 0) continue;
                            System.out.println("Releasing modifier " + keys[i]);
                            int code = KeysList.getVkMap().get(keys[i]);
                            this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, false));
                        }
                    } else if (control.startsWith("VK_")) {
                        int code = KeysList.getVkMap().get(control);
                        String modOn = (String)paramsMap.get("modon");
                        System.out.println(control + " (" + modOn + ")");
                        if (modOn == null) {
                            this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, true));
                            this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, false));
                        } else {
                            boolean isOn = modOn.equalsIgnoreCase("true");
                            if (isOn) {
                                this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, true));
                            } else {
                                this.con.sendKeyRequest(KeyRequest.getKeyRequestForCode(code, false));
                            }
                        }
                    }
                }
            }
            return new HttpResponse("<x></x>", "text/xml");
        }
        return this.produceSimpleTable((String)paramsMap.get("language"));
    }

    private HttpResponse produceChangedUpdates(long timestamp) {
        return new HttpResponse(new UpdatePrinter(timestamp), "text/plain");
    }

    private void addControl(StringBuffer sb, String button, String controlValue, boolean middle, String description) {
        this.addControl(sb, button, controlValue, middle, description, true);
    }

    private void addControl(StringBuffer sb, String iconSrc, String controlValue, boolean middle, String description, boolean isVisible) {
        sb.append("\n<td width='").append("10%").append("' align='center' valign='top' id='cbutton_").append(controlValue).append("' class='sh_optionsText sh_roundborder sh_greyBackgroundBasic'>\n");
        sb.append("\n<input id='control_").append(controlValue).append("' type='image' src='").append(iconSrc).append("'>\n");
        this.addStandardControlEventListeners(sb, controlValue);
        sb.append("\n<br>\n");
        sb.append(description);
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n<br>\n");
        sb.append("\n</td>\n");
    }

    private void addStandardControlEventListeners(StringBuffer sb, String controlValue) {
        sb.append("\n<script>\n");
        sb.append(" if (isMobile) bindEvent(document.getElementById('control_").append(controlValue).append("'), 'touchstart',doControlTouch);\n");
        sb.append(" if (!isMobile) bindEvent(document.getElementById('control_").append(controlValue).append("'), 'click',doControlStandard);\n");
        sb.append("\n</script>\n");
    }

    private void addModKeyControlEventListeners(StringBuffer sb, String controlValue) {
        sb.append("\n<script>\n");
        sb.append(" if (isMobile) bindEvent(document.getElementById('control_").append(controlValue).append("'), 'touchstart',doControlTouchModkey);\n");
        sb.append(" if (!isMobile) bindEvent(document.getElementById('control_").append(controlValue).append("'), 'click',doControlModkey);\n");
        sb.append("\n</script>\n");
    }

    private HttpResponse produceSimpleTable(String language) {
        int sy;
        LightweightClientUserInterface.reloadStaticHtml();
        StringBuffer sb = new StringBuffer();
        sb.append("\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Strict//EN\">\n");
        sb.append("\n<html>\n");
        sb.append("\n<head>\n");
        sb.append(SDemoHtml.getLanguageEncodingMetaTag(language));
        sb.append("\n<meta name='viewport' content='user-scalable=yes, initial-scale=1.0, width=").append(Math.max(800, this.screenSize.width)).append(", height=").append(Math.max(600, this.screenSize.height)).append("'/>\n");
        sb.append(controls_header);
        sb.append("\n<style type=\"text/css\"><!--\n");
        sb.append(controls_css);
        sb.append("--></style>\n");
        sb.append("\n<script>");
        sb.append("\n");
        sb.append("\nvar controlhttp;");
        sb.append("\nif (window.XMLHttpRequest) {");
        sb.append("\n controlhttp = new XMLHttpRequest();");
        sb.append("\n} else {");
        sb.append("\n if (window.ActiveXObject) {");
        sb.append("\n  controlhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
        sb.append("\n }");
        sb.append("\n}");
        sb.append("\nvar secondaryhttp;");
        sb.append("\nif (window.XMLHttpRequest) {");
        sb.append("\n secondaryhttp = new XMLHttpRequest();");
        sb.append("\n} else {");
        sb.append("\n if (window.ActiveXObject) {");
        sb.append("\n  secondaryhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
        sb.append("\n }");
        sb.append("\n}");
        sb.append("\nvar amTouching = false;");
        sb.append("\nfunction touchStarted(event) {");
        sb.append("\n   amTouching = true;");
        sb.append("\n}");
        sb.append("\nfunction touchEnded(event) {");
        sb.append("\n   amTouching = false;");
        sb.append("\n}");
        sb.append("\nfunction doControlTouch(event) {");
        sb.append("\n blockHide = true;");
        sb.append("\n try {");
        sb.append("\n  event.preventDefault();");
        sb.append("\n } catch (err) {}");
        sb.append("\n doControlStandard(event);");
        sb.append("\n}");
        sb.append("\nfunction doControlTouchModkey(event) {");
        sb.append("\n blockHide = true;");
        sb.append("\n try {");
        sb.append("\n  event.preventDefault();");
        sb.append("\n } catch (err) {}");
        sb.append("\n doControlModkey(event);");
        sb.append("\n}");
        sb.append("\nfunction clearModKeys() {");
        sb.append("\n var turnOff = '';");
        for (String MODIFIER : MODIFIERS) {
            sb.append("\n  if (document.getElementById('mod_control_").append(MODIFIER).append("').dataIsOn == 'true') {");
            sb.append("\n   document.getElementById('mod_control_").append(MODIFIER).append("').className='sh_greyBackgroundBasic sh_roundborder';");
            sb.append("\n   document.getElementById('mod_control_").append(MODIFIER).append("').dataIsOn = 'false';");
            sb.append("\n   turnOff = turnOff + '").append(MODIFIER).append(",';");
            sb.append("\n  }");
        }
        sb.append("\n secondaryhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control=releasemods&mods='+turnOff,true);");
        sb.append("\n secondaryhttp.send(null);");
        sb.append("\n}");
        sb.append("\n function hideControlButton() {");
        sb.append("\n}");
        sb.append("\nfunction doControlModkey(event) {");
        sb.append("\n var contValue = getSource(event).id.substring(8);");
        sb.append("\n var tdId = 'mod_' + getSource(event).id;");
        sb.append("\n var modOn = document.getElementById(tdId).dataIsOn == 'true';");
        sb.append("\n modOn = !modOn;");
        sb.append("\n if (modOn) {");
        sb.append("\n  document.getElementById(tdId).className='sh_greyBackgroundSelected sh_roundborder';");
        sb.append("\n  document.getElementById(tdId).dataIsOn = 'true';");
        sb.append("\n } else {");
        sb.append("\n  document.getElementById(tdId).className='sh_greyBackgroundBasic sh_roundborder';");
        sb.append("\n  document.getElementById(tdId).dataIsOn = 'false';");
        sb.append("\n }");
        sb.append("\n controlhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+contValue+'&modon='+modOn,true);");
        sb.append("\n controlhttp.send(null);");
        sb.append("\n}");
        sb.append("\n\t\tfunction toggleTuneButtons(contValue) {\t\n");
        sb.append("\n\t\t}\n");
        sb.append("\n\t\tfunction setHardwareButton(isOn) {\t\n");
        sb.append("\n\t\t\tvar onNode = document.getElementById('control_hw_on').parentNode;\t\n");
        sb.append("\n\t\t\tvar offNode = document.getElementById('control_hw_off').parentNode;\t\n");
        sb.append("\n\t\t\tif (isOn) {\t\n");
        sb.append("\n\t\t\t\tAddClassName(onNode, 'sh_downRadio', false);\n");
        sb.append("\n\t\t\t\tAddClassName(offNode, 'sh_upRadio', false);\n");
        sb.append("\n\t\t\t\tRemoveClassName(onNode, 'sh_upRadio');\n");
        sb.append("\n\t\t\t\tRemoveClassName(offNode, 'sh_downRadio');\n");
        sb.append("\n\t\t\t} else { ");
        sb.append("\n\t\t\t\tAddClassName(onNode, 'sh_upRadio', false);\n");
        sb.append("\n\t\t\t\tAddClassName(offNode, 'sh_downRadio', false);\n");
        sb.append("\n\t\t\t\tRemoveClassName(onNode, 'sh_downRadio');\n");
        sb.append("\n\t\t\t\tRemoveClassName(offNode, 'sh_upRadio');\n");
        sb.append("\n\t\t}\t\n");
        sb.append("\n\t}\t\n");
        sb.append("\n\t\tfunction setColorDepthButton(isFull) {\t\n");
        sb.append("\n\t\t\tvar onNode = document.getElementById('control_fullcolor').parentNode;\t\n");
        sb.append("\n\t\t\tvar offNode = document.getElementById('control_mediumcolor').parentNode;\t\n");
        sb.append("\n\t\t\tif (isFull) {\t\n");
        sb.append("\n\t\t\t\tAddClassName(onNode, 'sh_downRadio', false);\n");
        sb.append("\n\t\t\t\tAddClassName(offNode, 'sh_upRadio', false);\n");
        sb.append("\n\t\t\t\tRemoveClassName(onNode, 'sh_upRadio');\n");
        sb.append("\n\t\t\t\tRemoveClassName(offNode, 'sh_downRadio');\n");
        sb.append("\n\t\t\t} else { ");
        sb.append("\n\t\t\t\tAddClassName(onNode, 'sh_upRadio', false);\n");
        sb.append("\n\t\t\t\tAddClassName(offNode, 'sh_downRadio', false);\n");
        sb.append("\n\t\t\t\tRemoveClassName(onNode, 'sh_downRadio');\n");
        sb.append("\n\t\t\t\tRemoveClassName(offNode, 'sh_upRadio');\n");
        sb.append("\n\t\t}\t\n");
        sb.append("\n\t}\t\n");
        sb.append("\n\tvar predictiveTextWarned = false;\n");
        sb.append("\n\tfunction warnPredictiveText() {\n");
        sb.append("\n\t\tif (!predictiveTextWarned) {\n");
        sb.append("\n\t\t\tpredictiveTextWarned = true;\n");
        sb.append("\n\t\t\twrn('").append(ServerLanguageCollection.getString(language, "MOBILE_DISABLE_PREDTEXT")).append("',5000);\n");
        sb.append("\n\t\t}\t\n");
        sb.append("\n\t}\t\n");
        sb.append("\n\tfunction doControlStandard(event) {\t\n ");
        sb.append("\n\t\tvar contValue = getSource(event).id.substring(8);");
        sb.append("\n \t\tif (contValue == 'keyboard') {");
        sb.append("\n\t\t\tdeselect('cbutton_doubleclick');");
        sb.append("\n\t\t\tdeselect('cbutton_rightclick');");
        sb.append("\n\t\t\tdeselect('cbutton_leftdrag');");
        sb.append("\n  \t\t\ttoggleKeyboard();");
        sb.append("\n \t \t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control=clearclicks',true);");
        sb.append("\n  \t\t\tcontrolhttp.send(null);");
        sb.append("\n \t\t} else if (contValue == 'combos') {");
        sb.append("\n  \t\t\ttoggleCombos();");
        sb.append("\n \t\t} else if (contValue == 'requestscreen') {");
        sb.append("\n \t\t\t requestScreen();");
        sb.append("\n \t\t} else if (contValue == 'requestcontrol') {");
        sb.append("\n \t\t\t requestControl();");
        sb.append("\n \t\t} else if (contValue == 'configure') {");
        sb.append("\n \t\t\t showConfigureControls();");
        sb.append("\n \t\t} else if (contValue == 'tuneConnection') {");
        sb.append("\n\t\t\tshowTuneConnectionControls();");
        sb.append("\n \t\t} else if (contValue == 'filetransfer') {");
        sb.append("\n\t\t\ttemporarySelect('cbutton_filetransfer');");
        sb.append("\n  \t\t\tswitchToFileTransfer();");
        sb.append("\n \t\t} else if (contValue == 'selectedkey') {");
        sb.append("\n \t\t\tvar selKeys = document.getElementById('selectedKeyBox');");
        sb.append("\n  \t\t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+(selKeys.options[selKeys.selectedIndex].value),true);");
        sb.append("\n  \t\t\tcontrolhttp.send(null);");
        sb.append("\n \t\t} else if (contValue == 'quality') {");
        sb.append("\n\t\t\ttoggleQuality();");
        sb.append("\n\t \t} else if (contValue == 'scaling') {");
        sb.append("\n\t\t\ttoggleScaling();");
        sb.append("\n \t\t} else if (contValue == 'fitToScreen') {");
        sb.append("\n\t\t\tfitToScreen();");
        sb.append("\n \t\t} else if (contValue == 'fitToOriginal') {");
        sb.append("\n\t\t\tfitToOriginal();");
        sb.append("\n \t\t} else if (contValue.indexOf('VK_') == 0 || contValue == 'hw_on' || contValue == 'hw_off' || contValue == 'fullcolor' || contValue == 'mediumcolor' || contValue == 'blackandwhite') {");
        sb.append("\n\t\t\ttoggleTuneButtons(contValue);\n");
        sb.append("\n  \t\t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+contValue,true);");
        sb.append("\n  \t\t\tcontrolhttp.send(null);");
        sb.append("\n \t\t} else { ");
        sb.append("\n \t  \t\tif (contValue == 'doubleclick') {");
        sb.append("\n\t\t\t\tif (!isSelected('cbutton_doubleclick')) {");
        sb.append("\n\t\t\t  \t\tselect('cbutton_doubleclick');");
        sb.append("\n\t\t\t\t} else {");
        sb.append("\n\t\t\t  \t\tdeselect('cbutton_doubleclick');");
        sb.append("\n\t\t\t  \t\tcontValue = 'clearclicks';");
        sb.append("\n\t\t\t\t}");
        sb.append("\n \t  \t\t} else if (contValue == 'rightclick') {");
        sb.append("\n\t\t\t\tif (!isSelected('cbutton_rightclick')) {");
        sb.append("\n\t\t\t  \t\tselect('cbutton_rightclick');");
        sb.append("\n\t\t\t\t} else {");
        sb.append("\n\t\t\t  \t\tdeselect('cbutton_rightclick');");
        sb.append("\n\t\t\t  \t\tcontValue = 'clearclicks';");
        sb.append("\n\t\t\t\t}");
        sb.append("\n \t  \t\t} else if (contValue == 'leftdrag') {");
        sb.append("\n\t\t\t\tif (!isSelected('cbutton_leftdrag')) {");
        sb.append("\n\t\t\t  \t\tselect('cbutton_leftdrag');");
        sb.append("\n\t\t\t\t} else {");
        sb.append("\n\t\t\t  \t\tdeselect('cbutton_leftdrag');");
        sb.append("\n\t\t\t  \t\tcontValue = 'clearclicks';");
        sb.append("\n\t\t\t\t}");
        sb.append("\n \t  \t\t} else if (contValue == 'terminate') {");
        sb.append("\n\t\t\t\tselect('cbutton_terminate');");
        sb.append("\n \t\t  \t}");
        sb.append("\n \t \t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+contValue,true);");
        sb.append("\n  \t\t\tcontrolhttp.send(null);");
        sb.append("\n  \t\t\tclearModKeys();");
        sb.append("\n\t\t}");
        sb.append("\n\t}");
        sb.append("\nfunction sendControlValue(controlvalue) {");
        sb.append("\n controlhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+controlvalue,true);");
        sb.append("\n controlhttp.send(null);");
        sb.append("\n}");
        sb.append("\nfunction requestControl() {");
        sb.append("\n  sendControlValue('requestcontrol');");
        sb.append("\n}");
        sb.append("\nfunction requestScreen() {");
        sb.append("\n  sendControlValue('requestscreen');");
        sb.append("\n}");
        sb.append("\nfunction sendOngoingControlValue(controlvalue) {");
        sb.append("\n controlhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control='+controlvalue,true);");
        sb.append("\n controlhttp.send(null);");
        sb.append("\n}");
        sb.append("\nfunction sendText() {");
        sb.append("\n document.getElementById('typingBox').blur();");
        sb.append("\n sendControlValue('typing&inputtext='+encodeURIComponent(document.getElementById(\"typingBox\").value));");
        sb.append("\n document.getElementById('typingBox').value='';");
        sb.append("\n document.getElementById('textinputSpan').style.display='none';");
        sb.append("\n return false;");
        sb.append("\n}");
        sb.append("\nfunction sendCombos() {");
        sb.append("\n deselect('cbutton_combos');");
        sb.append("\n document.getElementById('typingcomboBox').blur();");
        sb.append("\n sendControlValue('combos&inputtext='+encodeURIComponent(document.getElementById(\"typingcomboBox\").value));");
        sb.append("\n document.getElementById('textcomboSpan').value='';");
        sb.append("\n document.getElementById('textcomboSpan').style.display='none';");
        sb.append("\n return false;");
        sb.append("\n}");
        sb.append("\nfunction sendKeyPress(event) {");
        sb.append("\n var code = (event.keyCode ? event.keyCode : event.which);");
        sb.append("\n if (code == 13) code = 10;  //iOS Return mapped to ENTER");
        sb.append("\n msgadd('Sendkey: '+code);");
        sb.append("\n if (code) {");
        sb.append("\n   sendOngoingControlValue('keyup&key='+code+'&which='+event.shiftKey);");
        sb.append("\n   sendOngoingControlValue('keydown&key='+code+'&which='+event.shiftKey);");
        sb.append("\n }");
        sb.append("\n msgadd('(OK)');");
        sb.append("\n}");
        sb.append("\nfunction sendKeyDown(event) {");
        sb.append("\n var code = (event.keyCode ? event.keyCode : event.which);");
        sb.append("\n if (code) {");
        sb.append("\n   sendOngoingControlValue('keydown&key='+code+'&which='+event.shiftKey);");
        sb.append("\n }");
        sb.append("\n}");
        sb.append("\nfunction sendKeyUp(event) {");
        sb.append("\n var code = (event.keyCode ? event.keyCode : event.which);");
        sb.append("\n if (code) {");
        sb.append("\n   sendOngoingControlValue('keyup&key='+code+'&which='+event.shiftKey);");
        sb.append("\n }");
        sb.append("\n}");
        if (this.isDemo) {
            sb.append("hideControlButton();\n");
        }
        sb.append("\n</script>");
        sb.append("\n</head>\n");
        sb.append("\n<body id='lightweightBody' onload='initAll()' style='text-align: center'>\n");
        sb.append(controls_begin);
        sb.append("\n<div id='typingControls' width='50px'>");
        if (this.techPermissionsHandler.canControlOrRequestControl()) {
            sb.append("\n<table width='100%' class='sh_roundborder sh_greyBackgroundBasic'>");
            sb.append("\n<tr>");
            sb.append("\n<td width='1%' valign='middle' style='padding: 5px;' class='sh_lightTextColor'>Aa</td>");
            sb.append("\n<td width='99%'>");
            sb.append("\n<form style='display:inline' action='' onsubmit='return sendText()'>");
            sb.append("\n<textarea style='display:inline; padding: 3px; width:95%, background:rgba(0,0,0,0)' onfocus='rePos(this);' id='typingBox' class='sh_inputTextColor' type='password' name='password' autocomplete=\"off\" autocorrect=\"off\" autocapitalize=\"off\" spellcheck=\"false\"></textarea>");
            sb.append("\n</form>");
            sb.append("\n</td>");
            sb.append("\n</tr>");
            sb.append("\n</table>");
        }
        sb.append("\n</div>");
        sb.append(controls_mid);
        if (!this.isDemo) {
            sb.append("\n<tr>");
            sb.append("\n<td width='100%' height='1%' align='center'>");
            sb.append("\n<div id='mainControls' width='50px'>");
            sb.append("\n<table width='100%' class='sh_controlsTable' id='mainControlsTable'>");
            sb.append("\n<tr>");
            if (!this.techPermissionsHandler.canView() && this.techPermissionsHandler.needToRequestControl()) {
                this.addControl(sb, "lightweightfiles/screenbig.png", "requestscreen", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_VIEW"));
                this.addControl(sb, "lightweightfiles/keyboardbig.png", "requestcontrol", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_VIEW_AND_CONTROL"));
            } else if (this.techPermissionsHandler.canView() && this.techPermissionsHandler.needToRequestControl()) {
                this.addControl(sb, "lightweightfiles/keyboardbig.png", "requestcontrol", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_CONTROL"));
            } else {
                this.addControl(sb, "lightweightfiles/keyboardbig.png", "keyboard", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_KEYBOARD"));
                this.addControl(sb, "lightweightfiles/mousebig_double.png", "doubleclick", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_DOUBLE"));
                this.addControl(sb, "lightweightfiles/mousebig_right.png", "rightclick", true, ServerLanguageCollection.getString(language, "MOBILE_OPTION_RIGHT"));
                this.addControl(sb, "lightweightfiles/mousebig_drag.png", "leftdrag", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_DRAG"));
            }
            if (this.techPermissionsHandler.canView()) {
                this.addControl(sb, "lightweightfiles/color.png", "quality", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_QUALITY"));
                this.addControl(sb, "lightweightfiles/zoom_in.png", "scaling", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_SCALE"));
            }
            if (this.techPermissionsHandler.canControl()) {
                this.addControl(sb, "lightweightfiles/login.png", "combos", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_COMBOS"));
                if (this.techPermissionsHandler.getPermissions().canUseFileTransfer()) {
                    this.addControl(sb, "lightweightfiles/folderbig.png", "filetransfer", true, ServerLanguageCollection.getString(language, "MOBILE_OPTION_FILES"));
                }
            }
            this.addControl(sb, "lightweightfiles/quitbig.png", "terminate", false, ServerLanguageCollection.getString(language, "MOBILE_OPTION_FINISH"));
            sb.append("\n</tr>");
            sb.append("\n</table>");
            sb.append("\n</div>");
            sb.append("\n<div id='keyboardControls'>");
            sb.append("\n</div>");
            sb.append("\n<div id='configureControls'>");
            sb.append("\n</div>");
            sb.append("\n<div id='tuneConnectionControls' width='100%'>");
            sb.append("\n</div>");
            sb.append("\n</td>");
            sb.append("\n</tr>");
            sb.append("\n<script>");
            sb.append("\nfunction showMainControls() {");
            sb.append("\n document.getElementById('mainControls').style.display = \"\";");
            sb.append("\n document.getElementById('keyboardControls').style.display = 'none';");
            sb.append("\n document.getElementById('configureControls').style.display = 'none';");
            sb.append("\n document.getElementById('tuneConnectionControls').style.display = 'none';");
            sb.append("\n document.getElementById('typingControls').style.display = \"\";");
            sb.append("\n document.getElementById('keysControls').style.display = 'none';");
            sb.append("\n document.getElementById('pulloutImage').src = 'lightweightfiles/pulloutbig.png';");
            sb.append("\n}");
            sb.append("\nfunction showKeyboardControls() {");
            sb.append("\n document.getElementById('mainControls').style.display = 'none';");
            sb.append("\n document.getElementById('keyboardControls').style.display = \"\";");
            sb.append("\n document.getElementById('configureControls').style.display = 'none';");
            sb.append("\n document.getElementById('tuneConnectionControls').style.display = 'none';");
            sb.append("\n document.getElementById('typingControls').style.display = \"\";");
            sb.append("\n document.getElementById('keysControls').style.display = \"\";");
            sb.append("\n document.getElementById('pulloutImage').src = 'lightweightfiles/pullbackbig.png';");
            sb.append("\n}");
            sb.append("\nfunction showConfigureControls() {");
            sb.append("\n document.getElementById('mainControls').style.display = 'none';");
            sb.append("\n document.getElementById('keyboardControls').style.display = 'none';");
            sb.append("\n document.getElementById('configureControls').style.display = \"\";");
            sb.append("\n document.getElementById('typingControls').style.display = \"\";");
            sb.append("\n document.getElementById('tuneConnectionControls').style.display = 'none';");
            sb.append("\n document.getElementById('keysControls').style.display = 'none';");
            sb.append("\n document.getElementById('pulloutImage').src = 'lightweightfiles/pullbackbig.png';");
            sb.append("\n}");
            sb.append("\nfunction showTuneConnectionControls() {");
            sb.append("\n document.getElementById('mainControls').style.display = 'none';");
            sb.append("\n document.getElementById('keyboardControls').style.display = 'none';");
            sb.append("\n document.getElementById('configureControls').style.display = 'none';");
            sb.append("\n document.getElementById('typingControls').style.display = 'none';");
            sb.append("\n document.getElementById('tuneConnectionControls').style.display = \"\";");
            sb.append("\n document.getElementById('keysControls').style.display = 'none';");
            sb.append("\n document.getElementById('pulloutImage').src = 'lightweightfiles/pullbackbig.png';");
            sb.append("\n}");
            sb.append("\nfunction switchToFileTransfer() {");
            sb.append("\n window.location='").append(this.page).append("?language=").append(language).append(this.machineOrEmpty).append("&name=").append(this.escapedSessionName).append("&ftp=';");
            sb.append("\n}");
            sb.append("var showingFitted = 'true';\n");
            sb.append("\nfunction fitToScreen() {");
            sb.append(" \tshowingFitted = 'true';\n");
            sb.append("\t\tresizeToFit = true;\n");
            sb.append("\t\tresizeChunks();\n");
            sb.append("\n}");
            sb.append("\nfunction fitToOriginal() {\n");
            sb.append(" \tshowingFitted = 'false';\n");
            sb.append("\t\tresizeToFit = false;\n");
            sb.append("\t\tresizeChunks();\n");
            sb.append("\n}");
            sb.append("\nfunction toggleScaling() {\n");
            sb.append("\t\tif (showingFitted == 'true') {\n");
            sb.append("\t\t\tselect('cbutton_scaling',0);\n");
            sb.append("\t\t\tlastSelected = null;\n");
            sb.append("\n");
            sb.append("\t\t    msg('Fitting to original...');\n");
            sb.append("\t\t    fitToOriginal();\n");
            sb.append("\t\t    msg('Fitting to original (OK)');\n");
            sb.append("\t\t} else {\n");
            sb.append("\t\t\tdeselect('cbutton_scaling');\n");
            sb.append("\n");
            sb.append("\t\t    msg('Fitting to screen...');\n");
            sb.append("\t\t\tfitToScreen();\n");
            sb.append("\t\t    msg('Fitting to screen (OK)');\n");
            sb.append("\t\t}\n");
            sb.append("\n}");
            sb.append("var showingFullColor = 'false';\n");
            sb.append("\nfunction toggleQuality() {\n");
            sb.append("\t\tif (showingFullColor == 'true') {\n");
            sb.append("\t\t\tdeselect('cbutton_quality');\n");
            sb.append("\t\t    msg('Showing banded color...');\n");
            sb.append("\t\t    showingFullColor = 'false';\n");
            sb.append("  \t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control=mediumcolor',true);\n");
            sb.append("\n  \t\tcontrolhttp.send(null);");
            sb.append("\t\t    msg('Showing banded color (OK)');\n");
            sb.append("\t\t} else {\n");
            sb.append("\t\t\tselect('cbutton_quality',0);\n");
            sb.append("\t\t\tlastSelected = null;\n");
            sb.append("\t\t    msg('Showing full color...');\n");
            sb.append("\t\t    showingFullColor = 'true';\n");
            sb.append("  \t\tcontrolhttp.open('GET','/").append(this.page).append("?name=").append(this.escapedSessionName).append("&control=fullcolor',true);\n");
            sb.append("\n  \t\tcontrolhttp.send(null);");
            sb.append("\t\t    msg('Showing full color (OK)');\n");
            sb.append("\t\t}\n");
            sb.append("}\n");
            sb.append(" document.addEventListener('touchstart',touchStarted, false);\n");
            sb.append(" document.addEventListener('touchend',touchEnded, false);\n");
            sb.append(" document.addEventListener('touchcancel',touchEnded, false);\n");
            sb.append(" document.addEventListener('touchleave',touchEnded, false);\n");
            sb.append("\n</script>");
        }
        sb.append(controls_end);
        sb.append("\n <div id='textcomboSpan' style='z-index:10; position: absolute; bottom:0%; left: 0%; width: 300px; color: white; padding: 0px; display:none'>");
        sb.append("\n  <table width='100%' height='100%' id='textinputTable' cellspacing='0' cellpadding='0' border='0'>");
        sb.append("\n<table width='100%' class='sh_roundborder sh_greyPopupPlain'>");
        sb.append("\n<tr>");
        sb.append("\n<td width='1%' valign='middle' style='padding: 5px; white-space: nowrap' class='sh_lightTextColor'>").append(Language.get("MOBILE_OPTION_TYPING_COMBOS")).append("<br>").append(Language.get("MOBILE_OPTION_TYPING_COMBOS_2")).append("</td>");
        sb.append("\n<td width='99%'>");
        sb.append("\n<form style='display:inline' action='' onsubmit='return sendCombos()'>");
        sb.append("\n<span><input autocomplete=\"off\" autocorrect=\"off\" autocapitalize=\"off\" spellcheck=\"false\" style='display:inline; padding: 3px; width:95%; box-sizing:border-box' id='typingcomboBox' class='sh_inputTextColor' type='text' name='combos'></span>");
        sb.append("\n</form>");
        sb.append("\n</td>");
        sb.append("\n</tr>");
        sb.append("\n</table>");
        sb.append("\n  </table>");
        sb.append("\n </div>");
        sb.append("\n<span id='mousePointerId' style='position:absolute; left:0px; top:0px; '><img src='lightweightfiles/presentationcursor.png'></span>");
        sb.append("\n<div align=\"center\">");
        sb.append("\n<table id='chunkTable' border='0px' cellspacing='0px' cellpadding='0px' style='padding-right:" + this.PAD + "px; margin: " + this.PAD + "px " + this.PAD + "px " + this.PAD + "px " + this.PAD + "px'>");
        if (!this.isDemo) {
            sb.append("\n<script>");
            sb.append("\n document.getElementById('chunkTable').onmousedown = mouseClick;");
            sb.append("\nfunction mouseClick(evt) {");
            sb.append("\n var offset = findAbsPos(document.getElementById('chunkTable'));");
            sb.append("\n var evt = evt || window.event;");
            sb.append("\n var posx = 0;");
            sb.append("\n var posy = 0;");
            sb.append("\n msgadd('Mouse');");
            sb.append("\nif (evt.pageX || evt.pageY)");
            sb.append("\n{");
            sb.append("\n msgadd('Page');");
            sb.append("\n\tposx = evt.pageX - offset[0];");
            sb.append("\n\tposy = evt.pageY - offset[1];");
            sb.append("\n}");
            sb.append("\nelse if (evt.clientX || evt.clientY) \t");
            sb.append("\n{");
            sb.append("\n msgadd('Client');");
            sb.append("\n\tposx = evt.clientX + document.body.scrollLeft + document.documentElement.scrollLeft - offset[0];");
            sb.append("\n\tposy = evt.clientY + document.body.scrollTop + document.documentElement.scrollTop - offset[1];");
            sb.append("\n}");
            sb.append("\n msgadd('Factor '+factor);");
            sb.append("\nposx = posx / factor;");
            sb.append("\nposy = posy / factor;");
            sb.append("\n if (lastSelected) deselect(lastSelected);");
            sb.append("\n msgadd('(Sending)');");
            sb.append("\n sendControlValue('click&x='+posx+'&y='+posy);");
            sb.append("\n}");
            sb.append("\n</script>");
        }
        for (sy = 0; sy < this.numberOfChunksHigh; ++sy) {
            int ch;
            sb.append("<tr>");
            if (sy == this.numberOfChunksHigh - 1 && this.heightLastChunk != 0) {
                ch = this.heightLastChunk;
            } else {
                if (sy == 0) {
                    // empty if block
                }
                ch = 128;
            }
            for (int sx = 0; sx < this.numberOfChunksWide; ++sx) {
                int cw;
                if (sx == this.numberOfChunksWide - 1 && this.widthLastChunk != 0) {
                    cw = this.widthLastChunk;
                } else {
                    if (sx == 0) {
                        // empty if block
                    }
                    cw = 128;
                }
                sb.append("<td><img style=\"display:block;\" id='").append(this.getKey(sx, sy)).append("' src='").append("lightweightfiles/grey.png").append("' border='0px' width='").append(cw).append("px' width='").append(ch).append("px'></td>");
            }
            sb.append("</tr>");
        }
        sb.append("\n</table>");
        sb.append("\n</div>");
        sb.append("\n<div id='lowerText' style='text-align: left'>");
        sb.append("\n</div>");
        sb.append("\n<script>");
        sb.append("\nvar mouseX = 20;");
        sb.append("\nvar mouseY = 20;");
        sb.append("\nvar myDemoTimestamp = 0;");
        sb.append("\nvar checkTimeout = 200;");
        sb.append("\nvar screenRefresh = ").append(this.screenRefresh).append(";");
        sb.append("\nvar xmlhttp;");
        sb.append("\nif (window.XMLHttpRequest) {");
        sb.append("\n xmlhttp = new XMLHttpRequest();");
        sb.append("\n} else {");
        sb.append("\n if (window.ActiveXObject) {");
        sb.append("\n  xmlhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
        sb.append("\n }");
        sb.append("\n}");
        sb.append("\nvar demoUpdates = [0,0];");
        sb.append("\nvar updatedPngs = 0;");
        sb.append("\nfunction countdownToRefresh() {");
        sb.append("\n if (updatedPngs == 0) return;");
        sb.append("\n updatedPngs--;");
        sb.append("\n if (updatedPngs == 0) delayedCheckForUpdates();");
        sb.append("\n}");
        sb.append("\nfunction processUpdates() {");
        sb.append("\nif (xmlhttp.readyState != 4) return;");
        sb.append("\nif (xmlhttp.status == 200) {");
        sb.append("\nif (xmlhttp.responseText.search('").append(SDemoHtml.NOT_FOUND_MARKER).append("') != -1) window.location='").append(this.page).append("?language=").append(language).append("&name=").append(this.escapedSessionName).append("&finished=yes").append("';");
        sb.append("\ndemoUpdates = eval(xmlhttp.responseText);");
        sb.append("\nmouseX = demoUpdates[demoUpdates.length-5];");
        sb.append("\nmouseY = demoUpdates[demoUpdates.length-4];");
        sb.append("\nupdateMousePointer();");
        sb.append("\nmyDemoTimestamp = demoUpdates[demoUpdates.length-3];");
        sb.append("\ncheckTimeout = demoUpdates[demoUpdates.length-2];");
        sb.append("\nvar curScreen = demoUpdates[demoUpdates.length-1];");
        sb.append("\ndemoUpdates.length = demoUpdates.length-5;");
        sb.append("\nif (curScreen != screenRefresh) {");
        sb.append("\n window.location.reload();");
        sb.append("\n}");
        sb.append("var currPng;");
        sb.append("var pixkey;");
        sb.append("var pixdata;");
        sb.append("var total=0;");
        sb.append("\nfor (var pix=0; pix < demoUpdates.length; pix+=2) {");
        sb.append("\npixkey = demoUpdates[pix];");
        sb.append("\npixdata = demoUpdates[pix+1];");
        sb.append("\nvar currPng = document.getElementById(pixkey);");
        sb.append("\nif (currPng) {");
        sb.append("\ncurrPng.src = 'data:image/png;base64,'+pixdata;");
        sb.append("\n}");
        sb.append("");
        sb.append("\n}");
        sb.append("\n setTimeout('checkForUpdates();',checkTimeout);");
        sb.append("\n}");
        sb.append("\n}");
        sb.append("\nfunction findAbsPos(obj) {");
        sb.append("\nvar curleft = 0;");
        sb.append("\nvar curtop = 0;");
        sb.append("\nif (obj.offsetParent) {");
        sb.append("\n  do {");
        sb.append("\n    curleft += obj.offsetLeft;");
        sb.append("\n    curtop += obj.offsetTop;");
        sb.append("\n  } while (obj = obj.offsetParent);");
        sb.append("\n}");
        sb.append("\nreturn [curleft,curtop];");
        sb.append("\n}");
        sb.append("\nfunction updateMousePointer() {");
        sb.append("\nvar factorX = parseFloat(document.getElementById('chunkTable').offsetWidth - " + this.PAD + ") / ").append(this.screenSize.width).append(".0;");
        sb.append("\nvar factorY = parseFloat(document.getElementById('chunkTable').offsetHeight) / ").append(this.screenSize.height).append(".0;");
        sb.append("\nvar offset = findAbsPos(document.getElementById('chunkTable'));");
        sb.append("\nvar newValueTop  = (offset[1] + parseInt(parseFloat(mouseY) * factorY))+'px';");
        sb.append("\nvar newValueLeft = (offset[0] + parseInt(parseFloat(mouseX) * factorX))+'px';");
        sb.append("\ndocument.getElementById('mousePointerId').style.left = newValueLeft;");
        sb.append("\ndocument.getElementById('mousePointerId').style.top = newValueTop;");
        sb.append("\n}");
        sb.append("\nfunction checkForUpdates() {");
        sb.append("\nxmlhttp.onreadystatechange = processUpdates;");
        sb.append("\nvar url = '/").append(this.page).append("?name=").append(this.escapedSessionName).append("&t=").append("'+myDemoTimestamp;");
        sb.append("\nxmlhttp.open('GET',url,true);");
        sb.append("\nxmlhttp.send(null);");
        sb.append("\n}");
        sb.append("\nfunction delayedCheckForUpdates() {");
        sb.append("\nsetTimeout('checkForUpdates();',checkTimeout);");
        sb.append("\n}");
        sb.append("\nvar factor;");
        sb.append("\nvar resizeToFit = true; ");
        sb.append("\nfunction resizeChunks() {");
        sb.append("\nfactor =  (document.body.clientWidth)/").append(this.screenSize.width).append(";");
        sb.append("\n if (!resizeToFit) {");
        sb.append("factor = 1;");
        sb.append("\n}");
        sb.append("\n if (factor > 1) {");
        sb.append("factor = 1;");
        sb.append("\n}");
        sb.append("\nvar fullWidth = parseInt((factor * 128));");
        sb.append("\nvar fullHeight = fullWidth;");
        sb.append("\nvar firstWidth = parseInt((factor * ").append(this.widthFirstChunk).append("));");
        sb.append("\nvar firstHeight = parseInt((factor * ").append(this.heightFirstChunk).append("));");
        sb.append("\nvar lastWidth = parseInt((factor * ").append(this.widthLastChunk).append("));");
        sb.append("\nvar lastHeight = parseInt((factor * ").append(this.heightLastChunk).append("));");
        for (sy = 0; sy < this.numberOfChunksHigh; ++sy) {
            String ch;
            if (sy == this.numberOfChunksHigh - 1 && this.heightLastChunk != 0) {
                ch = "lastHeight";
            } else {
                if (sy == 0) {
                    // empty if block
                }
                ch = "fullHeight";
            }
            for (int sx = 0; sx < this.numberOfChunksWide; ++sx) {
                String cw;
                if (sx == this.numberOfChunksWide - 1 && this.widthLastChunk != 0) {
                    cw = "lastWidth";
                } else {
                    if (sx == 0) {
                        // empty if block
                    }
                    cw = "fullWidth";
                }
                sb.append("\n document.getElementById('").append(this.getKey(sx, sy)).append("').width = ").append(cw).append(";");
                sb.append("\n document.getElementById('").append(this.getKey(sx, sy)).append("').height = ").append(ch).append(";");
            }
        }
        sb.append("\nupdateMousePointer();");
        sb.append("\n}");
        sb.append("\nwindow.onresize = resizeChunks;");
        sb.append("\nresizeChunks();");
        sb.append("\nsetTimeout('checkForUpdates();',checkTimeout);");
        if (this.techPermissionsHandler != null) {
            if (!this.techPermissionsHandler.canView() && this.techPermissionsHandler.needToRequestControl()) {
                sb.append("wrn('").append(ServerLanguageCollection.getString(language, "MOBILE_REQUEST_SCREEN_MESSAGE")).append("',0);");
            } else if (!this.techPermissionsHandler.canControl()) {
                sb.append("wrn('").append(ServerLanguageCollection.getString(language, "MOBILE_REQUEST_CONTROL_MESSAGE")).append("',6000);");
            }
        }
        sb.append("\n</script>");
        sb.append("\n</body>");
        sb.append("\n</html>");
        return new HttpResponse(sb.toString(), "text/html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getEmbeddedImageList(long myTimestamp) {
        ArrayList<Object> list = new ArrayList<Object>();
        int contentLen = 0;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.techPermissionsHandler.canView()) {
                int px = 0;
                int py = 0;
                for (int i = 0; i < this.indices.length; ++i) {
                    if (this.pngs[i] == null) {
                        if (!CentralDebugging.PX_VERBOSE_SCREEN_PNGS) break;
                        System.out.println("[LightweightClientUserInterface] No more PNGs after point " + i);
                        break;
                    }
                    px = i % this.numberOfChunksWide;
                    if (this.indices[i] < myTimestamp) continue;
                    py = i / this.numberOfChunksWide;
                    int index = this.getMapIndex(px, py);
                    byte[] pngdat = (byte[])this.pngs[index];
                    byte[] keyStr = this.getKeyBytes(px, py);
                    contentLen = contentLen + keyStr.length + pngdat.length + 4;
                    list.add(keyStr);
                    list.add(pngdat);
                }
            }
            this.changed.setLength(0);
            this.changed.append(this.pointerX);
            this.changed.append(',');
            this.changed.append(this.pointerY);
            this.changed.append(',');
            this.changed.append(this.logicalTimestamp);
            this.changed.append(',');
            if (CentralDebugging.SET_LIGHTWEIGHT_QUERY_MS != 0) {
                this.changed.append(CentralDebugging.SET_LIGHTWEIGHT_QUERY_MS);
            } else {
                this.changed.append(200);
            }
            this.changed.append(',');
            this.changed.append(this.screenRefresh);
            byte[] end = StringToAscii.stringToAsciiBytes(this.changed);
            list.add(end);
            list.add(new Integer(contentLen += end.length));
        }
        return list;
    }

    private void printEmbeddedImageList(ArrayList list, OutputStream out) throws IOException {
        int len = list.size() - 2;
        for (int i = 0; i < len; i += 2) {
            byte[] key = (byte[])list.get(i);
            byte[] pngdat = (byte[])list.get(i + 1);
            out.write(key);
            out.write(44);
            out.write(39);
            out.write(pngdat);
            out.write(39);
            out.write(44);
        }
        out.write((byte[])list.get(len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getChangedList(long myTimestamp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.changed.setLength(0);
            long startKey = -1L;
            int adv = 0;
            int px = 0;
            int py = 0;
            for (int i = 0; i < this.indices.length && this.pngs[i] != null; ++i) {
                px = i % this.numberOfChunksWide;
                if (px == 0 && startKey != -1L) {
                    this.changed.append(startKey).append(',');
                    this.changed.append(adv).append(',');
                    startKey = -1L;
                    adv = 0;
                }
                if (this.indices[i] >= myTimestamp) {
                    py = i / this.numberOfChunksWide;
                    ++adv;
                    if (startKey != -1L) continue;
                    startKey = this.getKey(px, py);
                    continue;
                }
                if (startKey == -1L) continue;
                this.changed.append(startKey).append(',');
                this.changed.append(adv).append(',');
                startKey = -1L;
                adv = 0;
            }
            if (startKey != -1L) {
                this.changed.append(startKey).append(',');
                this.changed.append(adv).append(',');
                startKey = -1L;
                adv = 0;
            }
            this.changed.append(this.pointerX);
            this.changed.append(',');
            this.changed.append(this.pointerY);
            this.changed.append(',');
            this.changed.append(this.logicalTimestamp);
            this.changed.append(',');
            this.changed.append(200);
            this.changed.append(',');
            this.changed.append(this.screenRefresh);
            return this.changed.toString();
        }
    }

    @Override
    public Rectangle getGrabRectangle() {
        return this.screenSize;
    }

    @Override
    public void setScreenSize(int x, int y, int w, int h, ScreenDimension[] screens, int remoteScalingPercentage) {
        if (this.screenSize != null && this.screenSize.x == x && this.screenSize.y == y && this.screenSize.width == w && this.screenSize.height == h) {
            return;
        }
        this.forceClientToUpdateScreen();
        this.screenSize = new Rectangle(x, y, w, h);
        if (this.con != null) {
            this.con.setFiltering(53);
        }
        this.numberOfChunksWide = this.screenSize.width / 128;
        this.numberOfChunksHigh = this.screenSize.height / 128;
        if (this.screenSize.width % 128 != 0) {
            ++this.numberOfChunksWide;
            this.widthLastChunk = this.screenSize.width % 128;
        } else {
            this.widthLastChunk = 0;
        }
        if (this.screenSize.height % 128 != 0) {
            ++this.numberOfChunksHigh;
            this.heightLastChunk = this.screenSize.height % 128;
        } else {
            this.heightLastChunk = 0;
        }
        if (this.con != null) {
            this.con.notifyGrabRectangleHasChanged();
        }
        if (!this.isDemo) {
            if (this.con != null) {
                this.con.setContinuousRequestScreen(true);
            }
            if (this.con != null) {
                this.con.requestScreenAsPngs(null);
            }
        }
        ++this.screenRefresh;
    }

    private void forceClientToUpdateScreen() {
        long timestamp = this.logicalTimestamp + 1L;
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.pngs[i] == null) continue;
            this.indices[i] = timestamp;
        }
    }

    @Override
    public void setPointerLocation(int x, int y) {
        if (this.techPermissionsHandler.canView()) {
            this.pointerX = x;
            this.pointerY = y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenPng(int x, int y, byte[] png) {
        x /= 128;
        y /= 128;
        Object object = this.LOCK;
        synchronized (object) {
            int index = this.getMapIndex(x, y);
            long timestamp = this.logicalTimestamp++;
            this.pngs[index] = png;
            this.indices[index] = timestamp;
            if (CentralDebugging.PX_VERBOSE_SCREEN_PNGS) {
                System.out.println("[LightweightClientUserInterface] screen png upload index=" + index + " t=" + timestamp + " bytes=" + png.length + " xy=(" + x + "," + y + ")");
            }
        }
    }

    public static void main(String[] args) {
        int y;
        int x;
        LightweightClientUserInterface sd = new LightweightClientUserInterface(null, "Test", null, true);
        sd.setScreenSize(0, 0, 2048, 2048, new ScreenDimension[]{new ScreenDimension(0, 0, 2048, 2048, 1, "1")}, 100);
        byte[] dat = new byte[1024];
        for (x = 0; x < 2048; x += 128) {
            for (y = 0; y < 2048; y += 128) {
                sd.setScreenPng(x, y, dat);
            }
        }
        for (x = 0; x < 2048; x += 128) {
            for (y = 0; y < 2048; y += 128) {
                sd.setScreenPng(x, y, dat);
            }
        }
        String list = "";
        System.out.print("Fetch changed list...");
        long S = 3L;
        long T = System.currentTimeMillis() + S * 1000L;
        long N = 0L;
        while (System.currentTimeMillis() < T) {
            for (int i = 0; i < 100; ++i) {
                list = sd.getChangedList(0L);
            }
            N += 100L;
        }
        System.out.println(N / S + " per second");
        System.out.println("Changed list: (" + list.length() + ") " + list);
        dat = new byte[1024];
        System.out.print("Set PNGs...");
        long S2 = 3L;
        long T2 = System.currentTimeMillis() + S2 * 1000L;
        long N2 = 0L;
        while (System.currentTimeMillis() < T2) {
            for (int i = 0; i < 100; ++i) {
                sd.setScreenPng(0, 0, dat);
            }
            N2 += 100L;
        }
        System.out.println(N2 / S2 + " per second");
    }

    public void setMachinePassword(String pass) {
        this.machinePasswordRequired = false;
        this.machinePassword = pass;
    }

    public boolean machinePasswordRequired() {
        return this.machinePasswordRequired;
    }

    @Override
    public String requestMachinePassword() {
        this.machinePasswordRequired = true;
        System.out.println("[Mobile] machine password required");
        try {
            while (this.machinePassword == null) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String password = this.machinePassword;
        this.machinePassword = null;
        return password;
    }

    @Override
    public void promptForRdpConsoleSwitch() {
        Message m = new Message(-1061158890);
        this.con.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
    }

    @Override
    public void addMessage(String user, String host, String message) {
    }

    @Override
    public void addProgramPrintout(String data) {
    }

    @Override
    public void clearScreenImage() {
    }

    @Override
    public void connected() {
    }

    @Override
    public void disableChat() {
    }

    @Override
    public void disableDesktop() {
    }

    @Override
    public void disableReconnect() {
    }

    @Override
    public void silentReconnect(String reason) {
    }

    @Override
    public void doLicenseWait(int evalUses, int evalWait) {
    }

    @Override
    public void exportScreen() {
    }

    @Override
    public String getChatText() {
        return null;
    }

    public StyledDocument getChatDocument() {
        return null;
    }

    @Override
    public JFrame getParentFrame() {
        return null;
    }

    public String[] getUsers() {
        return null;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public void promptMmoveFailure() {
    }

    public void setCompression(int compression) {
    }

    @Override
    public void setConnected(boolean connected, String host) {
        if (connected) {
            int colDepth = this.con.getColourDepth();
            boolean bl = this.con.getUseHardwareAcceleration();
        }
    }

    @Override
    public void setCanControlAndView(boolean control, boolean view) {
    }

    public void setFiltering(int filtering) {
    }

    @Override
    public void setFitAll() {
    }

    @Override
    public void setFitHeight() {
    }

    @Override
    public void setFitOneToOne() {
    }

    public void setProgress(int p) {
    }

    @Override
    public void setSessionTitle(String name) {
    }

    @Override
    public void setResolutionPercentage(double percentage) {
    }

    @Override
    public void setScreenImage(BufferedImage screen, Rectangle[] updatedRegions) {
    }

    public void setStatus(String statusMessage, String details) {
    }

    @Override
    public void setTextEcho(boolean b) {
    }

    @Override
    public void setTyping(String typing) {
    }

    public void setUsers(String[] users) {
    }

    @Override
    public void showServerDisabledMessage() {
    }

    @Override
    public void stopReconnectsForRemoteClose() {
    }

    @Override
    public void turnOffNorthPanel() {
    }

    @Override
    public void turnOnNorthPanel() {
    }

    @Override
    public void updateFTPJobFinished(int jobID) {
    }

    @Override
    public void updateFTPProgress(int jobID, boolean upload, String dir, String file, long sent, long max, long transferred) {
    }

    @Override
    public void keyLayoutAvailable() {
    }

    @Override
    public void setPortRedirector(PortRedirector redir) {
    }

    public void setTopLeftGreyOverlay(String message) {
    }

    @Override
    public void setCentreGreyOverlay(String message, long waitFor) {
    }

    @Override
    public void setTopLeftGreyOverlay(String message, long waitFor) {
    }

    @Override
    public void setToolState(String toolClassName, boolean enabled) {
    }

    @Override
    public void setSelectedScreen(int selectedScreen) {
    }

    @Override
    public void showSessionInfoDialog() {
    }

    @Override
    public void sendAllHotkeysToRemoteMachine(boolean turningOn) {
    }

    @Override
    public void setRemoteCursor(CursorInfo cInfo) {
    }

    @Override
    public void updateFTPProgressError(int jobID, String errorMessage) {
    }

    @Override
    public void showBlankScreenOrBlockedInputWarning(boolean enabled) {
    }

    @Override
    public void expectReboot() {
    }

    @Override
    public void expectCustomerTerminate() {
    }

    @Override
    public void expectSessionDeactivated() {
    }

    @Override
    public void expectSessionActivated() {
    }

    @Override
    public void expectSleep() {
    }

    @Override
    public void expectPowerOrLogoff() {
    }

    @Override
    public void expectWake() {
    }

    @Override
    public void toggleShowAllScreens() {
    }

    @Override
    public void setCanUninstallSG(boolean can) {
    }

    @Override
    public void requestEntireScreenForRecording() {
    }

    @Override
    public void updateCustomerIsTyping(String displayName) {
    }

    public void setTechPermissions(TechGroupPermissions permissions) {
        this.techPermissionsHandler = new TechPermissionsHandler(permissions, false);
    }

    public void setTechUser(TransientTechUser transientTechUser) {
        this.techUser = transientTechUser;
    }

    @Override
    public NLOptimisationFeed getNLOptimisationFeed() {
        return null;
    }

    @Override
    public void upgradeStarted(int local, int remote) {
    }

    @Override
    public void upgradeComplete() {
    }

    @Override
    public void upgradeFailed(boolean firstStageWorked) {
    }

    @Override
    public void updateFTPProgress(int jobID, long totalSize) {
    }

    @Override
    public void recommendTcp() {
    }

    @Override
    public void receivedTerminalOutput(byte[] data) {
    }

    @Override
    public void releaseTrackingButton() {
    }

    @Override
    public void keyEvent(int keyCode, boolean pressed) {
    }

    @Override
    public void about() {
    }

    @Override
    public void preferences() {
    }

    @Override
    public boolean quit() {
        return false;
    }

    @Override
    public void startup(ProxyConnectSettings settings) {
    }

    @Override
    public NodeLinkStatusListener getNodeLinkStatusListener() {
        return null;
    }

    @Override
    public void loadBoundsOfWindow() {
    }

    @Override
    public void setToolBox(ToolBox box) {
    }

    @Override
    public void setTechnicianDetails(TransientTechUser techUser) {
    }

    @Override
    public void disableSGManagement() {
    }

    @Override
    public void setTechnicianPermissions(TechGroupPermissions permissions, boolean shouldRequestControl) {
    }

    @Override
    public void setWebTransactor(WebTransactor wtrans) {
    }

    @Override
    public void setTechnicianAvatar(byte[] avatarImage) {
    }

    @Override
    public void setupPostPreload() {
    }

    @Override
    public void linkOK(NodeLink object) {
    }

    @Override
    public void setAutoRefresh(boolean b) {
    }

    @Override
    public void disableFullScreenMode() {
    }

    @Override
    public void initEventListeners() {
    }

    @Override
    public void init(ClientController con) {
    }

    @Override
    public void notifyTrackingAlarmed() {
    }

    @Override
    public void notifyTrackingStarted() {
    }

    @Override
    public void setAudioMixer(Mixer mixer) {
    }

    @Override
    public void setSessionInfo(SessionInfo info) {
    }

    @Override
    public FileTransferStats getFileTransferStats() {
        return this.fileTransferStats;
    }

    @Override
    public void switchTransports(int local, int remote) {
    }

    @Override
    public void firstConnect() {
    }

    class UpdatePrinter
    implements HttpResponsePrinter {
        final ArrayList list;
        final int contentLen;

        public UpdatePrinter(long timestamp) {
            this.list = LightweightClientUserInterface.this.getEmbeddedImageList(timestamp);
            this.contentLen = (Integer)this.list.get(this.list.size() - 1);
        }

        @Override
        public int getLength() {
            return this.contentLen + 5;
        }

        @Override
        public void writeData(OutputStream out) throws IOException {
            out.write(40);
            out.write(91);
            LightweightClientUserInterface.this.printEmbeddedImageList(this.list, out);
            out.write(93);
            out.write(41);
            out.write(59);
        }
    }

    private class ScreenResponseListener
    implements CommandResponseListener {
        private ScreenResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            System.out.println("[LightweightClientUserInterface] Got screen request response [" + m + "].");
            boolean result = m.getAsBoolean(0);
            if (result) {
                LightweightClientUserInterface.this.techPermissionsHandler.requestScreenApproved();
                LightweightClientUserInterface.this.forceClientToUpdateScreen();
                LightweightClientUserInterface.this.screenRefresh++;
            }
            Object object = LightweightClientUserInterface.this.SCREEN_REQUEST_LOCK;
            synchronized (object) {
                LightweightClientUserInterface.this.SCREEN_REQUEST_LOCK.notify();
            }
        }
    }

    private class ControlResponseListener
    implements CommandResponseListener {
        private ControlResponseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message m) {
            System.out.println("[LightweightClientUserInterface] Got control request response.");
            boolean result = m.getAsBoolean(0);
            if (result) {
                LightweightClientUserInterface.this.techPermissionsHandler.requestControlApproved();
                LightweightClientUserInterface.this.techPermissionsHandler.requestScreenApproved();
                LightweightClientUserInterface.this.forceClientToUpdateScreen();
                LightweightClientUserInterface.this.screenRefresh++;
            }
            Object object = LightweightClientUserInterface.this.CONTROL_REQUEST_LOCK;
            synchronized (object) {
                LightweightClientUserInterface.this.CONTROL_REQUEST_LOCK.notify();
            }
        }
    }

    private class FileDownloader
    implements HttpResponsePrinter,
    ImmediateFileTransferListener {
        long len = -1L;
        OutputStream out;
        final String remotedir;
        final String remotefile;

        public FileDownloader(long len, String remotedir, String remotefile) {
            this.len = len;
            this.remotedir = remotedir;
            this.remotefile = remotefile;
        }

        @Override
        public int getLength() {
            if (CentralDebugging.LIGHTWEIGHT_FILE_TRANSFER) {
                System.out.println("[LightweightFileTransfer] Returned file length of " + (int)this.len);
            }
            return (int)this.len;
        }

        @Override
        public void writeData(OutputStream out) throws IOException {
            this.out = out;
            if (CentralDebugging.LIGHTWEIGHT_FILE_TRANSFER) {
                System.out.println("[LightweightFileTransfer] Starting up immediate file transfer and writing data...");
            }
            ++((LightweightClientUserInterface)LightweightClientUserInterface.this).fileTransferStats.totalBytesTransferred;
            LightweightClientUserInterface.this.con.doImmediateFileGet(this.remotedir, this.remotefile, this);
        }

        @Override
        public void fileDataReceived(byte[] dat) {
            ((LightweightClientUserInterface)LightweightClientUserInterface.this).fileTransferStats.totalBytesTransferred += (long)dat.length;
            try {
                if (CentralDebugging.LIGHTWEIGHT_FILE_TRANSFER) {
                    System.out.println("[LightweightFileTransfer] Writing " + dat.length);
                }
                this.out.write(dat);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void finished() {
            try {
                if (CentralDebugging.LIGHTWEIGHT_FILE_TRANSFER) {
                    System.out.println("[LightweightFileTransfer] Transfer complete");
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void setFileLength(long len) {
        }
    }
}

