/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdemo.AttendeeInfo;
import com.aem.sdemo.LightweightClientUserInterface;
import com.aem.sdemo.ProxiedClientController;
import com.aem.sdemo.SDemoHtml;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.proxy.DemoInfo;
import com.aem.shelp.proxy.HttpResponse;
import com.aem.shelp.proxy.LicenseConfig;
import com.aem.shelp.proxy.ProxyServer;
import com.aem.shelp.proxy.ServerLanguageCollection;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechUser;
import com.aem.shelp.proxy.logging.presentation.AttendeeJoined;
import com.aem.shelp.proxy.logging.presentation.PresentationEnd;
import com.aem.shelp.proxy.logging.presentation.PresentationRegistered;
import com.aem.shelp.proxy.logging.presentation.PresentationStart;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientListener;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.PresentationMachine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.authentication.TwoTierCodeEntryGlassDialog;
import com.aem.shelp.tech.gstarted.TrialUtils;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.Debugger;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import utils.loggingframework.LoggingFramework;
import utils.message.Message;
import utils.site.StringEscaper;

public class DemoQueryHandler {
    private static final String DETAIL_NAME = "detail_name";
    private static final String DETAIL_EMAIL = "detail_email";
    Object demos_LOCK = new Object();
    HashMap demos = new HashMap();
    static int demoUIDs = Math.abs(new Random(System.currentTimeMillis()).nextInt(100000));
    static Object demoUIDs_LOCK = new Object();

    public static String getDemoAttendeeCookieName(String demoID) {
        return demoID + "_aid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handleSDemoQuery(String fullResource, String cookie, HashMap paramsMap, boolean isSsl) throws FileNotFoundException {
        SDemoHandler handler;
        String demo = (String)paramsMap.get("name");
        if (demo == null) {
            String getlist;
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[DemoQueryHandler] incoming request, no demo specified");
            }
            if ((getlist = (String)paramsMap.get("getlist")) != null) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] (ajax) request for list contents, building");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("([");
                ArrayList<SDemoHandler> list = new ArrayList<SDemoHandler>();
                Object object = this.demos_LOCK;
                synchronized (object) {
                    Collection col = this.demos.values();
                    Object[] objs = new Object[col.size()];
                    col.toArray(objs);
                    for (int i = 0; i < objs.length; ++i) {
                        SDemoHandler handler2 = (SDemoHandler)objs[i];
                        if (handler2.isPrivate()) continue;
                        list.add(handler2);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    SDemoHandler handler3 = (SDemoHandler)list.get(i);
                    sb.append('\"');
                    sb.append(StringEscaper.escapeToJavascriptString(handler3.presentationName));
                    sb.append('\"');
                    if (i >= list.size() - 1) continue;
                    sb.append(',');
                }
                sb.append("]);");
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] responding with list " + sb.toString());
                }
                return new HttpResponse(sb.toString(), "text/plain");
            }
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[DemoQueryHandler] no demo and no getlist params, defaulting to HTML presentation page");
            }
            int size = 10;
            String width = (String)paramsMap.get("width");
            if (width == null) {
                width = "300px";
            }
            try {
                size = Integer.parseInt(((String)paramsMap.get("size")).trim());
            }
            catch (Exception i) {
                // empty catch block
            }
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[DemoQueryHandler] width=" + width + ", size=" + size);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), true));
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb.append("\n<script>");
            sb.append("\nvar checkTimeout = 15000;");
            sb.append("\nvar xmlhttp;");
            sb.append("\nif (window.XMLHttpRequest) {");
            sb.append("\n xmlhttp = new XMLHttpRequest();");
            sb.append("\n} else {");
            sb.append("\n if (window.ActiveXObject) {");
            sb.append("\n  xmlhttp = new ActiveXObject('MSXML2.XMLHTTP.3.0');");
            sb.append("\n }");
            sb.append("\n}");
            sb.append("\nfunction checkForUpdates() {");
            sb.append("\nxmlhttp.onreadystatechange = populateSDemoList;");
            sb.append("\nvar url = '/demo?getlist='+(new Date()).getTime();");
            sb.append("\nxmlhttp.open('GET',url,true);");
            sb.append("\nxmlhttp.send(null);");
            sb.append("\n}");
            sb.append("\nfunction populateSDemoList() {");
            sb.append("\nif (xmlhttp.readyState != 4) return;");
            sb.append("\nif (xmlhttp.status == 200) {");
            sb.append("\ndocument.getElementById('sdemoList').options.length = 0;");
            sb.append("\nvar allPublicDemos = eval(xmlhttp.responseText);");
            sb.append("\nfor (var curDemo=0; curDemo < allPublicDemos.length; curDemo++) {");
            sb.append("\ndocument.getElementById('sdemoList').options[curDemo] = new Option(allPublicDemos[curDemo],allPublicDemos[curDemo],false,false);");
            sb.append("\n");
            sb.append("\n}");
            sb.append("\nsetTimeout('checkForUpdates();',checkTimeout);");
            sb.append("\n}");
            sb.append("\n}");
            sb.append("\nfunction joinSelectedDemo() {");
            sb.append("\n var demoName = document.getElementById('sdemoList').options[document.getElementById('sdemoList').selectedIndex].value;");
            sb.append("\n var noSpaceName = demoName.replace(/[^a-zA-Z0-9]+/g, '');");
            sb.append("\n if (document.location.href.indexOf('?') == -1) {");
            sb.append("\n  window.open(encodeURI(document.location.href)+'?name='+encodeURIComponent(demoName),noSpaceName,'');");
            sb.append("\n } else {");
            sb.append("\n  window.open(encodeURI(document.location.href)+'&name='+encodeURIComponent(demoName),noSpaceName,'');");
            sb.append("\n }");
            sb.append("\n}");
            sb.append("\ncheckForUpdates();");
            sb.append("\n</script>");
            sb.append("</head>");
            sb.append("<body>");
            SDemoHtml.addSHTitleBranding(sb, true);
            sb.append("<div align=\"center\">");
            sb.append("<table width=\"" + width + "\" border=\"0px\">");
            sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder sh_presentationlist\" align=\"center\">");
            sb.append("<H3>" + ServerLanguageCollection.getString(paramsMap, "OPEN_PRESENTATIONS") + "</H3>");
            sb.append(ServerLanguageCollection.getString(paramsMap, "SELECT_PRESENTATION"));
            sb.append("<br>");
            sb.append("\n<select onChange=\"if (this.selectedIndex == -1) document.getElementById('connectButton').className = 'sh_disabled'; else document.getElementById('connectButton').className = 'sh_up';\" id='sdemoList' style='width:" + width + "' size='" + size + "' multiple>");
            sb.append("\n</select><br>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<span id=\"connectButton\" class=\"sh_disabled\" onmouseout=\"if (this.className=='sh_disabled') return; this.className='sh_up';\" onmouseover=\"if (this.className=='sh_disabled') return; this.className='sh_over';\" onclick=\"if (this.className=='sh_disabled') return false; joinSelectedDemo();\" >\n");
            sb.append(ServerLanguageCollection.getString(paramsMap, "CONNECT_PRESENTATION"));
            sb.append("</span>\n");
            sb.append("<br>");
            sb.append("<br>");
            sb.append("</td></tr>");
            sb.append("</table>");
            sb.append("</div>");
            sb.append("\n</body>");
            sb.append("\n</html>");
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[DemoQueryHandler] returning HTML presentation page");
            }
            return new HttpResponse(sb.toString(), "text/html");
        }
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[DemoQueryHandler] demo specified '" + demo + "'");
        }
        Object size = this.demos_LOCK;
        synchronized (size) {
            handler = (SDemoHandler)this.demos.get(demo);
        }
        if (handler == null) {
            String fin = (String)paramsMap.get("finished");
            if (fin != null) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] no handler found for '" + demo + "' but finished param present, showing presentation finished page");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), true));
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.addSHTitleBranding(sb, true);
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<div class=\"sh_logout\">\n");
                sb.append("<br>");
                sb.append("<H3>").append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FINISHED_TITLE")).append("</H3>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FINISHED_MESSAGE"));
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<a href='demo'>");
                sb.append("<span id=\"connectButton\" class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" >\n");
                sb.append(ServerLanguageCollection.getString(paramsMap, "GO_TO_DEMOS"));
                sb.append("</a>");
                sb.append("</span>\n");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("</div>\n");
                sb.append("</body>");
                sb.append("</html>");
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] responding with 'presentation finished' HTML page");
                }
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                Debugger.info("[DemoQueryHandler] no handler found for '" + demo + "' and client not asking for end page, returning 'Presentation Not Found' plain text");
            }
            return new HttpResponse("Presentation" + SDemoHtml.NOT_FOUND_MARKER + " (" + demo + ")", "text/plain");
        }
        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
            Debugger.info("[DemoQueryHandler] handler found for '" + demo + "'");
        }
        return handler.handleQuery(fullResource, cookie, paramsMap, isSsl);
    }

    public void incomingSDemoConnection(Customer customer) {
        Debugger.info("[SDemo] New presentation session started");
        SDemoHandler handler = new SDemoHandler(customer);
        handler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean presentationHasStarted(String name) {
        Object object = this.demos_LOCK;
        synchronized (object) {
            SDemoHandler info = (SDemoHandler)this.demos.get(name);
            if (info != null && info.hasStarted()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePresentation(String name) {
        System.out.println("[SDemo] Deleting demo " + name);
        Object object = this.demos_LOCK;
        synchronized (object) {
            SDemoHandler demo = (SDemoHandler)this.demos.remove(name);
            if (demo != null && demo.hasStarted()) {
                demo.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDummyDemoHandler(String name, String desc, String pass, boolean isSecure, boolean acceptDetails, boolean isPrivate, TechUser techUser) {
        Object object = this.demos_LOCK;
        synchronized (object) {
            SDemoHandler info = (SDemoHandler)this.demos.get(name);
            if (info != null) {
                return !info.hasStarted();
                {
                }
            }
            new SDemoHandler(name, desc, pass, isSecure, acceptDetails, isPrivate, techUser);
            try {
                PresentationRegistered event = PresentationRegistered.createEvent(techUser, name);
                LoggingFramework.INSTANCE.logEvent(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPresentationList(Message ret) {
        Object object = this.demos_LOCK;
        synchronized (object) {
            Object[] dems = this.demos.values().toArray();
            for (int i = 0; i < dems.length; ++i) {
                SDemoHandler handler = (SDemoHandler)dems[i];
                boolean add = true;
                if (handler.sock != null && !handler.sock.isAlive()) {
                    this.demos.remove(handler.presentationName);
                    add = false;
                }
                if (!add || handler.isPrivate()) continue;
                DemoInfo info = new DemoInfo();
                info.name = handler.presentationName;
                info.desc = handler.presentationDesc;
                info.pass = handler.presentationPassword;
                info.secure = handler.isSecure;
                info.started = handler.hasStarted();
                info.details = handler.acceptDetails;
                Object object2 = handler.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
                synchronized (object2) {
                    info.attendeeCount = handler.allDetails.size();
                }
                ret.append(info.toMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttendeeInfo[] getAttendeeList(String demoName) {
        SDemoHandler demoHandler = this.getDemoHandler(demoName);
        if (demoHandler == null) {
            return new AttendeeInfo[0];
        }
        Object object = demoHandler.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
        synchronized (object) {
            AttendeeInfo[] info = new AttendeeInfo[demoHandler.allDetails.size()];
            demoHandler.allDetails.toArray(info);
            return info;
        }
    }

    public Message handleProxiedControllerMessage(String demoName, Message m) {
        return this.getDemoHandler(demoName).handleProxiedControllerMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDemoHandler getDemoHandler(String name) {
        Object object = this.demos_LOCK;
        synchronized (object) {
            return (SDemoHandler)this.demos.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextDemoUID() {
        int uid;
        Object object = demoUIDs_LOCK;
        synchronized (object) {
            uid = demoUIDs++;
        }
        return uid;
    }

    public int getTotalAttendeeCount() {
        Collection col = this.demos.values();
        Iterator it = col.iterator();
        int count = 0;
        while (it.hasNext()) {
            SDemoHandler handler = (SDemoHandler)it.next();
            count += handler.allDetails.size();
        }
        return count;
    }

    class FormInputLine {
        String variableName;
        String label;

        public FormInputLine(String label, String variableName) {
            this.label = label;
            this.variableName = variableName;
        }
    }

    class SDemoHandler
    extends Thread
    implements TechClientListener,
    NodeLinkStatusListener {
        Customer customer;
        NodeLink sock;
        LightweightClientUserInterface sdui;
        Controller con;
        String demoUID;
        String presentationName;
        String presentationPassword;
        String presentationDesc;
        String accessCode;
        boolean isPrivate;
        boolean isSecure;
        boolean acceptDetails;
        Object ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
        ArrayList allDetails;
        HashMap allIds;
        int nextID;
        int lastConcCheck;
        ProxiedClientController pcon;
        String connectedSessionId;
        private TechUser techUser;
        private PresentationMachine machine;
        private DemoSession session;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SDemoHandler(String demoName, String demoDesc, String pass, boolean isSecure, boolean acceptDetails, boolean isPrivate, TechUser techUser) {
            this.demoUID = DemoQueryHandler.this.nextDemoUID() + "";
            this.isPrivate = false;
            this.isSecure = false;
            this.acceptDetails = true;
            this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS = new Object();
            this.allDetails = new ArrayList();
            this.allIds = new HashMap();
            this.nextID = 1;
            this.lastConcCheck = -1;
            this.connectedSessionId = null;
            this.presentationName = demoName;
            this.presentationDesc = demoDesc;
            this.presentationPassword = pass;
            this.isSecure = isSecure;
            this.acceptDetails = acceptDetails;
            this.techUser = techUser;
            this.isPrivate = isPrivate;
            if (this.presentationPassword == null) {
                this.presentationPassword = "";
            }
            this.accessCode = this.presentationPassword.length() == 0 ? null : Long.toString(SecurityUtil.nextSecureID());
            Object object = DemoQueryHandler.this.demos_LOCK;
            synchronized (object) {
                DemoQueryHandler.this.demos.put(this.presentationName, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SDemoHandler(Customer customer) {
            this.demoUID = DemoQueryHandler.this.nextDemoUID() + "";
            this.isPrivate = false;
            this.isSecure = false;
            this.acceptDetails = true;
            this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS = new Object();
            this.allDetails = new ArrayList();
            this.allIds = new HashMap();
            this.nextID = 1;
            this.lastConcCheck = -1;
            this.connectedSessionId = null;
            this.customer = customer;
            this.presentationName = customer.getValue("SDemoName", true);
            this.presentationPassword = customer.getValue("SDemoPass", true);
            this.presentationDesc = customer.getValue("SDemoDesc", true);
            this.isPrivate = customer.getValue("SDemoPrivate", true).equalsIgnoreCase("true");
            this.isSecure = customer.getValue("SDemoSecure", true).equalsIgnoreCase("true");
            this.acceptDetails = customer.getValue("SDemoDetails", true).equalsIgnoreCase("true");
            if (this.presentationPassword == null) {
                this.presentationPassword = "";
            }
            if (this.presentationName == null) {
                this.presentationName = "";
            }
            if (this.presentationName.length() == 0) {
                Debugger.info("[SDemo] Invalid presentation name (" + this.presentationName + ")");
                if (this.sock != null) {
                    this.sock.stop("closing sd attempt due to invalid presentation name");
                }
            }
            this.accessCode = this.presentationPassword.length() == 0 ? null : Long.toString(SecurityUtil.nextSecureID());
            Object object = DemoQueryHandler.this.demos_LOCK;
            synchronized (object) {
                SDemoHandler oldHandler = (SDemoHandler)DemoQueryHandler.this.demos.get(this.presentationName);
                if (oldHandler != null) {
                    this.allIds.putAll(oldHandler.allIds);
                    this.allDetails.addAll(oldHandler.allDetails);
                    this.techUser = oldHandler.techUser;
                    this.accessCode = oldHandler.accessCode;
                    this.demoUID = oldHandler.demoUID;
                }
                DemoQueryHandler.this.demos.put(this.presentationName, this);
            }
            PresentationMachine machine = PresentationMachine.createFrom(customer);
            this.session = new DemoSession(machine, this.demoUID);
            this.session.setTechnicianDisplayName(this.techUser.displayName);
            this.session.setTechnicianUsername(this.techUser.login);
            this.session.setDesc(this.presentationDesc);
            this.session.setName(this.presentationName);
            this.session.setStartTime(System.currentTimeMillis());
        }

        public Message handleProxiedControllerMessage(Message m) {
            return this.pcon.handleProxiedControllerMessage(m);
        }

        public boolean isPrivate() {
            return this.isPrivate;
        }

        public boolean hasStarted() {
            return this.sdui != null;
        }

        public void terminate() {
            System.out.println("[SDemo] Demo " + this.presentationName + " terminating");
            try {
                this.con.closeConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.con.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sock.stop("shutting down demo " + this.presentationName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private String appendToCookie(String existingCookie, String newContent) {
            if (existingCookie == null || existingCookie.length() == 0) {
                return newContent;
            }
            return existingCookie + ", " + newContent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kickAttendee(String attendeeID) {
            Object object = this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
            synchronized (object) {
                this.allIds.remove(attendeeID);
                for (int i = 0; i < this.allDetails.size(); ++i) {
                    AttendeeInfo info = (AttendeeInfo)this.allDetails.get(i);
                    if (!info.id.equals(attendeeID)) continue;
                    this.allDetails.remove(i--);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpResponse handleQuery(String fullResource, String cookie, HashMap paramsMap, boolean isSsl) {
            String setCookie = null;
            this.parseCookieIntoParamsMap(cookie, paramsMap);
            String attendeeID = this.getAttendeeID(this.demoUID, paramsMap);
            if (this.acceptDetails || this.accessCode != null) {
                boolean skip = false;
                if (this.accessCode != null && cookie != null && cookie.indexOf(this.accessCode) != -1) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[DemoQueryHandler] passcode required, but cookie OK");
                    }
                    skip = true;
                }
                if (this.accessCode == null && attendeeID != null) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[DemoQueryHandler] details (not passcode) required, but already a registered attendee");
                    }
                    skip = true;
                }
                if (!skip) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[DemoQueryHandler] passcode or details required, needDetails=" + this.acceptDetails + ", needPass=" + (this.accessCode != null));
                    }
                    boolean invalidPassword = false;
                    boolean reprintDetails = false;
                    String attname = (String)paramsMap.get(DemoQueryHandler.DETAIL_NAME);
                    String attpass = (String)paramsMap.get("pw");
                    if (attname != null || attpass != null) {
                        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            Debugger.info("[DemoQueryHandler] details being posted in this request");
                        }
                        skip = true;
                        if (this.accessCode != null) {
                            if (attpass.equals(this.presentationPassword)) {
                                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                    Debugger.info("[DemoQueryHandler] demo password accepted, setting access code cookie");
                                }
                                setCookie = this.appendToCookie(setCookie, "shelp_demo_access=" + this.accessCode);
                            } else {
                                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                    Debugger.info("[DemoQueryHandler] bad password, will re-request");
                                }
                                invalidPassword = true;
                                reprintDetails = true;
                                skip = false;
                            }
                        }
                    }
                    if (!skip) {
                        String lang;
                        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            Debugger.info("[DemoQueryHandler] prompting for details and/or password");
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("<html>");
                        sb.append("<head>");
                        sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), true));
                        sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                        sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                        sb.append("</head>");
                        sb.append("<body>");
                        SDemoHtml.addSHTitleBranding(sb, true);
                        sb.append("<div align=\"center\">");
                        sb.append("<table class=\"sh_passwordTable\" border=\"0px\">");
                        sb.append("<tr><td width=\"100%\" class=\"sh_blockBorder\" align=\"center\">");
                        sb.append("<h3>" + this.presentationName + "</h3>");
                        if (invalidPassword) {
                            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                Debugger.info("[DemoQueryHandler] password was bad last time");
                            }
                            sb.append("<div class=\"sh_invalidPassword\">");
                            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_INVALID_PASSWORD"));
                            sb.append("</div>");
                            sb.append("<br>");
                        }
                        if (this.acceptDetails) {
                            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                Debugger.info("[DemoQueryHandler] requesting details");
                            }
                            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_DETAILS")).append(":");
                            sb.append("<br>");
                            sb.append("<br>");
                        }
                        sb.append("<form name=\"detailsForm\" method=\"post\" action=\"" + fullResource + "\">");
                        sb.append("<table border='0' cellspacing='5' cellpadding='0'>");
                        if (this.acceptDetails) {
                            FormInputLine[] lines = new FormInputLine[]{new FormInputLine(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_INPUT_NAME"), DemoQueryHandler.DETAIL_NAME), new FormInputLine(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_INPUT_EMAIL"), DemoQueryHandler.DETAIL_EMAIL)};
                            for (int i = 0; i < lines.length; ++i) {
                                sb.append("<tr>");
                                sb.append("<td class=\"sh_labelcell\">");
                                sb.append(lines[i].label).append(":");
                                sb.append("</td>");
                                sb.append("<td class=\"sh_fieldcell\">");
                                if (reprintDetails) {
                                    sb.append("<input class='sh_details' size='30' type='text' name='").append(lines[i].variableName).append("' value='").append(paramsMap.get(lines[i].variableName)).append("'/>");
                                } else {
                                    sb.append("<input class='sh_details' size='30' type='text' name='").append(lines[i].variableName).append("'/>");
                                }
                                sb.append("</td>");
                                sb.append("</tr>");
                            }
                        }
                        if (this.accessCode != null) {
                            if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                                Debugger.info("[DemoQueryHandler] requesting password");
                            }
                            sb.append("<tr>");
                            sb.append("<td class=\"sh_labelcell\">");
                            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_INPUT_PASSWORD")).append(":");
                            sb.append("</td>");
                            sb.append("<td class=\"sh_fieldcell\">");
                            sb.append("<input class='sh_details' size='30' type='password' name='pw'/>");
                            sb.append("</td>");
                            sb.append("</tr>");
                        }
                        if ((lang = (String)paramsMap.get("language")) != null) {
                            sb.append("<input type='hidden' name='language' value='").append(lang).append("'/>");
                        }
                        sb.append("<input type='hidden' name='name' value='").append(this.presentationName).append("'/>");
                        sb.append("</table>");
                        sb.append("<input type=\"submit\" style=\"visibility:hidden;width: 0px;height: 0px;border: none\">");
                        sb.append("</form>");
                        sb.append("<br>");
                        sb.append("<br>");
                        sb.append("<span id=\"connectButton\" class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"return; this.className='sh_over';\" onclick=\"document.detailsForm.submit();\" >\n");
                        sb.append(ServerLanguageCollection.getString(paramsMap, "CONNECT_PRESENTATION"));
                        sb.append("</span>\n");
                        sb.append("<br>");
                        sb.append("<br>");
                        sb.append("</td></tr>");
                        sb.append("</table>");
                        sb.append("</div>");
                        sb.append("</body>");
                        sb.append("</html>");
                        if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                            Debugger.info("[DemoQueryHandler] responding with user input HTML for details and/or password");
                        }
                        HttpResponse resp = new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                        return resp;
                    }
                }
            }
            if (attendeeID != null && this.connectedSessionId != null) {
                Object skip = ProxyServer.INSTANCE.INTERNAL_getConcLock();
                synchronized (skip) {
                    Object object = this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
                    synchronized (object) {
                        if (this.allDetails.size() != this.lastConcCheck) {
                            this.lastConcCheck = this.allDetails.size();
                            int extraSessionsRequired = LicenseConfig.get().getLicense().getLicensePlanVersion() == 1 ? Math.max(0, (this.allDetails.size() - 1) / 3) : 0;
                            if (!ProxyServer.INSTANCE.sessionSetClaimedSessionCount(this.connectedSessionId, extraSessionsRequired) && this.allDetails.size() > 0) {
                                this.kickAttendee(attendeeID);
                                System.out.println("[DemoQueryHandler] Presentation too full, kicking attendee");
                            }
                        }
                    }
                }
            }
            if (attendeeID == null) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] user authenticated but does not have ID yet");
                }
                if (!this.registerAttendee(paramsMap, attendeeID = Long.toString(Math.abs(SecurityUtil.nextSecureID())))) {
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[DemoQueryHandler] couldn't register attendee, presentation was full");
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("<html>");
                    sb.append("<head>");
                    sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), true));
                    sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                    sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                    sb.append("</head>");
                    sb.append("<body>");
                    SDemoHtml.addSHTitleBranding(sb, true);
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("<div class=\"sh_logout\">\n");
                    sb.append("<br>");
                    sb.append("<H3>").append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FULL_TITLE")).append("</H3>");
                    sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FULL_MESSAGE"));
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("<a href='demo'>");
                    sb.append("<span id=\"connectButton\" class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" >\n");
                    sb.append(ServerLanguageCollection.getString(paramsMap, "GO_TO_DEMOS"));
                    sb.append("</a>");
                    sb.append("</span>\n");
                    sb.append("<br>");
                    sb.append("<br>");
                    sb.append("</div>\n");
                    sb.append("</body>");
                    sb.append("</html>");
                    if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                        Debugger.info("[DemoQueryHandler] responding with 'presentation full' HTML page");
                    }
                    return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
                }
                setCookie = this.appendToCookie(setCookie, DemoQueryHandler.getDemoAttendeeCookieName(this.demoUID) + "=" + attendeeID);
            } else if (!this.attendeeExists(attendeeID)) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] fake or bannned attendee, will respond with presentation full message");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<head>");
                sb.append(SDemoHtml.getApplicationNameTitleTag(ServerLanguageCollection.getString(paramsMap, "SIMPLEHELP"), true));
                sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
                sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
                sb.append("</head>");
                sb.append("<body>");
                SDemoHtml.addSHTitleBranding(sb, true);
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<div class=\"sh_logout\">\n");
                sb.append("<br>");
                sb.append("<h3>").append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FULL_TITLE")).append("</h3>");
                sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_FULL_MESSAGE"));
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("<a href='demo'>");
                sb.append("<span id=\"connectButton\" class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" >\n");
                sb.append(ServerLanguageCollection.getString(paramsMap, "GO_TO_DEMOS"));
                sb.append("</a>");
                sb.append("</span>\n");
                sb.append("<br>");
                sb.append("<br>");
                sb.append("</div>\n");
                sb.append("</body>");
                sb.append("</html>");
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] responding with 'presentation full' HTML page");
                }
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            HttpResponse resp = this.handleQueryAuthenticated(fullResource, paramsMap, isSsl);
            if (setCookie != null) {
                resp.cookie = setCookie;
            }
            return resp;
        }

        private void parseCookieIntoParamsMap(String cookie, HashMap paramsMap) {
            if (cookie == null || cookie.length() == 0) {
                return;
            }
            String[] cookieParams = cookie.split(";");
            for (int i = 0; i < cookieParams.length; ++i) {
                int firstEquals = cookieParams[i].indexOf(61);
                if (firstEquals == -1 && firstEquals != cookieParams[i].length() - 1) continue;
                String name = cookieParams[i].substring(0, firstEquals);
                String value = cookieParams[i].substring(firstEquals + 1);
                if (name == null || value == null) continue;
                paramsMap.put(name.trim(), value.trim());
            }
        }

        private String getAttendeeID(String demoID, HashMap paramsMap) {
            String id = (String)paramsMap.get(DemoQueryHandler.getDemoAttendeeCookieName(demoID));
            if (id != null && this.attendeeExists(id)) {
                return id;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attendeeExists(String id) {
            Object object = this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
            synchronized (object) {
                return this.allIds.get(id) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean registerAttendee(HashMap paramsMap, String id) {
            AttendeeInfo info = new AttendeeInfo();
            info.joined = System.currentTimeMillis();
            info.name = (String)paramsMap.get(DemoQueryHandler.DETAIL_NAME);
            info.email = (String)paramsMap.get(DemoQueryHandler.DETAIL_EMAIL);
            info.id = id;
            if (info.name != null && info.name.trim().length() == 0) {
                info.name = null;
            }
            String transAttendee = "";
            if (info.name == null) {
                transAttendee = ServerLanguageCollection.getString(paramsMap, "ATTENDEE");
            }
            Object object = ProxyServer.INSTANCE.INTERNAL_getConcLock();
            synchronized (object) {
                Object object2 = this.ids_LOCK_DO_NOT_EXIT_THIS_CLASS;
                synchronized (object2) {
                    AttendeeInfo replace;
                    if (info.name == null) {
                        info.name = transAttendee + " " + this.nextID++;
                    }
                    if ((replace = (AttendeeInfo)this.allIds.get(id)) == null) {
                        if (this.connectedSessionId != null) {
                            info.sessioned = true;
                            if (TrialUtils.amTriallingBizOrEnt()) {
                                return true;
                            }
                            if (LicenseConfig.get().getLicense().getLicensePlanVersion() == 1) {
                                int attendeeFactor = 3;
                                if (this.allDetails.size() >= attendeeFactor && this.allDetails.size() % attendeeFactor == 0) {
                                    if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                                        System.out.println("[DemoSessions] Trying to claim for new attendee on " + this.connectedSessionId);
                                    }
                                    if (!ProxyServer.INSTANCE.sessionClaimOneSession(this.connectedSessionId)) {
                                        if (CentralDebugging.PX_SHOW_DEMO_SESSIONS) {
                                            System.out.println("[DemoSessions] Failed - no more sessions available");
                                        }
                                        return false;
                                    }
                                }
                            } else if (this.allDetails.size() >= LicenseConfig.get().getLicense().getDemoAttendees()) {
                                System.out.println("[DemoSessions] Failed - license does not allow more presentation attendees");
                                return false;
                            }
                        }
                        this.allDetails.add(info);
                        AttendeeJoined event = AttendeeJoined.createEvent(this.techUser, this.presentationName, info.name, info.email, this.allIds.size() + 1);
                        LoggingFramework.INSTANCE.logEvent(event);
                    } else {
                        for (int i = 0; i < this.allDetails.size(); ++i) {
                            AttendeeInfo ai = (AttendeeInfo)this.allDetails.get(i);
                            if (!ai.id.equals(id)) continue;
                            this.allDetails.set(i, info);
                        }
                    }
                    this.allIds.put(id, info);
                }
            }
            return true;
        }

        private StringBuffer getRedirectToHTTPSResponse(HashMap paramsMap, String name) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            SDemoHtml.appendHttpsRedirectJavascript(sb, ServerConfig.get().portList);
            sb.append(SDemoHtml.getLanguageEncodingMetaTag(paramsMap));
            sb.append("</head>");
            sb.append("<body>");
            SDemoHtml.addSHTitleBranding(sb, true);
            sb.append("<div class=\"sh_logout\">\n");
            sb.append("<H3>").append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_PREFIX") + ": " + name).append("</H3>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_NEEDS_SECURE"));
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append("<span class=\"sh_up\" onmouseout=\"this.className='sh_up';\" onmouseover=\"this.className='sh_over';\" onclick=\"document.location='https' + document.location.href.substring(4);\" >\n");
            sb.append(ServerLanguageCollection.getString(paramsMap, "REDIRECT_NOW") + "...");
            sb.append("</span>\n");
            sb.append("</div>\n");
            sb.append("</body>");
            sb.append("</html>");
            return sb;
        }

        private StringBuffer getPresentationNotStartedResponse(HashMap paramsMap, String name) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append(SDemoHtml.getStandardIosMobilePageHeaders());
            sb.append("<meta http-equiv='refresh' content='5' />");
            sb.append("</head>");
            sb.append("<body>");
            SDemoHtml.addSHTitleBranding(sb, true);
            sb.append("<div class=\"sh_logout\">\n");
            sb.append("<H3>").append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_PREFIX") + ": " + name).append("</H3>");
            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_NOT_STARTED1"));
            sb.append("<br>");
            sb.append(ServerLanguageCollection.getString(paramsMap, "PRESENTATION_NOT_STARTED2"));
            sb.append("<br>");
            sb.append("<br>");
            if (this.presentationDesc.length() > 0) {
                sb.append("<h3>").append(ServerLanguageCollection.getString(paramsMap, "ATTENDEE_INFORMATION")).append("</h3>");
                sb.append(this.presentationDesc);
            }
            sb.append("<br>");
            sb.append("<br>");
            sb.append("</div>\n");
            sb.append("</body>");
            sb.append("</html>");
            return sb;
        }

        public HttpResponse handleQueryAuthenticated(String fullResource, HashMap paramsMap, boolean isSsl) {
            if (this.isSecure && !isSsl) {
                StringBuffer sb = this.getRedirectToHTTPSResponse(paramsMap, this.presentationName);
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] user should be running SSL, responding with SSL redirect");
                }
                return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
            }
            if (this.sdui != null) {
                if (CentralDebugging.LW_DEBUG_LIGHTWEIGHT_PRIMARY) {
                    Debugger.info("[DemoQueryHandler] passing query to SD Lightweight Client UI");
                }
                return this.sdui.handleQuery(paramsMap);
            }
            StringBuffer sb = this.getPresentationNotStartedResponse(paramsMap, this.presentationName);
            return new HttpResponse(sb.toString(), "text/html", ServerLanguageCollection.isUTF8(paramsMap));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long initTime = System.currentTimeMillis();
            try {
                TechClient tc;
                Debugger.info("[SDemo] Initing handler for presentation (" + this.presentationName + ")");
                this.con = new Controller(true);
                this.pcon = new ProxiedClientController(this.con);
                ProxyConnectSettings settings = new ProxyConnectSettings();
                settings.retry = false;
                settings.isMachine = false;
                String[] ips = ServerConfig.get().ipPortPairsList;
                if (ips != null && ips.length > 0) {
                    settings.host = ServerConfig.getHostFromIpAndPort(ips[0]);
                    settings.port = ServerConfig.getPortFromIpAndPort(ips[0]);
                } else {
                    settings.host = "localhost";
                    int[] ports = ServerConfig.get().portList;
                    settings.port = ports[0];
                }
                byte[] randomSessionToken = new byte[16];
                BCUtil.getSecureRandom().nextBytes(randomSessionToken);
                ProxyServer.INSTANCE.registerSessionID(ServerConfig.get().serverAdmin, randomSessionToken);
                try {
                    settings.setCredentials("", ServerConfig.get().serverPassword.getDecryptedPassword(), randomSessionToken);
                    settings.customerOrMachineID = this.customer.getCustomerID();
                    settings.techname = "SimpleDemoProxyServerClient";
                    Debugger.info("[SDemo] Creating TechClient");
                    tc = new TechClient("NO LANGFILE NEEDED", Language.DEFLANG, settings.credentials, true, this, this);
                    settings.credentials.setSessionToken(tc.getSessionID());
                }
                finally {
                    ProxyServer.INSTANCE.deregisterSessionID(ServerConfig.get().serverAdmin, randomSessionToken);
                }
                this.connectedSessionId = settings.customerOrMachineID;
                Debugger.info("[SDemo] Connecting TechClient");
                BCUtil sessionBCU = tc.connect(initTime, settings);
                Debugger.info("[SDemo] Getting presentation streams");
                this.sock = tc.getConnectedSocketAndInvalidateTC();
                this.sock.setFriendlyName("DemoServCon " + this.presentationName);
                OutputStream out = tc.getConnectedOutputStream();
                InputStream in = tc.getConnectedInputStream();
                this.sdui = new LightweightClientUserInterface(this.con, this.presentationName, null, true);
                this.sdui.setTechPermissions(tc.getTechUser().getPermissions());
                this.sdui.setTechUser(tc.getTechUser());
                this.con.setGUI(this.sdui);
                this.con.setControlEnabled(false);
                this.con.setLocalServerAddress(settings.host, settings.port);
                Debugger.info("[SDemo] Launching presentation controller");
                ProxyConnectSettings connectSettings = new ProxyConnectSettings();
                connectSettings.techname = settings.techname;
                connectSettings.host = "localhost";
                connectSettings.port = -1;
                connectSettings.initialMode = 0;
                connectSettings.isMobile = settings.isMobile;
                this.con.connectToProxy(connectSettings, null, null, this.sock, in, out, null, sessionBCU, tc.getTechUser());
                this.sock.addLinkStatusListener(this);
                PresentationStart event = PresentationStart.createEvent(this.techUser, this.presentationName);
                LoggingFramework.INSTANCE.logEvent(event);
                this.session.setStartTime(System.currentTimeMillis());
            }
            catch (Throwable t) {
                Debugger.info("[SDemo] Failed to handle presentation (" + this.presentationName + "):");
                t.printStackTrace();
            }
        }

        @Override
        public void customerListChanged() {
        }

        @Override
        public void setWarningMessage(String text) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void linkDead(NodeLink link, String reason) {
            System.out.println("[SDemo] Presentation ended (" + this.presentationName + ") - " + link);
            try {
                PresentationEnd event = PresentationEnd.createEvent(this.techUser, this.presentationName);
                LoggingFramework.INSTANCE.logEvent(event);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.createEventInHistory();
            try {
                this.con.closeConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.con.terminate();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sock.stop("demo handler shutting down " + this.presentationName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = DemoQueryHandler.this.demos_LOCK;
            synchronized (object) {
                DemoQueryHandler.this.demos.remove(this.presentationName);
            }
        }

        private void createEventInHistory() {
            this.session.setAttendeeCount(DemoQueryHandler.this.getTotalAttendeeCount());
            this.session.setDuration(System.currentTimeMillis() - this.session.getStartTime());
            ProxyServer.INSTANCE.registerSessionInHistory(this.session);
        }

        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            Debugger.info("[SDemo] Link broken for presentation (" + this.presentationName + ")");
        }

        @Override
        public void linkOK(NodeLink link) {
            Debugger.info("[SDemo] Link ok for presentation (" + this.presentationName + ")");
        }

        @Override
        public void demoListChanged() {
        }

        @Override
        public void updateSessionCounts(boolean isJoinedSessionCounts, boolean isEvaluation, boolean isPlan2, int totalSessions, int maxSHSessions, int maxSGSessions, int alertedMachines, int alertLimit, int regMachines, int machineLimit) {
        }

        @Override
        public TechClientListener.TwoTierResponse requestTwoTierCode(boolean showIncorrectWarning, String emailAddress, boolean allowRemember) {
            return new TechClientListener.TwoTierResponse();
        }

        @Override
        public TechClientListener.TwoTierResponse processAuthenticationChallenge(boolean showIncorrectWarning, String replyMessage) throws TwoTierCodeEntryGlassDialog.SwitchUserException {
            return new TechClientListener.TwoTierResponse();
        }

        @Override
        public void machineAdded(Machine machine) {
        }

        @Override
        public void machineRemoved(Machine machine) {
        }

        @Override
        public void machinesAdded(Machine[] machine) {
        }

        @Override
        public void machinesRemoved(Machine[] machine) {
        }

        @Override
        public void machineOnline(Machine machine) {
        }

        @Override
        public void machineOffline(Machine machine) {
        }

        @Override
        public void machineDataChanged(Machine machine) {
        }

        @Override
        public void machineFilterableInfoChanged(Machine machine) {
        }

        @Override
        public void sessionAdded(AccessSession session) {
        }

        @Override
        public void sessionRemoved(AccessSession session) {
        }

        @Override
        public void customerLiveListChanged() {
        }

        @Override
        public void peersChanged() {
        }

        @Override
        public void licenseChanged() {
        }

        @Override
        public void alertAdded(ResourceContainer alert) {
        }

        @Override
        public void alertRemoved(ResourceContainer alert) {
        }

        @Override
        public void alertChanged(ResourceContainer alert) {
        }

        @Override
        public void newNotificationReceived(Notification newNotification) {
        }

        @Override
        public long requestAppAuthenticationSetup(String totpKey, String totpUsername, String hostname, int length) {
            return 0L;
        }

        @Override
        public void closeAppAuthenticationSetup() {
        }

        @Override
        public void configChanged() {
        }

        @Override
        public void waitingForRemoteUserToAccept() {
        }

        @Override
        public void sgUpdatingDuringConnect() {
        }
    }
}

