/*
 * Decompiled with CFR 0.152.
 */
package com.aem.profiles.model;

import com.aem.profiles.model.AppProfiles;
import com.aem.profiles.model.ProfileType;
import java.util.Properties;
import utils.message.Message;
import utils.message.TypedMap;

public class AppProfile {
    private static String KEY_VERSION = "V";
    private static int VERSION = 1;
    private static String KEY_APP_TYPE_ID = "AppTypeID";
    private static String KEY_ID = "ID";
    private static String KEY_NAME = "Name";
    private static String KEY_ALIAS = "AL";
    private static String KEY_LAUNCH_PROPS = "LP";
    private static String KEY_RACCESS_GROUP_RESTRICTIONS = "RAGRP";
    private TypedMap properties = new TypedMap();

    public AppProfile(ProfileType type, String ID, String alias) {
        this.properties.setString(KEY_APP_TYPE_ID, type.getID());
        this.properties.setString(KEY_ID, ID);
        this.properties.setString(KEY_ALIAS, alias);
        this.properties.setInt(KEY_VERSION, VERSION);
    }

    public String getAlias() {
        return this.properties.getString(KEY_ALIAS);
    }

    public AppProfile(TypedMap properties) {
        this.properties = properties;
    }

    public int objectCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AppProfile)) {
            return false;
        }
        AppProfile oo = (AppProfile)o;
        return oo.getID().equals(this.getID());
    }

    public String getID() {
        return this.properties.getString(KEY_ID);
    }

    public void setName(String name) {
        this.properties.setString(KEY_NAME, name);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.properties.getString(KEY_NAME);
    }

    private String getAppTypeID() {
        return this.properties.getString(KEY_APP_TYPE_ID);
    }

    public ProfileType getType() {
        return AppProfiles.getProfileTypeByID(this.getAppTypeID());
    }

    public Message toMessage() {
        return this.properties.toMessage();
    }

    public static AppProfile fromMessage(Message loadAppProfile) {
        return new AppProfile(TypedMap.fromMessage(loadAppProfile));
    }

    public void setLaunchProperties(Properties launchProps) {
        this.properties.setProperties(KEY_LAUNCH_PROPS, launchProps);
    }

    public Properties getLaunchProperties() {
        return this.properties.getPropertiesCopy(KEY_LAUNCH_PROPS);
    }
}

