/*
 * Decompiled with CFR 0.152.
 */
package com.aem.profiles;

import java.util.Random;

public class CodeGenerator {
    private static final Random r = new Random(System.currentTimeMillis());
    private int codeLength;
    private boolean numbersOnly;
    private CodeChecker codeChecker;

    public CodeGenerator(int codeLength, boolean numbersOnly, CodeChecker codeChecker) {
        this.codeLength = codeLength;
        this.numbersOnly = numbersOnly;
        this.codeChecker = codeChecker;
    }

    public String getNewCode() {
        if (this.numbersOnly) {
            return this.getNewCodeNumbers();
        }
        return this.getNewCodeLetters();
    }

    private String getNewCodeNumbers() {
        StringBuffer buffer;
        String code;
        do {
            buffer = new StringBuffer();
            for (int i = 0; i < this.codeLength; ++i) {
                int c = r.nextInt(10);
                char newChar = (char)(48 + c);
                buffer.append(newChar);
            }
        } while (this.codeChecker.codeAlreadyUsed(code = buffer.toString()));
        return code;
    }

    private String getNewCodeLetters() {
        StringBuffer buffer;
        String code;
        String ambiguousChars = "0O1QIL";
        do {
            buffer = new StringBuffer();
            for (int i = 0; i < this.codeLength; ++i) {
                char newChar = '0';
                boolean okChar = false;
                while (!okChar) {
                    int c = r.nextInt(34);
                    newChar = c < 24 ? (char)(65 + c) : (char)(48 + (c - 24));
                    if (ambiguousChars.indexOf(newChar) != -1) continue;
                    okChar = true;
                }
                buffer.append(newChar);
            }
        } while (this.codeChecker.codeAlreadyUsed(code = buffer.toString()));
        return code;
    }

    public static interface CodeChecker {
        public boolean codeAlreadyUsed(String var1);
    }
}

