/*
 * Decompiled with CFR 0.152.
 */
package com.aem.profiles;

import bcutil.BCUtil;
import com.aem.profiles.CodeGenerator;
import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.AppProfiles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.TypedMap;
import utils.progtools.BestCaseCompressor;
import utils.progtools.Cache;
import utils.string.WebBase64;

public class AppProfileRepository
implements CodeGenerator.CodeChecker {
    private File repositoryDirectory;
    private Object cache_LOCK = new Object();
    private Cache<String, AppProfile> cache = new Cache("AppProfiles", 1000);
    private String PREFIX = "Profile-";
    private transient HashMap<String, String> appProfileShortIDToIDMap = new HashMap();
    private CodeGenerator codeGenerator = new CodeGenerator(10, true, this);

    public AppProfileRepository(File repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.cache_LOCK;
        synchronized (object) {
            this.cache.clear();
        }
    }

    private void load() {
        File[] files = this.repositoryDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().startsWith(this.PREFIX)) continue;
            String ID = file.getName().substring(this.PREFIX.length());
            this.getProfile(ID);
        }
    }

    private String getNextProfileID() {
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 24) {
            sb.append(BCUtil.getNextAbsID());
        }
        return sb.toString();
    }

    private String getNextShortProfileID() {
        return this.codeGenerator.getNewCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(AppProfile profileToDelete) {
        File file = new File(this.repositoryDirectory, this.PREFIX + profileToDelete.getID());
        if (file.exists()) {
            file.delete();
        }
        Object object = this.cache_LOCK;
        synchronized (object) {
            this.cache.removeFromCache(profileToDelete.getID());
        }
        this.appProfileShortIDToIDMap.remove(profileToDelete.getAlias());
    }

    public AppProfile createNewProfile(String typeID, String name) {
        String shortID = this.getNextShortProfileID();
        String ID = this.getNextProfileID();
        AppProfile profile = new AppProfile(AppProfiles.getProfileTypeByID(typeID), ID, shortID);
        this.appProfileShortIDToIDMap.put(shortID, ID);
        profile.setName(name);
        this.setProfile(profile);
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProfile(AppProfile profile) {
        try {
            File file = new File(this.repositoryDirectory, this.PREFIX + profile.getID());
            String value = this.getProfileAsDynpropValue(profile.toMessage());
            FileUtil.writeFileAsStringUTF8(file, value);
            Object object = this.cache_LOCK;
            synchronized (object) {
                this.cache.addToCache(profile.getID(), profile);
                this.appProfileShortIDToIDMap.put(profile.getAlias(), profile.getID());
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public AppProfile getProfileByShortID(String shortID) {
        return this.getProfile(this.appProfileShortIDToIDMap.get(shortID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppProfile getProfile(String id) {
        try {
            AppProfile ret;
            Object object = this.cache_LOCK;
            synchronized (object) {
                ret = this.cache.getFromCache(id);
                if (ret != null) {
                    return ret;
                }
            }
            File file = new File(this.repositoryDirectory, this.PREFIX + id);
            String raw = FileUtil.readFileAsStringUTF8(file);
            ret = AppProfile.fromMessage(AppProfileRepository.loadAppProfile(raw));
            Object object2 = this.cache_LOCK;
            synchronized (object2) {
                this.cache.addToCache(id, ret);
            }
            return ret;
        }
        catch (Throwable x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppProfile[] getProfilesByType(String profileTypeID) {
        ArrayList<AppProfile> result = new ArrayList<AppProfile>();
        Object object = this.cache_LOCK;
        synchronized (object) {
            Set<String> keys = this.cache.getKeySet();
            for (String key : keys) {
                AppProfile profile = this.cache.getFromCache(key);
                if (!profile.getType().getID().equals(profileTypeID)) continue;
                result.add(profile);
            }
        }
        return result.toArray(new AppProfile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppProfile[] getProfiles() {
        ArrayList<AppProfile> result = new ArrayList<AppProfile>();
        Object object = this.cache_LOCK;
        synchronized (object) {
            Set<String> keys = this.cache.getKeySet();
            for (String key : keys) {
                AppProfile profile = this.cache.getFromCache(key);
                result.add(profile);
            }
        }
        return result.toArray(new AppProfile[0]);
    }

    public String getProfileAsDynpropValue(Message profile) {
        byte[] data = MessageUtils.messageToBytes(profile);
        try {
            data = BestCaseCompressor.compress(data);
            data = BCUtil.encryptWithSecret(data, "dgsdajkweuicbjhwqehkqwjroaisdhjkahrieuhfiuabjhksahuhiuy3898yr78tiuyskgdaguidljh2434343434343gddkj3hj3jkdskskkkkkk", "shdskjahkjdasbjkeu82y38yghjdksabhjkxzxqe2lwvcjwjghioignxsurur%", 800);
            return WebBase64.byteArrayToBase64(data);
        }
        catch (IOException x) {
            return null;
        }
    }

    public static AppProfile decodeAppProfile(String dynpropValue) {
        return new AppProfile(TypedMap.fromMessage(AppProfileRepository.loadAppProfile(dynpropValue)));
    }

    private static Message loadAppProfile(String dynpropValue) {
        byte[] data = WebBase64.base64ToByteArray(dynpropValue);
        try {
            data = BCUtil.decryptWithSecret(data, "dgsdajkweuicbjhwqehkqwjroaisdhjkahrieuhfiuabjhksahuhiuy3898yr78tiuyskgdaguidljh2434343434343gddkj3hj3jkdskskkkkkk", "shdskjahkjdasbjkeu82y38yghjdksabhjkxzxqe2lwvcjwjghioignxsurur%", 800);
            data = BestCaseCompressor.decompress(data);
            return MessageUtils.bytesToMessage(data);
        }
        catch (IOException x) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Message m = new Message();
        m.append(1);
        m.append(7);
        m.append(9);
        m.append("Mr Chunky");
        m.append("Sample Data");
        System.out.println(new AppProfileRepository(new File(".")).getProfileAsDynpropValue(m).length());
    }

    @Override
    public boolean codeAlreadyUsed(String code) {
        return this.appProfileShortIDToIDMap.containsKey(code);
    }
}

