/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.InfiniteLoop;

public class UnqueuedSemaphore {
    Object sem_LOCK = new Object();
    private int current;

    public UnqueuedSemaphore(int initial) {
        this.current = initial - 1;
    }

    public int getCurrent() {
        return this.current;
    }

    public void acquire(int count) {
        try {
            this.acquire(count, true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(int count, boolean hideInterrupts) throws InterruptedException {
        boolean hadToWait = false;
        Object object = this.sem_LOCK;
        synchronized (object) {
            InfiniteLoop il = new InfiniteLoop();
            while (count > 0) {
                il.LOOP();
                if (this.current >= 0) {
                    if (this.current < count) {
                        count -= this.current + 1;
                        this.current = -1;
                        continue;
                    }
                    this.current -= count;
                    return hadToWait;
                }
                try {
                    hadToWait = true;
                    this.sem_LOCK.wait();
                }
                catch (InterruptedException e) {
                    if (hideInterrupts) {
                        e.printStackTrace();
                        continue;
                    }
                    throw e;
                }
            }
        }
        return hadToWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int count) {
        Object object = this.sem_LOCK;
        synchronized (object) {
            this.current += count;
            if (this.current - count < 0) {
                this.sem_LOCK.notifyAll();
            }
        }
    }
}

