/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.SafeClock;
import java.text.DecimalFormat;

public class RTTBuckets {
    public static long IGNORE_FIRST_MS = 20000L;
    public static int[] rttLimits = new int[30];
    public long[] rtts = new long[rttLimits.length];
    long setupAt = SafeClock.currentTimeMillis();

    public RTTBuckets cloneSelf() {
        RTTBuckets buckets = new RTTBuckets();
        buckets.rtts = (long[])this.rtts.clone();
        return buckets;
    }

    public void clear() {
        for (int i = 0; i < this.rtts.length; ++i) {
            this.rtts[i] = 0L;
        }
    }

    public String getRttLines(String prefix, boolean header, boolean data) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (header) {
            sb.append(prefix + " Bands:");
            DecimalFormat dfMs = new DecimalFormat("000");
            DecimalFormat df = new DecimalFormat("#.0");
            for (i = 0; i < rttLimits.length; ++i) {
                int num = rttLimits[i];
                if (i == rttLimits.length - 1) {
                    sb.append(">>>");
                    continue;
                }
                if (num < 1000) {
                    sb.append(dfMs.format(num) + "|");
                    continue;
                }
                if (num < 10000) {
                    sb.append(df.format((double)num / 1000.0) + "|");
                    continue;
                }
                sb.append(num / 1000 + "s|");
            }
            sb.append("\n");
        }
        if (data) {
            double total = 0.0;
            for (i = 0; i < this.rtts.length; ++i) {
                total += (double)this.rtts[i];
            }
            double frac = 100.0 / total;
            DecimalFormat df = new DecimalFormat("0");
            sb.append(prefix + " RTTs :");
            if (!Double.isNaN(frac) && !Double.isInfinite(frac)) {
                for (int i2 = 0; i2 < this.rtts.length; ++i2) {
                    double pc = frac * (double)this.rtts[i2];
                    if (pc == 0.0) {
                        sb.append("    ");
                        continue;
                    }
                    String str = df.format(Math.min(99.0, pc));
                    if (str.length() == 1) {
                        sb.append(" " + str + "% ");
                        continue;
                    }
                    sb.append(str + "% ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void rttMeasured(long rtt) {
        if (SafeClock.currentTimeMillis() < this.setupAt + IGNORE_FIRST_MS) {
            return;
        }
        for (int i = 0; i < rttLimits.length; ++i) {
            if (rtt > (long)rttLimits[i]) continue;
            int n = i;
            this.rtts[n] = this.rtts[n] + 1L;
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < rttLimits.length; ++i) {
            System.out.println(rttLimits[i]);
        }
        RTTBuckets stats = new RTTBuckets();
        for (int i = 0; i < 1000; ++i) {
            stats.rttMeasured(1400L);
        }
        System.out.println(stats.getRttLines("Network", true, true));
    }

    static {
        double L = 20.0;
        for (int i = 0; i < rttLimits.length; ++i) {
            RTTBuckets.rttLimits[i] = (int)L;
            L *= 1.3;
        }
        RTTBuckets.rttLimits[RTTBuckets.rttLimits.length - 1] = Integer.MAX_VALUE;
    }
}

