/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.InfiniteLoop;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataUtils {
    public static String readAllAsString(InputStream in) throws IOException {
        byte[] dat = DataUtils.readAll(in);
        return new String(dat, 0, dat.length, "ISO-8859-1");
    }

    public static String readAllAsStringUTF8(InputStream in) throws IOException {
        byte[] dat = DataUtils.readAll(in);
        return new String(dat, 0, dat.length, "UTF8");
    }

    public static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        InfiniteLoop il = new InfiniteLoop();
        while (n != -1) {
            il.LOOP();
            n = in.read(buf, 0, 65536);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }

    public static void writeBytes(OutputStream out, byte[] b) throws IOException {
        DataUtils.writeInt(out, b.length);
        out.write(b, 0, b.length);
    }

    public static void writeBytes(OutputStream out, byte[] b, int off, int len) throws IOException {
        DataUtils.writeInt(out, len);
        out.write(b, off, len);
    }

    public static void writeString(OutputStream out, String n) throws IOException {
        DataUtils.writeBytes(out, n.getBytes());
    }

    public static void writeStringUTF8(OutputStream out, String n) throws IOException {
        DataUtils.writeBytes(out, n.getBytes("UTF-8"));
    }

    public static void writeStringUTF8orNull(OutputStream out, String n) throws IOException {
        if (n == null) {
            DataUtils.writeBoolean(out, true);
        } else {
            DataUtils.writeBoolean(out, false);
            DataUtils.writeBytes(out, n.getBytes("UTF-8"));
        }
    }

    public static void writeStringASCII(OutputStream out, String n) throws IOException {
        DataUtils.writeBytes(out, n.getBytes("ASCII"));
    }

    public static void writeLong(OutputStream out, long n) throws IOException {
        out.write((byte)(n >>> 56));
        out.write((byte)(n >>> 48));
        out.write((byte)(n >>> 40));
        out.write((byte)(n >>> 32));
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeDouble(OutputStream out, double n) throws IOException {
        DataUtils.writeLong(out, Double.doubleToLongBits(n));
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeInt(byte[] buf, int n) throws IOException {
        buf[0] = (byte)(n >>> 24);
        buf[1] = (byte)(n >>> 16);
        buf[2] = (byte)(n >>> 8);
        buf[3] = (byte)n;
    }

    public static void writeFloat(OutputStream out, float n) throws IOException {
        DataUtils.writeInt(out, Float.floatToIntBits(n));
    }

    public static void writeShort(OutputStream out, short n) throws IOException {
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeShortNetOrder(OutputStream out, short n) throws IOException {
        out.write((byte)n);
        out.write((byte)(n >>> 8));
    }

    public static void writeChar(OutputStream out, char v) throws IOException {
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeBoolean(OutputStream out, boolean n) throws IOException {
        if (n) {
            out.write(255);
        } else {
            out.write(238);
        }
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        int red = 0;
        InfiniteLoop il = new InfiniteLoop();
        for (int tot = 0; tot < len; tot += red) {
            il.LOOP();
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static byte[] readBytes(InputStream in, int len, byte[] b) throws IOException {
        int red = 0;
        InfiniteLoop il = new InfiniteLoop();
        for (int tot = 0; tot < len; tot += red) {
            il.LOOP();
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static byte[] readLine(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int last = -1;
        int c = in.read();
        if (c == -1) {
            throw new IOException("End of stream");
        }
        InfiniteLoop il = new InfiniteLoop();
        while (c != 10 && c != -1) {
            il.LOOP();
            if (last != -1) {
                bout.write(last);
            }
            last = c;
            c = in.read();
        }
        if (last != -1 && last != 13) {
            bout.write(last);
        }
        return bout.toByteArray();
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len = DataUtils.readInt(in);
        byte[] b = new byte[len];
        int red = 0;
        InfiniteLoop il = new InfiniteLoop();
        for (int tot = 0; tot < len; tot += red) {
            il.LOOP();
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static String readString(InputStream in) throws IOException {
        return new String(DataUtils.readBytes(in));
    }

    public static String readStringUTF8(InputStream in) throws IOException {
        return new String(DataUtils.readBytes(in), "UTF-8");
    }

    public static String readStringUTF8orNull(InputStream in) throws IOException {
        if (DataUtils.readBoolean(in)) {
            return null;
        }
        return new String(DataUtils.readBytes(in), "UTF-8");
    }

    public static String readStringASCII(InputStream in) throws IOException {
        return new String(DataUtils.readBytes(in), "ASCII");
    }

    public static byte[] readNBytes(InputStream in, int maxlen) throws IOException {
        int len = DataUtils.readInt(in);
        if (len < 0) {
            throw new IOException("Invalid data length specified (" + len + ")");
        }
        if (len > maxlen) {
            throw new IOException("Unsafe data length specified (" + len + ")");
        }
        byte[] b = new byte[len];
        int red = 0;
        InfiniteLoop il = new InfiniteLoop();
        for (int tot = 0; tot < len; tot += red) {
            il.LOOP();
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream (tried to read " + len + " but only read " + tot + " before end of data)");
        }
        return b;
    }

    public static String readNString(InputStream in, int maxlen) throws IOException {
        return new String(DataUtils.readNBytes(in, maxlen));
    }

    public static String readNStringUTF8(InputStream in, int maxlen) throws IOException {
        return new String(DataUtils.readNBytes(in, maxlen), "UTF-8");
    }

    public static String readNStringASCII(InputStream in, int maxlen) throws IOException {
        return new String(DataUtils.readNBytes(in, maxlen), "ASCII");
    }

    public static long readLong(InputStream in) throws IOException {
        long n = 0L;
        int r = 0;
        for (int i = 0; i < 8; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | (long)r;
        }
        return n;
    }

    public static double readDouble(InputStream in) throws IOException {
        long l = DataUtils.readLong(in);
        return Double.longBitsToDouble(l);
    }

    public static int readInt(InputStream in) throws IOException {
        int n = 0;
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | r;
        }
        return n;
    }

    public static float readFloat(InputStream in) throws IOException {
        int i = DataUtils.readInt(in);
        return Float.intBitsToFloat(i);
    }

    public static short readShort(InputStream in) throws IOException {
        short n = 0;
        int r = 0;
        for (int i = 0; i < 2; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = (short)(n << 8 | r);
        }
        return n;
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        if (a == -1 || b == -1) {
            throw new EOFException("End of stream");
        }
        return (char)(a << 8 | b & 0xFF);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException("End of stream");
        }
        return n == 255;
    }
}

