/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.udp;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.Transport;
import com.aem.nodelink.udp.UdpPacketHandler;
import com.aem.nodelink.udp.UdpTransport;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UdpEndpoint
implements Endpoint {
    InetAddress inetaddr;
    String host;
    int port;
    String stringval;
    int lport = -1;
    boolean isServerEndpoint = false;
    long udpConnectTimeout = 10000L;
    String bindIp = null;
    long lastReceivedData = 0L;
    UdpPacketHandler alt;
    short forwardingID = 0;
    DatagramSocket useSock;
    Object sendBuffer;
    long discardAllUntil = 0L;

    public UdpEndpoint(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            this.inetaddr = InetAddress.getByName(host);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.stringval = host + ":" + port;
    }

    public UdpEndpoint(InetAddress returnhost, int port) {
        this.inetaddr = returnhost;
        this.port = port;
        this.stringval = returnhost + ":" + port;
    }

    public DatagramSocket getExistingDatagramSocket() {
        return this.useSock;
    }

    public void setExistingDatagramSocket(DatagramSocket dsock) {
        this.useSock = dsock;
    }

    public boolean hasForwardingID() {
        return this.forwardingID != 0;
    }

    public void setForwardingID(short fid) {
        this.forwardingID = fid;
    }

    public void setLocalPort(int port) {
        this.lport = port;
    }

    public void setReturnHost(InetAddress addr) {
        this.inetaddr = addr;
    }

    public void setUdpConnectTimeout(long millis) {
        this.udpConnectTimeout = millis;
    }

    public void setBindIp(String ip) {
        this.bindIp = ip;
    }

    public String toString() {
        return this.stringval;
    }

    @Override
    public Transport newTransport(Node n) {
        return new UdpTransport(n, this.udpConnectTimeout);
    }

    public void setIsServerEndpoint(boolean b) {
        this.isServerEndpoint = b;
    }

    public boolean isServerEndpoint() {
        return this.isServerEndpoint;
    }

    public void setAlternateSocketHandler(UdpPacketHandler handler) {
        this.alt = handler;
    }

    public UdpPacketHandler getAlternateSocketHandler() {
        return this.alt;
    }
}

