/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.QuietException;
import com.aem.nodelink.utils.IterableWeakReferenceListThread;
import com.aem.nodelink.utils.SafeClock;
import java.util.HashMap;
import utils.switches.Switches;

public class QuietManager
extends IterableWeakReferenceListThread<NodeLink> {
    private static final int UDP_TIMEOUT = 9000;
    private static final int TCP_UDP_TIMEOUT = 15000;
    private static Object LOCK = new Object();
    private static QuietManager INSTANCE;
    private static long disabledUntil;
    private static HashMap<String, Long> SEEN;
    private static HashMap<String, Long> CLEARED;
    static int POLL_SLEEP_MS;
    long lastDebug = 0L;

    public static void disableGloballyFor(long ms) {
        System.out.println("QuietManager disabling for " + ms + "ms");
        disabledUntil = SafeClock.currentTimeMillis() + ms;
    }

    private static boolean amDisabled() {
        return SafeClock.currentTimeMillis() < disabledUntil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seen(NodeLinkConversation key) {
        Object object = LOCK;
        synchronized (object) {
            SEEN.put(key.toString(), SafeClock.currentTimeMillis());
            if (Switches.SH_1468_nlQuietManagerDetectClearBug && CLEARED.containsKey(key.toString())) {
                long clearedAt = CLEARED.get(key.toString());
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("QuietManager cleared " + key.toString() + " but then it was SEEN " + (SafeClock.currentTimeMillis() - clearedAt) + "ms LATER!");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastSeen(NodeLinkConversation key) {
        Long last;
        Object object = LOCK;
        synchronized (object) {
            last = SEEN.get(key.toString());
        }
        if (last == null) {
            return 0L;
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSeen(NodeLinkConversation key) {
        Object object = LOCK;
        synchronized (object) {
            if (Switches.SH_1468_nlQuietManagerDetectClearBug) {
                CLEARED.put(key.toString(), SafeClock.currentTimeMillis());
            } else {
                SEEN.remove(key.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuietManager get() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new QuietManager();
            }
        }
        return INSTANCE;
    }

    private QuietManager() {
        super("QuietManager", POLL_SLEEP_MS, 120000);
    }

    public void registerNodeLink(NodeLink nodelink) {
        if (Switches.SH_1468_debugging) {
            System.out.println("[SH-1468] Connection " + nodelink + " registered with QuietManager");
        }
        this.addToList(nodelink);
    }

    public void deregisterNodeLink(NodeLink nodelink) {
        if (Switches.SH_1468_debugging) {
            System.out.println("[SH-1468] Connection " + nodelink + " REMOVED from QuietManager");
        }
        this.removeFromList(nodelink);
    }

    @Override
    protected void process(NodeLink nodelink) {
        if (QuietManager.amDisabled()) {
            long timeSinceLastPacket = nodelink.getTimeSinceIncomingData();
            if (timeSinceLastPacket > nodelink.getReconnectTimeoutMs() && Switches.SH_1468_nlQuietManagerDieOnQuiet) {
                if (Switches.SH_1468_debugging) {
                    System.out.println("[SH-1468] QuietManager is terminating " + nodelink);
                }
                nodelink.removeFromQuietManager();
                this.deregisterNodeLink(nodelink);
                try {
                    if (nodelink.isAlive() || !Switches.SH_1468_quietManagerNotKillAlreadyDead) {
                        System.out.println("QuietManager terminating " + nodelink);
                        nodelink.channelDiedDueToQuiet();
                    }
                }
                catch (Throwable throwable) {}
            } else if (timeSinceLastPacket > 9000L && nodelink.isUsingFlowControl() && Switches.SH_1468_nlQuietManagerDownOnQuiet) {
                if (!nodelink.isDown()) {
                    nodelink.linkDown(new QuietException("No UDP packets through for some time"));
                }
            } else if (timeSinceLastPacket > 15000L && Switches.SH_1468_nlQuietManagerDownOnQuiet) {
                if (!nodelink.isDown()) {
                    nodelink.linkDown(new QuietException("No TCP data through for some time"));
                }
            } else {
                if (Switches.SH_1468_debugging) {
                    System.out.println("[SH-1468] Connection " + nodelink + " is still alive, last received data " + timeSinceLastPacket + "ms ago");
                }
                if (nodelink.isDown()) {
                    nodelink.linkOK();
                }
            }
        }
    }

    static {
        disabledUntil = 0L;
        SEEN = new HashMap();
        CLEARED = new HashMap();
        POLL_SLEEP_MS = Switches.SH_1468_nlQuietManagerDetectClearBug ? 50 : 500;
    }
}

