/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkFlowController;

public class NodeLinkLatencyLossController
implements NodeLinkFlowController {
    Object LOCK = new Object();
    Object flow_LOCK = new Object();
    private static final boolean SAWTOOTH_RATE_CONSTANT_IN_RATE_BAND = true;
    private static final boolean RESET_ON_PACKET_LOSS_DURING_RESEND = false;
    private static final boolean KEEP_FAST_CLIMB_ON_HIGH_LATENCY = false;
    private static final int HIGH_LATENCY = 350;
    private static final int MIN_MS_PER_CLIMB = 100;
    private static final boolean GRADUATE_RTTS_PER_CLIMB_BASED_ON_LATENCY = true;
    private static final boolean LIMIT_RTTS_PER_CLIMB_TO_PRODUCE_MIN_INCREASE_SPEED = false;
    private static final boolean IGNORE_FREQUENT_PACKET_LOSS_ON_HIGH_LATENCY = false;
    public static boolean BYPASS_ALL_FLOW_CONTROL = false;
    boolean MINIMISE_CHOPPINESS_DUE_TO_WRITE_RESTRICTIONS = true;
    boolean MINIMISE_LATENCY_DUE_TO_BUFFER_BLOAT = true;
    boolean fixedFlowRate = false;
    int bytesPerT;
    int bytesPerTMax = 50000;
    final long T = 10L;
    int increaseWhenMaxedForMax = 18;
    int increaseWhenMaxedForMin = 3;
    int increaseWhenMaxedFor;
    boolean maxed = false;
    int maxedFor = 0;
    double backoffFactor = 0.7;
    int backedOffForSoReset = 3;
    int backedOffFor = 0;
    double increaseFactor;
    int increasesPerBackoff;
    int increasesPerBackoffMax;
    int increasedForSoReset;
    int increasedFor = 0;
    double badRttGradient = 1.035;
    double goodRttGradient = 0.98;
    int latencyDecreases = 0;
    int latencyIncreases = 0;
    int latencyValidSample = 7;
    int latencyActNowSample = 9;
    int rttSamples = 0;
    int rttSamplesPerRttAverage;
    int rttSamplesPerRttAverageConstant;
    int rttSamplesPerRttAverageMax = 16;
    double prevRttAverage = -1.0;
    double currentRttTotal;
    double currentRttCount;
    double logBase2Factor = Math.log(2.0);
    private static boolean ADJUST_LATENCY_RESPONSE_BASED_ON_RATE = false;
    private static boolean BAN_INCREASES_WHEN_LATENCY_DROPS = false;
    long nextReductionAt = 0L;
    long nextIncreaseAt = 0L;
    long latestAckReceived;
    long latestPacketSent;
    boolean waitedThisT = false;
    long currentT = 0L;
    int bytesInCurrentT = 0;
    long lastRTT = 0L;
    double lastRTTsmooth = 0.0;
    long prevT = 0L;
    long backoffIfPacketLossWithin = 0L;
    long lastLossPoint = -1L;
    long nextBackoffAt = 0L;
    long timeUntilBackoff = 0L;
    int lossCount = 0;

    public boolean maySlowFlow() {
        return true;
    }

    @Override
    public byte[] nextRequiredPacket() {
        return null;
    }

    public void setLowLatencyRequired(boolean b) {
        this.MINIMISE_CHOPPINESS_DUE_TO_WRITE_RESTRICTIONS = b;
        this.MINIMISE_LATENCY_DUE_TO_BUFFER_BLOAT = b;
    }

    public NodeLinkLatencyLossController() {
        this.resetBytesPerTRate();
        this.resetClimbRate();
    }

    private void resetBytesPerTRate() {
        if (!this.fixedFlowRate) {
            this.bytesPerT = 500;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxDataPerWrite() {
        Object object = this.LOCK;
        synchronized (object) {
            return Math.max(200, this.bytesPerT);
        }
    }

    @Override
    public void setInitialRateKbPerSec(int kbPerSec) {
    }

    @Override
    public double getRateKbPerSec() {
        double rate = 100.0;
        rate = (double)this.bytesPerT * rate;
        return rate /= 1024.0;
    }

    public void setFlexibleFlowRate() {
        this.fixedFlowRate = false;
        System.out.println("[NLFC] Using flexible flow rate");
    }

    public void setFixedFlowRate(double kbps) {
        this.fixedFlowRate = true;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double bytesps = 1024.0 * kbps;
        this.bytesPerT = (int)(bytesps / 100.0);
        System.out.println("[NLFC] Fixing flow rate at " + kbps + "KB/s = " + this.getRateKbPerSec());
    }

    private void recalculateMaxFlowDetection() {
        double rate = this.getRateKbPerSec();
        this.increaseWhenMaxedFor = (int)Math.max(0.0, 1.5 * Math.log(rate) - 3.0);
        if (this.lastRTT == 0L) {
            this.increaseWhenMaxedFor = 3;
        } else {
            if (this.lastRTTsmooth < 50.0) {
                this.increaseWhenMaxedFor += 4;
            } else if (this.lastRTTsmooth < 100.0) {
                this.increaseWhenMaxedFor += 3;
            } else if (this.lastRTTsmooth < 200.0) {
                this.increaseWhenMaxedFor += 2;
            } else if (this.lastRTTsmooth > 500.0) {
                this.increaseWhenMaxedFor /= 2;
            }
            int rttMin = (int)(100.0 / Math.max((double)this.lastRTT, Math.max(5.0, this.lastRTTsmooth)));
            this.increaseWhenMaxedFor = Math.max(rttMin, this.increaseWhenMaxedFor);
        }
        if (NodeLink.VERBOSE_FLOW_RATE) {
            System.out.println("[NLFC] Rate " + rate + "k/sec, Will plane at " + this.increaseWhenMaxedFor + " RTTs, ><=" + this.lastRTTsmooth);
        }
    }

    private void resetClimbRate() {
        this.recalculateMaxFlowDetection();
        this.increasesPerBackoff = 1;
        this.increasesPerBackoffMax = 6;
        this.recalculateClimbFactor();
    }

    private void slowClimbRate() {
        if (this.increasesPerBackoff < this.increasesPerBackoffMax) {
            ++this.increasesPerBackoff;
        }
        this.recalculateClimbFactor();
    }

    private void recalculateClimbFactor() {
        this.increaseFactor = (1.0 / this.backoffFactor - 1.0) / (double)this.increasesPerBackoff;
        this.increasedForSoReset = Math.max((int)Math.ceil(this.increasesPerBackoff) + 2, (int)Math.ceil((double)this.increasesPerBackoff * 1.3));
        this.recalculateRttSamplesForLatencyCeiling();
    }

    private void recalculateRttSamplesForLatencyCeiling() {
        if (!ADJUST_LATENCY_RESPONSE_BASED_ON_RATE) {
            this.rttSamplesPerRttAverageConstant = 6;
        }
    }

    public static void main(String[] args) throws Exception {
        NodeLinkLatencyLossController control = new NodeLinkLatencyLossController();
        control.bytesPerT = 10;
        for (int i = 0; i < 30; ++i) {
            control.recalculateRttSamplesForLatencyCeiling();
            System.out.println("[NLFC] " + 100 * control.bytesPerT + " bytes/sec = " + control.rttSamplesPerRttAverage + " samples");
            control.bytesPerT = (int)((double)control.bytesPerT * 1.5);
        }
    }

    int nlinfoGetLatencyIncreases() {
        return this.latencyIncreases;
    }

    int nlinfoGetLatencyDecreases() {
        return this.latencyDecreases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rttMeasured(long rtt) {
        Object object = this.LOCK;
        synchronized (object) {
            if (NodeLink.FIX_SYSTEM_CLOCK_CHANGES) {
                if (rtt < 0L) {
                    System.out.println("[NLFC] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
                if (rtt > 30000L) {
                    System.out.println("[NLFC] System clock changed produced erroneous RTT, ignoring");
                    return 30000L;
                }
            }
            this.lastRTT = rtt;
            this.lastRTTsmooth = this.lastRTTsmooth * 0.9 + (double)this.lastRTT * 0.1;
            rtt = (long)this.lastRTTsmooth;
            this.lastRTT = (long)this.lastRTTsmooth;
            if (this.MINIMISE_LATENCY_DUE_TO_BUFFER_BLOAT) {
                this.currentRttTotal += (double)rtt;
                this.currentRttCount += 1.0;
                ++this.rttSamples;
                boolean validRttSample = false;
                if (!(ADJUST_LATENCY_RESPONSE_BASED_ON_RATE && this.latencyIncreases == this.latencyValidSample - 2 || this.latencyDecreases == this.latencyValidSample - 2 || this.rttSamples < this.rttSamplesPerRttAverageConstant)) {
                    validRttSample = true;
                }
                if (validRttSample) {
                    this.rttSamples = 0;
                    double currentRttAverage = this.currentRttTotal / this.currentRttCount;
                    this.currentRttTotal = 0.0;
                    this.currentRttCount = 0.0;
                    if (this.prevRttAverage != -1.0) {
                        if (this.latencyIncreases >= this.latencyValidSample) {
                            ++this.latencyIncreases;
                        } else if (this.latencyDecreases >= this.latencyValidSample) {
                            ++this.latencyDecreases;
                        } else if (currentRttAverage / this.prevRttAverage > this.badRttGradient) {
                            this.latencyDecreases = 0;
                            ++this.latencyIncreases;
                        } else if (this.prevRttAverage / currentRttAverage < this.goodRttGradient) {
                            this.latencyIncreases = 0;
                            ++this.latencyDecreases;
                        }
                    }
                    if (this.latencyIncreases >= this.latencyActNowSample) {
                        this.latencyIncreases = 0;
                        if (NodeLink.VERBOSE_FLOW_RATE) {
                            System.out.println("[NLFC] Latency increasing (" + this.prevRttAverage + "->" + currentRttAverage + "), dropping flow rate");
                        }
                        this.congestionOrBloatDetected("Rampant Latency", true);
                    }
                    if (this.latencyDecreases >= this.latencyActNowSample && BAN_INCREASES_WHEN_LATENCY_DROPS) {
                        this.latencyDecreases = 0;
                        if (NodeLink.VERBOSE_FLOW_RATE) {
                            System.out.println("[NLFC] Latency dropping (" + this.prevRttAverage + "->" + currentRttAverage + "), preventing increases");
                        }
                        this.maxedFor = -this.rttSamplesPerRttAverage;
                    }
                    this.prevRttAverage = currentRttAverage;
                }
            }
        }
        return (long)this.lastRTTsmooth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ackReceived(long ack) {
        Object object = this.LOCK;
        synchronized (object) {
            this.latestAckReceived = Math.max(this.latestAckReceived, ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void packetSent(long packet) {
        Object object = this.LOCK;
        synchronized (object) {
            this.latestPacketSent = Math.max(this.latestPacketSent, packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flowControl(int size, boolean allowIncrease) {
        if (BYPASS_ALL_FLOW_CONTROL) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            long newT = System.currentTimeMillis() / 10L;
            long delta = newT - this.prevT;
            if (delta > 35L) {
                if (NodeLink.VERBOSE_FLOW_RATE) {
                    System.out.println("[NLFC] Break in data " + delta + " reset max");
                }
                this.maxedFor = 0;
            }
            if (allowIncrease && this.latestAckReceived > this.nextIncreaseAt) {
                if (this.maxed) {
                    ++this.maxedFor;
                    if (this.maxedFor >= this.increaseWhenMaxedFor) {
                        ++this.increasedFor;
                        this.backedOffFor = 0;
                        if (this.increasedFor >= this.increasedForSoReset) {
                            this.increasedFor = 0;
                            if (NodeLink.VERBOSE_FLOW_RATE) {
                                System.out.println("[NLFC] Increased a lot - unsteady so resetting climb rate");
                            }
                            this.resetClimbRate();
                        }
                        long oldBytesPerT = this.bytesPerT;
                        if (!this.fixedFlowRate) {
                            if (this.bytesPerT < this.bytesPerTMax) {
                                this.bytesPerT = (int)((double)this.bytesPerT * (1.0 + this.increaseFactor));
                            }
                            if ((long)this.bytesPerT == oldBytesPerT) {
                                ++this.bytesPerT;
                            }
                        }
                        this.recalculateRttSamplesForLatencyCeiling();
                        this.recalculateMaxFlowDetection();
                        if (NodeLink.INFO_FEED != null) {
                            NodeLink.INFO_FEED.addMarker(5.0);
                        }
                        if (NodeLink.VERBOSE_FLOW_RATE) {
                            double ifac = (int)(this.increaseFactor * 100.0);
                            double rtt = (int)(this.lastRTTsmooth * 100.0);
                            System.out.println("[NLFC] BytesPerT (^=" + this.increaseWhenMaxedFor + " *=" + (1.0 + (ifac /= 100.0)) + " ...=" + this.increasesPerBackoff + " !=" + this.increasedForSoReset + " ><=" + (rtt /= 100.0) + ") ++> " + this.bytesPerT + " (" + (long)this.bytesPerT * 100L / 1024L + "k/sec)");
                        }
                        this.maxedFor = 0;
                    }
                }
                this.maxed = true;
                this.nextIncreaseAt = this.latestPacketSent;
            }
            this.bytesInCurrentT += size;
        }
        object = this.flow_LOCK;
        synchronized (object) {
            while (this.bytesInCurrentT > this.bytesPerT) {
                this.waitedThisT = true;
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object2 = this.LOCK;
                synchronized (object2) {
                    long thisT = System.currentTimeMillis() / 10L;
                    if (thisT != this.currentT) {
                        this.currentT = thisT;
                        this.bytesInCurrentT -= this.bytesPerT;
                        if (!this.waitedThisT) {
                            this.maxed = false;
                        }
                        this.waitedThisT = false;
                    }
                }
            }
        }
        this.prevT = System.currentTimeMillis() / 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWasRestricted() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.MINIMISE_CHOPPINESS_DUE_TO_WRITE_RESTRICTIONS) {
                this.congestionOrBloatDetected("Write Restricted", false);
            }
        }
    }

    @Override
    public void packetLossDuringResendDetected(long atPoint, long holeSize) {
        this.packetLossDetected(atPoint, holeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void packetLossDetected(long atPoint, long holeSize) {
        Object object = this.LOCK;
        synchronized (object) {
            if (NodeLink.VERBOSE_FLOW_RATE) {
                System.out.println("[NLFC] Restart from " + atPoint + " (hole=" + holeSize + "b)");
            }
            long T = System.currentTimeMillis();
            boolean congested = false;
            String subReason = "";
            if (this.lastRTTsmooth > 350.0) {
                // empty if block
            }
            if (T < this.backoffIfPacketLossWithin) {
                congested = true;
                subReason = "(frequent)";
                ++this.lossCount;
            }
            this.backoffIfPacketLossWithin = T + (long)(this.lastRTTsmooth * 50.0);
            this.lossCount = 0;
            this.lastLossPoint = atPoint;
            this.congestionOrBloatDetected("Packet Loss (" + subReason + ") @" + atPoint + " (" + holeSize + "b)", true);
            T = System.currentTimeMillis();
            this.timeUntilBackoff = Math.max(200L, (long)(this.lastRTTsmooth * 2.0));
            this.nextBackoffAt = T + this.timeUntilBackoff;
            if (NodeLink.FIX_SYSTEM_CLOCK_CHANGES && Math.abs(T - this.nextBackoffAt) > this.timeUntilBackoff) {
                this.nextBackoffAt = 0L;
                if (NodeLink.VERBOSE_FLOW_RATE) {
                    System.out.println("[NLFC] System clock change produced resetting backoff point");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void congestionOrBloatDetected(String reason, boolean force) {
        Object object = this.LOCK;
        synchronized (object) {
            this.maxedFor = 0;
            if (force || this.latestAckReceived > this.nextReductionAt) {
                ++this.backedOffFor;
                this.increasedFor = 0;
                if (!this.fixedFlowRate) {
                    this.bytesPerT = (int)((double)this.bytesPerT * this.backoffFactor);
                    if (this.bytesPerT < 10) {
                        this.bytesPerT = 10;
                    }
                }
                this.recalculateRttSamplesForLatencyCeiling();
                this.recalculateMaxFlowDetection();
                if (NodeLink.VERBOSE_FLOW_RATE) {
                    System.out.println("[NLFC] BytesPerT --> (" + reason + ") " + this.bytesPerT + " (" + (long)this.bytesPerT * 100L / 1024L + "k/sec)");
                }
                if (NodeLink.VERBOSE_FLOW_RATE) {
                    System.out.println("[NLFC]   Latest ACK: " + this.latestAckReceived + " > " + this.nextReductionAt);
                }
                if (this.backedOffFor >= this.backedOffForSoReset) {
                    if (NodeLink.VERBOSE_FLOW_RATE) {
                        System.out.println("[NLFC] Backed off a lot - unsteady so resetting climb rate");
                    }
                    this.resetClimbRate();
                } else {
                    this.slowClimbRate();
                }
                this.nextReductionAt = this.latestPacketSent;
            }
        }
    }

    @Override
    public void readRateMeasured(long packetsPerSecond) {
    }
}

