/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import com.aem.nodelink.CloseSignal;
import com.aem.nodelink.ContactableMachineUnavailableException;
import com.aem.nodelink.Endpoint;
import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.NoEndpointException;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.NodeOutOfBandListener;
import com.aem.nodelink.OrphanPacketListener;
import com.aem.nodelink.OutOfBandData;
import com.aem.nodelink.QuietManager;
import com.aem.nodelink.Transport;
import com.aem.nodelink.TransportStatusListener;
import com.aem.nodelink.http.BasicHttpTransport;
import com.aem.nodelink.http.FullDuplexHttpTransport;
import com.aem.nodelink.http.OldHttpTransport;
import com.aem.nodelink.utils.BlockingByteInputStreamHashMap;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import utils.switches.Switches;

public class Node {
    private static final boolean VERBOSE = false;
    public boolean TRACE_ALL_NODE_CREATES = false;
    public boolean DEBUG_SHOW_ALL_PACKETS = false;
    public boolean DEBUG_SHOW_ALL_PACKETS_TRACE = false;
    private static long UNUSED_TIMEOUT = 300000L;
    public static int MAX_BUFFERED_MESSAGES_PER_CHANNEL = Switches.SH_1468_bufferMoreInNode ? 4000 : 2000;
    public static final Object UID_LOCK = new Object();
    public static final Random rand = new Random(System.currentTimeMillis());
    public static int count = 0;
    public static final Node CURRENT_JVM = new Node();
    public static long DEFAULT_SEND_TIMEOUT = 180000L;
    public static long REESTABLISH_FAST_UNTIL = 90000L;
    public static long MAX_REESTABLISH_WAIT = 5000L;
    public static long STOP_REESTABLISH_CONTACTABLE_NODE = MAX_REESTABLISH_WAIT * 2L;
    public static final int CONV_ANYONE = -1;
    OrphanPacketListener orphans;
    BlockingByteInputStreamHashMap incoming = new BlockingByteInputStreamHashMap();
    Object endpoints_LOCK = new Object();
    HashMap<String, ReachableEndpoint> endpoints = new HashMap();
    String uid;
    Throwable creator;
    int fwdID = 0;
    boolean noRetryOnBrokenTransport = false;
    boolean singleUse = false;
    Object open_LOCK = new Object();
    HashMap<String, Conversation> open = new HashMap();
    ArrayList<String> open_perm = new ArrayList();
    long lastPrintout = 0L;
    byte[] empty = new byte[0];
    long expectReconnectBy = -1L;
    Object forwards_LOCK = new Object();
    HashMap forwards = new HashMap();
    long lastPacket = SafeClock.currentTimeMillis();
    private LinkedList<WeakReference<NodeLink>> associatedNodeLinks = new LinkedList();
    boolean lastNotifiedLinkDown = false;

    void markEndpointUsed(Node node) {
        if (Switches.SH_1582_nodeEndpointsTimeOutAfterNlErrorDefault) {
            this.getEndpoint(node).updateLastUsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markConversationUsed(NodeLinkConversation conversation) {
        if (Switches.SH_1582_nodeConversationsTimeOutAfterNlErrorDefault) {
            Object object = this.open_LOCK;
            synchronized (object) {
                Conversation conv = this.open.get(conversation.OBJKEY);
                conv.updateLastUsed();
            }
        }
    }

    public ReachableEndpoint getEndpoint(Node node) {
        return this.getEndpoint(node.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReachableEndpoint getEndpoint(String nodeID) {
        ReachableEndpoint re;
        Object object = this.endpoints_LOCK;
        synchronized (object) {
            re = this.endpoints.get(nodeID);
        }
        if (re != null) {
            re.updateLastUsed();
        }
        return re;
    }

    public void setEndpoint(Node node, ReachableEndpoint re) {
        this.setEndpoint(node.toString(), re);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String nodeID, ReachableEndpoint re) {
        if (re != null) {
            re.updateLastUsed();
        }
        Object object = this.endpoints_LOCK;
        synchronized (object) {
            this.endpoints.put(nodeID, re);
            if (Switches.SH_1582_nodeEndpointsTimeOutAfterNlErrorDefault) {
                Object[] keys = this.endpoints.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    String key = (String)keys[i];
                    ReachableEndpoint tmpre = this.endpoints.get(key);
                    if (tmpre.isValid()) continue;
                    System.out.println("[NL Endpoints] Removing endpoint:" + re.e.toString() + " / " + re.t.toString());
                    this.endpoints.remove(key);
                }
            }
        }
    }

    public void setNoRetryOnBrokenTransport(boolean b) {
        this.noRetryOnBrokenTransport = b;
    }

    public void setSingleUse(boolean shutdownWithNL) {
        this.singleUse = shutdownWithNL;
    }

    public boolean isSingleUse() {
        return this.singleUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTransports() {
        Object[] eps;
        Object object = this.endpoints_LOCK;
        synchronized (object) {
            eps = this.endpoints.values().toArray();
            this.endpoints.clear();
        }
        for (int i = 0; i < eps.length; ++i) {
            try {
                ((ReachableEndpoint)eps[i]).t.cleanupAllConnections();
                continue;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private boolean canRespond() {
        long wait = 1000L;
        if (this.orphans != null) {
            wait = this.orphans.getMaxRegularityInMs();
        }
        if (SafeClock.currentTimeMillis() - this.lastPrintout > wait) {
            this.lastPrintout = SafeClock.currentTimeMillis();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newUID() {
        Object object = UID_LOCK;
        synchronized (object) {
            this.uid = "@" + (NodeLink.MACHID + Math.abs(rand.nextInt(100000))) + "" + count;
            ++count;
        }
        return this.uid;
    }

    private void setupPermanents() {
        this.incoming.setUseTimeout(5, 1);
        this.keepConversationOpenForever(new NodeLinkConversation(-1));
        this.keepConversationOpenForever(new NodeLinkConversation(NodeLink.NEW_CHANNEL_GROUP));
    }

    public Node() {
        this.uid = this.newUID();
        this.setupPermanents();
        this.creator = new Throwable("Node Creator..." + this.uid);
        if (this.TRACE_ALL_NODE_CREATES) {
            this.creator.printStackTrace(System.out);
        }
    }

    public Node(boolean singleUse) {
        this.uid = this.newUID();
        this.setupPermanents();
        this.creator = new Throwable("Node Creator..." + this.uid);
        this.setSingleUse(singleUse);
        if (this.TRACE_ALL_NODE_CREATES) {
            this.creator.printStackTrace(System.out);
        }
    }

    public Node(String name) {
        this.uid = name;
        this.setupPermanents();
        this.creator = new Throwable("Node Creator..." + this.uid);
        if (this.TRACE_ALL_NODE_CREATES) {
            this.creator.printStackTrace(System.out);
        }
    }

    public String getUID() {
        return this.uid;
    }

    public void setNewUID(String newUID) {
        this.uid = newUID;
    }

    public void setNewUID() {
        this.uid = this.newUID();
    }

    public void setOrphanPacketListener(OrphanPacketListener op) {
        if (this.orphans != op) {
            this.orphans = op;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepConversationOpenForever(NodeLinkConversation conversation) {
        this.incoming.keepOpen(conversation.OBJKEY);
        Object object = this.open_LOCK;
        synchronized (object) {
            this.open_perm.add(conversation.OBJKEY);
        }
    }

    public void setConversationOpen(NodeLinkConversation conversation) {
        this.setConversationOpen(conversation, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConversationOpen(NodeLinkConversation conversation, long until) {
        Object object = this.open_LOCK;
        synchronized (object) {
            Conversation conv = this.open.get(conversation.OBJKEY);
            if (conv == null) {
                conv = new Conversation();
                conv.until = until;
                conv.count = 0;
                this.open.put(conversation.OBJKEY, conv);
                if (Switches.SH_1582_nodeConversationsTimeOutAfterNlErrorDefault) {
                    Object[] keys = this.open.keySet().toArray();
                    for (int i = 0; i < keys.length; ++i) {
                        String key = (String)keys[i];
                        Conversation tmpconv = this.open.get(key);
                        if (tmpconv.isValid() || this.open_perm.indexOf(key) != -1) continue;
                        System.out.println("[NL Conv] Removing conversation:" + conv);
                        this.open.remove(key);
                    }
                }
            }
            conv.until = Math.max(conv.until, until);
            ++conv.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConversationExpiryDate(NodeLinkConversation conversation, long until, boolean overwrite) {
        Object object = this.open_LOCK;
        synchronized (object) {
            Conversation conv = this.open.get(conversation.OBJKEY);
            if (conv != null) {
                conv.until = overwrite ? until : Math.max(until, conv.until);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConversationClosed(NodeLinkConversation conversation) {
        Object object = this.open_LOCK;
        synchronized (object) {
            Conversation conv = this.open.get(conversation.OBJKEY);
            if (conv != null) {
                --conv.count;
                if (conv.count == 0) {
                    this.open.remove(conversation.OBJKEY);
                }
            } else {
                if (Switches.SH_XXXX_nlNodeReturnOnConversationClosed) {
                    return;
                }
                throw new Error("Error: conversation closed too many times");
            }
            this.clearConversation(conversation);
        }
    }

    private void clearConversation(NodeLinkConversation conversation) {
        block4: {
            try {
                InfiniteLoop il = new InfiniteLoop();
                if (Switches.SH_XXXX_nlNodeClearConversationsFast) {
                    this.incoming.clear(conversation.OBJKEY);
                    break block4;
                }
                while (true) {
                    il.LOOP();
                    this.incoming.get(conversation.OBJKEY, 1L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void machineIsContactable() {
        if (this.expectReconnectBy == -1L) {
            this.expectReconnectBy = SafeClock.currentTimeMillis() + STOP_REESTABLISH_CONTACTABLE_NODE;
        }
    }

    public Transport getTransportForNode(Node target) throws Exception {
        ReachableEndpoint re = this.getEndpoint(target);
        if (Switches.SH_XXXX_nlNodeReturnNullIfTransportNull && re == null) {
            return null;
        }
        return re.t;
    }

    public Endpoint getEndpointForNode(Node target) throws Exception {
        ReachableEndpoint re = this.getEndpoint(target);
        return re.e;
    }

    private ReachableEndpoint getReachableEndpointForNode(Node target) throws Exception {
        ReachableEndpoint re = this.getEndpoint(target);
        return re;
    }

    public void replaceTransportForNode(Node target, Node otherHome, Node otherTarget) throws Exception {
        ReachableEndpoint re = this.getEndpoint(target);
        this.setEndpoint(target, otherHome.getReachableEndpointForNode(otherTarget));
        re.t.cleanupAllConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapTransportForNode(Node myTarget, Node otherHome, Node otherTarget, int fwdID) throws Exception {
        Object object = this.endpoints_LOCK;
        synchronized (object) {
            Object object2 = otherHome.endpoints_LOCK;
            synchronized (object2) {
                System.out.println("[Node] Swapping NL transports");
                ReachableEndpoint myre = this.getReachableEndpointForNode(myTarget);
                ReachableEndpoint otherre = otherHome.getReachableEndpointForNode(otherTarget);
                myre.t.dropAllPackets();
                otherre.t.dropAllPackets();
                this.waitUntilNoPacketsFor(600, null, 120000L);
                otherHome.waitUntilNoPacketsFor(600, null, 120000L);
                System.out.println("[Node] Will use fwd ID " + fwdID);
                this.useForwardingID(fwdID);
                System.out.println("[Node] Pulling target into " + myre.t + " from " + otherre.t);
                myre.t.swapTargetsWith(myTarget, otherre.t, myre.e, otherTarget);
                System.out.println("[Node] Swapped targets");
                otherre.t.copyTransportData(otherTarget, myTarget, otherre.e);
                this.setEndpoint(myTarget, otherre);
                otherre.t.setMyNode(this, otherre.e);
                otherre.t.stopDroppingAllPackets();
                if (otherre.t instanceof OldHttpTransport) {
                    ((BasicHttpTransport)otherre.t).addFetchTarget(otherHome);
                }
                if (otherre.t instanceof BasicHttpTransport) {
                    ((BasicHttpTransport)otherre.t).addFetchTarget(otherHome);
                }
                if (otherre.t instanceof FullDuplexHttpTransport) {
                    ((FullDuplexHttpTransport)otherre.t).addFetchTarget(otherHome);
                }
                otherHome.endpoints.clear();
                myre.t.setMyNode(otherHome, myre.e);
                new CleanupThread(myre.t).start();
            }
        }
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key) throws Exception {
        this.sendToSpecific(packet, target, key, DEFAULT_SEND_TIMEOUT, null, null, null);
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout) throws Exception {
        this.sendToSpecific(packet, target, key, retryTimeout, null, null, null);
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout, boolean noForwardingID) throws Exception {
        this.sendToSpecific(packet, target, key, retryTimeout, null, null, null, false, noForwardingID);
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout, TransportStatusListener status) throws Exception {
        this.sendToSpecific(packet, target, key, retryTimeout, status, null, null);
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout, TransportStatusListener status, String[] oobNames, byte[][] oobDatas) throws Exception {
        this.sendToSpecific(packet, target, key, retryTimeout, status, oobNames, oobDatas, false);
    }

    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout, TransportStatusListener status, String[] oobNames, byte[][] oobDatas, boolean rarelyVerifyTransportOkLive) throws Exception {
        this.sendToSpecific(packet, target, key, retryTimeout, status, oobNames, oobDatas, rarelyVerifyTransportOkLive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToSpecific(byte[] packet, Node target, NodeLinkConversation key, long retryTimeout, TransportStatusListener status, String[] oobNames, byte[][] oobDatas, boolean rarelyVerifyTransportOkLive, boolean noForwardingID) throws Exception {
        boolean ignoreMain = false;
        if (packet == null) {
            if (oobNames != null) {
                packet = this.empty;
                ignoreMain = true;
            } else {
                throw new Exception("Main packet data and out of band data cannot both be null");
            }
        }
        long started = SafeClock.currentTimeMillis();
        int errors = 0;
        while (true) {
            try {
                Transport t;
                Endpoint e;
                byte[] ndat = new byte[4 + key.length + 4 + packet.length];
                if (!noForwardingID) {
                    ByteArrayUtils.writeInt(ndat, 0, this.fwdID);
                }
                System.arraycopy(key.data, 0, ndat, 4, key.length);
                ByteArrayUtils.writeInt(ndat, 4 + key.length, packet.length);
                System.arraycopy(packet, 0, ndat, 4 + key.length + 4, packet.length);
                if (oobNames != null) {
                    int oobs = oobNames.length;
                    ByteArrayOutputStream oobout = new ByteArrayOutputStream();
                    DataUtils.writeBoolean(oobout, ignoreMain);
                    DataUtils.writeInt(oobout, oobs);
                    for (int i = 0; i < oobNames.length; ++i) {
                        DataUtils.writeStringASCII(oobout, oobNames[i]);
                        DataUtils.writeBytes(oobout, oobDatas[i]);
                    }
                    byte[] oobdat = oobout.toByteArray();
                    byte[] tmp = new byte[ndat.length + oobdat.length];
                    System.arraycopy(ndat, 0, tmp, 0, ndat.length);
                    System.arraycopy(oobdat, 0, tmp, ndat.length, oobdat.length);
                    ndat = tmp;
                }
                this.markEndpointUsed(target);
                this.markConversationUsed(key);
                Object object = this.endpoints_LOCK;
                synchronized (object) {
                    ReachableEndpoint re = this.getEndpoint(target);
                    if (re == null) {
                        throw new NoEndpointException("Unable to send packet to " + target + ", no Endpoint address");
                    }
                    e = re.e;
                    t = re.t;
                }
                if (this.DEBUG_SHOW_ALL_PACKETS) {
                    System.out.println("[Node] Packet going OUT to " + key + " from " + target + " (" + ndat.length + ")");
                    if (this.DEBUG_SHOW_ALL_PACKETS_TRACE) {
                        new Exception("Packet Sent From...").printStackTrace();
                    }
                }
                t.sendPacketTo(target, e, ndat, rarelyVerifyTransportOkLive);
                if (status != null) {
                    status.transportLinkOK();
                }
                errors = 0;
            }
            catch (Exception t) {
                if (Switches.SH_XXXX_nlThrowImmediateOnEndpointException && t instanceof NoEndpointException) {
                    throw t;
                }
                if (this.noRetryOnBrokenTransport) {
                    throw t;
                }
                if (status != null) {
                    status.transportLinkDown(t);
                }
                if (errors > 0 && SafeClock.currentTimeMillis() - started > retryTimeout) {
                    throw t;
                }
                if (errors < 100) {
                    ++errors;
                }
                try {
                    if ((long)errors < REESTABLISH_FAST_UNTIL / 1000L) {
                        Thread.sleep(1000L);
                    } else {
                        Thread.sleep(MAX_REESTABLISH_WAIT);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (errors != 1) continue;
                this.expectReconnectBy = -1L;
                if (this.expectReconnectBy == -1L || SafeClock.currentTimeMillis() <= this.expectReconnectBy) continue;
                new Exception("Trying to close NL").printStackTrace();
                ContactableMachineUnavailableException ex = new ContactableMachineUnavailableException();
                ex.initCause(t);
                throw ex;
            }
            break;
        }
    }

    public byte[] nextSinglePacketFromSpecific(NodeLinkConversation key) {
        return this.nextSinglePacketFromSpecific(key, null);
    }

    public byte[] nextSinglePacketFromSpecific(NodeLinkConversation key, NodeOutOfBandListener ooblistener) {
        this.setConversationOpen(key);
        byte[] dat = this.nextPacketFromSpecific(key, ooblistener);
        this.setConversationClosed(key);
        return dat;
    }

    public byte[] nextSinglePacketFromSpecific(NodeLinkConversation key, long timeout, long keepopen) {
        return this.nextSinglePacketFromSpecific(key, timeout, keepopen, null);
    }

    public byte[] nextSinglePacketFromSpecific(NodeLinkConversation key, long timeout, long keepopen, NodeOutOfBandListener ooblistener) {
        this.setConversationOpen(key);
        byte[] dat = this.nextPacketFromSpecific(key, timeout, ooblistener);
        this.setConversationExpiryDate(key, System.currentTimeMillis() + keepopen, true);
        return dat;
    }

    public byte[] nextPacketFromSpecific(NodeLinkConversation key) {
        return this.nextPacketFromSpecific(key, null);
    }

    public byte[] nextPacketFromSpecific(NodeLinkConversation key, NodeOutOfBandListener ooblistener) {
        try {
            while (true) {
                Object o = this.incoming.get(key.OBJKEY);
                try {
                    return (byte[])o;
                }
                catch (ClassCastException e) {
                    OutOfBandData oob = (OutOfBandData)o;
                    if (ooblistener == null) continue;
                    for (int k = 0; k < oob.names.length; ++k) {
                        ooblistener.outOfBandData(oob.names[k], oob.datas[k]);
                    }
                    if (oob.ignoreMain) continue;
                    return oob.maindata;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public byte[] nextPacketFromSpecific(NodeLinkConversation key, long timeout) {
        return this.nextPacketFromSpecific(key, timeout, null);
    }

    public byte[] nextPacketFromSpecific(NodeLinkConversation key, long timeout, NodeOutOfBandListener ooblistener) {
        try {
            while (true) {
                Object o = this.incoming.get(key.OBJKEY, timeout);
                try {
                    return (byte[])o;
                }
                catch (ClassCastException e) {
                    OutOfBandData oob = (OutOfBandData)o;
                    if (ooblistener == null) continue;
                    for (int k = 0; k < oob.names.length; ++k) {
                        ooblistener.outOfBandData(oob.names[k], oob.datas[k]);
                    }
                    if (oob.ignoreMain) continue;
                    return oob.maindata;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public String toString() {
        return this.uid;
    }

    public void importRemoteNodeAddress(Node home, Node homeTarget, Node newTarget) {
        ReachableEndpoint re = home.getEndpoint(homeTarget);
        ReachableEndpoint myre = new ReachableEndpoint(re.e, re.t);
        this.setEndpoint(newTarget, myre);
    }

    public void setRemoteNodeAddress(Node n, Endpoint e) {
        ReachableEndpoint re = new ReachableEndpoint(e, e.newTransport(this));
        this.setEndpoint(n, re);
    }

    public void setRemoteNodeAddress(Node n, Endpoint e, Transport t) {
        ReachableEndpoint re = new ReachableEndpoint(e, t);
        this.setEndpoint(n, re);
    }

    public Transport acceptIncomingOn(Endpoint e) throws Exception {
        Transport t = e.newTransport(this);
        t.ensureAcceptingOn(e);
        return t;
    }

    public void useForwardingID(int ID) {
        this.fwdID = ID;
    }

    public int getForwardingID() {
        return this.fwdID;
    }

    public boolean isForwarding() {
        return this.fwdID != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelForwarding(int fwdID) {
        Object object = this.forwards_LOCK;
        synchronized (object) {
            ForwardTarget forwardTarget = (ForwardTarget)this.forwards.remove(fwdID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFwdValid(int fwdID) {
        Object object = this.forwards_LOCK;
        synchronized (object) {
            ForwardTarget ft = (ForwardTarget)this.forwards.get(fwdID);
            if (ft == null) {
                return false;
            }
            return ft.isValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardPacketsTo(int fwdID, Transport transport, Node fakefrom, Node target, Endpoint ep) throws Exception {
        Integer FWD = new Integer(fwdID);
        Object object = this.forwards_LOCK;
        synchronized (object) {
            this.forwards.put(FWD, new ForwardTarget(transport, fakefrom, target, ep, FWD));
            System.out.println("[NL Forwarding] Created NL forwarding rule fwd:" + FWD);
            Object[] vals = this.forwards.values().toArray();
            for (int i = 0; i < vals.length; ++i) {
                ForwardTarget ft = (ForwardTarget)vals[i];
                if (ft.isValid()) continue;
                System.out.println("[NL Forwarding] Removing NL forward fwd:" + ft.myFWD);
                this.forwards.remove(ft.myFWD);
            }
        }
    }

    public void waitUntilNoPacketsFor(int ms, CloseSignal closed, long timeout) throws IOException {
        this.waitUntilNoPacketsFor(ms, 50, closed, timeout);
    }

    public void waitUntilNoPacketsFor(int ms, int granularityMs, CloseSignal closed, long timeout) throws IOException {
        if (closed != null && closed.closed) {
            return;
        }
        long EX = SafeClock.currentTimeMillis() + timeout;
        System.out.println("[Node] Waiting for end of packets");
        long D = SafeClock.currentTimeMillis() - this.lastPacket;
        while (D < (long)ms) {
            try {
                Thread.sleep(granularityMs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            D = SafeClock.currentTimeMillis() - this.lastPacket;
            if (closed != null && closed.closed) {
                return;
            }
            if (SafeClock.currentTimeMillis() <= EX) continue;
            throw new IOException("Failed to wait for packets");
        }
        System.out.println("[Node] End of packets (" + D + ")");
    }

    public void waitUntilPackets(CloseSignal closed, long timeout) throws IOException {
        if (closed != null && closed.closed) {
            return;
        }
        long EX = SafeClock.currentTimeMillis() + timeout;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[Node] Waiting for packets");
        long D = SafeClock.currentTimeMillis() - this.lastPacket;
        while (D > 1000L) {
            try {
                Thread.sleep(800L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            D = SafeClock.currentTimeMillis() - this.lastPacket;
            if (closed != null && closed.closed) {
                return;
            }
            if (SafeClock.currentTimeMillis() <= EX) continue;
            throw new IOException("Failed to wait for packets");
        }
        System.out.println("[Node] Start of packets (" + D + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPacket(byte[] dat, String fromnode) {
        block34: {
            this.lastPacket = SafeClock.currentTimeMillis();
            try {
                long buffered;
                int fwdTargetID = ByteArrayUtils.readInt(dat, 0);
                NodeLinkConversation nlkey = new NodeLinkConversation(ByteArrayUtils.readInt(dat, 4), false);
                this.markConversationUsed(nlkey);
                if (Switches.SH_1468_nlUseQuietManager) {
                    QuietManager.get().seen(nlkey);
                }
                if (this.DEBUG_SHOW_ALL_PACKETS) {
                    System.out.println("[Node] Packet IN on " + nlkey + " from " + fromnode + " (" + dat.length + ") (fid " + fwdTargetID + ")");
                }
                if (fwdTargetID != 0) {
                    ForwardTarget ft;
                    Integer FWD = new Integer(fwdTargetID);
                    Object object = this.forwards_LOCK;
                    synchronized (object) {
                        ft = (ForwardTarget)this.forwards.get(FWD);
                        if (ft != null) {
                            ft.updateLastUsed();
                        }
                    }
                    if (ft != null) {
                        block33: {
                            if (this.DEBUG_SHOW_ALL_PACKETS) {
                                System.out.println("[NL Forwarding] Forwarding to " + ft.fwdNode + " (from " + ft.fakeFrom + ") on " + nlkey.key + " (fid " + FWD + ")");
                            }
                            try {
                                if (SafeClock.currentTimeMillis() > ft.noPacketsUntil) {
                                    ft.fwdTransport.sendPacketTo(ft.fakeFrom, ft.fwdNode, ft.fwdEndpoint, dat, false);
                                }
                                if (this.DEBUG_SHOW_ALL_PACKETS) {
                                    System.out.println("[NL Forwarding] Sent to " + ft.fwdNode + " (from " + ft.fakeFrom + ") on " + nlkey.key + " (fid " + FWD + ")");
                                }
                            }
                            catch (Exception x) {
                                if (this.DEBUG_SHOW_ALL_PACKETS) {
                                    System.out.println("[NL Forwarding] Unable to send to " + ft.fwdNode + " (from " + ft.fakeFrom + ") on " + nlkey.key + " (fid " + FWD + ") " + x);
                                }
                                if (!Switches.SH_XXXX_nlNodeForwardMarkBroken) break block33;
                                long T = SafeClock.currentTimeMillis();
                                if (T < ft.noFwdErrorPrintsUntil) {
                                    System.out.println("[NL Forwarding] Forward failed (" + x + ") to " + ft.fwdNode + " (from " + ft.fakeFrom + ") on " + nlkey.key + " (fid " + FWD + "), will show no more failed fwds from this ID for 5s");
                                }
                                ft.noPacketsUntil = T + 1000L;
                                ft.noFwdErrorPrintsUntil = T + 5000L;
                                x.printStackTrace();
                            }
                        }
                        return;
                    }
                }
                int plen = ByteArrayUtils.readInt(dat, 4 + nlkey.length);
                byte[] pdat = new byte[plen];
                System.arraycopy(dat, 4 + nlkey.length + 4, pdat, 0, plen);
                int expectedLen = 4 + nlkey.length + 4 + plen;
                OutOfBandData oob = null;
                if (dat.length > expectedLen) {
                    ByteArrayInputStream oobin = new ByteArrayInputStream(dat, expectedLen, dat.length - expectedLen);
                    oob = new OutOfBandData();
                    oob.ignoreMain = DataUtils.readBoolean(oobin);
                    int count = DataUtils.readInt(oobin);
                    oob.maindata = pdat;
                    oob.names = new String[count];
                    oob.datas = new byte[count][];
                    for (int i = 0; i < count; ++i) {
                        oob.names[i] = DataUtils.readNStringASCII(oobin, 100000);
                        oob.datas[i] = DataUtils.readNBytes(oobin, 10000000);
                    }
                }
                boolean skip = false;
                String reason = "";
                Object i = this.open_LOCK;
                synchronized (i) {
                    Conversation conv = this.open.get(nlkey.OBJKEY);
                    if (conv == null) {
                        if (this.canRespond()) {
                            new OrphanPacketHandler(pdat, nlkey, fromnode).start();
                        }
                        skip = true;
                        reason = "not found";
                    } else if (conv.until != Long.MAX_VALUE) {
                        if (conv.until < System.currentTimeMillis()) {
                            if (this.canRespond()) {
                                new OrphanPacketHandler(pdat, nlkey, fromnode).start();
                            }
                            skip = true;
                            reason = "converstation expired";
                        } else if (Switches.SH_1582_nodeConversationsTimeOutAfterNlErrorDefault) {
                            conv.updateLastUsed();
                        }
                    }
                }
                if (skip || (buffered = oob != null ? this.incoming.put(nlkey.OBJKEY, oob) : this.incoming.put(nlkey.OBJKEY, pdat)) < (long)MAX_BUFFERED_MESSAGES_PER_CHANNEL) break block34;
                System.out.println("***WARNING*** " + buffered + " Node messages buffered under " + nlkey.OBJKEY + " from " + fromnode + ", unable to cope with incoming message rate");
                while ((buffered = this.incoming.getBuffered(nlkey.OBJKEY)) > (long)Math.max(0, MAX_BUFFERED_MESSAGES_PER_CHANNEL - 5)) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.lastPacket = SafeClock.currentTimeMillis();
                }
                System.out.println("***WARNING*** " + buffered + " Node messages buffered under " + nlkey.OBJKEY + ", resuming processing");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public long getTimeSinceLastPacket() {
        return SafeClock.currentTimeMillis() - this.lastPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeLinkListener(NodeLink nodelink) {
        LinkedList<WeakReference<NodeLink>> linkedList = this.associatedNodeLinks;
        synchronized (linkedList) {
            this.associatedNodeLinks.add(new WeakReference<NodeLink>(nodelink));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeLinkListener(NodeLink nodelink) {
        LinkedList<WeakReference<NodeLink>> linkedList = this.associatedNodeLinks;
        synchronized (linkedList) {
            Iterator it = this.associatedNodeLinks.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                NodeLink nl = (NodeLink)ref.get();
                if (nl != null && !nl.equals(nodelink)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNodeLinkListenerLinkOK() {
        this.lastNotifiedLinkDown = false;
        LinkedList<WeakReference<NodeLink>> linkedList = this.associatedNodeLinks;
        synchronized (linkedList) {
            Iterator it = this.associatedNodeLinks.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                NodeLink nl = (NodeLink)ref.get();
                if (nl == null) {
                    it.remove();
                    continue;
                }
                if (!nl.isAlive()) continue;
                nl.linkOK();
            }
        }
    }

    public boolean didNotifyLinkDown() {
        return this.lastNotifiedLinkDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNodeLinkListenerLinkDown(Throwable reason, boolean udpOnly) {
        LinkedList<WeakReference<NodeLink>> linkedList = this.associatedNodeLinks;
        synchronized (linkedList) {
            Iterator it = this.associatedNodeLinks.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                NodeLink nl = (NodeLink)ref.get();
                if (nl == null) {
                    it.remove();
                    continue;
                }
                if (!nl.isAlive()) continue;
                boolean isUDP = nl.isUsingFlowControl();
                if (udpOnly && !isUDP) continue;
                this.lastNotifiedLinkDown = true;
                nl.linkDown(reason);
            }
        }
    }

    class ReachableEndpoint {
        Endpoint e;
        Transport t;
        private long lastUsed = SafeClock.currentTimeMillis();

        public ReachableEndpoint(Endpoint e, Transport t) {
            this.e = e;
            this.t = t;
        }

        public void updateLastUsed() {
            this.lastUsed = SafeClock.currentTimeMillis();
        }

        public boolean isValid() {
            if (!Switches.SH_1582_nodeEndpointsTimeOutAfterNlErrorDefault) {
                return true;
            }
            return SafeClock.currentTimeMillis() - this.lastUsed < UNUSED_TIMEOUT;
        }
    }

    class OrphanPacketHandler
    extends Thread {
        byte[] pdat;
        NodeLinkConversation key;
        String fromnode;

        public OrphanPacketHandler(byte[] pdat, NodeLinkConversation key, String fromnode) {
            this.setName("OrphanPacketHandler");
            this.pdat = pdat;
            this.key = key;
            this.fromnode = fromnode;
        }

        @Override
        public void run() {
            try {
                if (Node.this.orphans != null) {
                    Node.this.orphans.processOrphanPacket(this.pdat, this.key.key, new Node(this.fromnode), Node.this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ForwardTarget {
        long noPacketsUntil = 0L;
        long noFwdErrorPrintsUntil = 0L;
        Transport fwdTransport;
        Node fakeFrom;
        Node fwdNode;
        Endpoint fwdEndpoint;
        Integer myFWD;
        private long lastUsed = SafeClock.currentTimeMillis();

        public void updateLastUsed() {
            this.lastUsed = SafeClock.currentTimeMillis();
        }

        public boolean isValid() {
            return SafeClock.currentTimeMillis() - this.lastUsed < UNUSED_TIMEOUT;
        }

        public ForwardTarget(Transport fwdTransport, Node fakeFrom, Node fwdNode, Endpoint fwdEndpoint, Integer myFWD) {
            this.fwdTransport = fwdTransport;
            this.fakeFrom = fakeFrom;
            this.fwdNode = fwdNode;
            this.fwdEndpoint = fwdEndpoint;
            this.myFWD = myFWD;
        }
    }

    class CleanupThread
    extends Thread {
        Transport t;

        public CleanupThread(Transport t) {
            this.t = t;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.t.cleanupAllConnections();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Conversation {
        long until;
        int count;
        private long lastUsed = SafeClock.currentTimeMillis();

        Conversation() {
        }

        public void updateLastUsed() {
            this.lastUsed = SafeClock.currentTimeMillis();
        }

        public boolean isValid() {
            if (Switches.SH_1582_nodeConversationsTimeOutAfterNlErrorDefault) {
                return true;
            }
            return SafeClock.currentTimeMillis() - this.lastUsed < UNUSED_TIMEOUT;
        }
    }
}

