/*
 * Decompiled with CFR 0.152.
 */
package com.aem.gstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.stream.VariableLengthStreamUtils;

public class DataBlock {
    boolean earliestBlock = false;
    boolean lastBlock = false;
    boolean noMoreBlocks = false;
    long packetUID;
    long packetIndex;
    long position;
    byte[] data;

    public DataBlock(long packetUID, long packetIndex, long position, byte[] data) {
        this.packetUID = packetUID;
        this.packetIndex = packetIndex;
        this.position = position;
        this.data = data;
    }

    public long getPacketUID() {
        return this.packetUID;
    }

    public boolean isLastBlock() {
        return this.lastBlock;
    }

    void setEarliestBlock(boolean b) {
        this.earliestBlock = b;
    }

    void setNoMoreBlocks(boolean b) {
        this.noMoreBlocks = b;
    }

    void setLastBlock(boolean b) {
        this.lastBlock = b;
    }

    public boolean noMoreBlocks() {
        return this.noMoreBlocks;
    }

    public boolean isEarliestBlock() {
        return this.earliestBlock;
    }

    public long getPacketStart() {
        return this.packetIndex;
    }

    public boolean isFirstInPacket() {
        return this.position == 0L;
    }

    public long getOverallStart() {
        return this.packetIndex + this.position;
    }

    public long getOverallEnd() {
        return this.getOverallStart() + (long)this.data.length;
    }

    public int getLength() {
        return this.data.length;
    }

    public String toString() {
        String suffix = "";
        if (this.lastBlock) {
            suffix = " (End of packet)";
        }
        if (this.isEarliestBlock()) {
            return "Block-P-" + this.packetUID + " (@" + this.packetIndex + "), i" + this.position + ", +" + this.data.length + " (Earliest Available)" + suffix;
        }
        return "Block-P-" + this.packetUID + " (@" + this.packetIndex + "), i" + this.position + ", +" + this.data.length + suffix;
    }

    public void toStream(OutputStream out) throws IOException {
        VariableLengthStreamUtils vs = new VariableLengthStreamUtils();
        VariableLengthStreamUtils.writeLong(out, this.packetUID);
        VariableLengthStreamUtils.writeLong(out, this.packetIndex);
        VariableLengthStreamUtils.writeLong(out, this.position);
        VariableLengthStreamUtils.writeBytes(out, this.data);
        boolean[] statii = new boolean[8];
        statii[0] = this.earliestBlock;
        statii[1] = this.lastBlock;
        statii[2] = this.noMoreBlocks;
        VariableLengthStreamUtils.writeMasked(out, statii);
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toStream(out);
        return out.toByteArray();
    }

    public static DataBlock fromBytes(byte[] data) throws IOException {
        return DataBlock.fromBytes(data, 0, data.length);
    }

    public static DataBlock fromBytes(byte[] data, int off, int len) throws IOException {
        return DataBlock.fromStream(new ByteArrayInputStream(data, off, len));
    }

    public static DataBlock fromStream(InputStream in) throws IOException {
        VariableLengthStreamUtils vs = new VariableLengthStreamUtils();
        long uid = VariableLengthStreamUtils.readLong(in);
        long index = VariableLengthStreamUtils.readLong(in);
        long pos = VariableLengthStreamUtils.readLong(in);
        byte[] dat = VariableLengthStreamUtils.readNBytes(in, 1000000000);
        boolean[] statii = VariableLengthStreamUtils.readMasked(in);
        boolean earliestBlock = statii[0];
        boolean lastBlock = statii[1];
        boolean noMoreBlocks = statii[2];
        DataBlock block = new DataBlock(uid, index, pos, dat);
        block.setLastBlock(lastBlock);
        block.setEarliestBlock(earliestBlock);
        block.setNoMoreBlocks(noMoreBlocks);
        return block;
    }
}

