/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import com.aem.BuildDate;
import java.util.Arrays;
import utils.progtools.DataUtil;

public class VersionUtil {
    private static final VersionInfo SERVER_VERSION = new VersionInfo(5, 1, 0, BuildDate.YMD, BuildDate.HMS);

    public static String getVersion() {
        return SERVER_VERSION.getSSuiteString();
    }

    public static String getShortVersion() {
        return SERVER_VERSION.getMajorMinorString();
    }

    public static String getShortVersionWithSub() {
        return SERVER_VERSION.getMajorMinorSubString();
    }

    public static boolean isLaterThan(String version1, String version2) {
        if (version2 == null) {
            return false;
        }
        if (version1 == null) {
            return true;
        }
        VersionInfo info1 = new VersionInfo(version1);
        VersionInfo info2 = new VersionInfo(version2);
        return info1.compareTo(info2) < 0;
    }

    public static boolean isFullVersionLaterThan(String version1, String version2) {
        return VersionUtil.isLaterThan(version1, version2);
    }

    public static boolean isVersionValid(String s) {
        s = s.trim();
        return (s = s.toLowerCase()).startsWith("ssuite") && s.length() <= "SSuite-AAAAA-BBBBB-YYYYMMDD-HHMMSS".length();
    }

    public static int[] getMajorMinorSubFrom(String version) {
        String[] parts = version.split("\\.");
        if (parts.length == 2) {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
        try {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])};
        }
        catch (Throwable t) {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
    }

    public static boolean areEqualVersions(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return true;
        }
        if (version2 == null) {
            return false;
        }
        if (version1 == null) {
            return false;
        }
        VersionInfo info1 = new VersionInfo(version1);
        VersionInfo info2 = new VersionInfo(version2);
        return info1.compareTo(info2) == 0;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(VersionUtil.getMajorMinorSubFrom("5.0")));
        System.out.println(Arrays.toString(VersionUtil.getMajorMinorSubFrom("3.12")));
        System.out.println(Arrays.toString(VersionUtil.getMajorMinorSubFrom("3.12.12")));
        System.out.println(VersionUtil.isLaterThan("3.12", "5.0.12"));
        System.out.println(new VersionInfo("SSuite-4.2-20150604-152326").getYYYYMMDDBuildString());
        System.out.println(new VersionInfo("4.2-20150604-152326").getYYYYMMDDBuildString());
        System.out.println(new VersionInfo("4.2"));
        System.out.println(new VersionInfo("4-2"));
        System.out.println(new VersionInfo("SSuite-4-2-20150604-152326").getYYYYMMDDBuildString());
        System.out.println(VersionUtil.areEqualVersions("SSuite-4-2-20150604-152326", "SSuite-4-2-20150604-152326"));
        System.out.println(VersionUtil.areEqualVersions("4-2-20150604-152326", "SSuite-4-2-20150604-152327"));
    }

    public static VersionInfo getVersionInfo(String ourVersion) {
        return new VersionInfo(ourVersion);
    }

    public static class VersionInfo
    implements Comparable<VersionInfo> {
        int major = -1;
        int minor = -1;
        int sub = -1;
        String buildYMD = null;
        String buildHMS = null;

        public VersionInfo(int major, int minor, int sub, String buildYMD, String buildHMS) {
            this.major = major;
            this.minor = minor;
            this.sub = sub;
            this.buildYMD = buildYMD;
            this.buildHMS = buildHMS;
        }

        public VersionInfo(String versionString) {
            String[] bits;
            if (versionString.startsWith("SSuite-")) {
                versionString = versionString.substring("SSuite-".length());
            }
            if ((bits = (versionString = versionString.replace(".", "-")).split("\\-")).length > 0) {
                this.major = Integer.parseInt(bits[0]);
            }
            if (bits.length > 1) {
                this.minor = Integer.parseInt(bits[1]);
            }
            if (bits.length > 2) {
                this.buildYMD = bits[2];
            }
            if (bits.length > 3) {
                this.buildHMS = bits[3];
            }
        }

        public String getMajorMinorString() {
            return this.major + "." + this.minor;
        }

        public String getMajorMinorSubString() {
            return this.major + "." + this.minor + "." + this.sub;
        }

        public String getSSuiteString() {
            return "SSuite-" + this.major + "-" + this.minor + "-" + this.buildYMD + "-" + this.buildHMS;
        }

        public String toString() {
            return this.getSSuiteString();
        }

        @Override
        public int compareTo(VersionInfo o) {
            if (this.major != o.major) {
                return DataUtil.compare(this.major, o.major);
            }
            if (this.minor != o.minor) {
                return DataUtil.compare(this.minor, o.minor);
            }
            if (this.sub != -1 && o.sub != -1 && this.sub != o.sub) {
                return DataUtil.compare(this.sub, o.sub);
            }
            if (this.buildYMD != null && o.buildYMD != null && !this.buildYMD.equals(o.buildYMD)) {
                return this.buildYMD.compareTo(o.buildYMD);
            }
            if (this.buildHMS != null && o.buildHMS != null && !this.buildHMS.equals(o.buildHMS)) {
                return this.buildHMS.compareTo(o.buildHMS);
            }
            return 0;
        }

        public int compareMajorMinorOnly(VersionInfo o) {
            if (this.major != o.major) {
                return DataUtil.compare(this.major, o.major);
            }
            if (this.minor != o.minor) {
                return DataUtil.compare(this.minor, o.minor);
            }
            return 0;
        }

        public String getYYYYMMDDBuildString() {
            return this.buildYMD;
        }
    }
}

