/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import com.aem.nodelink.utils.DataUtils;
import com.aem.shelp.common.Language;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;

public class SafeResourceBundle
extends PropertyResourceBundle {
    private static Map REPLACE_MAP = Collections.synchronizedMap(new HashMap());
    private static List IGNORE_LIST = Collections.synchronizedList(new ArrayList());
    private SafeResourceBundle substitutionBundle = null;
    String charset = "UTF-8";

    public static void main(String[] args) throws IOException {
        File f = new File("lib/translations/en.txt");
        FileInputStream fin = new FileInputStream(f);
        SafeResourceBundle bundle1 = new SafeResourceBundle(fin);
        f = new File("configuration/translations/en.txt");
        fin = new FileInputStream(f);
        SafeResourceBundle bundle2 = new SafeResourceBundle(fin);
        bundle1.setSubstitutionBundle(bundle2);
        System.out.println(bundle1.getString("ALLTIME"));
    }

    public static void addReplaceString(String key, String target, String[] ignore) {
        if (key == null || target == null) {
            return;
        }
        REPLACE_MAP.put(key, target);
        if (ignore != null) {
            for (int i = 0; i < ignore.length; ++i) {
                IGNORE_LIST.add(ignore[i]);
            }
        }
    }

    public static String replaceAll(String original) {
        if (REPLACE_MAP.size() == 0) {
            return original;
        }
        for (int i = 0; i < IGNORE_LIST.size(); ++i) {
            String ignoreKey = (String)IGNORE_LIST.get(i);
            if (original.indexOf(ignoreKey) == -1) continue;
            return original;
        }
        StringBuffer buffer = new StringBuffer(original);
        Set set = REPLACE_MAP.keySet();
        for (String key : set) {
            String value = (String)REPLACE_MAP.get(key);
            if (value == null || key.equals(value)) continue;
            int startIndex = buffer.indexOf(key);
            while (startIndex != -1) {
                buffer = buffer.replace(startIndex, startIndex + key.length(), value);
                startIndex = buffer.indexOf(key, startIndex + value.length());
            }
        }
        return buffer.toString();
    }

    public SafeResourceBundle(InputStream stream) throws IOException {
        super(stream);
        try {
            this.charset = (String)super.handleGetObject("charset");
            if (this.charset != null) {
                this.charset = this.charset.trim();
                if (this.charset.length() == 0) {
                    this.charset = null;
                }
            }
        }
        catch (Exception e) {
            this.charset = "UTF-8";
        }
    }

    private SafeResourceBundle() throws IOException {
        super(new ByteArrayInputStream(new byte[0]));
    }

    public static SafeResourceBundle getEmptyBundle() {
        try {
            return new SafeResourceBundle();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void loadTestBundle() throws IOException {
        SafeResourceBundle.loadTestBundle("en");
    }

    public static void loadTestBundle(String lang) throws IOException {
        try {
            SafeResourceBundle language;
            FileInputStream urlin = new FileInputStream("lib/translations/" + lang + ".txt");
            byte[] tmp = DataUtils.readAll(urlin);
            ((InputStream)urlin).close();
            Language.DEFLANG = language = new SafeResourceBundle(new ByteArrayInputStream(tmp));
            Language.DEFLANG_ID = lang;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Object handleGetObject(String key) {
        Object result = null;
        if (this.substitutionBundle != null) {
            result = this.substitutionBundle.getString(key);
        }
        if (result == null || result.equals(key)) {
            Object o = super.handleGetObject(key);
            if (o == null) {
                return key;
            }
            try {
                result = this.charset == null ? o : new String(((String)o).getBytes("ISO-8859-1"), this.charset);
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Warning - charset " + this.charset + " not supported");
                this.charset = null;
                result = o;
            }
            catch (Exception e) {
                result = o;
            }
        }
        if (result instanceof String) {
            return SafeResourceBundle.replaceAll((String)result);
        }
        return result;
    }

    public String getString(String key, Object[] arguments) {
        String value = super.getString(key);
        value = value.replace("'", "''");
        return MessageFormat.format(value, arguments);
    }

    public void setSubstitutionBundle(SafeResourceBundle additionalBundle) {
        this.substitutionBundle = additionalBundle;
    }
}

