/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.stream.OpenByteArrayOutputStream;

public class BCUtilOutputStream
extends OutputStream {
    int MAX = 40960;
    BCUtil bcu;
    DataOutputStream out;
    OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();

    public BCUtilOutputStream(OutputStream out, BCUtil bcu) {
        this.out = new DataOutputStream(out);
        this.bcu = bcu;
    }

    @Override
    public final void flush() throws IOException {
        if (this.bout.size() > 0) {
            this.writeChunk();
        }
        this.out.flush();
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > this.MAX) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
        if (this.bout.size() > this.MAX) {
            this.writeChunk();
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.bout.write(b);
        if (this.bout.size() > this.MAX) {
            this.writeChunk();
        }
    }

    private void writeChunk() throws IOException {
        this.bcu.wrap(this.bout.getByteArray(), this.bout.size(), this.out);
        this.bout.reset();
    }
}

