/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import utils.swing.customlaf.SHBorderFactory;

public class GridPanel
extends JPanel {
    Border space;
    boolean transparentSpacers = false;

    public GridPanel(int rows, int cols) {
        this(rows, cols, null);
    }

    public GridPanel(int rows, int cols, Insets insets) {
        super.setLayout(new GridLayout(rows, cols));
        if (insets != null) {
            this.space = SHBorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        }
    }

    public void setTransparentSpacers(boolean b) {
        this.transparentSpacers = b;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public void add(JComponent comp) {
        this.add((Component)comp, this.space);
    }

    public void add(JComponent comp, Insets insets) {
        this.add((Component)comp, SHBorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    private void add(JComponent comp, EmptyBorder space) {
        if (space != null) {
            JPanel tmp = new JPanel();
            tmp.setOpaque(comp.isOpaque());
            tmp.setBackground(comp.getBackground());
            if (this.transparentSpacers) {
                tmp.setOpaque(false);
            }
            tmp.setLayout(new GridLayout(1, 1));
            tmp.setBorder(space);
            tmp.add(comp);
            super.add(tmp);
        } else {
            super.add(comp);
        }
    }
}

