/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.ScaledInsets;

public class SHTextFieldBorder
extends AbstractBorder
implements UIResource {
    private static final Insets PADDING = new ScaledInsets(3, 5, 3, 5);
    private Insets insets;
    private boolean paintTop = true;
    private boolean paintBottom = true;
    private boolean paintLeft = true;
    private boolean paintRight = true;
    private Color enabledColor = SHUI.TEXT_BORDER;

    public boolean isPaintTop() {
        return this.paintTop;
    }

    public void setPaintTop(boolean paintTop) {
        this.paintTop = paintTop;
    }

    public boolean isPaintBottom() {
        return this.paintBottom;
    }

    public void setPaintBottom(boolean paintBottom) {
        this.paintBottom = paintBottom;
    }

    public boolean isPaintLeft() {
        return this.paintLeft;
    }

    public void setPaintLeft(boolean paintLeft) {
        this.paintLeft = paintLeft;
    }

    public boolean isPaintRight() {
        return this.paintRight;
    }

    public void setPaintRight(boolean paintRight) {
        this.paintRight = paintRight;
    }

    public SHTextFieldBorder() {
        this.insets = PADDING;
    }

    public SHTextFieldBorder(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public void setInsets(Insets i) {
        this.insets = i;
    }

    public void setColor(Color c) {
        this.enabledColor = c;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(SHButtonUI.getBorderStroke());
        if (c.isEnabled()) {
            g2d.setColor(this.enabledColor);
        } else {
            g2d.setColor(SHUI.TEXT_BORDER_DISABLED);
        }
        float strokeWidth = SHButtonUI.getBorderStrokeWidth();
        if (this.paintBottom && this.paintLeft && this.paintRight && this.paintTop) {
            Rectangle2D.Float rect = new Rectangle2D.Float(x, y, (float)w - strokeWidth, (float)h - strokeWidth);
            g2d.draw(rect);
        } else {
            if (this.paintTop) {
                g2d.draw(new Line2D.Float(x, y, (float)(x + w) - strokeWidth, y));
            }
            if (this.paintBottom) {
                g2d.draw(new Line2D.Float(x, (float)(y + h) - strokeWidth, (float)(x + w) - strokeWidth, (float)(y + h) - strokeWidth));
            }
            if (this.paintLeft) {
                g2d.draw(new Line2D.Float(x, y, x, (float)(y + h) - strokeWidth));
            }
            if (this.paintRight) {
                g2d.draw(new Line2D.Float((float)(x + w) - strokeWidth, y, (float)(x + w) - strokeWidth, (float)(y + h) - strokeWidth));
            }
        }
    }
}

