/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.customlaf;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.plaf.UIResource;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class SHCheckBoxIcon
implements Icon,
UIResource {
    private static GeneralPath tick;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int arc = SHStyle.ARC;
        boolean selected = c instanceof JCheckBox && ((JCheckBox)c).isSelected() || c instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)c).isSelected();
        RoundRectangle2D.Float s = new RoundRectangle2D.Float(x, y, (float)this.getIconWidth() - SHButtonUI.getBorderStrokeWidth(), (float)this.getIconHeight() - SHButtonUI.getBorderStrokeWidth(), arc, arc);
        if (!OEMSwitches.DARK_THEME) {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), this.getIconHeight(), false));
        } else if (selected) {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_BLUE, c.isEnabled(), this.getIconHeight(), false));
        } else {
            g2d.setPaint(SHButtonUI.getFill(SHUI.BUTTON_NORMAL, c.isEnabled(), this.getIconHeight(), false));
        }
        g2d.fill(s);
        g2d.setStroke(SHButtonUI.getBorderStroke());
        if (!OEMSwitches.DARK_THEME) {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, c.isEnabled()));
        } else if (selected) {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_BLUE, c.isEnabled()));
        } else {
            g2d.setColor(SHButtonUI.getBorderColor(SHUI.BUTTON_NORMAL, c.isEnabled()));
        }
        g2d.draw(s);
        g2d.setStroke(new BasicStroke(SimpleHelpLookAndFeel.scale(2.0f), 1, 1));
        if (c.isEnabled()) {
            g2d.setColor(SHUI.CHECKBOX_TICK);
        } else {
            g2d.setColor(SHUI.CHECKBOX_TICK_DISABLED);
        }
        if (selected) {
            g2d.translate(x, y);
            g2d.draw(tick);
            g2d.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return (int)(16.0 * SimpleHelpLookAndFeel.getScalingFactor());
    }

    @Override
    public int getIconHeight() {
        return this.getIconWidth();
    }

    static {
        double factor = SimpleHelpLookAndFeel.getScalingFactor();
        tick = new GeneralPath();
        tick.moveTo(3.0 * factor, 8.0 * factor);
        tick.lineTo(6.0 * factor, 12.0 * factor);
        tick.lineTo(12.0 * factor, 4.0 * factor);
    }
}

