/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SafeLookAndFeel {
    private static final boolean SET_IN_EVENT_DISPATCH_THREAD = false;

    public static void setLookAndFeel(final String lookAndFeel) throws Exception {
        System.out.println("[SafeLookAndFeel] Safely setting look and feel...");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void setSystemLookAndFeel() throws Exception {
        SafeLookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static void setLookAndFeel(final LookAndFeel lookAndFeel) throws Exception {
        System.out.println("[SafeLookAndFeel] Safely setting look and feel...");
        if (SwingUtilities.isEventDispatchThread()) {
            UIManager.setLookAndFeel(lookAndFeel);
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(lookAndFeel);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

