/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import utils.ostools.OS;
import utils.ostools.OSDirs;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpFrame;

public class SafeJFileChooser
extends JFileChooser {
    public static File saveFile(Component parent, String defaultFilename) {
        return SafeJFileChooser.saveFile(parent, OSDirs.getDesktopDir(), null, defaultFilename);
    }

    public static File saveFile(Component parent, String[] extensions, String defaultFilename) {
        return SafeJFileChooser.saveFile(parent, OSDirs.getDesktopDir(), extensions, defaultFilename);
    }

    public static File pickFile(Component parent) {
        return SafeJFileChooser.pickFile(parent, OSDirs.getDesktopDir(), null);
    }

    public static File pickFile(Component parent, String[] extensions) {
        return SafeJFileChooser.pickFile(parent, OSDirs.getDesktopDir(), extensions);
    }

    public static File pickFile(Component parent, File currentDirectory, String[] acceptedExtensions) {
        Frame frame = SwingUtil.getParentFrame(parent);
        FileDialog dialog = new FileDialog(frame, "", 0);
        SafeJFileChooser.init(dialog, frame, acceptedExtensions, currentDirectory);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return new File(dialog.getDirectory(), dialog.getFile());
    }

    public static File pickSave(Component parent) {
        return SafeJFileChooser.pickSave(parent, OSDirs.getDesktopDir(), null);
    }

    public static File pickSave(Component parent, String[] extensions) {
        return SafeJFileChooser.pickSave(parent, OSDirs.getDesktopDir(), extensions);
    }

    public static File pickSave(Component parent, File currentDirectory, String[] acceptedExtensions) {
        Frame frame = SwingUtil.getParentFrame(parent);
        FileDialog dialog = new FileDialog(frame, "", 1);
        SafeJFileChooser.init(dialog, frame, acceptedExtensions, currentDirectory);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return new File(dialog.getDirectory(), dialog.getFile());
    }

    public static File[] pickFiles(Component parent) {
        return SafeJFileChooser.pickFiles(parent, OSDirs.getDesktopDir(), null);
    }

    public static File[] pickFiles(Component parent, File currentDirectory, String[] acceptedExtensions) {
        Frame frame = SwingUtil.getParentFrame(parent);
        FileDialog dialog = new FileDialog(frame, "", 0);
        SafeJFileChooser.init(dialog, frame, acceptedExtensions, currentDirectory);
        try {
            Method setMultipleMode = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
            if (setMultipleMode != null) {
                setMultipleMode.invoke((Object)dialog, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dialog.setVisible(true);
        try {
            Method getFilesMethod = FileDialog.class.getMethod("getFiles", new Class[0]);
            if (getFilesMethod != null) {
                File[] result = (File[])getFilesMethod.invoke((Object)dialog, new Object[0]);
                if (result == null || result.length == 0) {
                    return null;
                }
                return result;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (dialog.getFile() == null) {
            return null;
        }
        return new File[]{new File(dialog.getDirectory(), dialog.getFile())};
    }

    public static File saveFile(Component parent, File currentDirectory, String[] acceptedExtensions, String defaultFilename) {
        Frame frame = SwingUtil.getParentFrame(parent);
        FileDialog dialog = new FileDialog(frame, "TEST", 1);
        SafeJFileChooser.init(dialog, frame, acceptedExtensions, currentDirectory);
        if (defaultFilename != null) {
            dialog.setFile(defaultFilename);
        }
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return new File(dialog.getDirectory(), dialog.getFile());
    }

    private static void init(FileDialog dialog, Frame frame, String[] acceptedExtensions, File currentDirectory) {
        dialog.setLocationRelativeTo(frame);
        dialog.setFilenameFilter(new ExtensionFilter(acceptedExtensions));
        dialog.setDirectory(currentDirectory.getAbsolutePath());
    }

    public static File saveDirectory(Component parent) {
        return SafeJFileChooser.saveDirectory(parent, OSDirs.getDesktopDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveDirectory(Component parent, File startingPath) {
        Frame frame = SwingUtil.getParentFrame(parent);
        if (OS.isMacOS()) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            try {
                FileDialog dialog = new FileDialog(frame, "");
                dialog.setDirectory(startingPath.getAbsolutePath());
                dialog.setVisible(true);
                if (dialog.getFile() == null) {
                    File file = null;
                    return file;
                }
                File file = new File(dialog.getDirectory(), dialog.getFile());
                return file;
            }
            finally {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
        }
        SafeJFileChooser chooser = SafeJFileChooser.getSafeJFileChooser();
        chooser.setCurrentDirectory(startingPath);
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showSaveDialog(parent) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        Thread.sleep(1000L);
        SafeJFileChooser.getSafeJFileChooser().showOpenDialog(null);
    }

    public static SafeJFileChooser getSafeJFileChooser() {
        return new SafeJFileChooser();
    }

    private SafeJFileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public SafeJFileChooser() {
        super(FileSystemView.getFileSystemView());
        this.setCurrentDirectory(OSDirs.getDesktopDir());
    }

    private SafeJFileChooser(File file) {
        super(file);
        this.setCurrentDirectory(OSDirs.getDesktopDir());
    }

    private SafeJFileChooser(String property) {
        super(property);
        this.setCurrentDirectory(OSDirs.getDesktopDir());
    }

    @Override
    public void updateUI() {
        if (OS.isWindows()) {
            this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        }
        super.updateUI();
    }

    static class ExtensionFilter
    implements FilenameFilter {
        private final String[] extensions;

        public ExtensionFilter(String[] extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.extensions == null) {
                return true;
            }
            for (String extension : this.extensions) {
                if (!name.toLowerCase().endsWith(extension.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }
}

