/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import utils.swing.listeners.SystemExitWindowListener;

public class ExponentialSlider {
    double distance;
    double[] positions;
    private boolean die = false;

    public ExponentialSlider(double distance, boolean opening) {
        this(distance, 400L, 4.0, opening);
    }

    public ExponentialSlider(double distance, long msecAt25fps, double acceleration, boolean startFast) {
        this(distance, (int)(msecAt25fps / 25L), acceleration, startFast);
    }

    public ExponentialSlider(double distance, int steps, double acceleration, boolean startFast) {
        this.distance = distance;
        double factor = distance / Math.pow(steps, 1.0 + acceleration);
        this.positions = new double[steps];
        for (int i = 1; i <= steps; ++i) {
            this.positions[i - 1] = factor * Math.pow(i, 1.0 + acceleration);
            if (i == steps - 1) {
                this.positions[i - 1] = distance;
            }
            if (!startFast) continue;
            this.positions[i - 1] = distance - this.positions[i - 1];
        }
        if (startFast) {
            double[] tmp = new double[this.positions.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = this.positions[tmp.length - 1 - i];
            }
            this.positions = tmp;
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void runAsSwingTimer(ExponentialPainListener listener, int sleepMS) {
        this.runAsSwingTimer(listener, sleepMS, true);
    }

    public void runAsSwingTimer(final ExponentialPainListener listener, int sleepMS, boolean initialDelay) {
        final Timer timer = new Timer(sleepMS, null);
        if (!initialDelay) {
            timer.setInitialDelay(0);
        }
        timer.addActionListener(new ActionListener(){
            int swingTimerIndex = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExponentialSlider.this.die) {
                    timer.stop();
                } else {
                    listener.paint(this.swingTimerIndex);
                    ++this.swingTimerIndex;
                    if (this.swingTimerIndex == ExponentialSlider.this.getPositionCount() || ExponentialSlider.this.die) {
                        timer.stop();
                    }
                }
            }
        });
        timer.start();
    }

    public double getPositionForStep(int step) {
        return this.positions[step];
    }

    public int getPositionForStepRounded(int step) {
        return (int)Math.round(this.positions[step]);
    }

    public int getPositionCount() {
        return this.positions.length;
    }

    public long get25fpsSleep() {
        return 30L;
    }

    public void die() {
        this.die = true;
    }

    public static void main(String[] args) throws Exception {
        int N = 400;
        JButton button = new JButton("GO");
        JPanel both = new JPanel();
        both.setLayout(new GridLayout(3, 1));
        int[] pows = new int[]{1, 5};
        for (int A = 0; A < pows.length; ++A) {
            ExponentialSlider exponentialSlider = new ExponentialSlider(50.0, N, (double)pows[A], true);
        }
        both.add(button);
        JFrame frame = new JFrame();
        frame.addWindowListener(new SystemExitWindowListener());
        frame.setBounds(200, 200, 450, 400);
        frame.getContentPane().add(both);
        frame.setVisible(true);
        button.addActionListener(new ExampleSlide(20, 100));
        button.addActionListener(new ExampleSlide(220, 200));
        button.addActionListener(new ExampleSlide(420, 300));
        button.addActionListener(new ExampleSlide(620, 35));
    }

    public boolean isDone(int step) {
        return step >= this.positions.length - 1;
    }

    static class ExampleSlide
    extends JFrame
    implements ActionListener,
    Runnable {
        int X;
        int height;
        JPanel tmp;
        boolean out = true;
        Thread prev;
        ExponentialSlider ex;

        public ExampleSlide(int X, int H) {
            this.height = H;
            this.X = X;
            this.ex = new ExponentialSlider((double)this.height, 250L, 2.0, true);
            this.setBounds(X, 0, 190, 50);
            this.tmp = new JPanel();
            this.tmp.setLayout(new GridLayout(1, 1));
            this.getContentPane().add(this.tmp);
            this.setVisible(true);
        }

        @Override
        public void run() {
            if (!this.out) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExampleSlide.this.tmp.removeAll();
                        ExampleSlide.this.tmp.invalidate();
                        ExampleSlide.this.tmp.revalidate();
                        ExampleSlide.this.repaint();
                    }
                });
            }
            if (this.out) {
                for (int i = 0; i < this.ex.getPositionCount(); ++i) {
                    this.setBoundsAndRepaint(this.X, 0, 190, 50 + (int)this.ex.getPositionForStep(i));
                    try {
                        Thread.sleep(this.ex.get25fpsSleep());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                for (int i = this.ex.getPositionCount() - 1; i >= 0; --i) {
                    this.setBoundsAndRepaint(this.X, 0, 190, 50 + (int)this.ex.getPositionForStep(i));
                    try {
                        Thread.sleep(this.ex.get25fpsSleep());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.out) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExampleSlide.this.tmp.add(new JLabel("DONE!", 0));
                        ExampleSlide.this.tmp.invalidate();
                        ExampleSlide.this.tmp.revalidate();
                        ExampleSlide.this.repaint();
                    }
                });
            }
            this.out = !this.out;
        }

        private void setBoundsAndRepaint(final int x2, final int i, final int j, final int k) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExampleSlide.this.setBounds(x2, i, j, k);
                    ExampleSlide.this.repaint();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.prev != null) {
                try {
                    this.prev.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.prev = new Thread(this);
            this.prev.start();
        }
    }

    public static interface ExponentialPainListener {
        public void paint(int var1);
    }
}

