/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

public class HexData {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void byteToHex(byte b, StringBuffer buf) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static byte hexToByte(byte b) {
        if (b >= 47 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b < 97) {
            return (byte)(b - 55);
        }
        return (byte)(b - 87);
    }

    public static String stringToHexString(String s) {
        if (s == null) {
            return null;
        }
        return HexData.byteArrayToHexString(s.getBytes());
    }

    public static String hexStringToString(String s) {
        return new String(HexData.hexStringToByteArray(s));
    }

    public static String byteArrayToHexString(byte[] bytes, int start, int length) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < start + length; ++i) {
            HexData.byteToHex(bytes[i], sb);
        }
        return sb.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return HexData.byteArrayToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByteArray(String s) {
        if (s == null) {
            return null;
        }
        byte[] string_bytes = s.getBytes();
        byte[] output_bytes = new byte[string_bytes.length / 2];
        for (int i = 0; i < string_bytes.length; i += 2) {
            byte b;
            int hi = HexData.hexToByte(string_bytes[i]) << 4;
            byte lo = HexData.hexToByte(string_bytes[i + 1]);
            output_bytes[i / 2] = b = (byte)(hi | lo);
        }
        return output_bytes;
    }

    public static void printAsHexWithSpaces(byte[] encoded) {
        String result = HexData.byteArrayToHexString(encoded);
        for (int i = 0; i < result.length(); i += 2) {
            System.out.print(result.charAt(i));
            System.out.print(result.charAt(i + 1));
            System.out.print(' ');
        }
        System.out.println();
    }
}

