/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIUtil {
    public static String escapeAllReservedPercentEncodingCharacters(String chlUrl) {
        chlUrl = chlUrl.replace("!", "%21");
        chlUrl = chlUrl.replace("#", "%23");
        chlUrl = chlUrl.replace("$", "%24");
        chlUrl = chlUrl.replace("&", "%26");
        chlUrl = chlUrl.replace("'", "%27");
        chlUrl = chlUrl.replace("(", "%28");
        chlUrl = chlUrl.replace(")", "%29");
        chlUrl = chlUrl.replace("*", "%2A");
        chlUrl = chlUrl.replace("+", "%2B");
        chlUrl = chlUrl.replace(",", "%2C");
        chlUrl = chlUrl.replace("/", "%2F");
        chlUrl = chlUrl.replace(":", "%3A");
        chlUrl = chlUrl.replace(";", "%3B");
        chlUrl = chlUrl.replace("=", "%3D");
        chlUrl = chlUrl.replace("?", "%3F");
        chlUrl = chlUrl.replace("@", "%40");
        chlUrl = chlUrl.replace("[", "%5B");
        chlUrl = chlUrl.replace("]", "%5D");
        return chlUrl;
    }

    public static String createQueryString(String[] keys, String[] values) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            String key = keys[i];
            String value = values[i];
            if (value == null) {
                buffer.append(key);
                continue;
            }
            try {
                value = URIUtil.urlEncodeSingleURLQueryKeyValue(value);
                buffer.append(key).append("=").append(value);
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public static String urlEncodeSingleURLQueryKeyValue(String query) throws URISyntaxException {
        URI uri = new URI("http", null, null, query, null);
        String s = uri.toString();
        return s.substring(s.indexOf(63) + 1);
    }

    public static URI getSafeURIFrom(URL targetURL) throws URISyntaxException {
        return new URI(targetURL.getProtocol(), null, targetURL.getHost(), targetURL.getPort(), targetURL.getPath(), targetURL.getQuery(), null);
    }

    public static URL getSafeURLFrom(URL targetURL) throws URISyntaxException, MalformedURLException {
        URI safeURI = URIUtil.getSafeURIFrom(targetURL);
        return safeURI.toURL();
    }

    public static URL tryGetSafeURLFrom(URL targetURL) {
        try {
            URI safeURI = URIUtil.getSafeURIFrom(targetURL);
            return safeURI.toURL();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return targetURL;
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        System.out.println(URIUtil.urlEncodeSingleURLQueryKeyValue("It's IT Remote Assistance"));
    }
}

