/*
 * Decompiled with CFR 0.152.
 */
package utils.plist;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import utils.plist.Key;
import utils.plist.PListArray;
import utils.plist.PListException;
import utils.plist.PListObject;

public class PListDict
extends PListObject {
    private final LinkedHashMap<String, PListObject> map = new LinkedHashMap();

    PListDict() {
        super(null);
    }

    void put(Key key, PListObject element) {
        this.map.put(key.getString(null), element);
    }

    void clear() {
        this.map.clear();
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public PListObject get(String key) {
        return this.map.get(key);
    }

    public long getInt(String key, long def) throws PListException {
        PListObject object = this.get(key);
        if (object == null) {
            return def;
        }
        return object.getInt(def);
    }

    public Date getDate(String key, Date def) throws PListException {
        PListObject object = this.get(key);
        if (object == null) {
            return def;
        }
        return object.getDate(def);
    }

    public String getString(String key, String def) throws PListException {
        PListObject object = this.get(key);
        if (object == null) {
            return def;
        }
        return object.getString(def);
    }

    public double getReal(String key, double def) throws PListException {
        PListObject object = this.get(key);
        if (object == null) {
            return def;
        }
        return object.getReal(def);
    }

    public boolean getBool(String key, boolean def) throws PListException {
        PListObject object = this.get(key);
        if (object == null) {
            return def;
        }
        return object.getBool(def);
    }

    public PListArray getPListArray(String key) {
        PListObject object = this.get(key);
        if (!(object instanceof PListArray)) {
            return null;
        }
        return (PListArray)object;
    }

    public PListDict getPListDict(String key) {
        PListObject object = this.get(key);
        if (!(object instanceof PListDict)) {
            return null;
        }
        return (PListDict)object;
    }

    @Override
    PListObject.Type getType() {
        return PListObject.Type.Dict;
    }

    @Override
    public void toString(StringBuffer sb, int indent, int level) {
        PListDict.insertSpaces(sb, indent, level);
        sb.append("<dict>").append('\n');
        Set<String> keySet = this.map.keySet();
        for (String key : keySet) {
            PListObject obj = this.map.get(key);
            PListDict.insertSpaces(sb, indent, level + 1);
            sb.append("<key>").append(key).append("</key>").append('\n');
            obj.toString(sb, indent, level + 1);
        }
        PListDict.insertSpaces(sb, indent, level);
        sb.append("</dict>").append('\n');
    }
}

