/*
 * Decompiled with CFR 0.152.
 */
package utils.plist;

import java.util.ArrayList;
import java.util.Date;
import utils.plist.PListDict;
import utils.plist.PListException;
import utils.plist.PListObject;

public class PListArray
extends PListObject<PListObject> {
    private final ArrayList<PListObject> list = new ArrayList();

    PListArray() {
        super(null);
    }

    void add(PListObject element) {
        this.list.add(element);
    }

    void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public PListObject get(int idx) {
        return this.list.get(idx);
    }

    public long getInt(int idx, long def) throws PListException {
        return this.get(idx).getInt(def);
    }

    public Date getDate(int idx, Date def) throws PListException {
        return this.get(idx).getDate(def);
    }

    public String getString(int idx, String def) throws PListException {
        return this.get(idx).getString(def);
    }

    public double getReal(int idx, double def) throws PListException {
        return this.get(idx).getReal(def);
    }

    public boolean getBool(int idx, boolean def) throws PListException {
        return this.get(idx).getBool(def);
    }

    public PListArray getPListArray(int idx) throws PListException {
        if (!(this.get(idx) instanceof PListArray)) {
            throw new PListException("index " + idx + " is not PListArray object.");
        }
        return (PListArray)this.get(idx);
    }

    public PListDict getPListDict(int idx) throws PListException {
        if (!(this.get(idx) instanceof PListDict)) {
            throw new PListException("index " + idx + " is not PListDict object.");
        }
        return (PListDict)this.get(idx);
    }

    @Override
    PListObject.Type getType() {
        return PListObject.Type.Array;
    }

    @Override
    void toString(StringBuffer sb, int indent, int level) {
        PListArray.insertSpaces(sb, indent, level);
        sb.append("<array>").append('\n');
        for (PListObject obj : this.list) {
            obj.toString(sb, indent, level + 1);
        }
        PListArray.insertSpaces(sb, indent, level);
        sb.append("</array>").append('\n');
    }
}

