/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools;

import java.io.File;
import java.nio.charset.StandardCharsets;
import utils.ostools.OS;
import utils.ostools.SlowWEnv;
import utils.string.FnvHash;

public class SaveDir {
    static Object LOCK = new Object();
    static String myHome = null;

    private static boolean isRoaming(String path) {
        return path.length() > 2 && path.charAt(0) == '\\' && path.charAt(1) == '\\';
    }

    private static boolean isASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(SaveDir.isASCII("C:\\DOCUME~1\\BRO~1\\APPLIC~1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getMyHome(WindowPathResolver resolver) {
        Object object = LOCK;
        synchronized (object) {
            if (myHome == null) {
                if (OS.isWindows()) {
                    String dir = SaveDir.getWindowsDirectory(resolver, false);
                    boolean working = true;
                    File test = new File(dir);
                    System.out.println("[SaveDir] Checking if directory " + test.getAbsolutePath() + " is valid");
                    if (!test.exists() || !SaveDir.isASCII(dir) || dir.indexOf(33) != -1) {
                        System.out.println("[SaveDir] Not working. [" + test.exists() + " , " + SaveDir.isASCII(dir) + " , " + dir.indexOf(33) + "]");
                        working = false;
                    }
                    if (!working && resolver != null) {
                        System.out.println("[SaveDir] 1) Problem with directory " + dir);
                        dir = SaveDir.getWindowsDirectory(resolver, true);
                        test = new File(dir);
                        if (!test.exists() || !SaveDir.isASCII(dir) || dir.indexOf(33) == -1) {
                            working = true;
                            System.out.println("[SaveDir] Resolved path is working [" + test.exists() + " , " + SaveDir.isASCII(dir) + "]");
                        } else {
                            System.out.println("[SaveDir] Resolved path is NOT working [" + test.exists() + " , " + SaveDir.isASCII(dir) + "]");
                        }
                    }
                    if (!working) {
                        System.out.println("[SaveDir] 2) Problem with directory " + dir);
                        String username = System.getProperty("user.name");
                        byte[] normalised = new byte[username.length()];
                        for (int i = 0; i < username.length(); ++i) {
                            char c = username.charAt(i);
                            normalised[i] = c >= '\u0000' && c <= '\u007f' ? (int)(0xFF & c) : 95;
                        }
                        try {
                            String normalisedUsername = new String(normalised, StandardCharsets.US_ASCII);
                            int hash = FnvHash.hash(username.getBytes());
                            hash = Math.abs(hash);
                            File parent = OS.isWindowsVistaOrAbove() ? new File(SlowWEnv.getEnv("PROGRAMDATA")) : new File(SlowWEnv.getEnv("ALLUSERSPROFILE"));
                            test = new File(parent, "JWUser-" + hash + "-" + normalisedUsername);
                            dir = test.getCanonicalPath();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    if (!dir.endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    myHome = dir;
                } else if (OS.isMacOS()) {
                    String dir = System.getProperty("user.home");
                    if (!dir.endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    myHome = dir = dir + "Library/Application Support/";
                } else if (OS.isLinux()) {
                    String dir = System.getProperty("user.home");
                    if (!dir.endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    myHome = dir;
                } else {
                    String dir = System.getProperty("user.home");
                    if (!dir.endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    myHome = dir;
                }
            }
        }
    }

    private static String getWindowsDirectory(WindowPathResolver resolver, boolean shortPaths) {
        String dir = resolver != null && shortPaths ? resolver.getEnv("APPDATA", true) : SlowWEnv.getEnv("APPDATA");
        if (SaveDir.isRoaming(dir)) {
            if (OS.isWindowsVistaOrAbove()) {
                dir = resolver != null && shortPaths ? resolver.getEnv("LOCALAPPDATA", true) : SlowWEnv.getEnv("LOCALAPPDATA");
                System.out.println("[SaveDir] Local AppData directory resolved to " + dir);
            } else {
                File fileDir = resolver != null && shortPaths ? new File(resolver.getEnv("USERPROFILE", true)) : new File(System.getProperty("user.home"));
                fileDir = new File(fileDir, "Local Settings");
                fileDir = new File(fileDir, "Application Data");
                dir = fileDir.getAbsolutePath();
                System.out.println("[SaveDir] Local AppData directory resolved to " + dir);
            }
        }
        return dir;
    }

    public static String getUserSpecificSaveDirWithSlash(String folderName, WindowPathResolver resolver) {
        return SaveDir.getUserSpecificSaveDirWithSlash(folderName, resolver, true);
    }

    public static String getUserSpecificSaveDirWithSlash(String folderName, WindowPathResolver resolver, boolean makeit) {
        String dir = SaveDir.getUserSpecificSaveDirNameWithSlash(folderName, resolver);
        if (makeit) {
            new File(dir).mkdirs();
        }
        return dir;
    }

    private static String getUserSpecificSaveDirNameWithSlash(String folderName, WindowPathResolver resolver) {
        SaveDir.getMyHome(resolver);
        if (OS.isWindows()) {
            return myHome + folderName + File.separator;
        }
        if (OS.isMacOS()) {
            return myHome + folderName + File.separator;
        }
        if (OS.isLinux()) {
            return myHome + ".JWrapper/" + folderName + File.separator;
        }
        return myHome + "." + folderName + File.separator;
    }

    public static interface WindowPathResolver {
        public String getShortNameFor(String var1);

        public String getEnv(String var1, boolean var2);
    }
}

