/*
 * Decompiled with CFR 0.152.
 */
package utils.osstats.winutils;

import java.util.ArrayList;
import java.util.HashMap;
import utils.osstats.winutils.WmicUtil;
import utils.string.CharStack;

public class WmicRows {
    private static boolean VALUE_TRIMMING = true;
    String[] columns;
    String[][] data;

    public String[] getColumns() {
        return this.columns;
    }

    public String[][] getData() {
        return this.data;
    }

    public ArrayList<HashMap<String, String>> toHashMap() {
        ArrayList<HashMap<String, String>> maps = new ArrayList<HashMap<String, String>>();
        for (String[] line : this.data) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int c = 0; c < this.columns.length; ++c) {
                map.put(this.columns[c], line[c]);
            }
            maps.add(map);
        }
        return maps;
    }

    public WmicRows(String s) {
        int i;
        String[] lines = s.split("\n");
        ArrayList<Column> cols = new ArrayList<Column>();
        CharStack cs = new CharStack(lines[0]);
        cs.popWhitespace();
        while (!cs.isEmpty()) {
            Column col = new Column();
            col.startIndex = cs.getIndex();
            col.name = cs.popText(true);
            cs.popWhitespace();
            col.endIndex = cs.getIndex();
            cols.add(col);
        }
        this.columns = new String[cols.size()];
        for (int i2 = 0; i2 < cols.size(); ++i2) {
            this.columns[i2] = ((Column)cols.get((int)i2)).name;
        }
        ArrayList<String[]> datas = new ArrayList<String[]>();
        for (i = 1; i < lines.length; ++i) {
            try {
                lines[i] = lines[i].replace('\r', ' ');
                lines[i] = lines[i].replace('\n', ' ');
                if (lines[i].trim().length() <= 0) continue;
                String[] linedat = new String[cols.size()];
                for (int k = 0; k < cols.size(); ++k) {
                    Column col = (Column)cols.get(k);
                    linedat[k] = lines[i].substring(col.startIndex, col.endIndex);
                    if (!VALUE_TRIMMING) continue;
                    linedat[k] = linedat[k].trim();
                }
                datas.add(linedat);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.data = new String[datas.size()][this.columns.length];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = (String[])datas.get(i);
        }
    }

    public static void main(String[] args) {
        VALUE_TRIMMING = false;
        WmicUtil util = new WmicUtil();
        util.sendCommand("service get Caption,Description,DisplayName,Name,PathName,ProcessId,Started,StartMode,StartName,State,Status", false);
        WmicRows rows = new WmicRows(util.getResultsArray()[0]);
        String[] cols = rows.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            System.out.println(cols[i]);
        }
        String[][] datas = rows.getData();
        for (int i = 0; i < datas.length; ++i) {
            for (int k = 0; k < datas[i].length; ++k) {
                System.out.print(datas[i][k] + ",");
            }
            System.out.println("");
        }
    }

    class Column {
        String name;
        int startIndex;
        int endIndex;

        Column() {
        }
    }
}

