/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageConstants;
import utils.message.TrackingBoutPool;
import utils.progtools.BufferPool;
import utils.stream.ByteArrayPool;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.VariableLengthStreamUtils;

public class MessageUtils
implements MessageConstants {
    public static final int COMPRESSED = -2147483647;

    public static int roughSize(Message m) {
        int rough = 0;
        for (int i = 0; i < m.length(); ++i) {
            int type = m.getType(i);
            rough += 4;
            if (m.get(i) == null) {
                rough += 4;
                continue;
            }
            if (type == 5) {
                rough += ((byte[])m.get(i)).length;
                continue;
            }
            if (type == 0) {
                rough += ((String)m.get(i)).length();
                continue;
            }
            if (type == 4) {
                rough += MessageUtils.roughSize((Message)m.get(i));
                continue;
            }
            if (type == 9) {
                rough += 4 * ((int[])m.get(i)).length;
                continue;
            }
            if (type == 12) {
                rough += 8 * ((double[])m.get(i)).length;
                continue;
            }
            if (type == 13) {
                rough += 8 * ((long[])m.get(i)).length;
                continue;
            }
            if (type == 10) {
                rough += 10 * ((int[])m.get(i)).length;
                continue;
            }
            rough += 8;
        }
        return rough;
    }

    public static byte[] messageToBytes(Message m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            MessageUtils.writeMessage(bout, m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bout.toByteArray();
    }

    public static Message bytesToMessage(byte[] b) {
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        Message m = null;
        try {
            m = MessageUtils.readMessage(bin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return m;
    }

    public static void writeMessage(OutputStream bout, Message m) throws IOException {
        MessageUtils.writeMessageNoFlush(bout, m);
        bout.flush();
    }

    public static void writeMessageNoFlush(OutputStream bout, Message m) throws IOException {
        int len = m.length();
        VariableLengthStreamUtils.writeByteNum(bout, 11);
        VariableLengthStreamUtils.writeInt(bout, m.getType());
        if (Message.INCLUDE_CREATION_STACKS) {
            m.callstack = null;
        }
        if (m.callstack != null) {
            VariableLengthStreamUtils.writeInt(bout, len + 1);
        } else {
            VariableLengthStreamUtils.writeInt(bout, len);
        }
        block14: for (int i = 0; i < len; ++i) {
            Object o = m.get(i);
            int typ = m.getType(i);
            VariableLengthStreamUtils.writeByteNum(bout, typ);
            switch (typ) {
                case 0: {
                    String s = (String)o;
                    if (s == null) {
                        VariableLengthStreamUtils.writeInt(bout, -123);
                        continue block14;
                    }
                    byte[] dat = s.getBytes(StandardCharsets.UTF_8);
                    VariableLengthStreamUtils.writeInt(bout, dat.length);
                    bout.write(dat);
                    continue block14;
                }
                case 1: {
                    Integer xi = (Integer)o;
                    VariableLengthStreamUtils.writeInt(bout, xi);
                    continue block14;
                }
                case 2: {
                    Long xl = (Long)o;
                    VariableLengthStreamUtils.writeLong(bout, xl);
                    continue block14;
                }
                case 3: {
                    Double xd = (Double)o;
                    VariableLengthStreamUtils.writeDouble(bout, xd);
                    continue block14;
                }
                case 7: {
                    Boolean xb = (Boolean)o;
                    VariableLengthStreamUtils.writeBoolean(bout, xb);
                    continue block14;
                }
                case 8: {
                    Byte bb = (Byte)o;
                    VariableLengthStreamUtils.writeByteNum(bout, bb.byteValue());
                    continue block14;
                }
                case 4: {
                    Message xm = (Message)o;
                    MessageUtils.writeMessageNoFlush(bout, xm);
                    continue block14;
                }
                case 5: {
                    Object ref;
                    if (o instanceof Message.ByteArrayRef) {
                        ref = (Message.ByteArrayRef)o;
                        VariableLengthStreamUtils.writeInt(bout, ((Message.ByteArrayRef)ref).len);
                        bout.write(((Message.ByteArrayRef)ref).array, ((Message.ByteArrayRef)ref).off, ((Message.ByteArrayRef)ref).len);
                        continue block14;
                    }
                    Object[] b = (byte[])o;
                    VariableLengthStreamUtils.writeInt(bout, b.length);
                    bout.write((byte[])b);
                    continue block14;
                }
                case 9: {
                    int ii;
                    Object ref;
                    if (o instanceof Message.IntegerArrayRef) {
                        ref = (Message.IntegerArrayRef)o;
                        VariableLengthStreamUtils.writeInt(bout, ((Message.IntegerArrayRef)ref).len);
                        for (ii = ((Message.IntegerArrayRef)ref).off; ii < ((Message.IntegerArrayRef)ref).len; ++ii) {
                            VariableLengthStreamUtils.writeInt(bout, ((Message.IntegerArrayRef)ref).array[ii]);
                        }
                        continue block14;
                    }
                    Object[] b = (int[])o;
                    VariableLengthStreamUtils.writeInt(bout, b.length);
                    for (ii = 0; ii < b.length; ++ii) {
                        VariableLengthStreamUtils.writeInt(bout, b[ii]);
                    }
                    continue block14;
                }
                case 13: {
                    int ii;
                    Object ref;
                    if (o instanceof Message.LongArrayRef) {
                        ref = (Message.LongArrayRef)o;
                        VariableLengthStreamUtils.writeInt(bout, ((Message.LongArrayRef)ref).len);
                        for (ii = ((Message.LongArrayRef)ref).off; ii < ((Message.LongArrayRef)ref).len; ++ii) {
                            VariableLengthStreamUtils.writeLong(bout, ((Message.LongArrayRef)ref).array[ii]);
                        }
                        continue block14;
                    }
                    Object[] b = (long[])o;
                    VariableLengthStreamUtils.writeInt(bout, b.length);
                    for (ii = 0; ii < b.length; ++ii) {
                        VariableLengthStreamUtils.writeLong(bout, b[ii]);
                    }
                    continue block14;
                }
                case 12: {
                    int ii;
                    Object ref;
                    if (o instanceof Message.DoubleArrayRef) {
                        ref = (Message.DoubleArrayRef)o;
                        VariableLengthStreamUtils.writeInt(bout, ((Message.DoubleArrayRef)ref).len);
                        for (ii = ((Message.DoubleArrayRef)ref).off; ii < ((Message.DoubleArrayRef)ref).len; ++ii) {
                            VariableLengthStreamUtils.writeDouble(bout, ((Message.DoubleArrayRef)ref).array[ii]);
                        }
                        continue block14;
                    }
                    Object[] b = (double[])o;
                    VariableLengthStreamUtils.writeInt(bout, b.length);
                    for (ii = 0; ii < b.length; ++ii) {
                        VariableLengthStreamUtils.writeDouble(bout, b[ii]);
                    }
                    continue block14;
                }
                case 10: {
                    byte[] dat;
                    Object string;
                    int ii;
                    Object ref;
                    if (o instanceof Message.StringArrayRef) {
                        ref = (Message.StringArrayRef)o;
                        VariableLengthStreamUtils.writeInt(bout, ((Message.StringArrayRef)ref).len);
                        for (ii = ((Message.StringArrayRef)ref).off; ii < ((Message.StringArrayRef)ref).len; ++ii) {
                            string = ((Message.StringArrayRef)ref).array[ii];
                            if (string == null) {
                                VariableLengthStreamUtils.writeInt(bout, -123);
                                continue;
                            }
                            dat = string.getBytes(StandardCharsets.UTF_8);
                            VariableLengthStreamUtils.writeInt(bout, dat.length);
                            bout.write(dat);
                        }
                        continue block14;
                    }
                    Object[] b = (String[])o;
                    VariableLengthStreamUtils.writeInt(bout, b.length);
                    for (ii = 0; ii < b.length; ++ii) {
                        string = b[ii];
                        if (string == null) {
                            VariableLengthStreamUtils.writeInt(bout, -123);
                            continue;
                        }
                        dat = string.getBytes(StandardCharsets.UTF_8);
                        VariableLengthStreamUtils.writeInt(bout, dat.length);
                        bout.write(dat);
                    }
                    continue block14;
                }
            }
        }
        if (m.callstack != null) {
            VariableLengthStreamUtils.writeByteNum(bout, 6);
            byte[] dat = m.callstack.toString().getBytes(StandardCharsets.US_ASCII);
            VariableLengthStreamUtils.writeInt(bout, dat.length);
            bout.write(dat);
        }
    }

    public static Message readMessage(InputStream bin) throws IOException {
        return MessageUtils.readMessageHighPerformance(bin, null);
    }

    public static Message readMessageHighPerformance(InputStream bin, ByteArrayPool pool) throws IOException {
        byte[] readbuffer = null;
        if (pool != null) {
            readbuffer = pool.allocateBuffer();
        }
        return MessageUtils.readMessageHighPerformance(bin, pool, readbuffer);
    }

    private static Message readMessageHighPerformance(InputStream bin, ByteArrayPool pool, byte[] readbuffer) throws IOException {
        Message m = new Message();
        int tmpi = VariableLengthStreamUtils.readByteNum(bin);
        if (tmpi != 11) {
            throw new IOException("Invalid Message Start " + tmpi);
        }
        tmpi = VariableLengthStreamUtils.readInt(bin);
        m.setType(tmpi);
        int datalen = VariableLengthStreamUtils.readInt(bin);
        block14: for (int i = 0; i < datalen; ++i) {
            int dtype = VariableLengthStreamUtils.readByteNum(bin);
            switch (dtype) {
                case 0: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    if (tmpi == -123) {
                        m.append((String)null);
                        continue block14;
                    }
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.append(new String(tmpb, 0, tmpi, StandardCharsets.UTF_8));
                    continue block14;
                }
                case 1: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    m.append(new Integer(tmpi));
                    continue block14;
                }
                case 2: {
                    long tmpl = VariableLengthStreamUtils.readLong(bin);
                    m.append(new Long(tmpl));
                    continue block14;
                }
                case 3: {
                    double tmpd = VariableLengthStreamUtils.readDouble(bin);
                    m.append(new Double(tmpd));
                    continue block14;
                }
                case 7: {
                    boolean tmpbl = VariableLengthStreamUtils.readBoolean(bin);
                    m.append(new Boolean(tmpbl));
                    continue block14;
                }
                case 8: {
                    byte tmpbyte = (byte)VariableLengthStreamUtils.readByteNum(bin);
                    m.append(new Byte(tmpbyte));
                    continue block14;
                }
                case 4: {
                    Message tmpmsg = MessageUtils.readMessageHighPerformance(bin, pool, readbuffer);
                    m.append(tmpmsg);
                    continue block14;
                }
                case 6: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.callstack = new StringBuffer(new String(tmpb, 0, tmpi));
                    continue block14;
                }
                case 9: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    int[] tmparr = MessageUtils.readInts(bin, tmpi);
                    m.append(tmparr, 0, tmpi);
                    continue block14;
                }
                case 12: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    double[] tmpdarr = MessageUtils.readDoubles(bin, tmpi);
                    m.append(tmpdarr, 0, tmpi);
                    continue block14;
                }
                case 13: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    long[] tmplarr = MessageUtils.readLongs(bin, tmpi);
                    m.append(tmplarr, 0, tmpi);
                    continue block14;
                }
                case 10: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    String[] tmpString = MessageUtils.readStrings(bin, tmpi);
                    m.append(tmpString, 0, tmpi);
                    continue block14;
                }
                default: {
                    tmpi = VariableLengthStreamUtils.readInt(bin);
                    if (tmpi > 10000000) {
                        System.out.println("[Messaging] Corrupted message");
                        return null;
                    }
                    if (pool != null) {
                        OpenByteArrayOutputStream bout = pool.allocate();
                        boolean tot = false;
                        int n = 0;
                        while (bout.size() < tmpi) {
                            n = bin.read(readbuffer, 0, Math.min(readbuffer.length, tmpi - bout.size()));
                            if (n > 0) {
                                bout.write(readbuffer, 0, n);
                            }
                            if (n != -1) continue;
                            throw new IOException("End of stream");
                        }
                        m.appendRef_WARNING_NO_GETS(bout.getByteArray(), 0, tmpi);
                        continue block14;
                    }
                    byte[] tmpb = MessageUtils.readBytes(bin, tmpi);
                    m.append(tmpb, 0, tmpi);
                }
            }
        }
        return m;
    }

    private static byte[] readBytes(InputStream i, int len) throws IOException {
        byte[] b = new byte[len];
        int n = 0;
        for (int t = 0; t < len; t += n) {
            n = i.read(b, t, len - t);
            if (n != -1) continue;
            throw new IOException("End of stream");
        }
        return b;
    }

    private static int[] readInts(InputStream i, int len) throws IOException {
        int[] b = new int[len];
        for (int ii = 0; ii < b.length; ++ii) {
            b[ii] = VariableLengthStreamUtils.readInt(i);
        }
        return b;
    }

    private static double[] readDoubles(InputStream i, int len) throws IOException {
        double[] b = new double[len];
        for (int ii = 0; ii < b.length; ++ii) {
            b[ii] = VariableLengthStreamUtils.readDouble(i);
        }
        return b;
    }

    private static long[] readLongs(InputStream i, int len) throws IOException {
        long[] b = new long[len];
        for (int ii = 0; ii < b.length; ++ii) {
            b[ii] = VariableLengthStreamUtils.readLong(i);
        }
        return b;
    }

    private static String[] readStrings(InputStream i, int len) throws IOException {
        String[] b = new String[len];
        for (int ii = 0; ii < b.length; ++ii) {
            int tmpi = VariableLengthStreamUtils.readInt(i);
            if (tmpi == -123) {
                b[ii] = null;
                continue;
            }
            byte[] tmpb = MessageUtils.readBytes(i, tmpi);
            b[ii] = new String(tmpb, 0, tmpi, StandardCharsets.UTF_8);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message fromFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            Message m;
            BufferedInputStream bin = new BufferedInputStream(fin);
            Message message = m = MessageUtils.readMessage(bin);
            return message;
        }
        finally {
            FileUtil.robustClose(fin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toFile(Message m, File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        try {
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            MessageUtils.writeMessage(bout, m);
        }
        finally {
            FileUtil.robustClose(fout);
        }
    }

    public static void main(String[] args) {
        Message m = new Message(12554352);
        m.append((byte)1);
        m.append(new int[]{1, 2, 3, 4, 5, 6, 7});
        m.append(new byte[]{1, 2, 3, 4, 5, 6, 7});
        m.append(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        Message tmp = new Message();
        tmp.append(new byte[1000]);
        tmp.append(new int[1000]);
        m.append(tmp);
        System.out.println(m);
        byte[] messageToBytes = MessageUtils.messageToBytes(m);
        System.out.println(messageToBytes.length);
        System.out.println(MessageUtils.roughSize(m));
        Message m2 = MessageUtils.bytesToMessage(messageToBytes);
        System.out.println(m2);
        BufferPool bpool = new BufferPool(4);
        OpenBoutPool pool = new OpenBoutPool(4, 110000);
        TrackingBoutPool tpool = new TrackingBoutPool(pool, bpool);
        try {
            m = MessageUtils.decompressHighPerformance(m, tpool);
            System.out.println(m);
            m = MessageUtils.compressHighPerformance(m, tpool);
            System.out.println(m);
            m = MessageUtils.decompressHighPerformance(m, tpool);
            System.out.println(m);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public static Message compress(Message m) throws IOException {
        return MessageUtils.compressHighPerformance(m, null);
    }

    public static Message compressHighPerformance(Message m, ByteArrayPool pool) throws IOException {
        OpenByteArrayOutputStream bout = pool != null ? pool.allocate() : new OpenByteArrayOutputStream();
        bout.reset();
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        MessageUtils.writeMessage(zout, m);
        zout.finish();
        m = new Message(-2147483647);
        if (pool != null) {
            m.appendRef_WARNING_NO_GETS(bout.getByteArray(), 0, bout.size());
        } else {
            m.append(bout.toByteArray());
        }
        return m;
    }

    public static Message decompress(Message m) throws IOException {
        return MessageUtils.decompressHighPerformance(m, null);
    }

    public static Message decompressHighPerformance(Message m, ByteArrayPool pool) throws IOException {
        if (m.getType() == -2147483647) {
            int len;
            int off;
            byte[] dat;
            OpenByteArrayOutputStream bout = pool != null ? pool.allocate() : new OpenByteArrayOutputStream();
            bout.reset();
            Object o = m.get(0);
            if (o instanceof Message.ByteArrayRef) {
                Message.ByteArrayRef ref = (Message.ByteArrayRef)o;
                dat = ref.array;
                off = ref.off;
                len = ref.len;
            } else {
                dat = (byte[])o;
                off = 0;
                len = dat.length;
            }
            if (pool != null) {
                return MessageUtils.readMessageHighPerformance(new GZIPInputStream(new ByteArrayInputStream(dat, off, len)), pool);
            }
            return MessageUtils.readMessage(new GZIPInputStream(new ByteArrayInputStream(dat, off, len)));
        }
        return m;
    }
}

