/*
 * Decompiled with CFR 0.152.
 */
package utils.encryption.aes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import utils.encryption.aes.Rijndael;
import utils.encryption.aes.RijndaelDecryptionStream;

public class RijndaelEncryptionStream
extends FilterOutputStream {
    public static final int MIN_BLOCK_SIZE = 512;
    public static final int DEFAULT_BLOCK_SIZE = 16384;
    private int MAX_BLOCK_SIZE = 16384;
    private byte[] buffer = null;
    private int buffered = 0;
    private Rijndael tf;
    private OutputStream out;

    public RijndaelEncryptionStream(OutputStream out, byte[] key) {
        this(out, key, 16384);
    }

    public RijndaelEncryptionStream(OutputStream out, byte[] key, int blocksiz) {
        super(out);
        this.out = out;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.tf = new Rijndael();
        this.tf.init(key);
    }

    public RijndaelEncryptionStream(OutputStream out, String key) {
        this(out, key, 16384);
    }

    public RijndaelEncryptionStream(OutputStream out, String key, int blocksiz) {
        super(out);
        this.out = out;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.tf = new Rijndael();
        this.tf.init(key);
    }

    public RijndaelEncryptionStream(OutputStream out, Rijndael tf) {
        super(out);
        this.out = out;
        int blocksiz = 16384;
        if (blocksiz < 512) {
            blocksiz = 512;
        }
        this.MAX_BLOCK_SIZE = blocksiz;
        this.buffer = new byte[blocksiz];
        this.tf = tf;
    }

    public Rijndael getRijndael() {
        return this.tf;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        this.out.flush();
        super.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int max = off + len;
        for (int i = off; i < max; ++i) {
            if (this.buffered == this.MAX_BLOCK_SIZE) {
                this.writeBuffer();
            }
            this.buffer[this.buffered++] = b[i];
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffered == this.MAX_BLOCK_SIZE) {
            this.writeBuffer();
        }
        this.buffer[this.buffered++] = (byte)b;
    }

    private void writeBuffer() throws IOException {
        if (this.buffered == 0) {
            return;
        }
        byte[] encrypted = this.tf.encryptCTR(this.buffer, 0, this.buffered);
        byte[] bytes = new byte[4];
        int shift = bytes.length * 8;
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(encrypted.length >> (shift -= 8));
        }
        this.out.write(bytes);
        this.out.write(encrypted);
        this.buffered = 0;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage TwofishEncryptionStream <test string size>");
            return;
        }
        int size = Integer.parseInt(args[0]);
        try {
            RijndaelEncryptionStream.testOneByteRead(size, -1);
            RijndaelEncryptionStream.testBufferRead(size, -1);
            RijndaelEncryptionStream.testOneByteRead(size, 1024);
            RijndaelEncryptionStream.testBufferRead(size, 1024);
            RijndaelEncryptionStream.testOneByteRead(size, size * 2);
            RijndaelEncryptionStream.testBufferRead(size, size * 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testOneByteRead(int size, int block) {
        System.out.println("Testing one byte reading with data size " + size + ", block size " + block);
        try {
            byte[] data = new byte[size];
            byte[] key = new byte[72];
            Random r = new Random(5555L);
            Random rr = new Random(6666L);
            r.nextBytes(data);
            rr.nextBytes(key);
            byte[] orig = new byte[size];
            System.arraycopy(data, 0, orig, 0, size);
            ByteArrayOutputStream e_out = new ByteArrayOutputStream();
            RijndaelEncryptionStream f_out = new RijndaelEncryptionStream((OutputStream)e_out, key, block);
            f_out.write(data);
            f_out.flush();
            ByteArrayInputStream e_in = new ByteArrayInputStream(e_out.toByteArray());
            RijndaelDecryptionStream f_in = new RijndaelDecryptionStream((InputStream)e_in, key);
            int i = 0;
            while (true) {
                int n;
                if ((n = f_in.read()) == -1) break;
                if ((byte)n != orig[i]) {
                    System.out.println("Error - data changed (" + i + ", " + (byte)n + ", " + orig[i] + ")");
                    System.exit(0);
                }
                ++i;
            }
            System.out.println("EOF");
            if (i < orig.length) {
                System.out.println("EOF premature (" + i + " < " + orig.length + ")");
            } else {
                System.out.println("data ok");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testBufferRead(int size, int block) {
        System.out.println("Testing buffer reading with data size " + size + ", block size " + block);
        try {
            byte[] data = new byte[size];
            byte[] key = new byte[72];
            Random r = new Random(5555L);
            Random rr = new Random(6666L);
            r.nextBytes(data);
            rr.nextBytes(key);
            byte[] orig = new byte[size];
            System.arraycopy(data, 0, orig, 0, size);
            ByteArrayOutputStream e_out = new ByteArrayOutputStream();
            RijndaelEncryptionStream f_out = new RijndaelEncryptionStream((OutputStream)e_out, key, block);
            f_out.write(data);
            f_out.flush();
            ByteArrayInputStream e_in = new ByteArrayInputStream(e_out.toByteArray());
            RijndaelDecryptionStream f_in = new RijndaelDecryptionStream((InputStream)e_in, key);
            int i = 0;
            byte[] buff = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = f_in.read(buff, 0, buff.length);
                if (n > 0) {
                    for (int x = 0; x < n; ++x) {
                        if (buff[x] != orig[i]) {
                            System.out.println("Error - data changed (" + i + ", " + buff[x] + ", " + orig[i] + ")");
                            System.exit(0);
                        }
                        ++i;
                    }
                    continue;
                }
                System.out.println("n = 0");
            }
            System.out.println("EOF");
            if (i < orig.length) {
                System.out.println("EOF premature (" + i + " < " + orig.length + ")");
            } else {
                System.out.println("data ok");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

