/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jwrapper.ui.JWLanguage;
import utils.swing.SafeLookAndFeel;

public class SimpleErrorHandler {
    public static void displayError(String title, String message, Component component) {
        SimpleErrorHandler.displayThrowable(null, title, message, null, component);
    }

    public static void displayThrowable(Throwable throwable, String title, String submissionURL, Component component) {
        SimpleErrorHandler.displayThrowable(throwable, title, null, submissionURL, component);
    }

    public static void displayThrowable(final Throwable throwable, String title, final String message, String submissionURL, Component component) {
        String msg = message;
        try {
            SafeLookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (throwable != null) {
            String className = throwable.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            msg = throwable.getMessage();
            msg = className + (msg != null ? ": " + msg : "");
        }
        if (message != null) {
            msg = message;
        }
        final String basicMessage = msg;
        final JLabel messageLabel = new JLabel(basicMessage);
        final JButton detailsButton = new JButton(JWLanguage.getString("SIMPLEERROR_DETAILS"));
        ImageIcon icon = null;
        try {
            InputStream fin = SimpleErrorHandler.class.getResourceAsStream("stop.png");
            BufferedImage enabledImage = ImageIO.read(fin);
            icon = new ImageIcon(enabledImage);
        }
        catch (Throwable t) {
            icon = null;
        }
        JOptionPane pane = throwable != null ? new JOptionPane(messageLabel, 0, 0, icon, new Object[]{JWLanguage.getString("SIMPLEERROR_EXIT"), detailsButton}) : new JOptionPane(messageLabel, 0, 0, icon, new Object[]{JWLanguage.getString("SIMPLEERROR_EXIT")});
        final JDialog dialog = pane.createDialog(component, title);
        detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String label = detailsButton.getText();
                if (label.startsWith(JWLanguage.getString("SIMPLEERROR_DETAILS"))) {
                    messageLabel.setText(SimpleErrorHandler.getHTMLDetails(message, throwable));
                    detailsButton.setText(JWLanguage.getString("SIMPLEERROR_HIDEDETAILS"));
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                } else {
                    messageLabel.setText(basicMessage);
                    detailsButton.setText(JWLanguage.getString("SIMPLEERROR_DETAILS"));
                    dialog.pack();
                }
            }
        });
        dialog.setVisible(true);
    }

    public static String getHTMLDetails(String message, Throwable throwable) {
        StringBuffer b = new StringBuffer("<html>");
        int lengthOfLastTrace = 1;
        if (message != null) {
            b.append(message).append("<BR><BR>");
        }
        while (throwable != null) {
            b.append("<b>" + throwable.getClass().getName() + "</b>: " + throwable.getMessage() + "<ul>");
            StackTraceElement[] stack = throwable.getStackTrace();
            for (int i = 0; i <= stack.length - lengthOfLastTrace; ++i) {
                b.append("<li><span> in " + stack[i].getClassName() + ".<b>" + stack[i].getMethodName() + "</b>( ) at <tt>" + stack[i].getFileName() + ":" + stack[i].getLineNumber() + "</tt></span></li>");
            }
            b.append("</ul>");
            if ((throwable = throwable.getCause()) == null) continue;
            b.append("<i>Caused by: </i>");
            lengthOfLastTrace = stack.length;
        }
        b.append("</html>");
        return b.toString();
    }

    public static class Test {
        public void a() {
            this.b();
        }

        public void b() {
            this.c();
        }

        public void c() {
            this.d();
        }

        public void d() {
            this.e();
        }

        public void e() {
            this.f();
        }

        public void f() {
            this.g();
        }

        public void g() {
            this.h();
        }

        public void h() {
            this.i();
        }

        public void i() {
            this.j();
        }

        public void j() {
            Integer.parseInt("aaa");
        }

        public static void main(String[] args) throws Exception {
            SafeLookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SimpleErrorHandler.displayError("poo", "woot", null);
            String url = args.length > 0 ? args[0] : null;
            try {
                Test.foo();
            }
            catch (Throwable e) {
                SimpleErrorHandler.displayThrowable(e, JWLanguage.getString("UPDATE_ERROR_TITLE"), JWLanguage.getString("UPDATE_ERROR_MESSAGE"), null, null);
                System.exit(1);
            }
        }

        public static void foo() {
            Test.bar(null);
        }

        public static void bar(Object o) {
            try {
                Test.blah(o);
            }
            catch (NullPointerException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("null argument").initCause(e);
            }
        }

        public static void blah(Object o) {
            Class<?> c = o.getClass();
        }
    }
}

