/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import jwrapper.proxy.JWProxyCredentials;

public class JWProxyAuthenticator
extends Authenticator {
    private JWProxyCredentials proxyCredentials;
    private String interceptPassword = null;
    private String interceptUsername = null;

    public JWProxyAuthenticator(JWProxyCredentials proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
        Authenticator.setDefault(this);
    }

    public void revertDefault() {
        Authenticator.setDefault(null);
    }

    public void saveInterceptCredentials(Proxy proxy) {
        System.out.println("[JWProxyAuthenticator] Saving intercept credentials");
        if (this.interceptUsername != null) {
            JWProxyCredentials.Credentials c = new JWProxyCredentials.Credentials(this.interceptUsername, this.interceptPassword);
            this.proxyCredentials.setCredentialsFor(proxy, c);
            this.interceptUsername = null;
        }
    }

    public void setInterceptCredentials(String username, String password) {
        if (username != null) {
            System.out.println("[JWProxyAuthenticator] Setting intercept credentials");
        } else {
            System.out.println("[JWProxyAuthenticator] Clearing intercept credentials");
        }
        this.interceptUsername = username;
        this.interceptPassword = password;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.interceptUsername != null) {
            return new PasswordAuthentication(this.interceptUsername, this.interceptPassword.toCharArray());
        }
        JWProxyCredentials.Credentials credentials = this.proxyCredentials.getCredentialsFor(this.getRequestingHost(), this.getRequestingPort());
        if (credentials != null && credentials.username != null) {
            if (credentials.password == null) {
                return new PasswordAuthentication(credentials.username, null);
            }
            return new PasswordAuthentication(credentials.username, credentials.password.toCharArray());
        }
        return null;
    }
}

