/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Pack200Compressor {
    private Pack200.Packer packer = Pack200.newPacker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        File jarFile = new File("../BuildJRE/win32/jre1.7.0_45/lib/rt.jar");
        File target = new File("test.pack");
        File targetUnpackedJar = new File("test.jar");
        target.delete();
        targetUnpackedJar.delete();
        long start = System.currentTimeMillis();
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(target));
        try {
            Pack200Compressor compressor = Pack200Compressor.initForEffort(0);
            compressor.compressFileToOutputStream(new JarFile(jarFile), bout);
        }
        finally {
            bout.close();
        }
        System.out.println("Compression took " + (System.currentTimeMillis() - start) + "ms ");
        System.out.println("Compressed = " + target.length() + " Original = " + jarFile.length());
        Thread.sleep(1000L);
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(target));
        JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(targetUnpackedJar)));
        try {
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)bin, jout);
        }
        finally {
            jout.close();
            bin.close();
        }
        System.out.println("Uncompression took " + (System.currentTimeMillis() - start) + "ms ");
    }

    public static boolean jarContainsAClass(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            System.out.println("[Pack200Compressor] Jar appears to not be a jar (" + t.getMessage() + ") (" + jarFile.getName() + ")");
            return false;
        }
    }

    public static Pack200Compressor initMaxCompression() {
        return new Pack200Compressor(-1, "latest", 9, "false");
    }

    public static Pack200Compressor initGoodCompression() {
        return new Pack200Compressor(10000000, "latest", 9, "false");
    }

    public static Pack200Compressor initDefaultCompression() {
        return new Pack200Compressor(1000000, "latest", 5, "false");
    }

    public static Pack200Compressor initLowCompression() {
        return new Pack200Compressor(100000, "latest", 1, "true");
    }

    public static Pack200Compressor initForEffort(int pack200Effort) {
        switch (pack200Effort) {
            case 1: 
            case 2: 
            case 3: {
                return new Pack200Compressor(100000, "latest", pack200Effort, "true");
            }
            case 4: 
            case 5: 
            case 6: {
                return new Pack200Compressor(1000000, "latest", pack200Effort, "false");
            }
            case 7: 
            case 8: {
                return new Pack200Compressor(10000000, "latest", pack200Effort, "false");
            }
        }
        return new Pack200Compressor(-1, "latest", 9, "false");
    }

    public Pack200Compressor(int segmentLimitSetting, String modificationSetting, int effortSetting, String keepFileOrderSetting) {
        this.packer.properties().put("pack.segment.limit", Integer.toString(segmentLimitSetting));
        this.packer.properties().put("pack.modification.time", modificationSetting);
        this.packer.properties().put("pack.effort", Integer.toString(effortSetting));
        this.packer.properties().put("pack.keep.file.order", keepFileOrderSetting);
    }

    public void compressFileToOutputStream(JarFile jarFile, OutputStream out) throws IOException {
        this.packer.pack(jarFile, out);
    }

    public void compressDirectory(File directory) {
        if (directory.isFile()) {
            File file = directory;
            if (file.getName().endsWith(".jar")) {
                try {
                    System.out.println("[Pack200Compressor] Compressing " + file.getName());
                    File parent = file.getParentFile();
                    String newName = file.getName().substring(0, file.getName().lastIndexOf(46));
                    File newTarget = new File(parent, newName + ".p2");
                    JarInputStream jin = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(newTarget));
                    try {
                        this.packer.pack(jin, (OutputStream)bout);
                    }
                    catch (IOException ex) {
                        if (newTarget.exists()) {
                            newTarget.delete();
                        }
                        throw ex;
                    }
                    finally {
                        bout.close();
                        jin.close();
                    }
                    file.delete();
                }
                catch (Throwable t) {
                    System.out.println("[Pack200Util] Couldn't compress " + file.getAbsolutePath());
                    t.printStackTrace();
                }
            }
        } else {
            File[] children = directory.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.compressDirectory(children[i]);
            }
        }
    }

    private static class MemoryThread
    extends Thread {
        long max = 0L;

        private MemoryThread() {
        }

        @Override
        public void run() {
            this.setDaemon(true);
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.max = Math.max(Runtime.getRuntime().totalMemory(), this.max);
            }
        }
    }
}

