/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.logging;

import java.io.File;
import jwrapper.logging.ProcessOutputUtil;
import jwrapper.logging.ProcessResult;
import utils.progtools.MapOfLists;

public class LogPoller {
    public static int POLL_FREQ = 2000;
    File master;
    long after = 0L;
    Object ANY = new Object();
    MapOfLists<String, Object> conditions = new MapOfLists(false);

    public LogPoller(File master) {
        this.master = master;
        System.out.println("[LogPoller] Set up for " + master);
        this.returnResultsAfter(System.currentTimeMillis());
        System.out.println("[LogPoller] Returning results after " + this.after);
    }

    public void addReturnOnLaunchedOkCase(String vapp) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = (OK)");
        this.conditions.add(vapp, new Integer(4));
    }

    public void addReturnOnSuccessCase(String vapp) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = (OK)");
        this.conditions.add(vapp, new Integer(1));
    }

    public void addReturnOnErrorCase(String vapp) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = (ERROR)");
        this.conditions.add(vapp, new Integer(2));
    }

    public void addReturnOnCancelledCase(String vapp) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = (CANCELLED)");
        this.conditions.add(vapp, new Integer(3));
    }

    public void addReturnOnAnyCase(String vapp) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = (ANY)");
        this.conditions.add(vapp, this.ANY);
    }

    public void addReturnOnCustomCase(String vapp, int resultCode) {
        System.out.println("[LogPoller] Returning if [" + vapp + "] = " + resultCode);
        this.conditions.add(vapp, new Integer(resultCode));
    }

    public void addReturnIfAutoupdateFailed() {
        this.addReturnOnErrorCase("JWrapper");
        this.addReturnOnCancelledCase("JWrapper");
    }

    public void returnResultsAfter(long time) {
        this.after = time;
        System.out.println("[LogPoller] Returning results after " + this.after);
    }

    public ProcessResult waitForResult(long timeout) throws InterruptedException {
        long giveUp = System.currentTimeMillis() + timeout;
        try {
            while (true) {
                try {
                    if (!this.master.exists()) {
                        System.out.println("Waiting for Process Result (master install folder does not exist yet)");
                    } else {
                        File logs = new File(this.master, "logs");
                        if (!logs.exists()) {
                            System.out.println("Waiting for Process Result (logs folder does not exist yet)");
                        } else {
                            File[] files = logs.listFiles();
                            if (files.length == 0) {
                                System.out.println("Waiting for Process Result (no log files found yet)");
                            } else {
                                for (int i = 0; i < files.length; ++i) {
                                    System.out.println("[LogPoller] Checking " + files[i]);
                                    ProcessResult[] prs = ProcessOutputUtil.parseFileForAllReturnCodes(files[i], "");
                                    System.out.println("[LogPoller] Found " + prs.length + " process results");
                                    for (int prIndex = 0; prIndex < prs.length; ++prIndex) {
                                        ProcessResult pr = prs[prIndex];
                                        System.out.println("[LogPoller] Found a result " + pr);
                                        if (pr.time >= this.after) {
                                            String source = pr.source;
                                            System.out.println("[LogPoller] Source is [" + source + "]");
                                            if (this.conditions.exists(source, this.ANY)) {
                                                return pr;
                                            }
                                            if (this.conditions.exists(source, new Integer(pr.code))) {
                                                return pr;
                                            }
                                            System.out.println("[LogPoller] No condition satisfied. Skipping.");
                                            continue;
                                        }
                                        System.out.println("[LogPoller] Result too old - " + pr.time + " < " + this.after);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception logs) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= giveUp) {
                    Thread.sleep(POLL_FREQ);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException x) {
            System.out.println("Waiting for Process Result (finished - due to interrupt!)");
        }
        return null;
    }
}

