/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.legacyutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;

public class VMStateUtil {
    private final boolean isWindows;
    private final ArrayList<String> vmArguments = new ArrayList();
    private final String className;
    private String classpath;
    private String[] appArguments;
    private String javaExecutable;

    public VMStateUtil(String className, String[] appArguments) {
        String osname = System.getProperty("os.name");
        this.isWindows = osname.contains("Windows");
        this.className = className;
        this.detectState(appArguments);
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    private void detectState(String[] appArguments) {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        this.vmArguments.addAll(runtimeMxBean.getInputArguments());
        this.classpath = System.getProperty("java.class.path");
        this.appArguments = appArguments;
        this.javaExecutable = this.getJavaExe();
    }

    public int fork(boolean block) throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.javaExecutable);
        commandLine.addAll(this.vmArguments);
        commandLine.add("-cp");
        commandLine.add(this.classpath);
        commandLine.add(this.className);
        commandLine.addAll(Arrays.asList(this.appArguments));
        System.out.println(commandLine);
        final Process p = Runtime.getRuntime().exec(commandLine.toArray(new String[0]));
        new Thread(){

            public void run() {
                try {
                    VMStateUtil.pipe(p.getInputStream(), System.out, 65536);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    VMStateUtil.pipe(p.getErrorStream(), System.err, 65536);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        if (block) {
            return p.waitFor();
        }
        return Integer.MIN_VALUE;
    }

    private static void pipe(InputStream in, OutputStream out, int bufSize) throws IOException {
        int n = 0;
        byte[] buf = new byte[bufSize];
        while (n != -1) {
            try {
                n = in.read(buf, 0, bufSize);
                if (n <= 0) continue;
                out.write(buf, 0, n);
                out.flush();
            }
            catch (InterruptedIOException x) {
                if (x.bytesTransferred > 0) {
                    out.write(buf, 0, x.bytesTransferred);
                }
                out.flush();
            }
        }
        out.flush();
    }

    private String getJavaExe(String javaHome) {
        return this.getJavaExe(javaHome, true);
    }

    private String getJavaExe(String javaHome, boolean windowsUseW) {
        char c = File.separatorChar;
        StringBuilder java = new StringBuilder(javaHome);
        java.append(c);
        java.append("bin");
        java.append(c);
        java.append("java");
        if (this.isWindows) {
            if (windowsUseW) {
                java.append("w.exe");
            } else {
                java.append(".exe");
            }
        }
        return java.toString();
    }

    private String getJavaExe() {
        String jhome = System.getProperty("java.home");
        return this.getJavaExe(jhome);
    }

    public void setJavaHome(File latestJREHome) {
        File newJREExecutable = new File(latestJREHome, "bin");
        newJREExecutable = this.isWindows ? new File(newJREExecutable, "javaw.exe") : new File(newJREExecutable, "javaw");
        this.setJavaExecutable(newJREExecutable.getAbsolutePath());
    }
}

