/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.legacyutils;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class JREFinder {
    public static File getLatestJREHome() {
        File currentFile = new File(".").getAbsoluteFile();
        return JREFinder.getLatestJREHome(currentFile);
    }

    public static File getLatestJREHome(File currentFile) {
        while (currentFile.getParentFile().getName().startsWith("JWrapper-")) {
            currentFile = currentFile.getParentFile();
        }
        File[] children = currentFile.listFiles();
        if (children != null) {
            Arrays.sort(children, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = children.length - 1; i >= 0; --i) {
                File child = children[i];
                if (!child.getName().contains("JRE")) continue;
                if (child.getName().endsWith(".plugin")) {
                    child = new File(child, "Contents");
                    child = new File(child, "Home");
                }
                return child.getAbsoluteFile();
            }
        }
        return null;
    }
}

